/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains information about a tenant associated with a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceTenantMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceTenantMetadata.Builder, ResourceTenantMetadata> {
    private static final SdkField<String> TENANT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TenantName").getter(getter(ResourceTenantMetadata::tenantName)).setter(setter(Builder::tenantName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantName").build()).build();

    private static final SdkField<String> TENANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TenantId").getter(getter(ResourceTenantMetadata::tenantId)).setter(setter(Builder::tenantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantId").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(ResourceTenantMetadata::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<Instant> ASSOCIATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("AssociatedTimestamp").getter(getter(ResourceTenantMetadata::associatedTimestamp))
            .setter(setter(Builder::associatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TENANT_NAME_FIELD,
            TENANT_ID_FIELD, RESOURCE_ARN_FIELD, ASSOCIATED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String tenantName;

    private final String tenantId;

    private final String resourceArn;

    private final Instant associatedTimestamp;

    private ResourceTenantMetadata(BuilderImpl builder) {
        this.tenantName = builder.tenantName;
        this.tenantId = builder.tenantId;
        this.resourceArn = builder.resourceArn;
        this.associatedTimestamp = builder.associatedTimestamp;
    }

    /**
     * <p>
     * The name of the tenant associated with the resource.
     * </p>
     * 
     * @return The name of the tenant associated with the resource.
     */
    public final String tenantName() {
        return tenantName;
    }

    /**
     * <p>
     * A unique identifier for the tenant associated with the resource.
     * </p>
     * 
     * @return A unique identifier for the tenant associated with the resource.
     */
    public final String tenantId() {
        return tenantId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The date and time when the resource was associated with the tenant.
     * </p>
     * 
     * @return The date and time when the resource was associated with the tenant.
     */
    public final Instant associatedTimestamp() {
        return associatedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tenantName());
        hashCode = 31 * hashCode + Objects.hashCode(tenantId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(associatedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceTenantMetadata)) {
            return false;
        }
        ResourceTenantMetadata other = (ResourceTenantMetadata) obj;
        return Objects.equals(tenantName(), other.tenantName()) && Objects.equals(tenantId(), other.tenantId())
                && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(associatedTimestamp(), other.associatedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceTenantMetadata").add("TenantName", tenantName()).add("TenantId", tenantId())
                .add("ResourceArn", resourceArn()).add("AssociatedTimestamp", associatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TenantName":
            return Optional.ofNullable(clazz.cast(tenantName()));
        case "TenantId":
            return Optional.ofNullable(clazz.cast(tenantId()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "AssociatedTimestamp":
            return Optional.ofNullable(clazz.cast(associatedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TenantName", TENANT_NAME_FIELD);
        map.put("TenantId", TENANT_ID_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("AssociatedTimestamp", ASSOCIATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceTenantMetadata, T> g) {
        return obj -> g.apply((ResourceTenantMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceTenantMetadata> {
        /**
         * <p>
         * The name of the tenant associated with the resource.
         * </p>
         * 
         * @param tenantName
         *        The name of the tenant associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantName(String tenantName);

        /**
         * <p>
         * A unique identifier for the tenant associated with the resource.
         * </p>
         * 
         * @param tenantId
         *        A unique identifier for the tenant associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantId(String tenantId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The date and time when the resource was associated with the tenant.
         * </p>
         * 
         * @param associatedTimestamp
         *        The date and time when the resource was associated with the tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedTimestamp(Instant associatedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String tenantName;

        private String tenantId;

        private String resourceArn;

        private Instant associatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceTenantMetadata model) {
            tenantName(model.tenantName);
            tenantId(model.tenantId);
            resourceArn(model.resourceArn);
            associatedTimestamp(model.associatedTimestamp);
        }

        public final String getTenantName() {
            return tenantName;
        }

        public final void setTenantName(String tenantName) {
            this.tenantName = tenantName;
        }

        @Override
        public final Builder tenantName(String tenantName) {
            this.tenantName = tenantName;
            return this;
        }

        public final String getTenantId() {
            return tenantId;
        }

        public final void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public final Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Instant getAssociatedTimestamp() {
            return associatedTimestamp;
        }

        public final void setAssociatedTimestamp(Instant associatedTimestamp) {
            this.associatedTimestamp = associatedTimestamp;
        }

        @Override
        public final Builder associatedTimestamp(Instant associatedTimestamp) {
            this.associatedTimestamp = associatedTimestamp;
            return this;
        }

        @Override
        public ResourceTenantMetadata build() {
            return new ResourceTenantMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
