/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An error corresponding to the unsuccessful processing of a single metric data query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricDataError implements SdkPojo, Serializable, ToCopyableBuilder<MetricDataError.Builder, MetricDataError> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(MetricDataError::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Code")
            .getter(getter(MetricDataError::codeAsString)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(MetricDataError::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, CODE_FIELD,
            MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String code;

    private final String message;

    private MetricDataError(BuilderImpl builder) {
        this.id = builder.id;
        this.code = builder.code;
        this.message = builder.message;
    }

    /**
     * <p>
     * The query identifier.
     * </p>
     * 
     * @return The query identifier.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The query error code. Can be one of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INTERNAL_FAILURE</code> – Amazon SES has failed to process one of the queries.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACCESS_DENIED</code> – You have insufficient access to retrieve metrics based on the given query.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link QueryErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return The query error code. Can be one of:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INTERNAL_FAILURE</code> – Amazon SES has failed to process one of the queries.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACCESS_DENIED</code> – You have insufficient access to retrieve metrics based on the given query.
     *         </p>
     *         </li>
     * @see QueryErrorCode
     */
    public final QueryErrorCode code() {
        return QueryErrorCode.fromValue(code);
    }

    /**
     * <p>
     * The query error code. Can be one of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INTERNAL_FAILURE</code> – Amazon SES has failed to process one of the queries.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACCESS_DENIED</code> – You have insufficient access to retrieve metrics based on the given query.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link QueryErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return The query error code. Can be one of:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INTERNAL_FAILURE</code> – Amazon SES has failed to process one of the queries.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACCESS_DENIED</code> – You have insufficient access to retrieve metrics based on the given query.
     *         </p>
     *         </li>
     * @see QueryErrorCode
     */
    public final String codeAsString() {
        return code;
    }

    /**
     * <p>
     * The error message associated with the current query error.
     * </p>
     * 
     * @return The error message associated with the current query error.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDataError)) {
            return false;
        }
        MetricDataError other = (MetricDataError) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(codeAsString(), other.codeAsString())
                && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricDataError").add("Id", id()).add("Code", codeAsString()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Code":
            return Optional.ofNullable(clazz.cast(codeAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Code", CODE_FIELD);
        map.put("Message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricDataError, T> g) {
        return obj -> g.apply((MetricDataError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricDataError> {
        /**
         * <p>
         * The query identifier.
         * </p>
         * 
         * @param id
         *        The query identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The query error code. Can be one of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INTERNAL_FAILURE</code> – Amazon SES has failed to process one of the queries.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACCESS_DENIED</code> – You have insufficient access to retrieve metrics based on the given query.
         * </p>
         * </li>
         * </ul>
         * 
         * @param code
         *        The query error code. Can be one of:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INTERNAL_FAILURE</code> – Amazon SES has failed to process one of the queries.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACCESS_DENIED</code> – You have insufficient access to retrieve metrics based on the given
         *        query.
         *        </p>
         *        </li>
         * @see QueryErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryErrorCode
         */
        Builder code(String code);

        /**
         * <p>
         * The query error code. Can be one of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INTERNAL_FAILURE</code> – Amazon SES has failed to process one of the queries.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACCESS_DENIED</code> – You have insufficient access to retrieve metrics based on the given query.
         * </p>
         * </li>
         * </ul>
         * 
         * @param code
         *        The query error code. Can be one of:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INTERNAL_FAILURE</code> – Amazon SES has failed to process one of the queries.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACCESS_DENIED</code> – You have insufficient access to retrieve metrics based on the given
         *        query.
         *        </p>
         *        </li>
         * @see QueryErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryErrorCode
         */
        Builder code(QueryErrorCode code);

        /**
         * <p>
         * The error message associated with the current query error.
         * </p>
         * 
         * @param message
         *        The error message associated with the current query error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String code;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDataError model) {
            id(model.id);
            code(model.code);
            message(model.message);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(QueryErrorCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public MetricDataError build() {
            return new MetricDataError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
