/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about resources associated with a specific tenant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTenantResourcesResponse extends SesV2Response implements
        ToCopyableBuilder<ListTenantResourcesResponse.Builder, ListTenantResourcesResponse> {
    private static final SdkField<List<TenantResource>> TENANT_RESOURCES_FIELD = SdkField
            .<List<TenantResource>> builder(MarshallingType.LIST)
            .memberName("TenantResources")
            .getter(getter(ListTenantResourcesResponse::tenantResources))
            .setter(setter(Builder::tenantResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TenantResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(TenantResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTenantResourcesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TENANT_RESOURCES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<TenantResource> tenantResources;

    private final String nextToken;

    private ListTenantResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.tenantResources = builder.tenantResources;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TenantResources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTenantResources() {
        return tenantResources != null && !(tenantResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that contains information about each resource associated with the tenant.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTenantResources} method.
     * </p>
     * 
     * @return An array that contains information about each resource associated with the tenant.
     */
    public final List<TenantResource> tenantResources() {
        return tenantResources;
    }

    /**
     * <p>
     * A token that indicates that there are additional resources to list. To view additional resources, issue another
     * request to <code>ListTenantResources</code>, and pass this token in the <code>NextToken</code> parameter.
     * </p>
     * 
     * @return A token that indicates that there are additional resources to list. To view additional resources, issue
     *         another request to <code>ListTenantResources</code>, and pass this token in the <code>NextToken</code>
     *         parameter.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTenantResources() ? tenantResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTenantResourcesResponse)) {
            return false;
        }
        ListTenantResourcesResponse other = (ListTenantResourcesResponse) obj;
        return hasTenantResources() == other.hasTenantResources() && Objects.equals(tenantResources(), other.tenantResources())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTenantResourcesResponse")
                .add("TenantResources", hasTenantResources() ? tenantResources() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TenantResources":
            return Optional.ofNullable(clazz.cast(tenantResources()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TenantResources", TENANT_RESOURCES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTenantResourcesResponse, T> g) {
        return obj -> g.apply((ListTenantResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SesV2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListTenantResourcesResponse> {
        /**
         * <p>
         * An array that contains information about each resource associated with the tenant.
         * </p>
         * 
         * @param tenantResources
         *        An array that contains information about each resource associated with the tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantResources(Collection<TenantResource> tenantResources);

        /**
         * <p>
         * An array that contains information about each resource associated with the tenant.
         * </p>
         * 
         * @param tenantResources
         *        An array that contains information about each resource associated with the tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantResources(TenantResource... tenantResources);

        /**
         * <p>
         * An array that contains information about each resource associated with the tenant.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sesv2.model.TenantResource.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sesv2.model.TenantResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sesv2.model.TenantResource.Builder#build()} is called immediately and
         * its result is passed to {@link #tenantResources(List<TenantResource>)}.
         * 
         * @param tenantResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sesv2.model.TenantResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tenantResources(java.util.Collection<TenantResource>)
         */
        Builder tenantResources(Consumer<TenantResource.Builder>... tenantResources);

        /**
         * <p>
         * A token that indicates that there are additional resources to list. To view additional resources, issue
         * another request to <code>ListTenantResources</code>, and pass this token in the <code>NextToken</code>
         * parameter.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates that there are additional resources to list. To view additional resources,
         *        issue another request to <code>ListTenantResources</code>, and pass this token in the
         *        <code>NextToken</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SesV2Response.BuilderImpl implements Builder {
        private List<TenantResource> tenantResources = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTenantResourcesResponse model) {
            super(model);
            tenantResources(model.tenantResources);
            nextToken(model.nextToken);
        }

        public final List<TenantResource.Builder> getTenantResources() {
            List<TenantResource.Builder> result = TenantResourceListCopier.copyToBuilder(this.tenantResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTenantResources(Collection<TenantResource.BuilderImpl> tenantResources) {
            this.tenantResources = TenantResourceListCopier.copyFromBuilder(tenantResources);
        }

        @Override
        public final Builder tenantResources(Collection<TenantResource> tenantResources) {
            this.tenantResources = TenantResourceListCopier.copy(tenantResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tenantResources(TenantResource... tenantResources) {
            tenantResources(Arrays.asList(tenantResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tenantResources(Consumer<TenantResource.Builder>... tenantResources) {
            tenantResources(Stream.of(tenantResources).map(c -> TenantResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTenantResourcesResponse build() {
            return new ListTenantResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
