/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to list the existing recommendations for your account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRecommendationsRequest extends SesV2Request implements
        ToCopyableBuilder<ListRecommendationsRequest.Builder, ListRecommendationsRequest> {
    private static final SdkField<Map<String, String>> FILTER_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Filter")
            .getter(getter(ListRecommendationsRequest::filterAsStrings))
            .setter(setter(Builder::filterWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRecommendationsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PageSize").getter(getter(ListRecommendationsRequest::pageSize)).setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD,
            NEXT_TOKEN_FIELD, PAGE_SIZE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Map<String, String> filter;

    private final String nextToken;

    private final Integer pageSize;

    private ListRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.nextToken = builder.nextToken;
        this.pageSize = builder.pageSize;
    }

    /**
     * <p>
     * Filters applied when retrieving recommendations. Can eiter be an individual filter, or combinations of
     * <code>STATUS</code> and <code>IMPACT</code> or <code>STATUS</code> and <code>TYPE</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilter} method.
     * </p>
     * 
     * @return Filters applied when retrieving recommendations. Can eiter be an individual filter, or combinations of
     *         <code>STATUS</code> and <code>IMPACT</code> or <code>STATUS</code> and <code>TYPE</code>
     */
    public final Map<ListRecommendationsFilterKey, String> filter() {
        return ListRecommendationsFilterCopier.copyStringToEnum(filter);
    }

    /**
     * For responses, this returns true if the service returned a value for the Filter property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilter() {
        return filter != null && !(filter instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Filters applied when retrieving recommendations. Can eiter be an individual filter, or combinations of
     * <code>STATUS</code> and <code>IMPACT</code> or <code>STATUS</code> and <code>TYPE</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilter} method.
     * </p>
     * 
     * @return Filters applied when retrieving recommendations. Can eiter be an individual filter, or combinations of
     *         <code>STATUS</code> and <code>IMPACT</code> or <code>STATUS</code> and <code>TYPE</code>
     */
    public final Map<String, String> filterAsStrings() {
        return filter;
    }

    /**
     * <p>
     * A token returned from a previous call to <code>ListRecommendations</code> to indicate the position in the list of
     * recommendations.
     * </p>
     * 
     * @return A token returned from a previous call to <code>ListRecommendations</code> to indicate the position in the
     *         list of recommendations.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The number of results to show in a single call to <code>ListRecommendations</code>. If the number of results is
     * larger than the number you specified in this parameter, then the response includes a <code>NextToken</code>
     * element, which you can use to obtain additional results.
     * </p>
     * <p>
     * The value you specify has to be at least 1, and can be no more than 100.
     * </p>
     * 
     * @return The number of results to show in a single call to <code>ListRecommendations</code>. If the number of
     *         results is larger than the number you specified in this parameter, then the response includes a
     *         <code>NextToken</code> element, which you can use to obtain additional results.</p>
     *         <p>
     *         The value you specify has to be at least 1, and can be no more than 100.
     */
    public final Integer pageSize() {
        return pageSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilter() ? filterAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecommendationsRequest)) {
            return false;
        }
        ListRecommendationsRequest other = (ListRecommendationsRequest) obj;
        return hasFilter() == other.hasFilter() && Objects.equals(filterAsStrings(), other.filterAsStrings())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(pageSize(), other.pageSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRecommendationsRequest").add("Filter", hasFilter() ? filterAsStrings() : null)
                .add("NextToken", nextToken()).add("PageSize", pageSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filter":
            return Optional.ofNullable(clazz.cast(filterAsStrings()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Filter", FILTER_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("PageSize", PAGE_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRecommendationsRequest, T> g) {
        return obj -> g.apply((ListRecommendationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SesV2Request.Builder, SdkPojo, CopyableBuilder<Builder, ListRecommendationsRequest> {
        /**
         * <p>
         * Filters applied when retrieving recommendations. Can eiter be an individual filter, or combinations of
         * <code>STATUS</code> and <code>IMPACT</code> or <code>STATUS</code> and <code>TYPE</code>
         * </p>
         * 
         * @param filter
         *        Filters applied when retrieving recommendations. Can eiter be an individual filter, or combinations of
         *        <code>STATUS</code> and <code>IMPACT</code> or <code>STATUS</code> and <code>TYPE</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterWithStrings(Map<String, String> filter);

        /**
         * <p>
         * Filters applied when retrieving recommendations. Can eiter be an individual filter, or combinations of
         * <code>STATUS</code> and <code>IMPACT</code> or <code>STATUS</code> and <code>TYPE</code>
         * </p>
         * 
         * @param filter
         *        Filters applied when retrieving recommendations. Can eiter be an individual filter, or combinations of
         *        <code>STATUS</code> and <code>IMPACT</code> or <code>STATUS</code> and <code>TYPE</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Map<ListRecommendationsFilterKey, String> filter);

        /**
         * <p>
         * A token returned from a previous call to <code>ListRecommendations</code> to indicate the position in the
         * list of recommendations.
         * </p>
         * 
         * @param nextToken
         *        A token returned from a previous call to <code>ListRecommendations</code> to indicate the position in
         *        the list of recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The number of results to show in a single call to <code>ListRecommendations</code>. If the number of results
         * is larger than the number you specified in this parameter, then the response includes a
         * <code>NextToken</code> element, which you can use to obtain additional results.
         * </p>
         * <p>
         * The value you specify has to be at least 1, and can be no more than 100.
         * </p>
         * 
         * @param pageSize
         *        The number of results to show in a single call to <code>ListRecommendations</code>. If the number of
         *        results is larger than the number you specified in this parameter, then the response includes a
         *        <code>NextToken</code> element, which you can use to obtain additional results.</p>
         *        <p>
         *        The value you specify has to be at least 1, and can be no more than 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private Map<String, String> filter = DefaultSdkAutoConstructMap.getInstance();

        private String nextToken;

        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecommendationsRequest model) {
            super(model);
            filterWithStrings(model.filter);
            nextToken(model.nextToken);
            pageSize(model.pageSize);
        }

        public final Map<String, String> getFilter() {
            if (filter instanceof SdkAutoConstructMap) {
                return null;
            }
            return filter;
        }

        public final void setFilter(Map<String, String> filter) {
            this.filter = ListRecommendationsFilterCopier.copy(filter);
        }

        @Override
        public final Builder filterWithStrings(Map<String, String> filter) {
            this.filter = ListRecommendationsFilterCopier.copy(filter);
            return this;
        }

        @Override
        public final Builder filter(Map<ListRecommendationsFilterKey, String> filter) {
            this.filter = ListRecommendationsFilterCopier.copyEnumToString(filter);
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRecommendationsRequest build() {
            return new ListRecommendationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
