/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a specific tenant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTenantResponse extends SesV2Response implements
        ToCopyableBuilder<GetTenantResponse.Builder, GetTenantResponse> {
    private static final SdkField<Tenant> TENANT_FIELD = SdkField.<Tenant> builder(MarshallingType.SDK_POJO).memberName("Tenant")
            .getter(getter(GetTenantResponse::tenant)).setter(setter(Builder::tenant)).constructor(Tenant::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenant").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TENANT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Tenant tenant;

    private GetTenantResponse(BuilderImpl builder) {
        super(builder);
        this.tenant = builder.tenant;
    }

    /**
     * <p>
     * A structure that contains details about the tenant.
     * </p>
     * 
     * @return A structure that contains details about the tenant.
     */
    public final Tenant tenant() {
        return tenant;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tenant());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTenantResponse)) {
            return false;
        }
        GetTenantResponse other = (GetTenantResponse) obj;
        return Objects.equals(tenant(), other.tenant());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTenantResponse").add("Tenant", tenant()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Tenant":
            return Optional.ofNullable(clazz.cast(tenant()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Tenant", TENANT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTenantResponse, T> g) {
        return obj -> g.apply((GetTenantResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SesV2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetTenantResponse> {
        /**
         * <p>
         * A structure that contains details about the tenant.
         * </p>
         * 
         * @param tenant
         *        A structure that contains details about the tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenant(Tenant tenant);

        /**
         * <p>
         * A structure that contains details about the tenant.
         * </p>
         * This is a convenience method that creates an instance of the {@link Tenant.Builder} avoiding the need to
         * create one manually via {@link Tenant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Tenant.Builder#build()} is called immediately and its result is
         * passed to {@link #tenant(Tenant)}.
         * 
         * @param tenant
         *        a consumer that will call methods on {@link Tenant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tenant(Tenant)
         */
        default Builder tenant(Consumer<Tenant.Builder> tenant) {
            return tenant(Tenant.builder().applyMutation(tenant).build());
        }
    }

    static final class BuilderImpl extends SesV2Response.BuilderImpl implements Builder {
        private Tenant tenant;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTenantResponse model) {
            super(model);
            tenant(model.tenant);
        }

        public final Tenant.Builder getTenant() {
            return tenant != null ? tenant.toBuilder() : null;
        }

        public final void setTenant(Tenant.BuilderImpl tenant) {
            this.tenant = tenant != null ? tenant.build() : null;
        }

        @Override
        public final Builder tenant(Tenant tenant) {
            this.tenant = tenant;
            return this;
        }

        @Override
        public GetTenantResponse build() {
            return new GetTenantResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
