/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a configuration set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConfigurationSetResponse extends SesV2Response implements
        ToCopyableBuilder<GetConfigurationSetResponse.Builder, GetConfigurationSetResponse> {
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSetName").getter(getter(GetConfigurationSetResponse::configurationSetName))
            .setter(setter(Builder::configurationSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build())
            .build();

    private static final SdkField<TrackingOptions> TRACKING_OPTIONS_FIELD = SdkField
            .<TrackingOptions> builder(MarshallingType.SDK_POJO).memberName("TrackingOptions")
            .getter(getter(GetConfigurationSetResponse::trackingOptions)).setter(setter(Builder::trackingOptions))
            .constructor(TrackingOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingOptions").build()).build();

    private static final SdkField<DeliveryOptions> DELIVERY_OPTIONS_FIELD = SdkField
            .<DeliveryOptions> builder(MarshallingType.SDK_POJO).memberName("DeliveryOptions")
            .getter(getter(GetConfigurationSetResponse::deliveryOptions)).setter(setter(Builder::deliveryOptions))
            .constructor(DeliveryOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryOptions").build()).build();

    private static final SdkField<ReputationOptions> REPUTATION_OPTIONS_FIELD = SdkField
            .<ReputationOptions> builder(MarshallingType.SDK_POJO).memberName("ReputationOptions")
            .getter(getter(GetConfigurationSetResponse::reputationOptions)).setter(setter(Builder::reputationOptions))
            .constructor(ReputationOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReputationOptions").build()).build();

    private static final SdkField<SendingOptions> SENDING_OPTIONS_FIELD = SdkField
            .<SendingOptions> builder(MarshallingType.SDK_POJO).memberName("SendingOptions")
            .getter(getter(GetConfigurationSetResponse::sendingOptions)).setter(setter(Builder::sendingOptions))
            .constructor(SendingOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendingOptions").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(GetConfigurationSetResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SuppressionOptions> SUPPRESSION_OPTIONS_FIELD = SdkField
            .<SuppressionOptions> builder(MarshallingType.SDK_POJO).memberName("SuppressionOptions")
            .getter(getter(GetConfigurationSetResponse::suppressionOptions)).setter(setter(Builder::suppressionOptions))
            .constructor(SuppressionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuppressionOptions").build())
            .build();

    private static final SdkField<VdmOptions> VDM_OPTIONS_FIELD = SdkField.<VdmOptions> builder(MarshallingType.SDK_POJO)
            .memberName("VdmOptions").getter(getter(GetConfigurationSetResponse::vdmOptions)).setter(setter(Builder::vdmOptions))
            .constructor(VdmOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VdmOptions").build()).build();

    private static final SdkField<ArchivingOptions> ARCHIVING_OPTIONS_FIELD = SdkField
            .<ArchivingOptions> builder(MarshallingType.SDK_POJO).memberName("ArchivingOptions")
            .getter(getter(GetConfigurationSetResponse::archivingOptions)).setter(setter(Builder::archivingOptions))
            .constructor(ArchivingOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchivingOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_NAME_FIELD,
            TRACKING_OPTIONS_FIELD, DELIVERY_OPTIONS_FIELD, REPUTATION_OPTIONS_FIELD, SENDING_OPTIONS_FIELD, TAGS_FIELD,
            SUPPRESSION_OPTIONS_FIELD, VDM_OPTIONS_FIELD, ARCHIVING_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String configurationSetName;

    private final TrackingOptions trackingOptions;

    private final DeliveryOptions deliveryOptions;

    private final ReputationOptions reputationOptions;

    private final SendingOptions sendingOptions;

    private final List<Tag> tags;

    private final SuppressionOptions suppressionOptions;

    private final VdmOptions vdmOptions;

    private final ArchivingOptions archivingOptions;

    private GetConfigurationSetResponse(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.trackingOptions = builder.trackingOptions;
        this.deliveryOptions = builder.deliveryOptions;
        this.reputationOptions = builder.reputationOptions;
        this.sendingOptions = builder.sendingOptions;
        this.tags = builder.tags;
        this.suppressionOptions = builder.suppressionOptions;
        this.vdmOptions = builder.vdmOptions;
        this.archivingOptions = builder.archivingOptions;
    }

    /**
     * <p>
     * The name of the configuration set.
     * </p>
     * 
     * @return The name of the configuration set.
     */
    public final String configurationSetName() {
        return configurationSetName;
    }

    /**
     * <p>
     * An object that defines the open and click tracking options for emails that you send using the configuration set.
     * </p>
     * 
     * @return An object that defines the open and click tracking options for emails that you send using the
     *         configuration set.
     */
    public final TrackingOptions trackingOptions() {
        return trackingOptions;
    }

    /**
     * <p>
     * An object that defines the dedicated IP pool that is used to send emails that you send using the configuration
     * set.
     * </p>
     * 
     * @return An object that defines the dedicated IP pool that is used to send emails that you send using the
     *         configuration set.
     */
    public final DeliveryOptions deliveryOptions() {
        return deliveryOptions;
    }

    /**
     * <p>
     * An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send that
     * use the configuration set.
     * </p>
     * 
     * @return An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send
     *         that use the configuration set.
     */
    public final ReputationOptions reputationOptions() {
        return reputationOptions;
    }

    /**
     * <p>
     * An object that defines whether or not Amazon SES can send email that you send using the configuration set.
     * </p>
     * 
     * @return An object that defines whether or not Amazon SES can send email that you send using the configuration
     *         set.
     */
    public final SendingOptions sendingOptions() {
        return sendingOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that define the tags (keys and values) that are associated with the configuration set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of objects that define the tags (keys and values) that are associated with the configuration
     *         set.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * An object that contains information about the suppression list preferences for your account.
     * </p>
     * 
     * @return An object that contains information about the suppression list preferences for your account.
     */
    public final SuppressionOptions suppressionOptions() {
        return suppressionOptions;
    }

    /**
     * <p>
     * An object that contains information about the VDM preferences for your configuration set.
     * </p>
     * 
     * @return An object that contains information about the VDM preferences for your configuration set.
     */
    public final VdmOptions vdmOptions() {
        return vdmOptions;
    }

    /**
     * <p>
     * An object that defines the MailManager archive where sent emails are archived that you send using the
     * configuration set.
     * </p>
     * 
     * @return An object that defines the MailManager archive where sent emails are archived that you send using the
     *         configuration set.
     */
    public final ArchivingOptions archivingOptions() {
        return archivingOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(trackingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(reputationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(sendingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(suppressionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(vdmOptions());
        hashCode = 31 * hashCode + Objects.hashCode(archivingOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfigurationSetResponse)) {
            return false;
        }
        GetConfigurationSetResponse other = (GetConfigurationSetResponse) obj;
        return Objects.equals(configurationSetName(), other.configurationSetName())
                && Objects.equals(trackingOptions(), other.trackingOptions())
                && Objects.equals(deliveryOptions(), other.deliveryOptions())
                && Objects.equals(reputationOptions(), other.reputationOptions())
                && Objects.equals(sendingOptions(), other.sendingOptions()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(suppressionOptions(), other.suppressionOptions())
                && Objects.equals(vdmOptions(), other.vdmOptions())
                && Objects.equals(archivingOptions(), other.archivingOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConfigurationSetResponse").add("ConfigurationSetName", configurationSetName())
                .add("TrackingOptions", trackingOptions()).add("DeliveryOptions", deliveryOptions())
                .add("ReputationOptions", reputationOptions()).add("SendingOptions", sendingOptions())
                .add("Tags", hasTags() ? tags() : null).add("SuppressionOptions", suppressionOptions())
                .add("VdmOptions", vdmOptions()).add("ArchivingOptions", archivingOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSetName":
            return Optional.ofNullable(clazz.cast(configurationSetName()));
        case "TrackingOptions":
            return Optional.ofNullable(clazz.cast(trackingOptions()));
        case "DeliveryOptions":
            return Optional.ofNullable(clazz.cast(deliveryOptions()));
        case "ReputationOptions":
            return Optional.ofNullable(clazz.cast(reputationOptions()));
        case "SendingOptions":
            return Optional.ofNullable(clazz.cast(sendingOptions()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "SuppressionOptions":
            return Optional.ofNullable(clazz.cast(suppressionOptions()));
        case "VdmOptions":
            return Optional.ofNullable(clazz.cast(vdmOptions()));
        case "ArchivingOptions":
            return Optional.ofNullable(clazz.cast(archivingOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConfigurationSetName", CONFIGURATION_SET_NAME_FIELD);
        map.put("TrackingOptions", TRACKING_OPTIONS_FIELD);
        map.put("DeliveryOptions", DELIVERY_OPTIONS_FIELD);
        map.put("ReputationOptions", REPUTATION_OPTIONS_FIELD);
        map.put("SendingOptions", SENDING_OPTIONS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("SuppressionOptions", SUPPRESSION_OPTIONS_FIELD);
        map.put("VdmOptions", VDM_OPTIONS_FIELD);
        map.put("ArchivingOptions", ARCHIVING_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConfigurationSetResponse, T> g) {
        return obj -> g.apply((GetConfigurationSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SesV2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetConfigurationSetResponse> {
        /**
         * <p>
         * The name of the configuration set.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * An object that defines the open and click tracking options for emails that you send using the configuration
         * set.
         * </p>
         * 
         * @param trackingOptions
         *        An object that defines the open and click tracking options for emails that you send using the
         *        configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingOptions(TrackingOptions trackingOptions);

        /**
         * <p>
         * An object that defines the open and click tracking options for emails that you send using the configuration
         * set.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrackingOptions.Builder} avoiding the
         * need to create one manually via {@link TrackingOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrackingOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #trackingOptions(TrackingOptions)}.
         * 
         * @param trackingOptions
         *        a consumer that will call methods on {@link TrackingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trackingOptions(TrackingOptions)
         */
        default Builder trackingOptions(Consumer<TrackingOptions.Builder> trackingOptions) {
            return trackingOptions(TrackingOptions.builder().applyMutation(trackingOptions).build());
        }

        /**
         * <p>
         * An object that defines the dedicated IP pool that is used to send emails that you send using the
         * configuration set.
         * </p>
         * 
         * @param deliveryOptions
         *        An object that defines the dedicated IP pool that is used to send emails that you send using the
         *        configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryOptions(DeliveryOptions deliveryOptions);

        /**
         * <p>
         * An object that defines the dedicated IP pool that is used to send emails that you send using the
         * configuration set.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeliveryOptions.Builder} avoiding the
         * need to create one manually via {@link DeliveryOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeliveryOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #deliveryOptions(DeliveryOptions)}.
         * 
         * @param deliveryOptions
         *        a consumer that will call methods on {@link DeliveryOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deliveryOptions(DeliveryOptions)
         */
        default Builder deliveryOptions(Consumer<DeliveryOptions.Builder> deliveryOptions) {
            return deliveryOptions(DeliveryOptions.builder().applyMutation(deliveryOptions).build());
        }

        /**
         * <p>
         * An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send
         * that use the configuration set.
         * </p>
         * 
         * @param reputationOptions
         *        An object that defines whether or not Amazon SES collects reputation metrics for the emails that you
         *        send that use the configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reputationOptions(ReputationOptions reputationOptions);

        /**
         * <p>
         * An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send
         * that use the configuration set.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReputationOptions.Builder} avoiding the
         * need to create one manually via {@link ReputationOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReputationOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #reputationOptions(ReputationOptions)}.
         * 
         * @param reputationOptions
         *        a consumer that will call methods on {@link ReputationOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reputationOptions(ReputationOptions)
         */
        default Builder reputationOptions(Consumer<ReputationOptions.Builder> reputationOptions) {
            return reputationOptions(ReputationOptions.builder().applyMutation(reputationOptions).build());
        }

        /**
         * <p>
         * An object that defines whether or not Amazon SES can send email that you send using the configuration set.
         * </p>
         * 
         * @param sendingOptions
         *        An object that defines whether or not Amazon SES can send email that you send using the configuration
         *        set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendingOptions(SendingOptions sendingOptions);

        /**
         * <p>
         * An object that defines whether or not Amazon SES can send email that you send using the configuration set.
         * </p>
         * This is a convenience method that creates an instance of the {@link SendingOptions.Builder} avoiding the need
         * to create one manually via {@link SendingOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SendingOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #sendingOptions(SendingOptions)}.
         * 
         * @param sendingOptions
         *        a consumer that will call methods on {@link SendingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sendingOptions(SendingOptions)
         */
        default Builder sendingOptions(Consumer<SendingOptions.Builder> sendingOptions) {
            return sendingOptions(SendingOptions.builder().applyMutation(sendingOptions).build());
        }

        /**
         * <p>
         * An array of objects that define the tags (keys and values) that are associated with the configuration set.
         * </p>
         * 
         * @param tags
         *        An array of objects that define the tags (keys and values) that are associated with the configuration
         *        set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of objects that define the tags (keys and values) that are associated with the configuration set.
         * </p>
         * 
         * @param tags
         *        An array of objects that define the tags (keys and values) that are associated with the configuration
         *        set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of objects that define the tags (keys and values) that are associated with the configuration set.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sesv2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.sesv2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.sesv2.model.Tag.Builder#build()}
         * is called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.sesv2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * An object that contains information about the suppression list preferences for your account.
         * </p>
         * 
         * @param suppressionOptions
         *        An object that contains information about the suppression list preferences for your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppressionOptions(SuppressionOptions suppressionOptions);

        /**
         * <p>
         * An object that contains information about the suppression list preferences for your account.
         * </p>
         * This is a convenience method that creates an instance of the {@link SuppressionOptions.Builder} avoiding the
         * need to create one manually via {@link SuppressionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SuppressionOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #suppressionOptions(SuppressionOptions)}.
         * 
         * @param suppressionOptions
         *        a consumer that will call methods on {@link SuppressionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suppressionOptions(SuppressionOptions)
         */
        default Builder suppressionOptions(Consumer<SuppressionOptions.Builder> suppressionOptions) {
            return suppressionOptions(SuppressionOptions.builder().applyMutation(suppressionOptions).build());
        }

        /**
         * <p>
         * An object that contains information about the VDM preferences for your configuration set.
         * </p>
         * 
         * @param vdmOptions
         *        An object that contains information about the VDM preferences for your configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vdmOptions(VdmOptions vdmOptions);

        /**
         * <p>
         * An object that contains information about the VDM preferences for your configuration set.
         * </p>
         * This is a convenience method that creates an instance of the {@link VdmOptions.Builder} avoiding the need to
         * create one manually via {@link VdmOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VdmOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #vdmOptions(VdmOptions)}.
         * 
         * @param vdmOptions
         *        a consumer that will call methods on {@link VdmOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vdmOptions(VdmOptions)
         */
        default Builder vdmOptions(Consumer<VdmOptions.Builder> vdmOptions) {
            return vdmOptions(VdmOptions.builder().applyMutation(vdmOptions).build());
        }

        /**
         * <p>
         * An object that defines the MailManager archive where sent emails are archived that you send using the
         * configuration set.
         * </p>
         * 
         * @param archivingOptions
         *        An object that defines the MailManager archive where sent emails are archived that you send using the
         *        configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archivingOptions(ArchivingOptions archivingOptions);

        /**
         * <p>
         * An object that defines the MailManager archive where sent emails are archived that you send using the
         * configuration set.
         * </p>
         * This is a convenience method that creates an instance of the {@link ArchivingOptions.Builder} avoiding the
         * need to create one manually via {@link ArchivingOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArchivingOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #archivingOptions(ArchivingOptions)}.
         * 
         * @param archivingOptions
         *        a consumer that will call methods on {@link ArchivingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #archivingOptions(ArchivingOptions)
         */
        default Builder archivingOptions(Consumer<ArchivingOptions.Builder> archivingOptions) {
            return archivingOptions(ArchivingOptions.builder().applyMutation(archivingOptions).build());
        }
    }

    static final class BuilderImpl extends SesV2Response.BuilderImpl implements Builder {
        private String configurationSetName;

        private TrackingOptions trackingOptions;

        private DeliveryOptions deliveryOptions;

        private ReputationOptions reputationOptions;

        private SendingOptions sendingOptions;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private SuppressionOptions suppressionOptions;

        private VdmOptions vdmOptions;

        private ArchivingOptions archivingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfigurationSetResponse model) {
            super(model);
            configurationSetName(model.configurationSetName);
            trackingOptions(model.trackingOptions);
            deliveryOptions(model.deliveryOptions);
            reputationOptions(model.reputationOptions);
            sendingOptions(model.sendingOptions);
            tags(model.tags);
            suppressionOptions(model.suppressionOptions);
            vdmOptions(model.vdmOptions);
            archivingOptions(model.archivingOptions);
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final TrackingOptions.Builder getTrackingOptions() {
            return trackingOptions != null ? trackingOptions.toBuilder() : null;
        }

        public final void setTrackingOptions(TrackingOptions.BuilderImpl trackingOptions) {
            this.trackingOptions = trackingOptions != null ? trackingOptions.build() : null;
        }

        @Override
        public final Builder trackingOptions(TrackingOptions trackingOptions) {
            this.trackingOptions = trackingOptions;
            return this;
        }

        public final DeliveryOptions.Builder getDeliveryOptions() {
            return deliveryOptions != null ? deliveryOptions.toBuilder() : null;
        }

        public final void setDeliveryOptions(DeliveryOptions.BuilderImpl deliveryOptions) {
            this.deliveryOptions = deliveryOptions != null ? deliveryOptions.build() : null;
        }

        @Override
        public final Builder deliveryOptions(DeliveryOptions deliveryOptions) {
            this.deliveryOptions = deliveryOptions;
            return this;
        }

        public final ReputationOptions.Builder getReputationOptions() {
            return reputationOptions != null ? reputationOptions.toBuilder() : null;
        }

        public final void setReputationOptions(ReputationOptions.BuilderImpl reputationOptions) {
            this.reputationOptions = reputationOptions != null ? reputationOptions.build() : null;
        }

        @Override
        public final Builder reputationOptions(ReputationOptions reputationOptions) {
            this.reputationOptions = reputationOptions;
            return this;
        }

        public final SendingOptions.Builder getSendingOptions() {
            return sendingOptions != null ? sendingOptions.toBuilder() : null;
        }

        public final void setSendingOptions(SendingOptions.BuilderImpl sendingOptions) {
            this.sendingOptions = sendingOptions != null ? sendingOptions.build() : null;
        }

        @Override
        public final Builder sendingOptions(SendingOptions sendingOptions) {
            this.sendingOptions = sendingOptions;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final SuppressionOptions.Builder getSuppressionOptions() {
            return suppressionOptions != null ? suppressionOptions.toBuilder() : null;
        }

        public final void setSuppressionOptions(SuppressionOptions.BuilderImpl suppressionOptions) {
            this.suppressionOptions = suppressionOptions != null ? suppressionOptions.build() : null;
        }

        @Override
        public final Builder suppressionOptions(SuppressionOptions suppressionOptions) {
            this.suppressionOptions = suppressionOptions;
            return this;
        }

        public final VdmOptions.Builder getVdmOptions() {
            return vdmOptions != null ? vdmOptions.toBuilder() : null;
        }

        public final void setVdmOptions(VdmOptions.BuilderImpl vdmOptions) {
            this.vdmOptions = vdmOptions != null ? vdmOptions.build() : null;
        }

        @Override
        public final Builder vdmOptions(VdmOptions vdmOptions) {
            this.vdmOptions = vdmOptions;
            return this;
        }

        public final ArchivingOptions.Builder getArchivingOptions() {
            return archivingOptions != null ? archivingOptions.toBuilder() : null;
        }

        public final void setArchivingOptions(ArchivingOptions.BuilderImpl archivingOptions) {
            this.archivingOptions = archivingOptions != null ? archivingOptions.build() : null;
        }

        @Override
        public final Builder archivingOptions(ArchivingOptions archivingOptions) {
            this.archivingOptions = archivingOptions;
            return this;
        }

        @Override
        public GetConfigurationSetResponse build() {
            return new GetConfigurationSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
