/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains metadata related to a predictive inbox placement test.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeliverabilityTestReport implements SdkPojo, Serializable,
        ToCopyableBuilder<DeliverabilityTestReport.Builder, DeliverabilityTestReport> {
    private static final SdkField<String> REPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportId").getter(getter(DeliverabilityTestReport::reportId)).setter(setter(Builder::reportId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportId").build()).build();

    private static final SdkField<String> REPORT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportName").getter(getter(DeliverabilityTestReport::reportName)).setter(setter(Builder::reportName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportName").build()).build();

    private static final SdkField<String> SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Subject")
            .getter(getter(DeliverabilityTestReport::subject)).setter(setter(Builder::subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()).build();

    private static final SdkField<String> FROM_EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FromEmailAddress").getter(getter(DeliverabilityTestReport::fromEmailAddress))
            .setter(setter(Builder::fromEmailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromEmailAddress").build()).build();

    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateDate").getter(getter(DeliverabilityTestReport::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<String> DELIVERABILITY_TEST_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliverabilityTestStatus").getter(getter(DeliverabilityTestReport::deliverabilityTestStatusAsString))
            .setter(setter(Builder::deliverabilityTestStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliverabilityTestStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_ID_FIELD,
            REPORT_NAME_FIELD, SUBJECT_FIELD, FROM_EMAIL_ADDRESS_FIELD, CREATE_DATE_FIELD, DELIVERABILITY_TEST_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String reportId;

    private final String reportName;

    private final String subject;

    private final String fromEmailAddress;

    private final Instant createDate;

    private final String deliverabilityTestStatus;

    private DeliverabilityTestReport(BuilderImpl builder) {
        this.reportId = builder.reportId;
        this.reportName = builder.reportName;
        this.subject = builder.subject;
        this.fromEmailAddress = builder.fromEmailAddress;
        this.createDate = builder.createDate;
        this.deliverabilityTestStatus = builder.deliverabilityTestStatus;
    }

    /**
     * <p>
     * A unique string that identifies the predictive inbox placement test.
     * </p>
     * 
     * @return A unique string that identifies the predictive inbox placement test.
     */
    public final String reportId() {
        return reportId;
    }

    /**
     * <p>
     * A name that helps you identify a predictive inbox placement test report.
     * </p>
     * 
     * @return A name that helps you identify a predictive inbox placement test report.
     */
    public final String reportName() {
        return reportName;
    }

    /**
     * <p>
     * The subject line for an email that you submitted in a predictive inbox placement test.
     * </p>
     * 
     * @return The subject line for an email that you submitted in a predictive inbox placement test.
     */
    public final String subject() {
        return subject;
    }

    /**
     * <p>
     * The sender address that you specified for the predictive inbox placement test.
     * </p>
     * 
     * @return The sender address that you specified for the predictive inbox placement test.
     */
    public final String fromEmailAddress() {
        return fromEmailAddress;
    }

    /**
     * <p>
     * The date and time when the predictive inbox placement test was created.
     * </p>
     * 
     * @return The date and time when the predictive inbox placement test was created.
     */
    public final Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * The status of the predictive inbox placement test. If the status is <code>IN_PROGRESS</code>, then the predictive
     * inbox placement test is currently running. Predictive inbox placement tests are usually complete within 24 hours
     * of creating the test. If the status is <code>COMPLETE</code>, then the test is finished, and you can use the
     * <code>GetDeliverabilityTestReport</code> to view the results of the test.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deliverabilityTestStatus} will return {@link DeliverabilityTestStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deliverabilityTestStatusAsString}.
     * </p>
     * 
     * @return The status of the predictive inbox placement test. If the status is <code>IN_PROGRESS</code>, then the
     *         predictive inbox placement test is currently running. Predictive inbox placement tests are usually
     *         complete within 24 hours of creating the test. If the status is <code>COMPLETE</code>, then the test is
     *         finished, and you can use the <code>GetDeliverabilityTestReport</code> to view the results of the test.
     * @see DeliverabilityTestStatus
     */
    public final DeliverabilityTestStatus deliverabilityTestStatus() {
        return DeliverabilityTestStatus.fromValue(deliverabilityTestStatus);
    }

    /**
     * <p>
     * The status of the predictive inbox placement test. If the status is <code>IN_PROGRESS</code>, then the predictive
     * inbox placement test is currently running. Predictive inbox placement tests are usually complete within 24 hours
     * of creating the test. If the status is <code>COMPLETE</code>, then the test is finished, and you can use the
     * <code>GetDeliverabilityTestReport</code> to view the results of the test.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deliverabilityTestStatus} will return {@link DeliverabilityTestStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deliverabilityTestStatusAsString}.
     * </p>
     * 
     * @return The status of the predictive inbox placement test. If the status is <code>IN_PROGRESS</code>, then the
     *         predictive inbox placement test is currently running. Predictive inbox placement tests are usually
     *         complete within 24 hours of creating the test. If the status is <code>COMPLETE</code>, then the test is
     *         finished, and you can use the <code>GetDeliverabilityTestReport</code> to view the results of the test.
     * @see DeliverabilityTestStatus
     */
    public final String deliverabilityTestStatusAsString() {
        return deliverabilityTestStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reportId());
        hashCode = 31 * hashCode + Objects.hashCode(reportName());
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(fromEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(deliverabilityTestStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliverabilityTestReport)) {
            return false;
        }
        DeliverabilityTestReport other = (DeliverabilityTestReport) obj;
        return Objects.equals(reportId(), other.reportId()) && Objects.equals(reportName(), other.reportName())
                && Objects.equals(subject(), other.subject()) && Objects.equals(fromEmailAddress(), other.fromEmailAddress())
                && Objects.equals(createDate(), other.createDate())
                && Objects.equals(deliverabilityTestStatusAsString(), other.deliverabilityTestStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeliverabilityTestReport").add("ReportId", reportId()).add("ReportName", reportName())
                .add("Subject", subject()).add("FromEmailAddress", fromEmailAddress()).add("CreateDate", createDate())
                .add("DeliverabilityTestStatus", deliverabilityTestStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReportId":
            return Optional.ofNullable(clazz.cast(reportId()));
        case "ReportName":
            return Optional.ofNullable(clazz.cast(reportName()));
        case "Subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "FromEmailAddress":
            return Optional.ofNullable(clazz.cast(fromEmailAddress()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "DeliverabilityTestStatus":
            return Optional.ofNullable(clazz.cast(deliverabilityTestStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReportId", REPORT_ID_FIELD);
        map.put("ReportName", REPORT_NAME_FIELD);
        map.put("Subject", SUBJECT_FIELD);
        map.put("FromEmailAddress", FROM_EMAIL_ADDRESS_FIELD);
        map.put("CreateDate", CREATE_DATE_FIELD);
        map.put("DeliverabilityTestStatus", DELIVERABILITY_TEST_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeliverabilityTestReport, T> g) {
        return obj -> g.apply((DeliverabilityTestReport) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeliverabilityTestReport> {
        /**
         * <p>
         * A unique string that identifies the predictive inbox placement test.
         * </p>
         * 
         * @param reportId
         *        A unique string that identifies the predictive inbox placement test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportId(String reportId);

        /**
         * <p>
         * A name that helps you identify a predictive inbox placement test report.
         * </p>
         * 
         * @param reportName
         *        A name that helps you identify a predictive inbox placement test report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportName(String reportName);

        /**
         * <p>
         * The subject line for an email that you submitted in a predictive inbox placement test.
         * </p>
         * 
         * @param subject
         *        The subject line for an email that you submitted in a predictive inbox placement test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);

        /**
         * <p>
         * The sender address that you specified for the predictive inbox placement test.
         * </p>
         * 
         * @param fromEmailAddress
         *        The sender address that you specified for the predictive inbox placement test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromEmailAddress(String fromEmailAddress);

        /**
         * <p>
         * The date and time when the predictive inbox placement test was created.
         * </p>
         * 
         * @param createDate
         *        The date and time when the predictive inbox placement test was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * The status of the predictive inbox placement test. If the status is <code>IN_PROGRESS</code>, then the
         * predictive inbox placement test is currently running. Predictive inbox placement tests are usually complete
         * within 24 hours of creating the test. If the status is <code>COMPLETE</code>, then the test is finished, and
         * you can use the <code>GetDeliverabilityTestReport</code> to view the results of the test.
         * </p>
         * 
         * @param deliverabilityTestStatus
         *        The status of the predictive inbox placement test. If the status is <code>IN_PROGRESS</code>, then the
         *        predictive inbox placement test is currently running. Predictive inbox placement tests are usually
         *        complete within 24 hours of creating the test. If the status is <code>COMPLETE</code>, then the test
         *        is finished, and you can use the <code>GetDeliverabilityTestReport</code> to view the results of the
         *        test.
         * @see DeliverabilityTestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliverabilityTestStatus
         */
        Builder deliverabilityTestStatus(String deliverabilityTestStatus);

        /**
         * <p>
         * The status of the predictive inbox placement test. If the status is <code>IN_PROGRESS</code>, then the
         * predictive inbox placement test is currently running. Predictive inbox placement tests are usually complete
         * within 24 hours of creating the test. If the status is <code>COMPLETE</code>, then the test is finished, and
         * you can use the <code>GetDeliverabilityTestReport</code> to view the results of the test.
         * </p>
         * 
         * @param deliverabilityTestStatus
         *        The status of the predictive inbox placement test. If the status is <code>IN_PROGRESS</code>, then the
         *        predictive inbox placement test is currently running. Predictive inbox placement tests are usually
         *        complete within 24 hours of creating the test. If the status is <code>COMPLETE</code>, then the test
         *        is finished, and you can use the <code>GetDeliverabilityTestReport</code> to view the results of the
         *        test.
         * @see DeliverabilityTestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliverabilityTestStatus
         */
        Builder deliverabilityTestStatus(DeliverabilityTestStatus deliverabilityTestStatus);
    }

    static final class BuilderImpl implements Builder {
        private String reportId;

        private String reportName;

        private String subject;

        private String fromEmailAddress;

        private Instant createDate;

        private String deliverabilityTestStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeliverabilityTestReport model) {
            reportId(model.reportId);
            reportName(model.reportName);
            subject(model.subject);
            fromEmailAddress(model.fromEmailAddress);
            createDate(model.createDate);
            deliverabilityTestStatus(model.deliverabilityTestStatus);
        }

        public final String getReportId() {
            return reportId;
        }

        public final void setReportId(String reportId) {
            this.reportId = reportId;
        }

        @Override
        public final Builder reportId(String reportId) {
            this.reportId = reportId;
            return this;
        }

        public final String getReportName() {
            return reportName;
        }

        public final void setReportName(String reportName) {
            this.reportName = reportName;
        }

        @Override
        public final Builder reportName(String reportName) {
            this.reportName = reportName;
            return this;
        }

        public final String getSubject() {
            return subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final String getFromEmailAddress() {
            return fromEmailAddress;
        }

        public final void setFromEmailAddress(String fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
        }

        @Override
        public final Builder fromEmailAddress(String fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
            return this;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final String getDeliverabilityTestStatus() {
            return deliverabilityTestStatus;
        }

        public final void setDeliverabilityTestStatus(String deliverabilityTestStatus) {
            this.deliverabilityTestStatus = deliverabilityTestStatus;
        }

        @Override
        public final Builder deliverabilityTestStatus(String deliverabilityTestStatus) {
            this.deliverabilityTestStatus = deliverabilityTestStatus;
            return this;
        }

        @Override
        public final Builder deliverabilityTestStatus(DeliverabilityTestStatus deliverabilityTestStatus) {
            this.deliverabilityTestStatus(deliverabilityTestStatus == null ? null : deliverabilityTestStatus.toString());
            return this;
        }

        @Override
        public DeliverabilityTestReport build() {
            return new DeliverabilityTestReport(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
