/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing additional settings for your VDM configuration as applicable to the Dashboard.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashboardOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<DashboardOptions.Builder, DashboardOptions> {
    private static final SdkField<String> ENGAGEMENT_METRICS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngagementMetrics").getter(getter(DashboardOptions::engagementMetricsAsString))
            .setter(setter(Builder::engagementMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementMetrics").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGAGEMENT_METRICS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String engagementMetrics;

    private DashboardOptions(BuilderImpl builder) {
        this.engagementMetrics = builder.engagementMetrics;
    }

    /**
     * <p>
     * Specifies the status of your VDM engagement metrics collection. Can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> – Amazon SES enables engagement metrics for the configuration set.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> – Amazon SES disables engagement metrics for the configuration set.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engagementMetrics}
     * will return {@link FeatureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engagementMetricsAsString}.
     * </p>
     * 
     * @return Specifies the status of your VDM engagement metrics collection. Can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> – Amazon SES enables engagement metrics for the configuration set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> – Amazon SES disables engagement metrics for the configuration set.
     *         </p>
     *         </li>
     * @see FeatureStatus
     */
    public final FeatureStatus engagementMetrics() {
        return FeatureStatus.fromValue(engagementMetrics);
    }

    /**
     * <p>
     * Specifies the status of your VDM engagement metrics collection. Can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> – Amazon SES enables engagement metrics for the configuration set.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> – Amazon SES disables engagement metrics for the configuration set.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engagementMetrics}
     * will return {@link FeatureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engagementMetricsAsString}.
     * </p>
     * 
     * @return Specifies the status of your VDM engagement metrics collection. Can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> – Amazon SES enables engagement metrics for the configuration set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> – Amazon SES disables engagement metrics for the configuration set.
     *         </p>
     *         </li>
     * @see FeatureStatus
     */
    public final String engagementMetricsAsString() {
        return engagementMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(engagementMetricsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashboardOptions)) {
            return false;
        }
        DashboardOptions other = (DashboardOptions) obj;
        return Objects.equals(engagementMetricsAsString(), other.engagementMetricsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DashboardOptions").add("EngagementMetrics", engagementMetricsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EngagementMetrics":
            return Optional.ofNullable(clazz.cast(engagementMetricsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EngagementMetrics", ENGAGEMENT_METRICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DashboardOptions, T> g) {
        return obj -> g.apply((DashboardOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashboardOptions> {
        /**
         * <p>
         * Specifies the status of your VDM engagement metrics collection. Can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> – Amazon SES enables engagement metrics for the configuration set.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> – Amazon SES disables engagement metrics for the configuration set.
         * </p>
         * </li>
         * </ul>
         * 
         * @param engagementMetrics
         *        Specifies the status of your VDM engagement metrics collection. Can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> – Amazon SES enables engagement metrics for the configuration set.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> – Amazon SES disables engagement metrics for the configuration set.
         *        </p>
         *        </li>
         * @see FeatureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureStatus
         */
        Builder engagementMetrics(String engagementMetrics);

        /**
         * <p>
         * Specifies the status of your VDM engagement metrics collection. Can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> – Amazon SES enables engagement metrics for the configuration set.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> – Amazon SES disables engagement metrics for the configuration set.
         * </p>
         * </li>
         * </ul>
         * 
         * @param engagementMetrics
         *        Specifies the status of your VDM engagement metrics collection. Can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> – Amazon SES enables engagement metrics for the configuration set.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> – Amazon SES disables engagement metrics for the configuration set.
         *        </p>
         *        </li>
         * @see FeatureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureStatus
         */
        Builder engagementMetrics(FeatureStatus engagementMetrics);
    }

    static final class BuilderImpl implements Builder {
        private String engagementMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(DashboardOptions model) {
            engagementMetrics(model.engagementMetrics);
        }

        public final String getEngagementMetrics() {
            return engagementMetrics;
        }

        public final void setEngagementMetrics(String engagementMetrics) {
            this.engagementMetrics = engagementMetrics;
        }

        @Override
        public final Builder engagementMetrics(String engagementMetrics) {
            this.engagementMetrics = engagementMetrics;
            return this;
        }

        @Override
        public final Builder engagementMetrics(FeatureStatus engagementMetrics) {
            this.engagementMetrics(engagementMetrics == null ? null : engagementMetrics.toString());
            return this;
        }

        @Override
        public DashboardOptions build() {
            return new DashboardOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
