/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to create an import job from a data source for a data destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateImportJobRequest extends SesV2Request implements
        ToCopyableBuilder<CreateImportJobRequest.Builder, CreateImportJobRequest> {
    private static final SdkField<ImportDestination> IMPORT_DESTINATION_FIELD = SdkField
            .<ImportDestination> builder(MarshallingType.SDK_POJO).memberName("ImportDestination")
            .getter(getter(CreateImportJobRequest::importDestination)).setter(setter(Builder::importDestination))
            .constructor(ImportDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportDestination").build()).build();

    private static final SdkField<ImportDataSource> IMPORT_DATA_SOURCE_FIELD = SdkField
            .<ImportDataSource> builder(MarshallingType.SDK_POJO).memberName("ImportDataSource")
            .getter(getter(CreateImportJobRequest::importDataSource)).setter(setter(Builder::importDataSource))
            .constructor(ImportDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportDataSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_DESTINATION_FIELD,
            IMPORT_DATA_SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ImportDestination importDestination;

    private final ImportDataSource importDataSource;

    private CreateImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.importDestination = builder.importDestination;
        this.importDataSource = builder.importDataSource;
    }

    /**
     * <p>
     * The destination for the import job.
     * </p>
     * 
     * @return The destination for the import job.
     */
    public final ImportDestination importDestination() {
        return importDestination;
    }

    /**
     * <p>
     * The data source for the import job.
     * </p>
     * 
     * @return The data source for the import job.
     */
    public final ImportDataSource importDataSource() {
        return importDataSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(importDestination());
        hashCode = 31 * hashCode + Objects.hashCode(importDataSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImportJobRequest)) {
            return false;
        }
        CreateImportJobRequest other = (CreateImportJobRequest) obj;
        return Objects.equals(importDestination(), other.importDestination())
                && Objects.equals(importDataSource(), other.importDataSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateImportJobRequest").add("ImportDestination", importDestination())
                .add("ImportDataSource", importDataSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImportDestination":
            return Optional.ofNullable(clazz.cast(importDestination()));
        case "ImportDataSource":
            return Optional.ofNullable(clazz.cast(importDataSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ImportDestination", IMPORT_DESTINATION_FIELD);
        map.put("ImportDataSource", IMPORT_DATA_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateImportJobRequest, T> g) {
        return obj -> g.apply((CreateImportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SesV2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateImportJobRequest> {
        /**
         * <p>
         * The destination for the import job.
         * </p>
         * 
         * @param importDestination
         *        The destination for the import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importDestination(ImportDestination importDestination);

        /**
         * <p>
         * The destination for the import job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportDestination.Builder} avoiding the
         * need to create one manually via {@link ImportDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportDestination.Builder#build()} is called immediately and its
         * result is passed to {@link #importDestination(ImportDestination)}.
         * 
         * @param importDestination
         *        a consumer that will call methods on {@link ImportDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importDestination(ImportDestination)
         */
        default Builder importDestination(Consumer<ImportDestination.Builder> importDestination) {
            return importDestination(ImportDestination.builder().applyMutation(importDestination).build());
        }

        /**
         * <p>
         * The data source for the import job.
         * </p>
         * 
         * @param importDataSource
         *        The data source for the import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importDataSource(ImportDataSource importDataSource);

        /**
         * <p>
         * The data source for the import job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportDataSource.Builder} avoiding the
         * need to create one manually via {@link ImportDataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportDataSource.Builder#build()} is called immediately and its
         * result is passed to {@link #importDataSource(ImportDataSource)}.
         * 
         * @param importDataSource
         *        a consumer that will call methods on {@link ImportDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importDataSource(ImportDataSource)
         */
        default Builder importDataSource(Consumer<ImportDataSource.Builder> importDataSource) {
            return importDataSource(ImportDataSource.builder().applyMutation(importDataSource).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private ImportDestination importDestination;

        private ImportDataSource importDataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImportJobRequest model) {
            super(model);
            importDestination(model.importDestination);
            importDataSource(model.importDataSource);
        }

        public final ImportDestination.Builder getImportDestination() {
            return importDestination != null ? importDestination.toBuilder() : null;
        }

        public final void setImportDestination(ImportDestination.BuilderImpl importDestination) {
            this.importDestination = importDestination != null ? importDestination.build() : null;
        }

        @Override
        public final Builder importDestination(ImportDestination importDestination) {
            this.importDestination = importDestination;
            return this;
        }

        public final ImportDataSource.Builder getImportDataSource() {
            return importDataSource != null ? importDataSource.toBuilder() : null;
        }

        public final void setImportDataSource(ImportDataSource.BuilderImpl importDataSource) {
            this.importDataSource = importDataSource != null ? importDataSource.build() : null;
        }

        @Override
        public final Builder importDataSource(ImportDataSource importDataSource) {
            this.importDataSource = importDataSource;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateImportJobRequest build() {
            return new CreateImportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
