/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a <code>Complaint</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Complaint implements SdkPojo, Serializable, ToCopyableBuilder<Complaint.Builder, Complaint> {
    private static final SdkField<String> COMPLAINT_SUB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComplaintSubType").getter(getter(Complaint::complaintSubType)).setter(setter(Builder::complaintSubType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplaintSubType").build()).build();

    private static final SdkField<String> COMPLAINT_FEEDBACK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComplaintFeedbackType").getter(getter(Complaint::complaintFeedbackType))
            .setter(setter(Builder::complaintFeedbackType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplaintFeedbackType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLAINT_SUB_TYPE_FIELD,
            COMPLAINT_FEEDBACK_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String complaintSubType;

    private final String complaintFeedbackType;

    private Complaint(BuilderImpl builder) {
        this.complaintSubType = builder.complaintSubType;
        this.complaintFeedbackType = builder.complaintFeedbackType;
    }

    /**
     * <p>
     * Can either be <code>null</code> or <code>OnAccountSuppressionList</code>. If the value is
     * <code>OnAccountSuppressionList</code>, SES accepted the message, but didn't attempt to send it because it was on
     * the account-level suppression list.
     * </p>
     * 
     * @return Can either be <code>null</code> or <code>OnAccountSuppressionList</code>. If the value is
     *         <code>OnAccountSuppressionList</code>, SES accepted the message, but didn't attempt to send it because it
     *         was on the account-level suppression list.
     */
    public final String complaintSubType() {
        return complaintSubType;
    }

    /**
     * <p>
     * The value of the <code>Feedback-Type</code> field from the feedback report received from the ISP.
     * </p>
     * 
     * @return The value of the <code>Feedback-Type</code> field from the feedback report received from the ISP.
     */
    public final String complaintFeedbackType() {
        return complaintFeedbackType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(complaintSubType());
        hashCode = 31 * hashCode + Objects.hashCode(complaintFeedbackType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Complaint)) {
            return false;
        }
        Complaint other = (Complaint) obj;
        return Objects.equals(complaintSubType(), other.complaintSubType())
                && Objects.equals(complaintFeedbackType(), other.complaintFeedbackType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Complaint").add("ComplaintSubType", complaintSubType())
                .add("ComplaintFeedbackType", complaintFeedbackType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComplaintSubType":
            return Optional.ofNullable(clazz.cast(complaintSubType()));
        case "ComplaintFeedbackType":
            return Optional.ofNullable(clazz.cast(complaintFeedbackType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ComplaintSubType", COMPLAINT_SUB_TYPE_FIELD);
        map.put("ComplaintFeedbackType", COMPLAINT_FEEDBACK_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Complaint, T> g) {
        return obj -> g.apply((Complaint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Complaint> {
        /**
         * <p>
         * Can either be <code>null</code> or <code>OnAccountSuppressionList</code>. If the value is
         * <code>OnAccountSuppressionList</code>, SES accepted the message, but didn't attempt to send it because it was
         * on the account-level suppression list.
         * </p>
         * 
         * @param complaintSubType
         *        Can either be <code>null</code> or <code>OnAccountSuppressionList</code>. If the value is
         *        <code>OnAccountSuppressionList</code>, SES accepted the message, but didn't attempt to send it because
         *        it was on the account-level suppression list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complaintSubType(String complaintSubType);

        /**
         * <p>
         * The value of the <code>Feedback-Type</code> field from the feedback report received from the ISP.
         * </p>
         * 
         * @param complaintFeedbackType
         *        The value of the <code>Feedback-Type</code> field from the feedback report received from the ISP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complaintFeedbackType(String complaintFeedbackType);
    }

    static final class BuilderImpl implements Builder {
        private String complaintSubType;

        private String complaintFeedbackType;

        private BuilderImpl() {
        }

        private BuilderImpl(Complaint model) {
            complaintSubType(model.complaintSubType);
            complaintFeedbackType(model.complaintFeedbackType);
        }

        public final String getComplaintSubType() {
            return complaintSubType;
        }

        public final void setComplaintSubType(String complaintSubType) {
            this.complaintSubType = complaintSubType;
        }

        @Override
        public final Builder complaintSubType(String complaintSubType) {
            this.complaintSubType = complaintSubType;
            return this;
        }

        public final String getComplaintFeedbackType() {
            return complaintFeedbackType;
        }

        public final void setComplaintFeedbackType(String complaintFeedbackType) {
            this.complaintFeedbackType = complaintFeedbackType;
        }

        @Override
        public final Builder complaintFeedbackType(String complaintFeedbackType) {
            this.complaintFeedbackType = complaintFeedbackType;
            return this;
        }

        @Override
        public Complaint build() {
            return new Complaint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
