/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a <code>Bounce</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Bounce implements SdkPojo, Serializable, ToCopyableBuilder<Bounce.Builder, Bounce> {
    private static final SdkField<String> BOUNCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BounceType").getter(getter(Bounce::bounceTypeAsString)).setter(setter(Builder::bounceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BounceType").build()).build();

    private static final SdkField<String> BOUNCE_SUB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BounceSubType").getter(getter(Bounce::bounceSubType)).setter(setter(Builder::bounceSubType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BounceSubType").build()).build();

    private static final SdkField<String> DIAGNOSTIC_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiagnosticCode").getter(getter(Bounce::diagnosticCode)).setter(setter(Builder::diagnosticCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiagnosticCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOUNCE_TYPE_FIELD,
            BOUNCE_SUB_TYPE_FIELD, DIAGNOSTIC_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String bounceType;

    private final String bounceSubType;

    private final String diagnosticCode;

    private Bounce(BuilderImpl builder) {
        this.bounceType = builder.bounceType;
        this.bounceSubType = builder.bounceSubType;
        this.diagnosticCode = builder.diagnosticCode;
    }

    /**
     * <p>
     * The type of the bounce, as determined by SES. Can be one of <code>UNDETERMINED</code>, <code>TRANSIENT</code>, or
     * <code>PERMANENT</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bounceType} will
     * return {@link BounceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bounceTypeAsString}.
     * </p>
     * 
     * @return The type of the bounce, as determined by SES. Can be one of <code>UNDETERMINED</code>,
     *         <code>TRANSIENT</code>, or <code>PERMANENT</code>
     * @see BounceType
     */
    public final BounceType bounceType() {
        return BounceType.fromValue(bounceType);
    }

    /**
     * <p>
     * The type of the bounce, as determined by SES. Can be one of <code>UNDETERMINED</code>, <code>TRANSIENT</code>, or
     * <code>PERMANENT</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bounceType} will
     * return {@link BounceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bounceTypeAsString}.
     * </p>
     * 
     * @return The type of the bounce, as determined by SES. Can be one of <code>UNDETERMINED</code>,
     *         <code>TRANSIENT</code>, or <code>PERMANENT</code>
     * @see BounceType
     */
    public final String bounceTypeAsString() {
        return bounceType;
    }

    /**
     * <p>
     * The subtype of the bounce, as determined by SES.
     * </p>
     * 
     * @return The subtype of the bounce, as determined by SES.
     */
    public final String bounceSubType() {
        return bounceSubType;
    }

    /**
     * <p>
     * The status code issued by the reporting Message Transfer Authority (MTA). This field only appears if a delivery
     * status notification (DSN) was attached to the bounce and the <code>Diagnostic-Code</code> was provided in the
     * DSN.
     * </p>
     * 
     * @return The status code issued by the reporting Message Transfer Authority (MTA). This field only appears if a
     *         delivery status notification (DSN) was attached to the bounce and the <code>Diagnostic-Code</code> was
     *         provided in the DSN.
     */
    public final String diagnosticCode() {
        return diagnosticCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bounceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(bounceSubType());
        hashCode = 31 * hashCode + Objects.hashCode(diagnosticCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Bounce)) {
            return false;
        }
        Bounce other = (Bounce) obj;
        return Objects.equals(bounceTypeAsString(), other.bounceTypeAsString())
                && Objects.equals(bounceSubType(), other.bounceSubType())
                && Objects.equals(diagnosticCode(), other.diagnosticCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Bounce").add("BounceType", bounceTypeAsString()).add("BounceSubType", bounceSubType())
                .add("DiagnosticCode", diagnosticCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BounceType":
            return Optional.ofNullable(clazz.cast(bounceTypeAsString()));
        case "BounceSubType":
            return Optional.ofNullable(clazz.cast(bounceSubType()));
        case "DiagnosticCode":
            return Optional.ofNullable(clazz.cast(diagnosticCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BounceType", BOUNCE_TYPE_FIELD);
        map.put("BounceSubType", BOUNCE_SUB_TYPE_FIELD);
        map.put("DiagnosticCode", DIAGNOSTIC_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Bounce, T> g) {
        return obj -> g.apply((Bounce) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Bounce> {
        /**
         * <p>
         * The type of the bounce, as determined by SES. Can be one of <code>UNDETERMINED</code>, <code>TRANSIENT</code>
         * , or <code>PERMANENT</code>
         * </p>
         * 
         * @param bounceType
         *        The type of the bounce, as determined by SES. Can be one of <code>UNDETERMINED</code>,
         *        <code>TRANSIENT</code>, or <code>PERMANENT</code>
         * @see BounceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BounceType
         */
        Builder bounceType(String bounceType);

        /**
         * <p>
         * The type of the bounce, as determined by SES. Can be one of <code>UNDETERMINED</code>, <code>TRANSIENT</code>
         * , or <code>PERMANENT</code>
         * </p>
         * 
         * @param bounceType
         *        The type of the bounce, as determined by SES. Can be one of <code>UNDETERMINED</code>,
         *        <code>TRANSIENT</code>, or <code>PERMANENT</code>
         * @see BounceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BounceType
         */
        Builder bounceType(BounceType bounceType);

        /**
         * <p>
         * The subtype of the bounce, as determined by SES.
         * </p>
         * 
         * @param bounceSubType
         *        The subtype of the bounce, as determined by SES.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bounceSubType(String bounceSubType);

        /**
         * <p>
         * The status code issued by the reporting Message Transfer Authority (MTA). This field only appears if a
         * delivery status notification (DSN) was attached to the bounce and the <code>Diagnostic-Code</code> was
         * provided in the DSN.
         * </p>
         * 
         * @param diagnosticCode
         *        The status code issued by the reporting Message Transfer Authority (MTA). This field only appears if a
         *        delivery status notification (DSN) was attached to the bounce and the <code>Diagnostic-Code</code> was
         *        provided in the DSN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diagnosticCode(String diagnosticCode);
    }

    static final class BuilderImpl implements Builder {
        private String bounceType;

        private String bounceSubType;

        private String diagnosticCode;

        private BuilderImpl() {
        }

        private BuilderImpl(Bounce model) {
            bounceType(model.bounceType);
            bounceSubType(model.bounceSubType);
            diagnosticCode(model.diagnosticCode);
        }

        public final String getBounceType() {
            return bounceType;
        }

        public final void setBounceType(String bounceType) {
            this.bounceType = bounceType;
        }

        @Override
        public final Builder bounceType(String bounceType) {
            this.bounceType = bounceType;
            return this;
        }

        @Override
        public final Builder bounceType(BounceType bounceType) {
            this.bounceType(bounceType == null ? null : bounceType.toString());
            return this;
        }

        public final String getBounceSubType() {
            return bounceSubType;
        }

        public final void setBounceSubType(String bounceSubType) {
            this.bounceSubType = bounceSubType;
        }

        @Override
        public final Builder bounceSubType(String bounceSubType) {
            this.bounceSubType = bounceSubType;
            return this;
        }

        public final String getDiagnosticCode() {
            return diagnosticCode;
        }

        public final void setDiagnosticCode(String diagnosticCode) {
            this.diagnosticCode = diagnosticCode;
        }

        @Override
        public final Builder diagnosticCode(String diagnosticCode) {
            this.diagnosticCode = diagnosticCode;
            return this;
        }

        @Override
        public Bounce build() {
            return new Bounce(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
