/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.auth.scheme.internal;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.auth.aws.signer.RegionSet;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sesv2.auth.scheme.SesV2AuthSchemeParams;
import software.amazon.awssdk.services.sesv2.endpoints.SesV2EndpointProvider;
import software.amazon.awssdk.utils.Validate;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public final class DefaultSesV2AuthSchemeParams implements SesV2AuthSchemeParams, SesV2EndpointResolverAware {
    private final String operation;

    private final Region region;

    private final RegionSet regionSet;

    private final Boolean useDualStack;

    private final Boolean useFIPS;

    private final String endpoint;

    private final String endpointId;

    private final SesV2EndpointProvider endpointProvider;

    private DefaultSesV2AuthSchemeParams(Builder builder) {
        this.operation = Validate.paramNotNull(builder.operation, "operation");
        this.region = builder.region;
        this.regionSet = builder.regionSet;
        this.useDualStack = Validate.paramNotNull(builder.useDualStack, "useDualStack");
        this.useFIPS = Validate.paramNotNull(builder.useFIPS, "useFIPS");
        this.endpoint = builder.endpoint;
        this.endpointId = builder.endpointId;
        this.endpointProvider = builder.endpointProvider;
    }

    public static SesV2AuthSchemeParams.Builder builder() {
        return new Builder();
    }

    @Override
    public String operation() {
        return operation;
    }

    @Override
    public Region region() {
        return region;
    }

    @Override
    public RegionSet regionSet() {
        return regionSet;
    }

    @Override
    public Boolean useDualStack() {
        return useDualStack;
    }

    @Override
    public Boolean useFips() {
        return useFIPS;
    }

    @Override
    public String endpoint() {
        return endpoint;
    }

    @Override
    public String endpointId() {
        return endpointId;
    }

    @Override
    public SesV2EndpointProvider endpointProvider() {
        return endpointProvider;
    }

    @Override
    public SesV2AuthSchemeParams.Builder toBuilder() {
        return new Builder(this);
    }

    private static final class Builder implements SesV2AuthSchemeParams.Builder, SesV2EndpointResolverAware.Builder {
        private String operation;

        private Region region;

        private RegionSet regionSet;

        private Boolean useDualStack = false;

        private Boolean useFIPS = false;

        private String endpoint;

        private String endpointId;

        private SesV2EndpointProvider endpointProvider;

        Builder() {
        }

        Builder(DefaultSesV2AuthSchemeParams params) {
            this.operation = params.operation;
            this.region = params.region;
            this.regionSet = params.regionSet;
            this.useDualStack = params.useDualStack;
            this.useFIPS = params.useFIPS;
            this.endpoint = params.endpoint;
            this.endpointId = params.endpointId;
            this.endpointProvider = params.endpointProvider;
        }

        @Override
        public Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public Builder regionSet(RegionSet regionSet) {
            this.regionSet = regionSet;
            return this;
        }

        @Override
        public Builder useDualStack(Boolean useDualStack) {
            this.useDualStack = useDualStack;
            if (this.useDualStack == null) {
                this.useDualStack = false;
            }
            return this;
        }

        @Override
        public Builder useFips(Boolean useFIPS) {
            this.useFIPS = useFIPS;
            if (this.useFIPS == null) {
                this.useFIPS = false;
            }
            return this;
        }

        @Override
        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        @Override
        public Builder endpointProvider(SesV2EndpointProvider endpointProvider) {
            this.endpointProvider = endpointProvider;
            return this;
        }

        @Override
        public SesV2AuthSchemeParams build() {
            return new DefaultSesV2AuthSchemeParams(this);
        }
    }
}
