/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataRequest;
import software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataResponse;
import software.amazon.awssdk.services.sesv2.model.CancelExportJobRequest;
import software.amazon.awssdk.services.sesv2.model.CancelExportJobResponse;
import software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetRequest;
import software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetResponse;
import software.amazon.awssdk.services.sesv2.model.CreateContactListRequest;
import software.amazon.awssdk.services.sesv2.model.CreateContactListResponse;
import software.amazon.awssdk.services.sesv2.model.CreateContactRequest;
import software.amazon.awssdk.services.sesv2.model.CreateContactResponse;
import software.amazon.awssdk.services.sesv2.model.CreateCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.CreateCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.CreateDedicatedIpPoolRequest;
import software.amazon.awssdk.services.sesv2.model.CreateDedicatedIpPoolResponse;
import software.amazon.awssdk.services.sesv2.model.CreateDeliverabilityTestReportRequest;
import software.amazon.awssdk.services.sesv2.model.CreateDeliverabilityTestReportResponse;
import software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityPolicyRequest;
import software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityPolicyResponse;
import software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityRequest;
import software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityResponse;
import software.amazon.awssdk.services.sesv2.model.CreateEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.CreateEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.CreateExportJobRequest;
import software.amazon.awssdk.services.sesv2.model.CreateExportJobResponse;
import software.amazon.awssdk.services.sesv2.model.CreateImportJobRequest;
import software.amazon.awssdk.services.sesv2.model.CreateImportJobResponse;
import software.amazon.awssdk.services.sesv2.model.CreateMultiRegionEndpointRequest;
import software.amazon.awssdk.services.sesv2.model.CreateMultiRegionEndpointResponse;
import software.amazon.awssdk.services.sesv2.model.CreateTenantRequest;
import software.amazon.awssdk.services.sesv2.model.CreateTenantResourceAssociationRequest;
import software.amazon.awssdk.services.sesv2.model.CreateTenantResourceAssociationResponse;
import software.amazon.awssdk.services.sesv2.model.CreateTenantResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteContactListRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteContactListResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteContactRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteContactResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteDedicatedIpPoolRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteDedicatedIpPoolResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityPolicyRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityPolicyResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteMultiRegionEndpointRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteMultiRegionEndpointResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteSuppressedDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteSuppressedDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteTenantRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteTenantResourceAssociationRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteTenantResourceAssociationResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteTenantResponse;
import software.amazon.awssdk.services.sesv2.model.GetAccountRequest;
import software.amazon.awssdk.services.sesv2.model.GetAccountResponse;
import software.amazon.awssdk.services.sesv2.model.GetBlacklistReportsRequest;
import software.amazon.awssdk.services.sesv2.model.GetBlacklistReportsResponse;
import software.amazon.awssdk.services.sesv2.model.GetConfigurationSetEventDestinationsRequest;
import software.amazon.awssdk.services.sesv2.model.GetConfigurationSetEventDestinationsResponse;
import software.amazon.awssdk.services.sesv2.model.GetConfigurationSetRequest;
import software.amazon.awssdk.services.sesv2.model.GetConfigurationSetResponse;
import software.amazon.awssdk.services.sesv2.model.GetContactListRequest;
import software.amazon.awssdk.services.sesv2.model.GetContactListResponse;
import software.amazon.awssdk.services.sesv2.model.GetContactRequest;
import software.amazon.awssdk.services.sesv2.model.GetContactResponse;
import software.amazon.awssdk.services.sesv2.model.GetCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.GetCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpPoolRequest;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpPoolResponse;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpRequest;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpResponse;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsRequest;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsResponse;
import software.amazon.awssdk.services.sesv2.model.GetDeliverabilityDashboardOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.GetDeliverabilityDashboardOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.GetDeliverabilityTestReportRequest;
import software.amazon.awssdk.services.sesv2.model.GetDeliverabilityTestReportResponse;
import software.amazon.awssdk.services.sesv2.model.GetDomainDeliverabilityCampaignRequest;
import software.amazon.awssdk.services.sesv2.model.GetDomainDeliverabilityCampaignResponse;
import software.amazon.awssdk.services.sesv2.model.GetDomainStatisticsReportRequest;
import software.amazon.awssdk.services.sesv2.model.GetDomainStatisticsReportResponse;
import software.amazon.awssdk.services.sesv2.model.GetEmailIdentityPoliciesRequest;
import software.amazon.awssdk.services.sesv2.model.GetEmailIdentityPoliciesResponse;
import software.amazon.awssdk.services.sesv2.model.GetEmailIdentityRequest;
import software.amazon.awssdk.services.sesv2.model.GetEmailIdentityResponse;
import software.amazon.awssdk.services.sesv2.model.GetEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.GetEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.GetExportJobRequest;
import software.amazon.awssdk.services.sesv2.model.GetExportJobResponse;
import software.amazon.awssdk.services.sesv2.model.GetImportJobRequest;
import software.amazon.awssdk.services.sesv2.model.GetImportJobResponse;
import software.amazon.awssdk.services.sesv2.model.GetMessageInsightsRequest;
import software.amazon.awssdk.services.sesv2.model.GetMessageInsightsResponse;
import software.amazon.awssdk.services.sesv2.model.GetMultiRegionEndpointRequest;
import software.amazon.awssdk.services.sesv2.model.GetMultiRegionEndpointResponse;
import software.amazon.awssdk.services.sesv2.model.GetReputationEntityRequest;
import software.amazon.awssdk.services.sesv2.model.GetReputationEntityResponse;
import software.amazon.awssdk.services.sesv2.model.GetSuppressedDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.GetSuppressedDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.GetTenantRequest;
import software.amazon.awssdk.services.sesv2.model.GetTenantResponse;
import software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsRequest;
import software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsResponse;
import software.amazon.awssdk.services.sesv2.model.ListContactListsRequest;
import software.amazon.awssdk.services.sesv2.model.ListContactListsResponse;
import software.amazon.awssdk.services.sesv2.model.ListContactsRequest;
import software.amazon.awssdk.services.sesv2.model.ListContactsResponse;
import software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesRequest;
import software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesResponse;
import software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsRequest;
import software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsResponse;
import software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsRequest;
import software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsResponse;
import software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsRequest;
import software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsResponse;
import software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesRequest;
import software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesResponse;
import software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesRequest;
import software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesResponse;
import software.amazon.awssdk.services.sesv2.model.ListExportJobsRequest;
import software.amazon.awssdk.services.sesv2.model.ListExportJobsResponse;
import software.amazon.awssdk.services.sesv2.model.ListImportJobsRequest;
import software.amazon.awssdk.services.sesv2.model.ListImportJobsResponse;
import software.amazon.awssdk.services.sesv2.model.ListMultiRegionEndpointsRequest;
import software.amazon.awssdk.services.sesv2.model.ListMultiRegionEndpointsResponse;
import software.amazon.awssdk.services.sesv2.model.ListRecommendationsRequest;
import software.amazon.awssdk.services.sesv2.model.ListRecommendationsResponse;
import software.amazon.awssdk.services.sesv2.model.ListReputationEntitiesRequest;
import software.amazon.awssdk.services.sesv2.model.ListReputationEntitiesResponse;
import software.amazon.awssdk.services.sesv2.model.ListResourceTenantsRequest;
import software.amazon.awssdk.services.sesv2.model.ListResourceTenantsResponse;
import software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsRequest;
import software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsResponse;
import software.amazon.awssdk.services.sesv2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.sesv2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.sesv2.model.ListTenantResourcesRequest;
import software.amazon.awssdk.services.sesv2.model.ListTenantResourcesResponse;
import software.amazon.awssdk.services.sesv2.model.ListTenantsRequest;
import software.amazon.awssdk.services.sesv2.model.ListTenantsResponse;
import software.amazon.awssdk.services.sesv2.model.PutAccountDedicatedIpWarmupAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutAccountDedicatedIpWarmupAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutAccountDetailsRequest;
import software.amazon.awssdk.services.sesv2.model.PutAccountDetailsResponse;
import software.amazon.awssdk.services.sesv2.model.PutAccountSendingAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutAccountSendingAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutAccountSuppressionAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutAccountSuppressionAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutAccountVdmAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutAccountVdmAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetArchivingOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetArchivingOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetDeliveryOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetDeliveryOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetReputationOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetReputationOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSendingOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSendingOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSuppressionOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSuppressionOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetTrackingOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetTrackingOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetVdmOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetVdmOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpInPoolRequest;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpInPoolResponse;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpPoolScalingAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpPoolScalingAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpWarmupAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpWarmupAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutDeliverabilityDashboardOptionRequest;
import software.amazon.awssdk.services.sesv2.model.PutDeliverabilityDashboardOptionResponse;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityConfigurationSetAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityConfigurationSetAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimSigningAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimSigningAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityFeedbackAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityFeedbackAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityMailFromAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityMailFromAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutSuppressedDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.PutSuppressedDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.SendBulkEmailRequest;
import software.amazon.awssdk.services.sesv2.model.SendBulkEmailResponse;
import software.amazon.awssdk.services.sesv2.model.SendCustomVerificationEmailRequest;
import software.amazon.awssdk.services.sesv2.model.SendCustomVerificationEmailResponse;
import software.amazon.awssdk.services.sesv2.model.SendEmailRequest;
import software.amazon.awssdk.services.sesv2.model.SendEmailResponse;
import software.amazon.awssdk.services.sesv2.model.TagResourceRequest;
import software.amazon.awssdk.services.sesv2.model.TagResourceResponse;
import software.amazon.awssdk.services.sesv2.model.TestRenderEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.TestRenderEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.sesv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateContactListRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateContactListResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateContactRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateContactResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateEmailIdentityPolicyRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateEmailIdentityPolicyResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateReputationEntityCustomerManagedStatusRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateReputationEntityCustomerManagedStatusResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateReputationEntityPolicyRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateReputationEntityPolicyResponse;
import software.amazon.awssdk.services.sesv2.paginators.GetDedicatedIpsPublisher;
import software.amazon.awssdk.services.sesv2.paginators.ListConfigurationSetsPublisher;
import software.amazon.awssdk.services.sesv2.paginators.ListContactListsPublisher;
import software.amazon.awssdk.services.sesv2.paginators.ListContactsPublisher;
import software.amazon.awssdk.services.sesv2.paginators.ListCustomVerificationEmailTemplatesPublisher;
import software.amazon.awssdk.services.sesv2.paginators.ListDedicatedIpPoolsPublisher;
import software.amazon.awssdk.services.sesv2.paginators.ListDeliverabilityTestReportsPublisher;
import software.amazon.awssdk.services.sesv2.paginators.ListDomainDeliverabilityCampaignsPublisher;
import software.amazon.awssdk.services.sesv2.paginators.ListEmailIdentitiesPublisher;
import software.amazon.awssdk.services.sesv2.paginators.ListEmailTemplatesPublisher;
import software.amazon.awssdk.services.sesv2.paginators.ListExportJobsPublisher;
import software.amazon.awssdk.services.sesv2.paginators.ListImportJobsPublisher;
import software.amazon.awssdk.services.sesv2.paginators.ListMultiRegionEndpointsPublisher;
import software.amazon.awssdk.services.sesv2.paginators.ListRecommendationsPublisher;
import software.amazon.awssdk.services.sesv2.paginators.ListReputationEntitiesPublisher;
import software.amazon.awssdk.services.sesv2.paginators.ListResourceTenantsPublisher;
import software.amazon.awssdk.services.sesv2.paginators.ListSuppressedDestinationsPublisher;
import software.amazon.awssdk.services.sesv2.paginators.ListTenantResourcesPublisher;
import software.amazon.awssdk.services.sesv2.paginators.ListTenantsPublisher;

/**
 * Service client for accessing Amazon SES V2 asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <fullname>Amazon SES API v2</fullname>
 * <p>
 * <a href="http://aws.amazon.com/ses">Amazon SES</a> is an Amazon Web Services service that you can use to send email
 * messages to your customers.
 * </p>
 * <p>
 * If you're new to Amazon SES API v2, you might find it helpful to review the <a
 * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/">Amazon Simple Email Service Developer Guide</a>. The
 * <i>Amazon SES Developer Guide</i> provides information and code samples that demonstrate how to use Amazon SES API v2
 * features programmatically.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SesV2AsyncClient extends AwsClient {
    String SERVICE_NAME = "ses";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "email";

    /**
     * <p>
     * Retrieves batches of metric data collected based on your sending activity.
     * </p>
     * <p>
     * You can execute this operation no more than 16 times per second, and with at most 160 queries from the batches
     * per second (cumulative).
     * </p>
     *
     * @param batchGetMetricDataRequest
     *        Represents a request to retrieve a batch of metric data.
     * @return A Java Future containing the result of the BatchGetMetricData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>InternalServiceErrorException The request couldn't be processed because an error occurred with the
     *         Amazon SES API v2.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.BatchGetMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/BatchGetMetricData" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchGetMetricDataResponse> batchGetMetricData(BatchGetMetricDataRequest batchGetMetricDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves batches of metric data collected based on your sending activity.
     * </p>
     * <p>
     * You can execute this operation no more than 16 times per second, and with at most 160 queries from the batches
     * per second (cumulative).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetMetricDataRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetMetricDataRequest#builder()}
     * </p>
     *
     * @param batchGetMetricDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataRequest.Builder} to create a request.
     *        Represents a request to retrieve a batch of metric data.
     * @return A Java Future containing the result of the BatchGetMetricData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>InternalServiceErrorException The request couldn't be processed because an error occurred with the
     *         Amazon SES API v2.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.BatchGetMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/BatchGetMetricData" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchGetMetricDataResponse> batchGetMetricData(
            Consumer<BatchGetMetricDataRequest.Builder> batchGetMetricDataRequest) {
        return batchGetMetricData(BatchGetMetricDataRequest.builder().applyMutation(batchGetMetricDataRequest).build());
    }

    /**
     * <p>
     * Cancels an export job.
     * </p>
     *
     * @param cancelExportJobRequest
     *        Represents a request to cancel an export job using the export job ID.
     * @return A Java Future containing the result of the CancelExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CancelExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CancelExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelExportJobResponse> cancelExportJob(CancelExportJobRequest cancelExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an export job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelExportJobRequest.Builder} avoiding the need
     * to create one manually via {@link CancelExportJobRequest#builder()}
     * </p>
     *
     * @param cancelExportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.CancelExportJobRequest.Builder} to create a request.
     *        Represents a request to cancel an export job using the export job ID.
     * @return A Java Future containing the result of the CancelExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CancelExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CancelExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelExportJobResponse> cancelExportJob(
            Consumer<CancelExportJobRequest.Builder> cancelExportJobRequest) {
        return cancelExportJob(CancelExportJobRequest.builder().applyMutation(cancelExportJobRequest).build());
    }

    /**
     * <p>
     * Create a configuration set. <i>Configuration sets</i> are groups of rules that you can apply to the emails that
     * you send. You apply a configuration set to an email by specifying the name of the configuration set when you call
     * the Amazon SES API v2. When you apply a configuration set to an email, all of the rules in that configuration set
     * are applied to the email.
     * </p>
     *
     * @param createConfigurationSetRequest
     *        A request to create a configuration set.
     * @return A Java Future containing the result of the CreateConfigurationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateConfigurationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateConfigurationSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateConfigurationSetResponse> createConfigurationSet(
            CreateConfigurationSetRequest createConfigurationSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a configuration set. <i>Configuration sets</i> are groups of rules that you can apply to the emails that
     * you send. You apply a configuration set to an email by specifying the name of the configuration set when you call
     * the Amazon SES API v2. When you apply a configuration set to an email, all of the rules in that configuration set
     * are applied to the email.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConfigurationSetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateConfigurationSetRequest#builder()}
     * </p>
     *
     * @param createConfigurationSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetRequest.Builder} to create a
     *        request. A request to create a configuration set.
     * @return A Java Future containing the result of the CreateConfigurationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateConfigurationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateConfigurationSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateConfigurationSetResponse> createConfigurationSet(
            Consumer<CreateConfigurationSetRequest.Builder> createConfigurationSetRequest) {
        return createConfigurationSet(CreateConfigurationSetRequest.builder().applyMutation(createConfigurationSetRequest)
                .build());
    }

    /**
     * <p>
     * Create an event destination. <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and
     * complaints. <i>Event destinations</i> are places that you can send information about these events to. For
     * example, you can send event data to Amazon EventBridge and associate a rule to send the event to the specified
     * target.
     * </p>
     * <p>
     * A single configuration set can include more than one event destination.
     * </p>
     *
     * @param createConfigurationSetEventDestinationRequest
     *        A request to add an event destination to a configuration set.
     * @return A Java Future containing the result of the CreateConfigurationSetEventDestination operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateConfigurationSetEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConfigurationSetEventDestinationResponse> createConfigurationSetEventDestination(
            CreateConfigurationSetEventDestinationRequest createConfigurationSetEventDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an event destination. <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and
     * complaints. <i>Event destinations</i> are places that you can send information about these events to. For
     * example, you can send event data to Amazon EventBridge and associate a rule to send the event to the specified
     * target.
     * </p>
     * <p>
     * A single configuration set can include more than one event destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateConfigurationSetEventDestinationRequest.Builder} avoiding the need to create one manually via
     * {@link CreateConfigurationSetEventDestinationRequest#builder()}
     * </p>
     *
     * @param createConfigurationSetEventDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetEventDestinationRequest.Builder}
     *        to create a request. A request to add an event destination to a configuration set.
     * @return A Java Future containing the result of the CreateConfigurationSetEventDestination operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateConfigurationSetEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConfigurationSetEventDestinationResponse> createConfigurationSetEventDestination(
            Consumer<CreateConfigurationSetEventDestinationRequest.Builder> createConfigurationSetEventDestinationRequest) {
        return createConfigurationSetEventDestination(CreateConfigurationSetEventDestinationRequest.builder()
                .applyMutation(createConfigurationSetEventDestinationRequest).build());
    }

    /**
     * <p>
     * Creates a contact, which is an end-user who is receiving the email, and adds them to a contact list.
     * </p>
     *
     * @param createContactRequest
     * @return A Java Future containing the result of the CreateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateContact" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateContactResponse> createContact(CreateContactRequest createContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a contact, which is an end-user who is receiving the email, and adds them to a contact list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContactRequest.Builder} avoiding the need to
     * create one manually via {@link CreateContactRequest#builder()}
     * </p>
     *
     * @param createContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.CreateContactRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateContact" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateContactResponse> createContact(Consumer<CreateContactRequest.Builder> createContactRequest) {
        return createContact(CreateContactRequest.builder().applyMutation(createContactRequest).build());
    }

    /**
     * <p>
     * Creates a contact list.
     * </p>
     *
     * @param createContactListRequest
     * @return A Java Future containing the result of the CreateContactList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateContactList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateContactList" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateContactListResponse> createContactList(CreateContactListRequest createContactListRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a contact list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContactListRequest.Builder} avoiding the need
     * to create one manually via {@link CreateContactListRequest#builder()}
     * </p>
     *
     * @param createContactListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.CreateContactListRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateContactList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateContactList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateContactList" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateContactListResponse> createContactList(
            Consumer<CreateContactListRequest.Builder> createContactListRequest) {
        return createContactList(CreateContactListRequest.builder().applyMutation(createContactListRequest).build());
    }

    /**
     * <p>
     * Creates a new custom verification email template.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param createCustomVerificationEmailTemplateRequest
     *        Represents a request to create a custom verification email template.
     * @return A Java Future containing the result of the CreateCustomVerificationEmailTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateCustomVerificationEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCustomVerificationEmailTemplateResponse> createCustomVerificationEmailTemplate(
            CreateCustomVerificationEmailTemplateRequest createCustomVerificationEmailTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new custom verification email template.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateCustomVerificationEmailTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link CreateCustomVerificationEmailTemplateRequest#builder()}
     * </p>
     *
     * @param createCustomVerificationEmailTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.CreateCustomVerificationEmailTemplateRequest.Builder}
     *        to create a request. Represents a request to create a custom verification email template.
     * @return A Java Future containing the result of the CreateCustomVerificationEmailTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateCustomVerificationEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCustomVerificationEmailTemplateResponse> createCustomVerificationEmailTemplate(
            Consumer<CreateCustomVerificationEmailTemplateRequest.Builder> createCustomVerificationEmailTemplateRequest) {
        return createCustomVerificationEmailTemplate(CreateCustomVerificationEmailTemplateRequest.builder()
                .applyMutation(createCustomVerificationEmailTemplateRequest).build());
    }

    /**
     * <p>
     * Create a new pool of dedicated IP addresses. A pool can include one or more dedicated IP addresses that are
     * associated with your Amazon Web Services account. You can associate a pool with a configuration set. When you
     * send an email that uses that configuration set, the message is sent from one of the addresses in the associated
     * pool.
     * </p>
     *
     * @param createDedicatedIpPoolRequest
     *        A request to create a new dedicated IP pool.
     * @return A Java Future containing the result of the CreateDedicatedIpPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateDedicatedIpPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateDedicatedIpPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDedicatedIpPoolResponse> createDedicatedIpPool(
            CreateDedicatedIpPoolRequest createDedicatedIpPoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new pool of dedicated IP addresses. A pool can include one or more dedicated IP addresses that are
     * associated with your Amazon Web Services account. You can associate a pool with a configuration set. When you
     * send an email that uses that configuration set, the message is sent from one of the addresses in the associated
     * pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDedicatedIpPoolRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDedicatedIpPoolRequest#builder()}
     * </p>
     *
     * @param createDedicatedIpPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.CreateDedicatedIpPoolRequest.Builder} to create a
     *        request. A request to create a new dedicated IP pool.
     * @return A Java Future containing the result of the CreateDedicatedIpPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateDedicatedIpPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateDedicatedIpPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDedicatedIpPoolResponse> createDedicatedIpPool(
            Consumer<CreateDedicatedIpPoolRequest.Builder> createDedicatedIpPoolRequest) {
        return createDedicatedIpPool(CreateDedicatedIpPoolRequest.builder().applyMutation(createDedicatedIpPoolRequest).build());
    }

    /**
     * <p>
     * Create a new predictive inbox placement test. Predictive inbox placement tests can help you predict how your
     * messages will be handled by various email providers around the world. When you perform a predictive inbox
     * placement test, you provide a sample message that contains the content that you plan to send to your customers.
     * Amazon SES then sends that message to special email addresses spread across several major email providers. After
     * about 24 hours, the test is complete, and you can use the <code>GetDeliverabilityTestReport</code> operation to
     * view the results of the test.
     * </p>
     *
     * @param createDeliverabilityTestReportRequest
     *        A request to perform a predictive inbox placement test. Predictive inbox placement tests can help you
     *        predict how your messages will be handled by various email providers around the world. When you perform a
     *        predictive inbox placement test, you provide a sample message that contains the content that you plan to
     *        send to your customers. We send that message to special email addresses spread across several major email
     *        providers around the world. The test takes about 24 hours to complete. When the test is complete, you can
     *        use the <code>GetDeliverabilityTestReport</code> operation to view the results of the test.
     * @return A Java Future containing the result of the CreateDeliverabilityTestReport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccountSuspendedException The message can't be sent because the account's ability to send email has
     *         been permanently restricted.</li>
     *         <li>SendingPausedException The message can't be sent because the account's ability to send email is
     *         currently paused.</li>
     *         <li>MessageRejectedException The message can't be sent because it contains invalid content.</li>
     *         <li>MailFromDomainNotVerifiedException The message can't be sent because the sending domain isn't
     *         verified.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateDeliverabilityTestReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateDeliverabilityTestReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDeliverabilityTestReportResponse> createDeliverabilityTestReport(
            CreateDeliverabilityTestReportRequest createDeliverabilityTestReportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new predictive inbox placement test. Predictive inbox placement tests can help you predict how your
     * messages will be handled by various email providers around the world. When you perform a predictive inbox
     * placement test, you provide a sample message that contains the content that you plan to send to your customers.
     * Amazon SES then sends that message to special email addresses spread across several major email providers. After
     * about 24 hours, the test is complete, and you can use the <code>GetDeliverabilityTestReport</code> operation to
     * view the results of the test.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeliverabilityTestReportRequest.Builder}
     * avoiding the need to create one manually via {@link CreateDeliverabilityTestReportRequest#builder()}
     * </p>
     *
     * @param createDeliverabilityTestReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.CreateDeliverabilityTestReportRequest.Builder} to
     *        create a request. A request to perform a predictive inbox placement test. Predictive inbox placement tests
     *        can help you predict how your messages will be handled by various email providers around the world. When
     *        you perform a predictive inbox placement test, you provide a sample message that contains the content that
     *        you plan to send to your customers. We send that message to special email addresses spread across several
     *        major email providers around the world. The test takes about 24 hours to complete. When the test is
     *        complete, you can use the <code>GetDeliverabilityTestReport</code> operation to view the results of the
     *        test.
     * @return A Java Future containing the result of the CreateDeliverabilityTestReport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccountSuspendedException The message can't be sent because the account's ability to send email has
     *         been permanently restricted.</li>
     *         <li>SendingPausedException The message can't be sent because the account's ability to send email is
     *         currently paused.</li>
     *         <li>MessageRejectedException The message can't be sent because it contains invalid content.</li>
     *         <li>MailFromDomainNotVerifiedException The message can't be sent because the sending domain isn't
     *         verified.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateDeliverabilityTestReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateDeliverabilityTestReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDeliverabilityTestReportResponse> createDeliverabilityTestReport(
            Consumer<CreateDeliverabilityTestReportRequest.Builder> createDeliverabilityTestReportRequest) {
        return createDeliverabilityTestReport(CreateDeliverabilityTestReportRequest.builder()
                .applyMutation(createDeliverabilityTestReportRequest).build());
    }

    /**
     * <p>
     * Starts the process of verifying an email identity. An <i>identity</i> is an email address or domain that you use
     * when you send email. Before you can use an identity to send email, you first have to verify it. By verifying an
     * identity, you demonstrate that you're the owner of the identity, and that you've given Amazon SES API v2
     * permission to send email from the identity.
     * </p>
     * <p>
     * When you verify an email address, Amazon SES sends an email to the address. Your email address is verified as
     * soon as you follow the link in the verification email.
     * </p>
     * <p>
     * When you verify a domain without specifying the <code>DkimSigningAttributes</code> object, this operation
     * provides a set of DKIM tokens. You can convert these tokens into CNAME records, which you then add to the DNS
     * configuration for your domain. Your domain is verified when Amazon SES detects these records in the DNS
     * configuration for your domain. This verification method is known as <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.
     * </p>
     * <p>
     * Alternatively, you can perform the verification process by providing your own public-private key pair. This
     * verification method is known as Bring Your Own DKIM (BYODKIM). To use BYODKIM, your call to the
     * <code>CreateEmailIdentity</code> operation has to include the <code>DkimSigningAttributes</code> object. When you
     * specify this object, you provide a selector (a component of the DNS record name that identifies the public key to
     * use for DKIM authentication) and a private key.
     * </p>
     * <p>
     * When you verify a domain, this operation provides a set of DKIM tokens, which you can convert into CNAME tokens.
     * You add these CNAME tokens to the DNS configuration for your domain. Your domain is verified when Amazon SES
     * detects these records in the DNS configuration for your domain. For some DNS providers, it can take 72 hours or
     * more to complete the domain verification process.
     * </p>
     * <p>
     * Additionally, you can associate an existing configuration set with the email identity that you're verifying.
     * </p>
     *
     * @param createEmailIdentityRequest
     *        A request to begin the verification process for an email identity (an email address or domain).
     * @return A Java Future containing the result of the CreateEmailIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateEmailIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateEmailIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateEmailIdentityResponse> createEmailIdentity(
            CreateEmailIdentityRequest createEmailIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the process of verifying an email identity. An <i>identity</i> is an email address or domain that you use
     * when you send email. Before you can use an identity to send email, you first have to verify it. By verifying an
     * identity, you demonstrate that you're the owner of the identity, and that you've given Amazon SES API v2
     * permission to send email from the identity.
     * </p>
     * <p>
     * When you verify an email address, Amazon SES sends an email to the address. Your email address is verified as
     * soon as you follow the link in the verification email.
     * </p>
     * <p>
     * When you verify a domain without specifying the <code>DkimSigningAttributes</code> object, this operation
     * provides a set of DKIM tokens. You can convert these tokens into CNAME records, which you then add to the DNS
     * configuration for your domain. Your domain is verified when Amazon SES detects these records in the DNS
     * configuration for your domain. This verification method is known as <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.
     * </p>
     * <p>
     * Alternatively, you can perform the verification process by providing your own public-private key pair. This
     * verification method is known as Bring Your Own DKIM (BYODKIM). To use BYODKIM, your call to the
     * <code>CreateEmailIdentity</code> operation has to include the <code>DkimSigningAttributes</code> object. When you
     * specify this object, you provide a selector (a component of the DNS record name that identifies the public key to
     * use for DKIM authentication) and a private key.
     * </p>
     * <p>
     * When you verify a domain, this operation provides a set of DKIM tokens, which you can convert into CNAME tokens.
     * You add these CNAME tokens to the DNS configuration for your domain. Your domain is verified when Amazon SES
     * detects these records in the DNS configuration for your domain. For some DNS providers, it can take 72 hours or
     * more to complete the domain verification process.
     * </p>
     * <p>
     * Additionally, you can associate an existing configuration set with the email identity that you're verifying.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEmailIdentityRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEmailIdentityRequest#builder()}
     * </p>
     *
     * @param createEmailIdentityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityRequest.Builder} to create a
     *        request. A request to begin the verification process for an email identity (an email address or domain).
     * @return A Java Future containing the result of the CreateEmailIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateEmailIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateEmailIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateEmailIdentityResponse> createEmailIdentity(
            Consumer<CreateEmailIdentityRequest.Builder> createEmailIdentityRequest) {
        return createEmailIdentity(CreateEmailIdentityRequest.builder().applyMutation(createEmailIdentityRequest).build());
    }

    /**
     * <p>
     * Creates the specified sending authorization policy for the given identity (an email address or a domain).
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param createEmailIdentityPolicyRequest
     *        Represents a request to create a sending authorization policy for an identity. Sending authorization is an
     *        Amazon SES feature that enables you to authorize other senders to use your identities. For information,
     *        see the <a href=
     *        "https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-identity-owner-tasks-management.html"
     *        >Amazon SES Developer Guide</a>.
     * @return A Java Future containing the result of the CreateEmailIdentityPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateEmailIdentityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateEmailIdentityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEmailIdentityPolicyResponse> createEmailIdentityPolicy(
            CreateEmailIdentityPolicyRequest createEmailIdentityPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the specified sending authorization policy for the given identity (an email address or a domain).
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEmailIdentityPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link CreateEmailIdentityPolicyRequest#builder()}
     * </p>
     *
     * @param createEmailIdentityPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityPolicyRequest.Builder} to create a
     *        request. Represents a request to create a sending authorization policy for an identity. Sending
     *        authorization is an Amazon SES feature that enables you to authorize other senders to use your identities.
     *        For information, see the <a href=
     *        "https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-identity-owner-tasks-management.html"
     *        >Amazon SES Developer Guide</a>.
     * @return A Java Future containing the result of the CreateEmailIdentityPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateEmailIdentityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateEmailIdentityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEmailIdentityPolicyResponse> createEmailIdentityPolicy(
            Consumer<CreateEmailIdentityPolicyRequest.Builder> createEmailIdentityPolicyRequest) {
        return createEmailIdentityPolicy(CreateEmailIdentityPolicyRequest.builder()
                .applyMutation(createEmailIdentityPolicyRequest).build());
    }

    /**
     * <p>
     * Creates an email template. Email templates enable you to send personalized email to one or more destinations in a
     * single API operation. For more information, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param createEmailTemplateRequest
     *        Represents a request to create an email template. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the CreateEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateEmailTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateEmailTemplateResponse> createEmailTemplate(
            CreateEmailTemplateRequest createEmailTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an email template. Email templates enable you to send personalized email to one or more destinations in a
     * single API operation. For more information, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEmailTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEmailTemplateRequest#builder()}
     * </p>
     *
     * @param createEmailTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.CreateEmailTemplateRequest.Builder} to create a
     *        request. Represents a request to create an email template. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the CreateEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateEmailTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateEmailTemplateResponse> createEmailTemplate(
            Consumer<CreateEmailTemplateRequest.Builder> createEmailTemplateRequest) {
        return createEmailTemplate(CreateEmailTemplateRequest.builder().applyMutation(createEmailTemplateRequest).build());
    }

    /**
     * <p>
     * Creates an export job for a data source and destination.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param createExportJobRequest
     *        Represents a request to create an export job from a data source to a data destination.
     * @return A Java Future containing the result of the CreateExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateExportJobResponse> createExportJob(CreateExportJobRequest createExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an export job for a data source and destination.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateExportJobRequest.Builder} avoiding the need
     * to create one manually via {@link CreateExportJobRequest#builder()}
     * </p>
     *
     * @param createExportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.CreateExportJobRequest.Builder} to create a request.
     *        Represents a request to create an export job from a data source to a data destination.
     * @return A Java Future containing the result of the CreateExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateExportJobResponse> createExportJob(
            Consumer<CreateExportJobRequest.Builder> createExportJobRequest) {
        return createExportJob(CreateExportJobRequest.builder().applyMutation(createExportJobRequest).build());
    }

    /**
     * <p>
     * Creates an import job for a data destination.
     * </p>
     *
     * @param createImportJobRequest
     *        Represents a request to create an import job from a data source for a data destination.
     * @return A Java Future containing the result of the CreateImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateImportJobResponse> createImportJob(CreateImportJobRequest createImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an import job for a data destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateImportJobRequest.Builder} avoiding the need
     * to create one manually via {@link CreateImportJobRequest#builder()}
     * </p>
     *
     * @param createImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.CreateImportJobRequest.Builder} to create a request.
     *        Represents a request to create an import job from a data source for a data destination.
     * @return A Java Future containing the result of the CreateImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateImportJobResponse> createImportJob(
            Consumer<CreateImportJobRequest.Builder> createImportJobRequest) {
        return createImportJob(CreateImportJobRequest.builder().applyMutation(createImportJobRequest).build());
    }

    /**
     * <p>
     * Creates a multi-region endpoint (global-endpoint).
     * </p>
     * <p>
     * The primary region is going to be the AWS-Region where the operation is executed. The secondary region has to be
     * provided in request's parameters. From the data flow standpoint there is no difference between primary and
     * secondary regions - sending traffic will be split equally between the two. The primary region is the region where
     * the resource has been created and where it can be managed.
     * </p>
     *
     * @param createMultiRegionEndpointRequest
     *        Represents a request to create a multi-region endpoint (global-endpoint).
     * @return A Java Future containing the result of the CreateMultiRegionEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateMultiRegionEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateMultiRegionEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMultiRegionEndpointResponse> createMultiRegionEndpoint(
            CreateMultiRegionEndpointRequest createMultiRegionEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a multi-region endpoint (global-endpoint).
     * </p>
     * <p>
     * The primary region is going to be the AWS-Region where the operation is executed. The secondary region has to be
     * provided in request's parameters. From the data flow standpoint there is no difference between primary and
     * secondary regions - sending traffic will be split equally between the two. The primary region is the region where
     * the resource has been created and where it can be managed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMultiRegionEndpointRequest.Builder} avoiding
     * the need to create one manually via {@link CreateMultiRegionEndpointRequest#builder()}
     * </p>
     *
     * @param createMultiRegionEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.CreateMultiRegionEndpointRequest.Builder} to create a
     *        request. Represents a request to create a multi-region endpoint (global-endpoint).
     * @return A Java Future containing the result of the CreateMultiRegionEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateMultiRegionEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateMultiRegionEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMultiRegionEndpointResponse> createMultiRegionEndpoint(
            Consumer<CreateMultiRegionEndpointRequest.Builder> createMultiRegionEndpointRequest) {
        return createMultiRegionEndpoint(CreateMultiRegionEndpointRequest.builder()
                .applyMutation(createMultiRegionEndpointRequest).build());
    }

    /**
     * <p>
     * Create a tenant.
     * </p>
     * <p>
     * <i>Tenants</i> are logical containers that group related SES resources together. Each tenant can have its own set
     * of resources like email identities, configuration sets, and templates, along with reputation metrics and sending
     * status. This helps isolate and manage email sending for different customers or business units within your Amazon
     * SES API v2 account.
     * </p>
     *
     * @param createTenantRequest
     *        Represents a request to create a tenant.</p>
     *        <p>
     *        <i>Tenants</i> are logical containers that group related SES resources together. Each tenant can have its
     *        own set of resources like email identities, configuration sets, and templates, along with reputation
     *        metrics and sending status. This helps isolate and manage email sending for different customers or
     *        business units within your Amazon SES API v2 account.
     * @return A Java Future containing the result of the CreateTenant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li> <li>
     *         LimitExceededException There are too many instances of the specified resource type.</li> <li>
     *         TooManyRequestsException Too many requests have been made to the operation.</li> <li>BadRequestException
     *         The input you provided is invalid.</li> <li>SdkException Base class for all exceptions that can be thrown
     *         by the SDK (both service and client). Can be used for catch all scenarios.</li> <li>SdkClientException If
     *         any client side error occurs such as an IO related failure, failure to get credentials, etc.</li> <li>
     *         SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance of
     *         this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateTenant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateTenant" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTenantResponse> createTenant(CreateTenantRequest createTenantRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a tenant.
     * </p>
     * <p>
     * <i>Tenants</i> are logical containers that group related SES resources together. Each tenant can have its own set
     * of resources like email identities, configuration sets, and templates, along with reputation metrics and sending
     * status. This helps isolate and manage email sending for different customers or business units within your Amazon
     * SES API v2 account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTenantRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTenantRequest#builder()}
     * </p>
     *
     * @param createTenantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.CreateTenantRequest.Builder} to create a request.
     *        Represents a request to create a tenant.</p>
     *        <p>
     *        <i>Tenants</i> are logical containers that group related SES resources together. Each tenant can have its
     *        own set of resources like email identities, configuration sets, and templates, along with reputation
     *        metrics and sending status. This helps isolate and manage email sending for different customers or
     *        business units within your Amazon SES API v2 account.
     * @return A Java Future containing the result of the CreateTenant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li> <li>
     *         LimitExceededException There are too many instances of the specified resource type.</li> <li>
     *         TooManyRequestsException Too many requests have been made to the operation.</li> <li>BadRequestException
     *         The input you provided is invalid.</li> <li>SdkException Base class for all exceptions that can be thrown
     *         by the SDK (both service and client). Can be used for catch all scenarios.</li> <li>SdkClientException If
     *         any client side error occurs such as an IO related failure, failure to get credentials, etc.</li> <li>
     *         SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance of
     *         this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateTenant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateTenant" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTenantResponse> createTenant(Consumer<CreateTenantRequest.Builder> createTenantRequest) {
        return createTenant(CreateTenantRequest.builder().applyMutation(createTenantRequest).build());
    }

    /**
     * <p>
     * Associate a resource with a tenant.
     * </p>
     * <p>
     * <i>Resources</i> can be email identities, configuration sets, or email templates. When you associate a resource
     * with a tenant, you can use that resource when sending emails on behalf of that tenant.
     * </p>
     * <p>
     * A single resource can be associated with multiple tenants, allowing for resource sharing across different tenants
     * while maintaining isolation in email sending operations.
     * </p>
     *
     * @param createTenantResourceAssociationRequest
     *        Represents a request to associate a resource with a tenant.</p>
     *        <p>
     *        Resources can be email identities, configuration sets, or email templates. When you associate a resource
     *        with a tenant, you can use that resource when sending emails on behalf of that tenant.
     * @return A Java Future containing the result of the CreateTenantResourceAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li> <li>
     *         NotFoundException The resource you attempted to access doesn't exist.</li> <li>TooManyRequestsException
     *         Too many requests have been made to the operation.</li> <li>BadRequestException The input you provided is
     *         invalid.</li> <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service
     *         and client). Can be used for catch all scenarios.</li> <li>SdkClientException If any client side error
     *         occurs such as an IO related failure, failure to get credentials, etc.</li> <li>SesV2Exception Base class
     *         for all service exceptions. Unknown exceptions will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateTenantResourceAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateTenantResourceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTenantResourceAssociationResponse> createTenantResourceAssociation(
            CreateTenantResourceAssociationRequest createTenantResourceAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate a resource with a tenant.
     * </p>
     * <p>
     * <i>Resources</i> can be email identities, configuration sets, or email templates. When you associate a resource
     * with a tenant, you can use that resource when sending emails on behalf of that tenant.
     * </p>
     * <p>
     * A single resource can be associated with multiple tenants, allowing for resource sharing across different tenants
     * while maintaining isolation in email sending operations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTenantResourceAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateTenantResourceAssociationRequest#builder()}
     * </p>
     *
     * @param createTenantResourceAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.CreateTenantResourceAssociationRequest.Builder} to
     *        create a request. Represents a request to associate a resource with a tenant.</p>
     *        <p>
     *        Resources can be email identities, configuration sets, or email templates. When you associate a resource
     *        with a tenant, you can use that resource when sending emails on behalf of that tenant.
     * @return A Java Future containing the result of the CreateTenantResourceAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li> <li>
     *         NotFoundException The resource you attempted to access doesn't exist.</li> <li>TooManyRequestsException
     *         Too many requests have been made to the operation.</li> <li>BadRequestException The input you provided is
     *         invalid.</li> <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service
     *         and client). Can be used for catch all scenarios.</li> <li>SdkClientException If any client side error
     *         occurs such as an IO related failure, failure to get credentials, etc.</li> <li>SesV2Exception Base class
     *         for all service exceptions. Unknown exceptions will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateTenantResourceAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateTenantResourceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTenantResourceAssociationResponse> createTenantResourceAssociation(
            Consumer<CreateTenantResourceAssociationRequest.Builder> createTenantResourceAssociationRequest) {
        return createTenantResourceAssociation(CreateTenantResourceAssociationRequest.builder()
                .applyMutation(createTenantResourceAssociationRequest).build());
    }

    /**
     * <p>
     * Delete an existing configuration set.
     * </p>
     * <p>
     * <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a
     * configuration set to an email by including a reference to the configuration set in the headers of the email. When
     * you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     * </p>
     *
     * @param deleteConfigurationSetRequest
     *        A request to delete a configuration set.
     * @return A Java Future containing the result of the DeleteConfigurationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteConfigurationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteConfigurationSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationSetResponse> deleteConfigurationSet(
            DeleteConfigurationSetRequest deleteConfigurationSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an existing configuration set.
     * </p>
     * <p>
     * <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a
     * configuration set to an email by including a reference to the configuration set in the headers of the email. When
     * you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfigurationSetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteConfigurationSetRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetRequest.Builder} to create a
     *        request. A request to delete a configuration set.
     * @return A Java Future containing the result of the DeleteConfigurationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteConfigurationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteConfigurationSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationSetResponse> deleteConfigurationSet(
            Consumer<DeleteConfigurationSetRequest.Builder> deleteConfigurationSetRequest) {
        return deleteConfigurationSet(DeleteConfigurationSetRequest.builder().applyMutation(deleteConfigurationSetRequest)
                .build());
    }

    /**
     * <p>
     * Delete an event destination.
     * </p>
     * <p>
     * <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event
     * destinations</i> are places that you can send information about these events to. For example, you can send event
     * data to Amazon EventBridge and associate a rule to send the event to the specified target.
     * </p>
     *
     * @param deleteConfigurationSetEventDestinationRequest
     *        A request to delete an event destination from a configuration set.
     * @return A Java Future containing the result of the DeleteConfigurationSetEventDestination operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteConfigurationSetEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationSetEventDestinationResponse> deleteConfigurationSetEventDestination(
            DeleteConfigurationSetEventDestinationRequest deleteConfigurationSetEventDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an event destination.
     * </p>
     * <p>
     * <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event
     * destinations</i> are places that you can send information about these events to. For example, you can send event
     * data to Amazon EventBridge and associate a rule to send the event to the specified target.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteConfigurationSetEventDestinationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteConfigurationSetEventDestinationRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationSetEventDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetEventDestinationRequest.Builder}
     *        to create a request. A request to delete an event destination from a configuration set.
     * @return A Java Future containing the result of the DeleteConfigurationSetEventDestination operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteConfigurationSetEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationSetEventDestinationResponse> deleteConfigurationSetEventDestination(
            Consumer<DeleteConfigurationSetEventDestinationRequest.Builder> deleteConfigurationSetEventDestinationRequest) {
        return deleteConfigurationSetEventDestination(DeleteConfigurationSetEventDestinationRequest.builder()
                .applyMutation(deleteConfigurationSetEventDestinationRequest).build());
    }

    /**
     * <p>
     * Removes a contact from a contact list.
     * </p>
     *
     * @param deleteContactRequest
     * @return A Java Future containing the result of the DeleteContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteContact" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteContactResponse> deleteContact(DeleteContactRequest deleteContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a contact from a contact list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContactRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteContactRequest#builder()}
     * </p>
     *
     * @param deleteContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.DeleteContactRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteContact" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteContactResponse> deleteContact(Consumer<DeleteContactRequest.Builder> deleteContactRequest) {
        return deleteContact(DeleteContactRequest.builder().applyMutation(deleteContactRequest).build());
    }

    /**
     * <p>
     * Deletes a contact list and all of the contacts on that list.
     * </p>
     *
     * @param deleteContactListRequest
     * @return A Java Future containing the result of the DeleteContactList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteContactList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteContactList" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteContactListResponse> deleteContactList(DeleteContactListRequest deleteContactListRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a contact list and all of the contacts on that list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContactListRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteContactListRequest#builder()}
     * </p>
     *
     * @param deleteContactListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.DeleteContactListRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteContactList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteContactList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteContactList" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteContactListResponse> deleteContactList(
            Consumer<DeleteContactListRequest.Builder> deleteContactListRequest) {
        return deleteContactList(DeleteContactListRequest.builder().applyMutation(deleteContactListRequest).build());
    }

    /**
     * <p>
     * Deletes an existing custom verification email template.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param deleteCustomVerificationEmailTemplateRequest
     *        Represents a request to delete an existing custom verification email template.
     * @return A Java Future containing the result of the DeleteCustomVerificationEmailTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteCustomVerificationEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCustomVerificationEmailTemplateResponse> deleteCustomVerificationEmailTemplate(
            DeleteCustomVerificationEmailTemplateRequest deleteCustomVerificationEmailTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing custom verification email template.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteCustomVerificationEmailTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteCustomVerificationEmailTemplateRequest#builder()}
     * </p>
     *
     * @param deleteCustomVerificationEmailTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.DeleteCustomVerificationEmailTemplateRequest.Builder}
     *        to create a request. Represents a request to delete an existing custom verification email template.
     * @return A Java Future containing the result of the DeleteCustomVerificationEmailTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteCustomVerificationEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCustomVerificationEmailTemplateResponse> deleteCustomVerificationEmailTemplate(
            Consumer<DeleteCustomVerificationEmailTemplateRequest.Builder> deleteCustomVerificationEmailTemplateRequest) {
        return deleteCustomVerificationEmailTemplate(DeleteCustomVerificationEmailTemplateRequest.builder()
                .applyMutation(deleteCustomVerificationEmailTemplateRequest).build());
    }

    /**
     * <p>
     * Delete a dedicated IP pool.
     * </p>
     *
     * @param deleteDedicatedIpPoolRequest
     *        A request to delete a dedicated IP pool.
     * @return A Java Future containing the result of the DeleteDedicatedIpPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteDedicatedIpPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteDedicatedIpPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDedicatedIpPoolResponse> deleteDedicatedIpPool(
            DeleteDedicatedIpPoolRequest deleteDedicatedIpPoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a dedicated IP pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDedicatedIpPoolRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDedicatedIpPoolRequest#builder()}
     * </p>
     *
     * @param deleteDedicatedIpPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.DeleteDedicatedIpPoolRequest.Builder} to create a
     *        request. A request to delete a dedicated IP pool.
     * @return A Java Future containing the result of the DeleteDedicatedIpPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteDedicatedIpPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteDedicatedIpPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDedicatedIpPoolResponse> deleteDedicatedIpPool(
            Consumer<DeleteDedicatedIpPoolRequest.Builder> deleteDedicatedIpPoolRequest) {
        return deleteDedicatedIpPool(DeleteDedicatedIpPoolRequest.builder().applyMutation(deleteDedicatedIpPoolRequest).build());
    }

    /**
     * <p>
     * Deletes an email identity. An identity can be either an email address or a domain name.
     * </p>
     *
     * @param deleteEmailIdentityRequest
     *        A request to delete an existing email identity. When you delete an identity, you lose the ability to send
     *        email from that identity. You can restore your ability to send email by completing the verification
     *        process for the identity again.
     * @return A Java Future containing the result of the DeleteEmailIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteEmailIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteEmailIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEmailIdentityResponse> deleteEmailIdentity(
            DeleteEmailIdentityRequest deleteEmailIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an email identity. An identity can be either an email address or a domain name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEmailIdentityRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEmailIdentityRequest#builder()}
     * </p>
     *
     * @param deleteEmailIdentityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityRequest.Builder} to create a
     *        request. A request to delete an existing email identity. When you delete an identity, you lose the ability
     *        to send email from that identity. You can restore your ability to send email by completing the
     *        verification process for the identity again.
     * @return A Java Future containing the result of the DeleteEmailIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteEmailIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteEmailIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEmailIdentityResponse> deleteEmailIdentity(
            Consumer<DeleteEmailIdentityRequest.Builder> deleteEmailIdentityRequest) {
        return deleteEmailIdentity(DeleteEmailIdentityRequest.builder().applyMutation(deleteEmailIdentityRequest).build());
    }

    /**
     * <p>
     * Deletes the specified sending authorization policy for the given identity (an email address or a domain). This
     * API returns successfully even if a policy with the specified name does not exist.
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param deleteEmailIdentityPolicyRequest
     *        Represents a request to delete a sending authorization policy for an identity. Sending authorization is an
     *        Amazon SES feature that enables you to authorize other senders to use your identities. For information,
     *        see the <a href=
     *        "https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-identity-owner-tasks-management.html"
     *        >Amazon SES Developer Guide</a>.
     * @return A Java Future containing the result of the DeleteEmailIdentityPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteEmailIdentityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteEmailIdentityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEmailIdentityPolicyResponse> deleteEmailIdentityPolicy(
            DeleteEmailIdentityPolicyRequest deleteEmailIdentityPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified sending authorization policy for the given identity (an email address or a domain). This
     * API returns successfully even if a policy with the specified name does not exist.
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEmailIdentityPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEmailIdentityPolicyRequest#builder()}
     * </p>
     *
     * @param deleteEmailIdentityPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityPolicyRequest.Builder} to create a
     *        request. Represents a request to delete a sending authorization policy for an identity. Sending
     *        authorization is an Amazon SES feature that enables you to authorize other senders to use your identities.
     *        For information, see the <a href=
     *        "https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-identity-owner-tasks-management.html"
     *        >Amazon SES Developer Guide</a>.
     * @return A Java Future containing the result of the DeleteEmailIdentityPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteEmailIdentityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteEmailIdentityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEmailIdentityPolicyResponse> deleteEmailIdentityPolicy(
            Consumer<DeleteEmailIdentityPolicyRequest.Builder> deleteEmailIdentityPolicyRequest) {
        return deleteEmailIdentityPolicy(DeleteEmailIdentityPolicyRequest.builder()
                .applyMutation(deleteEmailIdentityPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes an email template.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param deleteEmailTemplateRequest
     *        Represents a request to delete an email template. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the DeleteEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteEmailTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEmailTemplateResponse> deleteEmailTemplate(
            DeleteEmailTemplateRequest deleteEmailTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an email template.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEmailTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEmailTemplateRequest#builder()}
     * </p>
     *
     * @param deleteEmailTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.DeleteEmailTemplateRequest.Builder} to create a
     *        request. Represents a request to delete an email template. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the DeleteEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteEmailTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEmailTemplateResponse> deleteEmailTemplate(
            Consumer<DeleteEmailTemplateRequest.Builder> deleteEmailTemplateRequest) {
        return deleteEmailTemplate(DeleteEmailTemplateRequest.builder().applyMutation(deleteEmailTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes a multi-region endpoint (global-endpoint).
     * </p>
     * <p>
     * Only multi-region endpoints (global-endpoints) whose primary region is the AWS-Region where operation is executed
     * can be deleted.
     * </p>
     *
     * @param deleteMultiRegionEndpointRequest
     *        Represents a request to delete a multi-region endpoint (global-endpoint).
     * @return A Java Future containing the result of the DeleteMultiRegionEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteMultiRegionEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteMultiRegionEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMultiRegionEndpointResponse> deleteMultiRegionEndpoint(
            DeleteMultiRegionEndpointRequest deleteMultiRegionEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a multi-region endpoint (global-endpoint).
     * </p>
     * <p>
     * Only multi-region endpoints (global-endpoints) whose primary region is the AWS-Region where operation is executed
     * can be deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMultiRegionEndpointRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteMultiRegionEndpointRequest#builder()}
     * </p>
     *
     * @param deleteMultiRegionEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.DeleteMultiRegionEndpointRequest.Builder} to create a
     *        request. Represents a request to delete a multi-region endpoint (global-endpoint).
     * @return A Java Future containing the result of the DeleteMultiRegionEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteMultiRegionEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteMultiRegionEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMultiRegionEndpointResponse> deleteMultiRegionEndpoint(
            Consumer<DeleteMultiRegionEndpointRequest.Builder> deleteMultiRegionEndpointRequest) {
        return deleteMultiRegionEndpoint(DeleteMultiRegionEndpointRequest.builder()
                .applyMutation(deleteMultiRegionEndpointRequest).build());
    }

    /**
     * <p>
     * Removes an email address from the suppression list for your account.
     * </p>
     *
     * @param deleteSuppressedDestinationRequest
     *        A request to remove an email address from the suppression list for your account.
     * @return A Java Future containing the result of the DeleteSuppressedDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteSuppressedDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteSuppressedDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSuppressedDestinationResponse> deleteSuppressedDestination(
            DeleteSuppressedDestinationRequest deleteSuppressedDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an email address from the suppression list for your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSuppressedDestinationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteSuppressedDestinationRequest#builder()}
     * </p>
     *
     * @param deleteSuppressedDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.DeleteSuppressedDestinationRequest.Builder} to create a
     *        request. A request to remove an email address from the suppression list for your account.
     * @return A Java Future containing the result of the DeleteSuppressedDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteSuppressedDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteSuppressedDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSuppressedDestinationResponse> deleteSuppressedDestination(
            Consumer<DeleteSuppressedDestinationRequest.Builder> deleteSuppressedDestinationRequest) {
        return deleteSuppressedDestination(DeleteSuppressedDestinationRequest.builder()
                .applyMutation(deleteSuppressedDestinationRequest).build());
    }

    /**
     * <p>
     * Delete an existing tenant.
     * </p>
     * <p>
     * When you delete a tenant, its associations with resources are removed, but the resources themselves are not
     * deleted.
     * </p>
     *
     * @param deleteTenantRequest
     *        Represents a request to delete a tenant.
     * @return A Java Future containing the result of the DeleteTenant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteTenant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteTenant" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTenantResponse> deleteTenant(DeleteTenantRequest deleteTenantRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an existing tenant.
     * </p>
     * <p>
     * When you delete a tenant, its associations with resources are removed, but the resources themselves are not
     * deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTenantRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTenantRequest#builder()}
     * </p>
     *
     * @param deleteTenantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.DeleteTenantRequest.Builder} to create a request.
     *        Represents a request to delete a tenant.
     * @return A Java Future containing the result of the DeleteTenant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteTenant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteTenant" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTenantResponse> deleteTenant(Consumer<DeleteTenantRequest.Builder> deleteTenantRequest) {
        return deleteTenant(DeleteTenantRequest.builder().applyMutation(deleteTenantRequest).build());
    }

    /**
     * <p>
     * Delete an association between a tenant and a resource.
     * </p>
     * <p>
     * When you delete a tenant-resource association, the resource itself is not deleted, only its association with the
     * specific tenant is removed. After removal, the resource will no longer be available for use with that tenant's
     * email sending operations.
     * </p>
     *
     * @param deleteTenantResourceAssociationRequest
     *        Represents a request to delete an association between a tenant and a resource.
     * @return A Java Future containing the result of the DeleteTenantResourceAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteTenantResourceAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteTenantResourceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTenantResourceAssociationResponse> deleteTenantResourceAssociation(
            DeleteTenantResourceAssociationRequest deleteTenantResourceAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an association between a tenant and a resource.
     * </p>
     * <p>
     * When you delete a tenant-resource association, the resource itself is not deleted, only its association with the
     * specific tenant is removed. After removal, the resource will no longer be available for use with that tenant's
     * email sending operations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTenantResourceAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteTenantResourceAssociationRequest#builder()}
     * </p>
     *
     * @param deleteTenantResourceAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.DeleteTenantResourceAssociationRequest.Builder} to
     *        create a request. Represents a request to delete an association between a tenant and a resource.
     * @return A Java Future containing the result of the DeleteTenantResourceAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteTenantResourceAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteTenantResourceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTenantResourceAssociationResponse> deleteTenantResourceAssociation(
            Consumer<DeleteTenantResourceAssociationRequest.Builder> deleteTenantResourceAssociationRequest) {
        return deleteTenantResourceAssociation(DeleteTenantResourceAssociationRequest.builder()
                .applyMutation(deleteTenantResourceAssociationRequest).build());
    }

    /**
     * <p>
     * Obtain information about the email-sending status and capabilities of your Amazon SES account in the current
     * Amazon Web Services Region.
     * </p>
     *
     * @param getAccountRequest
     *        A request to obtain information about the email-sending capabilities of your Amazon SES account.
     * @return A Java Future containing the result of the GetAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAccountResponse> getAccount(GetAccountRequest getAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Obtain information about the email-sending status and capabilities of your Amazon SES account in the current
     * Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountRequest.Builder} avoiding the need to
     * create one manually via {@link GetAccountRequest#builder()}
     * </p>
     *
     * @param getAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetAccountRequest.Builder} to create a request. A
     *        request to obtain information about the email-sending capabilities of your Amazon SES account.
     * @return A Java Future containing the result of the GetAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAccountResponse> getAccount(Consumer<GetAccountRequest.Builder> getAccountRequest) {
        return getAccount(GetAccountRequest.builder().applyMutation(getAccountRequest).build());
    }

    /**
     * <p>
     * Retrieve a list of the blacklists that your dedicated IP addresses appear on.
     * </p>
     *
     * @param getBlacklistReportsRequest
     *        A request to retrieve a list of the blacklists that your dedicated IP addresses appear on.
     * @return A Java Future containing the result of the GetBlacklistReports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetBlacklistReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetBlacklistReports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBlacklistReportsResponse> getBlacklistReports(
            GetBlacklistReportsRequest getBlacklistReportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve a list of the blacklists that your dedicated IP addresses appear on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBlacklistReportsRequest.Builder} avoiding the
     * need to create one manually via {@link GetBlacklistReportsRequest#builder()}
     * </p>
     *
     * @param getBlacklistReportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetBlacklistReportsRequest.Builder} to create a
     *        request. A request to retrieve a list of the blacklists that your dedicated IP addresses appear on.
     * @return A Java Future containing the result of the GetBlacklistReports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetBlacklistReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetBlacklistReports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBlacklistReportsResponse> getBlacklistReports(
            Consumer<GetBlacklistReportsRequest.Builder> getBlacklistReportsRequest) {
        return getBlacklistReports(GetBlacklistReportsRequest.builder().applyMutation(getBlacklistReportsRequest).build());
    }

    /**
     * <p>
     * Get information about an existing configuration set, including the dedicated IP pool that it's associated with,
     * whether or not it's enabled for sending email, and more.
     * </p>
     * <p>
     * <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a
     * configuration set to an email by including a reference to the configuration set in the headers of the email. When
     * you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     * </p>
     *
     * @param getConfigurationSetRequest
     *        A request to obtain information about a configuration set.
     * @return A Java Future containing the result of the GetConfigurationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetConfigurationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetConfigurationSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetConfigurationSetResponse> getConfigurationSet(
            GetConfigurationSetRequest getConfigurationSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about an existing configuration set, including the dedicated IP pool that it's associated with,
     * whether or not it's enabled for sending email, and more.
     * </p>
     * <p>
     * <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a
     * configuration set to an email by including a reference to the configuration set in the headers of the email. When
     * you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfigurationSetRequest.Builder} avoiding the
     * need to create one manually via {@link GetConfigurationSetRequest#builder()}
     * </p>
     *
     * @param getConfigurationSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetConfigurationSetRequest.Builder} to create a
     *        request. A request to obtain information about a configuration set.
     * @return A Java Future containing the result of the GetConfigurationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetConfigurationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetConfigurationSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetConfigurationSetResponse> getConfigurationSet(
            Consumer<GetConfigurationSetRequest.Builder> getConfigurationSetRequest) {
        return getConfigurationSet(GetConfigurationSetRequest.builder().applyMutation(getConfigurationSetRequest).build());
    }

    /**
     * <p>
     * Retrieve a list of event destinations that are associated with a configuration set.
     * </p>
     * <p>
     * <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event
     * destinations</i> are places that you can send information about these events to. For example, you can send event
     * data to Amazon EventBridge and associate a rule to send the event to the specified target.
     * </p>
     *
     * @param getConfigurationSetEventDestinationsRequest
     *        A request to obtain information about the event destinations for a configuration set.
     * @return A Java Future containing the result of the GetConfigurationSetEventDestinations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetConfigurationSetEventDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetConfigurationSetEventDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConfigurationSetEventDestinationsResponse> getConfigurationSetEventDestinations(
            GetConfigurationSetEventDestinationsRequest getConfigurationSetEventDestinationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve a list of event destinations that are associated with a configuration set.
     * </p>
     * <p>
     * <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event
     * destinations</i> are places that you can send information about these events to. For example, you can send event
     * data to Amazon EventBridge and associate a rule to send the event to the specified target.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetConfigurationSetEventDestinationsRequest.Builder} avoiding the need to create one manually via
     * {@link GetConfigurationSetEventDestinationsRequest#builder()}
     * </p>
     *
     * @param getConfigurationSetEventDestinationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetConfigurationSetEventDestinationsRequest.Builder} to
     *        create a request. A request to obtain information about the event destinations for a configuration set.
     * @return A Java Future containing the result of the GetConfigurationSetEventDestinations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetConfigurationSetEventDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetConfigurationSetEventDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConfigurationSetEventDestinationsResponse> getConfigurationSetEventDestinations(
            Consumer<GetConfigurationSetEventDestinationsRequest.Builder> getConfigurationSetEventDestinationsRequest) {
        return getConfigurationSetEventDestinations(GetConfigurationSetEventDestinationsRequest.builder()
                .applyMutation(getConfigurationSetEventDestinationsRequest).build());
    }

    /**
     * <p>
     * Returns a contact from a contact list.
     * </p>
     *
     * @param getContactRequest
     * @return A Java Future containing the result of the GetContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetContact" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetContactResponse> getContact(GetContactRequest getContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a contact from a contact list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContactRequest.Builder} avoiding the need to
     * create one manually via {@link GetContactRequest#builder()}
     * </p>
     *
     * @param getContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetContactRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetContact" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetContactResponse> getContact(Consumer<GetContactRequest.Builder> getContactRequest) {
        return getContact(GetContactRequest.builder().applyMutation(getContactRequest).build());
    }

    /**
     * <p>
     * Returns contact list metadata. It does not return any information about the contacts present in the list.
     * </p>
     *
     * @param getContactListRequest
     * @return A Java Future containing the result of the GetContactList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetContactList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetContactList" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetContactListResponse> getContactList(GetContactListRequest getContactListRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns contact list metadata. It does not return any information about the contacts present in the list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContactListRequest.Builder} avoiding the need to
     * create one manually via {@link GetContactListRequest#builder()}
     * </p>
     *
     * @param getContactListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetContactListRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetContactList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetContactList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetContactList" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetContactListResponse> getContactList(Consumer<GetContactListRequest.Builder> getContactListRequest) {
        return getContactList(GetContactListRequest.builder().applyMutation(getContactListRequest).build());
    }

    /**
     * <p>
     * Returns the custom email verification template for the template name you specify.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param getCustomVerificationEmailTemplateRequest
     *        Represents a request to retrieve an existing custom verification email template.
     * @return A Java Future containing the result of the GetCustomVerificationEmailTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetCustomVerificationEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCustomVerificationEmailTemplateResponse> getCustomVerificationEmailTemplate(
            GetCustomVerificationEmailTemplateRequest getCustomVerificationEmailTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the custom email verification template for the template name you specify.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCustomVerificationEmailTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link GetCustomVerificationEmailTemplateRequest#builder()}
     * </p>
     *
     * @param getCustomVerificationEmailTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetCustomVerificationEmailTemplateRequest.Builder} to
     *        create a request. Represents a request to retrieve an existing custom verification email template.
     * @return A Java Future containing the result of the GetCustomVerificationEmailTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetCustomVerificationEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCustomVerificationEmailTemplateResponse> getCustomVerificationEmailTemplate(
            Consumer<GetCustomVerificationEmailTemplateRequest.Builder> getCustomVerificationEmailTemplateRequest) {
        return getCustomVerificationEmailTemplate(GetCustomVerificationEmailTemplateRequest.builder()
                .applyMutation(getCustomVerificationEmailTemplateRequest).build());
    }

    /**
     * <p>
     * Get information about a dedicated IP address, including the name of the dedicated IP pool that it's associated
     * with, as well information about the automatic warm-up process for the address.
     * </p>
     *
     * @param getDedicatedIpRequest
     *        A request to obtain more information about a dedicated IP address.
     * @return A Java Future containing the result of the GetDedicatedIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDedicatedIp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDedicatedIpResponse> getDedicatedIp(GetDedicatedIpRequest getDedicatedIpRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about a dedicated IP address, including the name of the dedicated IP pool that it's associated
     * with, as well information about the automatic warm-up process for the address.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDedicatedIpRequest.Builder} avoiding the need to
     * create one manually via {@link GetDedicatedIpRequest#builder()}
     * </p>
     *
     * @param getDedicatedIpRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetDedicatedIpRequest.Builder} to create a request. A
     *        request to obtain more information about a dedicated IP address.
     * @return A Java Future containing the result of the GetDedicatedIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDedicatedIp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDedicatedIpResponse> getDedicatedIp(Consumer<GetDedicatedIpRequest.Builder> getDedicatedIpRequest) {
        return getDedicatedIp(GetDedicatedIpRequest.builder().applyMutation(getDedicatedIpRequest).build());
    }

    /**
     * <p>
     * Retrieve information about the dedicated pool.
     * </p>
     *
     * @param getDedicatedIpPoolRequest
     *        A request to obtain more information about a dedicated IP pool.
     * @return A Java Future containing the result of the GetDedicatedIpPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDedicatedIpPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIpPool" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDedicatedIpPoolResponse> getDedicatedIpPool(GetDedicatedIpPoolRequest getDedicatedIpPoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve information about the dedicated pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDedicatedIpPoolRequest.Builder} avoiding the
     * need to create one manually via {@link GetDedicatedIpPoolRequest#builder()}
     * </p>
     *
     * @param getDedicatedIpPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetDedicatedIpPoolRequest.Builder} to create a request.
     *        A request to obtain more information about a dedicated IP pool.
     * @return A Java Future containing the result of the GetDedicatedIpPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDedicatedIpPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIpPool" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDedicatedIpPoolResponse> getDedicatedIpPool(
            Consumer<GetDedicatedIpPoolRequest.Builder> getDedicatedIpPoolRequest) {
        return getDedicatedIpPool(GetDedicatedIpPoolRequest.builder().applyMutation(getDedicatedIpPoolRequest).build());
    }

    /**
     * <p>
     * List the dedicated IP addresses that are associated with your Amazon Web Services account.
     * </p>
     *
     * @param getDedicatedIpsRequest
     *        A request to obtain more information about dedicated IP pools.
     * @return A Java Future containing the result of the GetDedicatedIps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDedicatedIps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIps" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDedicatedIpsResponse> getDedicatedIps(GetDedicatedIpsRequest getDedicatedIpsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the dedicated IP addresses that are associated with your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDedicatedIpsRequest.Builder} avoiding the need
     * to create one manually via {@link GetDedicatedIpsRequest#builder()}
     * </p>
     *
     * @param getDedicatedIpsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsRequest.Builder} to create a request. A
     *        request to obtain more information about dedicated IP pools.
     * @return A Java Future containing the result of the GetDedicatedIps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDedicatedIps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIps" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDedicatedIpsResponse> getDedicatedIps(
            Consumer<GetDedicatedIpsRequest.Builder> getDedicatedIpsRequest) {
        return getDedicatedIps(GetDedicatedIpsRequest.builder().applyMutation(getDedicatedIpsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #getDedicatedIps(software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.GetDedicatedIpsPublisher publisher = client.getDedicatedIpsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.GetDedicatedIpsPublisher publisher = client.getDedicatedIpsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDedicatedIps(software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsRequest)} operation.</b>
     * </p>
     *
     * @param getDedicatedIpsRequest
     *        A request to obtain more information about dedicated IP pools.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDedicatedIps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIps" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDedicatedIpsPublisher getDedicatedIpsPaginator(GetDedicatedIpsRequest getDedicatedIpsRequest) {
        return new GetDedicatedIpsPublisher(this, getDedicatedIpsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #getDedicatedIps(software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.GetDedicatedIpsPublisher publisher = client.getDedicatedIpsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.GetDedicatedIpsPublisher publisher = client.getDedicatedIpsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDedicatedIps(software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDedicatedIpsRequest.Builder} avoiding the need
     * to create one manually via {@link GetDedicatedIpsRequest#builder()}
     * </p>
     *
     * @param getDedicatedIpsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsRequest.Builder} to create a request. A
     *        request to obtain more information about dedicated IP pools.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDedicatedIps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIps" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDedicatedIpsPublisher getDedicatedIpsPaginator(Consumer<GetDedicatedIpsRequest.Builder> getDedicatedIpsRequest) {
        return getDedicatedIpsPaginator(GetDedicatedIpsRequest.builder().applyMutation(getDedicatedIpsRequest).build());
    }

    /**
     * <p>
     * Retrieve information about the status of the Deliverability dashboard for your account. When the Deliverability
     * dashboard is enabled, you gain access to reputation, deliverability, and other metrics for the domains that you
     * use to send email. You also gain the ability to perform predictive inbox placement tests.
     * </p>
     * <p>
     * When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees
     * that you accrue by using Amazon SES and other Amazon Web Services services. For more information about the
     * features and cost of a Deliverability dashboard subscription, see <a
     * href="http://aws.amazon.com/ses/pricing/">Amazon SES Pricing</a>.
     * </p>
     *
     * @param getDeliverabilityDashboardOptionsRequest
     *        Retrieve information about the status of the Deliverability dashboard for your Amazon Web Services
     *        account. When the Deliverability dashboard is enabled, you gain access to reputation, deliverability, and
     *        other metrics for your domains. You also gain the ability to perform predictive inbox placement tests.</p>
     *        <p>
     *        When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other
     *        fees that you accrue by using Amazon SES and other Amazon Web Services services. For more information
     *        about the features and cost of a Deliverability dashboard subscription, see <a
     *        href="http://aws.amazon.com/pinpoint/pricing/">Amazon Pinpoint Pricing</a>.
     * @return A Java Future containing the result of the GetDeliverabilityDashboardOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li> <li>
     *         LimitExceededException There are too many instances of the specified resource type.</li> <li>
     *         BadRequestException The input you provided is invalid.</li> <li>SdkException Base class for all
     *         exceptions that can be thrown by the SDK (both service and client). Can be used for catch all scenarios.
     *         </li> <li>SdkClientException If any client side error occurs such as an IO related failure, failure to
     *         get credentials, etc.</li> <li>SesV2Exception Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDeliverabilityDashboardOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDeliverabilityDashboardOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDeliverabilityDashboardOptionsResponse> getDeliverabilityDashboardOptions(
            GetDeliverabilityDashboardOptionsRequest getDeliverabilityDashboardOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve information about the status of the Deliverability dashboard for your account. When the Deliverability
     * dashboard is enabled, you gain access to reputation, deliverability, and other metrics for the domains that you
     * use to send email. You also gain the ability to perform predictive inbox placement tests.
     * </p>
     * <p>
     * When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees
     * that you accrue by using Amazon SES and other Amazon Web Services services. For more information about the
     * features and cost of a Deliverability dashboard subscription, see <a
     * href="http://aws.amazon.com/ses/pricing/">Amazon SES Pricing</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeliverabilityDashboardOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link GetDeliverabilityDashboardOptionsRequest#builder()}
     * </p>
     *
     * @param getDeliverabilityDashboardOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetDeliverabilityDashboardOptionsRequest.Builder} to
     *        create a request. Retrieve information about the status of the Deliverability dashboard for your Amazon
     *        Web Services account. When the Deliverability dashboard is enabled, you gain access to reputation,
     *        deliverability, and other metrics for your domains. You also gain the ability to perform predictive inbox
     *        placement tests.</p>
     *        <p>
     *        When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other
     *        fees that you accrue by using Amazon SES and other Amazon Web Services services. For more information
     *        about the features and cost of a Deliverability dashboard subscription, see <a
     *        href="http://aws.amazon.com/pinpoint/pricing/">Amazon Pinpoint Pricing</a>.
     * @return A Java Future containing the result of the GetDeliverabilityDashboardOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li> <li>
     *         LimitExceededException There are too many instances of the specified resource type.</li> <li>
     *         BadRequestException The input you provided is invalid.</li> <li>SdkException Base class for all
     *         exceptions that can be thrown by the SDK (both service and client). Can be used for catch all scenarios.
     *         </li> <li>SdkClientException If any client side error occurs such as an IO related failure, failure to
     *         get credentials, etc.</li> <li>SesV2Exception Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDeliverabilityDashboardOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDeliverabilityDashboardOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDeliverabilityDashboardOptionsResponse> getDeliverabilityDashboardOptions(
            Consumer<GetDeliverabilityDashboardOptionsRequest.Builder> getDeliverabilityDashboardOptionsRequest) {
        return getDeliverabilityDashboardOptions(GetDeliverabilityDashboardOptionsRequest.builder()
                .applyMutation(getDeliverabilityDashboardOptionsRequest).build());
    }

    /**
     * <p>
     * Retrieve the results of a predictive inbox placement test.
     * </p>
     *
     * @param getDeliverabilityTestReportRequest
     *        A request to retrieve the results of a predictive inbox placement test.
     * @return A Java Future containing the result of the GetDeliverabilityTestReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDeliverabilityTestReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDeliverabilityTestReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDeliverabilityTestReportResponse> getDeliverabilityTestReport(
            GetDeliverabilityTestReportRequest getDeliverabilityTestReportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve the results of a predictive inbox placement test.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeliverabilityTestReportRequest.Builder}
     * avoiding the need to create one manually via {@link GetDeliverabilityTestReportRequest#builder()}
     * </p>
     *
     * @param getDeliverabilityTestReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetDeliverabilityTestReportRequest.Builder} to create a
     *        request. A request to retrieve the results of a predictive inbox placement test.
     * @return A Java Future containing the result of the GetDeliverabilityTestReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDeliverabilityTestReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDeliverabilityTestReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDeliverabilityTestReportResponse> getDeliverabilityTestReport(
            Consumer<GetDeliverabilityTestReportRequest.Builder> getDeliverabilityTestReportRequest) {
        return getDeliverabilityTestReport(GetDeliverabilityTestReportRequest.builder()
                .applyMutation(getDeliverabilityTestReportRequest).build());
    }

    /**
     * <p>
     * Retrieve all the deliverability data for a specific campaign. This data is available for a campaign only if the
     * campaign sent email by using a domain that the Deliverability dashboard is enabled for.
     * </p>
     *
     * @param getDomainDeliverabilityCampaignRequest
     *        Retrieve all the deliverability data for a specific campaign. This data is available for a campaign only
     *        if the campaign sent email by using a domain that the Deliverability dashboard is enabled for (
     *        <code>PutDeliverabilityDashboardOption</code> operation).
     * @return A Java Future containing the result of the GetDomainDeliverabilityCampaign operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDomainDeliverabilityCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDomainDeliverabilityCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDomainDeliverabilityCampaignResponse> getDomainDeliverabilityCampaign(
            GetDomainDeliverabilityCampaignRequest getDomainDeliverabilityCampaignRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve all the deliverability data for a specific campaign. This data is available for a campaign only if the
     * campaign sent email by using a domain that the Deliverability dashboard is enabled for.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainDeliverabilityCampaignRequest.Builder}
     * avoiding the need to create one manually via {@link GetDomainDeliverabilityCampaignRequest#builder()}
     * </p>
     *
     * @param getDomainDeliverabilityCampaignRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetDomainDeliverabilityCampaignRequest.Builder} to
     *        create a request. Retrieve all the deliverability data for a specific campaign. This data is available for
     *        a campaign only if the campaign sent email by using a domain that the Deliverability dashboard is enabled
     *        for (<code>PutDeliverabilityDashboardOption</code> operation).
     * @return A Java Future containing the result of the GetDomainDeliverabilityCampaign operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDomainDeliverabilityCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDomainDeliverabilityCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDomainDeliverabilityCampaignResponse> getDomainDeliverabilityCampaign(
            Consumer<GetDomainDeliverabilityCampaignRequest.Builder> getDomainDeliverabilityCampaignRequest) {
        return getDomainDeliverabilityCampaign(GetDomainDeliverabilityCampaignRequest.builder()
                .applyMutation(getDomainDeliverabilityCampaignRequest).build());
    }

    /**
     * <p>
     * Retrieve inbox placement and engagement rates for the domains that you use to send email.
     * </p>
     *
     * @param getDomainStatisticsReportRequest
     *        A request to obtain deliverability metrics for a domain.
     * @return A Java Future containing the result of the GetDomainStatisticsReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDomainStatisticsReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDomainStatisticsReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDomainStatisticsReportResponse> getDomainStatisticsReport(
            GetDomainStatisticsReportRequest getDomainStatisticsReportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve inbox placement and engagement rates for the domains that you use to send email.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainStatisticsReportRequest.Builder} avoiding
     * the need to create one manually via {@link GetDomainStatisticsReportRequest#builder()}
     * </p>
     *
     * @param getDomainStatisticsReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetDomainStatisticsReportRequest.Builder} to create a
     *        request. A request to obtain deliverability metrics for a domain.
     * @return A Java Future containing the result of the GetDomainStatisticsReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDomainStatisticsReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDomainStatisticsReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDomainStatisticsReportResponse> getDomainStatisticsReport(
            Consumer<GetDomainStatisticsReportRequest.Builder> getDomainStatisticsReportRequest) {
        return getDomainStatisticsReport(GetDomainStatisticsReportRequest.builder()
                .applyMutation(getDomainStatisticsReportRequest).build());
    }

    /**
     * <p>
     * Provides information about a specific identity, including the identity's verification status, sending
     * authorization policies, its DKIM authentication status, and its custom Mail-From settings.
     * </p>
     *
     * @param getEmailIdentityRequest
     *        A request to return details about an email identity.
     * @return A Java Future containing the result of the GetEmailIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetEmailIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetEmailIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEmailIdentityResponse> getEmailIdentity(GetEmailIdentityRequest getEmailIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about a specific identity, including the identity's verification status, sending
     * authorization policies, its DKIM authentication status, and its custom Mail-From settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEmailIdentityRequest.Builder} avoiding the need
     * to create one manually via {@link GetEmailIdentityRequest#builder()}
     * </p>
     *
     * @param getEmailIdentityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetEmailIdentityRequest.Builder} to create a request. A
     *        request to return details about an email identity.
     * @return A Java Future containing the result of the GetEmailIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetEmailIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetEmailIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEmailIdentityResponse> getEmailIdentity(
            Consumer<GetEmailIdentityRequest.Builder> getEmailIdentityRequest) {
        return getEmailIdentity(GetEmailIdentityRequest.builder().applyMutation(getEmailIdentityRequest).build());
    }

    /**
     * <p>
     * Returns the requested sending authorization policies for the given identity (an email address or a domain). The
     * policies are returned as a map of policy names to policy contents. You can retrieve a maximum of 20 policies at a
     * time.
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param getEmailIdentityPoliciesRequest
     *        A request to return the policies of an email identity.
     * @return A Java Future containing the result of the GetEmailIdentityPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetEmailIdentityPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetEmailIdentityPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEmailIdentityPoliciesResponse> getEmailIdentityPolicies(
            GetEmailIdentityPoliciesRequest getEmailIdentityPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the requested sending authorization policies for the given identity (an email address or a domain). The
     * policies are returned as a map of policy names to policy contents. You can retrieve a maximum of 20 policies at a
     * time.
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEmailIdentityPoliciesRequest.Builder} avoiding
     * the need to create one manually via {@link GetEmailIdentityPoliciesRequest#builder()}
     * </p>
     *
     * @param getEmailIdentityPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetEmailIdentityPoliciesRequest.Builder} to create a
     *        request. A request to return the policies of an email identity.
     * @return A Java Future containing the result of the GetEmailIdentityPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetEmailIdentityPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetEmailIdentityPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEmailIdentityPoliciesResponse> getEmailIdentityPolicies(
            Consumer<GetEmailIdentityPoliciesRequest.Builder> getEmailIdentityPoliciesRequest) {
        return getEmailIdentityPolicies(GetEmailIdentityPoliciesRequest.builder().applyMutation(getEmailIdentityPoliciesRequest)
                .build());
    }

    /**
     * <p>
     * Displays the template object (which includes the subject line, HTML part and text part) for the template you
     * specify.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param getEmailTemplateRequest
     *        Represents a request to display the template object (which includes the subject line, HTML part and text
     *        part) for the template you specify.
     * @return A Java Future containing the result of the GetEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetEmailTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEmailTemplateResponse> getEmailTemplate(GetEmailTemplateRequest getEmailTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the template object (which includes the subject line, HTML part and text part) for the template you
     * specify.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEmailTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link GetEmailTemplateRequest#builder()}
     * </p>
     *
     * @param getEmailTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetEmailTemplateRequest.Builder} to create a request.
     *        Represents a request to display the template object (which includes the subject line, HTML part and text
     *        part) for the template you specify.
     * @return A Java Future containing the result of the GetEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetEmailTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEmailTemplateResponse> getEmailTemplate(
            Consumer<GetEmailTemplateRequest.Builder> getEmailTemplateRequest) {
        return getEmailTemplate(GetEmailTemplateRequest.builder().applyMutation(getEmailTemplateRequest).build());
    }

    /**
     * <p>
     * Provides information about an export job.
     * </p>
     *
     * @param getExportJobRequest
     *        Represents a request to retrieve information about an export job using the export job ID.
     * @return A Java Future containing the result of the GetExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetExportJobResponse> getExportJob(GetExportJobRequest getExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about an export job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExportJobRequest.Builder} avoiding the need to
     * create one manually via {@link GetExportJobRequest#builder()}
     * </p>
     *
     * @param getExportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetExportJobRequest.Builder} to create a request.
     *        Represents a request to retrieve information about an export job using the export job ID.
     * @return A Java Future containing the result of the GetExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetExportJobResponse> getExportJob(Consumer<GetExportJobRequest.Builder> getExportJobRequest) {
        return getExportJob(GetExportJobRequest.builder().applyMutation(getExportJobRequest).build());
    }

    /**
     * <p>
     * Provides information about an import job.
     * </p>
     *
     * @param getImportJobRequest
     *        Represents a request for information about an import job using the import job ID.
     * @return A Java Future containing the result of the GetImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetImportJobResponse> getImportJob(GetImportJobRequest getImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about an import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetImportJobRequest.Builder} avoiding the need to
     * create one manually via {@link GetImportJobRequest#builder()}
     * </p>
     *
     * @param getImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetImportJobRequest.Builder} to create a request.
     *        Represents a request for information about an import job using the import job ID.
     * @return A Java Future containing the result of the GetImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetImportJobResponse> getImportJob(Consumer<GetImportJobRequest.Builder> getImportJobRequest) {
        return getImportJob(GetImportJobRequest.builder().applyMutation(getImportJobRequest).build());
    }

    /**
     * <p>
     * Provides information about a specific message, including the from address, the subject, the recipient address,
     * email tags, as well as events associated with the message.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param getMessageInsightsRequest
     *        A request to return information about a message.
     * @return A Java Future containing the result of the GetMessageInsights operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetMessageInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetMessageInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMessageInsightsResponse> getMessageInsights(GetMessageInsightsRequest getMessageInsightsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about a specific message, including the from address, the subject, the recipient address,
     * email tags, as well as events associated with the message.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMessageInsightsRequest.Builder} avoiding the
     * need to create one manually via {@link GetMessageInsightsRequest#builder()}
     * </p>
     *
     * @param getMessageInsightsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetMessageInsightsRequest.Builder} to create a request.
     *        A request to return information about a message.
     * @return A Java Future containing the result of the GetMessageInsights operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetMessageInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetMessageInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMessageInsightsResponse> getMessageInsights(
            Consumer<GetMessageInsightsRequest.Builder> getMessageInsightsRequest) {
        return getMessageInsights(GetMessageInsightsRequest.builder().applyMutation(getMessageInsightsRequest).build());
    }

    /**
     * <p>
     * Displays the multi-region endpoint (global-endpoint) configuration.
     * </p>
     * <p>
     * Only multi-region endpoints (global-endpoints) whose primary region is the AWS-Region where operation is executed
     * can be displayed.
     * </p>
     *
     * @param getMultiRegionEndpointRequest
     *        Represents a request to display the multi-region endpoint (global-endpoint).
     * @return A Java Future containing the result of the GetMultiRegionEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetMultiRegionEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetMultiRegionEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMultiRegionEndpointResponse> getMultiRegionEndpoint(
            GetMultiRegionEndpointRequest getMultiRegionEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the multi-region endpoint (global-endpoint) configuration.
     * </p>
     * <p>
     * Only multi-region endpoints (global-endpoints) whose primary region is the AWS-Region where operation is executed
     * can be displayed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMultiRegionEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link GetMultiRegionEndpointRequest#builder()}
     * </p>
     *
     * @param getMultiRegionEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetMultiRegionEndpointRequest.Builder} to create a
     *        request. Represents a request to display the multi-region endpoint (global-endpoint).
     * @return A Java Future containing the result of the GetMultiRegionEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetMultiRegionEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetMultiRegionEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMultiRegionEndpointResponse> getMultiRegionEndpoint(
            Consumer<GetMultiRegionEndpointRequest.Builder> getMultiRegionEndpointRequest) {
        return getMultiRegionEndpoint(GetMultiRegionEndpointRequest.builder().applyMutation(getMultiRegionEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Retrieve information about a specific reputation entity, including its reputation management policy,
     * customer-managed status, Amazon Web Services Amazon SES-managed status, and aggregate sending status.
     * </p>
     * <p>
     * <i>Reputation entities</i> represent resources in your Amazon SES account that have reputation tracking and
     * management capabilities. The reputation impact reflects the highest impact reputation finding for the entity.
     * Reputation findings can be retrieved using the <code>ListRecommendations</code> operation.
     * </p>
     *
     * @param getReputationEntityRequest
     *        Represents a request to retrieve information about a specific reputation entity.
     * @return A Java Future containing the result of the GetReputationEntity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetReputationEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetReputationEntity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReputationEntityResponse> getReputationEntity(
            GetReputationEntityRequest getReputationEntityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve information about a specific reputation entity, including its reputation management policy,
     * customer-managed status, Amazon Web Services Amazon SES-managed status, and aggregate sending status.
     * </p>
     * <p>
     * <i>Reputation entities</i> represent resources in your Amazon SES account that have reputation tracking and
     * management capabilities. The reputation impact reflects the highest impact reputation finding for the entity.
     * Reputation findings can be retrieved using the <code>ListRecommendations</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReputationEntityRequest.Builder} avoiding the
     * need to create one manually via {@link GetReputationEntityRequest#builder()}
     * </p>
     *
     * @param getReputationEntityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetReputationEntityRequest.Builder} to create a
     *        request. Represents a request to retrieve information about a specific reputation entity.
     * @return A Java Future containing the result of the GetReputationEntity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetReputationEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetReputationEntity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReputationEntityResponse> getReputationEntity(
            Consumer<GetReputationEntityRequest.Builder> getReputationEntityRequest) {
        return getReputationEntity(GetReputationEntityRequest.builder().applyMutation(getReputationEntityRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specific email address that's on the suppression list for your account.
     * </p>
     *
     * @param getSuppressedDestinationRequest
     *        A request to retrieve information about an email address that's on the suppression list for your account.
     * @return A Java Future containing the result of the GetSuppressedDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetSuppressedDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetSuppressedDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSuppressedDestinationResponse> getSuppressedDestination(
            GetSuppressedDestinationRequest getSuppressedDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specific email address that's on the suppression list for your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSuppressedDestinationRequest.Builder} avoiding
     * the need to create one manually via {@link GetSuppressedDestinationRequest#builder()}
     * </p>
     *
     * @param getSuppressedDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetSuppressedDestinationRequest.Builder} to create a
     *        request. A request to retrieve information about an email address that's on the suppression list for your
     *        account.
     * @return A Java Future containing the result of the GetSuppressedDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetSuppressedDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetSuppressedDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSuppressedDestinationResponse> getSuppressedDestination(
            Consumer<GetSuppressedDestinationRequest.Builder> getSuppressedDestinationRequest) {
        return getSuppressedDestination(GetSuppressedDestinationRequest.builder().applyMutation(getSuppressedDestinationRequest)
                .build());
    }

    /**
     * <p>
     * Get information about a specific tenant, including the tenant's name, ID, ARN, creation timestamp, tags, and
     * sending status.
     * </p>
     *
     * @param getTenantRequest
     *        Represents a request to get information about a specific tenant.
     * @return A Java Future containing the result of the GetTenant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetTenant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetTenant" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTenantResponse> getTenant(GetTenantRequest getTenantRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about a specific tenant, including the tenant's name, ID, ARN, creation timestamp, tags, and
     * sending status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTenantRequest.Builder} avoiding the need to
     * create one manually via {@link GetTenantRequest#builder()}
     * </p>
     *
     * @param getTenantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetTenantRequest.Builder} to create a request.
     *        Represents a request to get information about a specific tenant.
     * @return A Java Future containing the result of the GetTenant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetTenant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetTenant" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTenantResponse> getTenant(Consumer<GetTenantRequest.Builder> getTenantRequest) {
        return getTenant(GetTenantRequest.builder().applyMutation(getTenantRequest).build());
    }

    /**
     * <p>
     * List all of the configuration sets associated with your account in the current region.
     * </p>
     * <p>
     * <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a
     * configuration set to an email by including a reference to the configuration set in the headers of the email. When
     * you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     * </p>
     *
     * @param listConfigurationSetsRequest
     *        A request to obtain a list of configuration sets for your Amazon SES account in the current Amazon Web
     *        Services Region.
     * @return A Java Future containing the result of the ListConfigurationSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListConfigurationSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListConfigurationSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListConfigurationSetsResponse> listConfigurationSets(
            ListConfigurationSetsRequest listConfigurationSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all of the configuration sets associated with your account in the current region.
     * </p>
     * <p>
     * <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a
     * configuration set to an email by including a reference to the configuration set in the headers of the email. When
     * you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListConfigurationSetsRequest#builder()}
     * </p>
     *
     * @param listConfigurationSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsRequest.Builder} to create a
     *        request. A request to obtain a list of configuration sets for your Amazon SES account in the current
     *        Amazon Web Services Region.
     * @return A Java Future containing the result of the ListConfigurationSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListConfigurationSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListConfigurationSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListConfigurationSetsResponse> listConfigurationSets(
            Consumer<ListConfigurationSetsRequest.Builder> listConfigurationSetsRequest) {
        return listConfigurationSets(ListConfigurationSetsRequest.builder().applyMutation(listConfigurationSetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfigurationSets(software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListConfigurationSetsPublisher publisher = client.listConfigurationSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListConfigurationSetsPublisher publisher = client.listConfigurationSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurationSets(software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConfigurationSetsRequest
     *        A request to obtain a list of configuration sets for your Amazon SES account in the current Amazon Web
     *        Services Region.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListConfigurationSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListConfigurationSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListConfigurationSetsPublisher listConfigurationSetsPaginator(
            ListConfigurationSetsRequest listConfigurationSetsRequest) {
        return new ListConfigurationSetsPublisher(this, listConfigurationSetsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfigurationSets(software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListConfigurationSetsPublisher publisher = client.listConfigurationSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListConfigurationSetsPublisher publisher = client.listConfigurationSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurationSets(software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListConfigurationSetsRequest#builder()}
     * </p>
     *
     * @param listConfigurationSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsRequest.Builder} to create a
     *        request. A request to obtain a list of configuration sets for your Amazon SES account in the current
     *        Amazon Web Services Region.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListConfigurationSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListConfigurationSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListConfigurationSetsPublisher listConfigurationSetsPaginator(
            Consumer<ListConfigurationSetsRequest.Builder> listConfigurationSetsRequest) {
        return listConfigurationSetsPaginator(ListConfigurationSetsRequest.builder().applyMutation(listConfigurationSetsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all of the contact lists available.
     * </p>
     * <p>
     * If your output includes a "NextToken" field with a string value, this indicates there may be additional contacts
     * on the filtered list - regardless of the number of contacts returned.
     * </p>
     *
     * @param listContactListsRequest
     * @return A Java Future containing the result of the ListContactLists operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListContactLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListContactLists" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListContactListsResponse> listContactLists(ListContactListsRequest listContactListsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the contact lists available.
     * </p>
     * <p>
     * If your output includes a "NextToken" field with a string value, this indicates there may be additional contacts
     * on the filtered list - regardless of the number of contacts returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactListsRequest.Builder} avoiding the need
     * to create one manually via {@link ListContactListsRequest#builder()}
     * </p>
     *
     * @param listContactListsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListContactListsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListContactLists operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListContactLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListContactLists" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListContactListsResponse> listContactLists(
            Consumer<ListContactListsRequest.Builder> listContactListsRequest) {
        return listContactLists(ListContactListsRequest.builder().applyMutation(listContactListsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listContactLists(software.amazon.awssdk.services.sesv2.model.ListContactListsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListContactListsPublisher publisher = client.listContactListsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListContactListsPublisher publisher = client.listContactListsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListContactListsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListContactListsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContactLists(software.amazon.awssdk.services.sesv2.model.ListContactListsRequest)} operation.</b>
     * </p>
     *
     * @param listContactListsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListContactLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListContactLists" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContactListsPublisher listContactListsPaginator(ListContactListsRequest listContactListsRequest) {
        return new ListContactListsPublisher(this, listContactListsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listContactLists(software.amazon.awssdk.services.sesv2.model.ListContactListsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListContactListsPublisher publisher = client.listContactListsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListContactListsPublisher publisher = client.listContactListsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListContactListsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListContactListsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContactLists(software.amazon.awssdk.services.sesv2.model.ListContactListsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactListsRequest.Builder} avoiding the need
     * to create one manually via {@link ListContactListsRequest#builder()}
     * </p>
     *
     * @param listContactListsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListContactListsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListContactLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListContactLists" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContactListsPublisher listContactListsPaginator(Consumer<ListContactListsRequest.Builder> listContactListsRequest) {
        return listContactListsPaginator(ListContactListsRequest.builder().applyMutation(listContactListsRequest).build());
    }

    /**
     * <p>
     * Lists the contacts present in a specific contact list.
     * </p>
     *
     * @param listContactsRequest
     * @return A Java Future containing the result of the ListContacts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListContacts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListContactsResponse> listContacts(ListContactsRequest listContactsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the contacts present in a specific contact list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactsRequest.Builder} avoiding the need to
     * create one manually via {@link ListContactsRequest#builder()}
     * </p>
     *
     * @param listContactsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListContactsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListContacts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListContacts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListContactsResponse> listContacts(Consumer<ListContactsRequest.Builder> listContactsRequest) {
        return listContacts(ListContactsRequest.builder().applyMutation(listContactsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listContacts(software.amazon.awssdk.services.sesv2.model.ListContactsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListContactsPublisher publisher = client.listContactsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListContactsPublisher publisher = client.listContactsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListContactsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListContactsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContacts(software.amazon.awssdk.services.sesv2.model.ListContactsRequest)} operation.</b>
     * </p>
     *
     * @param listContactsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListContacts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContactsPublisher listContactsPaginator(ListContactsRequest listContactsRequest) {
        return new ListContactsPublisher(this, listContactsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listContacts(software.amazon.awssdk.services.sesv2.model.ListContactsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListContactsPublisher publisher = client.listContactsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListContactsPublisher publisher = client.listContactsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListContactsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListContactsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContacts(software.amazon.awssdk.services.sesv2.model.ListContactsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactsRequest.Builder} avoiding the need to
     * create one manually via {@link ListContactsRequest#builder()}
     * </p>
     *
     * @param listContactsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListContactsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListContacts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContactsPublisher listContactsPaginator(Consumer<ListContactsRequest.Builder> listContactsRequest) {
        return listContactsPaginator(ListContactsRequest.builder().applyMutation(listContactsRequest).build());
    }

    /**
     * <p>
     * Lists the existing custom verification email templates for your account in the current Amazon Web Services
     * Region.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param listCustomVerificationEmailTemplatesRequest
     *        Represents a request to list the existing custom verification email templates for your account.
     * @return A Java Future containing the result of the ListCustomVerificationEmailTemplates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListCustomVerificationEmailTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListCustomVerificationEmailTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomVerificationEmailTemplatesResponse> listCustomVerificationEmailTemplates(
            ListCustomVerificationEmailTemplatesRequest listCustomVerificationEmailTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the existing custom verification email templates for your account in the current Amazon Web Services
     * Region.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCustomVerificationEmailTemplatesRequest.Builder} avoiding the need to create one manually via
     * {@link ListCustomVerificationEmailTemplatesRequest#builder()}
     * </p>
     *
     * @param listCustomVerificationEmailTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesRequest.Builder} to
     *        create a request. Represents a request to list the existing custom verification email templates for your
     *        account.
     * @return A Java Future containing the result of the ListCustomVerificationEmailTemplates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListCustomVerificationEmailTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListCustomVerificationEmailTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomVerificationEmailTemplatesResponse> listCustomVerificationEmailTemplates(
            Consumer<ListCustomVerificationEmailTemplatesRequest.Builder> listCustomVerificationEmailTemplatesRequest) {
        return listCustomVerificationEmailTemplates(ListCustomVerificationEmailTemplatesRequest.builder()
                .applyMutation(listCustomVerificationEmailTemplatesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCustomVerificationEmailTemplates(software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListCustomVerificationEmailTemplatesPublisher publisher = client.listCustomVerificationEmailTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListCustomVerificationEmailTemplatesPublisher publisher = client.listCustomVerificationEmailTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomVerificationEmailTemplates(software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomVerificationEmailTemplatesRequest
     *        Represents a request to list the existing custom verification email templates for your account.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListCustomVerificationEmailTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListCustomVerificationEmailTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomVerificationEmailTemplatesPublisher listCustomVerificationEmailTemplatesPaginator(
            ListCustomVerificationEmailTemplatesRequest listCustomVerificationEmailTemplatesRequest) {
        return new ListCustomVerificationEmailTemplatesPublisher(this, listCustomVerificationEmailTemplatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCustomVerificationEmailTemplates(software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListCustomVerificationEmailTemplatesPublisher publisher = client.listCustomVerificationEmailTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListCustomVerificationEmailTemplatesPublisher publisher = client.listCustomVerificationEmailTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomVerificationEmailTemplates(software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCustomVerificationEmailTemplatesRequest.Builder} avoiding the need to create one manually via
     * {@link ListCustomVerificationEmailTemplatesRequest#builder()}
     * </p>
     *
     * @param listCustomVerificationEmailTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesRequest.Builder} to
     *        create a request. Represents a request to list the existing custom verification email templates for your
     *        account.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListCustomVerificationEmailTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListCustomVerificationEmailTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomVerificationEmailTemplatesPublisher listCustomVerificationEmailTemplatesPaginator(
            Consumer<ListCustomVerificationEmailTemplatesRequest.Builder> listCustomVerificationEmailTemplatesRequest) {
        return listCustomVerificationEmailTemplatesPaginator(ListCustomVerificationEmailTemplatesRequest.builder()
                .applyMutation(listCustomVerificationEmailTemplatesRequest).build());
    }

    /**
     * <p>
     * List all of the dedicated IP pools that exist in your Amazon Web Services account in the current Region.
     * </p>
     *
     * @param listDedicatedIpPoolsRequest
     *        A request to obtain a list of dedicated IP pools.
     * @return A Java Future containing the result of the ListDedicatedIpPools operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListDedicatedIpPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDedicatedIpPools" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDedicatedIpPoolsResponse> listDedicatedIpPools(
            ListDedicatedIpPoolsRequest listDedicatedIpPoolsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all of the dedicated IP pools that exist in your Amazon Web Services account in the current Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDedicatedIpPoolsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDedicatedIpPoolsRequest#builder()}
     * </p>
     *
     * @param listDedicatedIpPoolsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsRequest.Builder} to create a
     *        request. A request to obtain a list of dedicated IP pools.
     * @return A Java Future containing the result of the ListDedicatedIpPools operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListDedicatedIpPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDedicatedIpPools" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDedicatedIpPoolsResponse> listDedicatedIpPools(
            Consumer<ListDedicatedIpPoolsRequest.Builder> listDedicatedIpPoolsRequest) {
        return listDedicatedIpPools(ListDedicatedIpPoolsRequest.builder().applyMutation(listDedicatedIpPoolsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDedicatedIpPools(software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDedicatedIpPoolsPublisher publisher = client.listDedicatedIpPoolsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDedicatedIpPoolsPublisher publisher = client.listDedicatedIpPoolsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDedicatedIpPools(software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDedicatedIpPoolsRequest
     *        A request to obtain a list of dedicated IP pools.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListDedicatedIpPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDedicatedIpPools" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDedicatedIpPoolsPublisher listDedicatedIpPoolsPaginator(ListDedicatedIpPoolsRequest listDedicatedIpPoolsRequest) {
        return new ListDedicatedIpPoolsPublisher(this, listDedicatedIpPoolsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDedicatedIpPools(software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDedicatedIpPoolsPublisher publisher = client.listDedicatedIpPoolsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDedicatedIpPoolsPublisher publisher = client.listDedicatedIpPoolsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDedicatedIpPools(software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDedicatedIpPoolsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDedicatedIpPoolsRequest#builder()}
     * </p>
     *
     * @param listDedicatedIpPoolsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsRequest.Builder} to create a
     *        request. A request to obtain a list of dedicated IP pools.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListDedicatedIpPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDedicatedIpPools" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDedicatedIpPoolsPublisher listDedicatedIpPoolsPaginator(
            Consumer<ListDedicatedIpPoolsRequest.Builder> listDedicatedIpPoolsRequest) {
        return listDedicatedIpPoolsPaginator(ListDedicatedIpPoolsRequest.builder().applyMutation(listDedicatedIpPoolsRequest)
                .build());
    }

    /**
     * <p>
     * Show a list of the predictive inbox placement tests that you've performed, regardless of their statuses. For
     * predictive inbox placement tests that are complete, you can use the <code>GetDeliverabilityTestReport</code>
     * operation to view the results.
     * </p>
     *
     * @param listDeliverabilityTestReportsRequest
     *        A request to list all of the predictive inbox placement tests that you've performed.
     * @return A Java Future containing the result of the ListDeliverabilityTestReports operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListDeliverabilityTestReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDeliverabilityTestReports"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeliverabilityTestReportsResponse> listDeliverabilityTestReports(
            ListDeliverabilityTestReportsRequest listDeliverabilityTestReportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Show a list of the predictive inbox placement tests that you've performed, regardless of their statuses. For
     * predictive inbox placement tests that are complete, you can use the <code>GetDeliverabilityTestReport</code>
     * operation to view the results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeliverabilityTestReportsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDeliverabilityTestReportsRequest#builder()}
     * </p>
     *
     * @param listDeliverabilityTestReportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsRequest.Builder} to create
     *        a request. A request to list all of the predictive inbox placement tests that you've performed.
     * @return A Java Future containing the result of the ListDeliverabilityTestReports operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListDeliverabilityTestReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDeliverabilityTestReports"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeliverabilityTestReportsResponse> listDeliverabilityTestReports(
            Consumer<ListDeliverabilityTestReportsRequest.Builder> listDeliverabilityTestReportsRequest) {
        return listDeliverabilityTestReports(ListDeliverabilityTestReportsRequest.builder()
                .applyMutation(listDeliverabilityTestReportsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDeliverabilityTestReports(software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDeliverabilityTestReportsPublisher publisher = client.listDeliverabilityTestReportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDeliverabilityTestReportsPublisher publisher = client.listDeliverabilityTestReportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeliverabilityTestReports(software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeliverabilityTestReportsRequest
     *        A request to list all of the predictive inbox placement tests that you've performed.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListDeliverabilityTestReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDeliverabilityTestReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeliverabilityTestReportsPublisher listDeliverabilityTestReportsPaginator(
            ListDeliverabilityTestReportsRequest listDeliverabilityTestReportsRequest) {
        return new ListDeliverabilityTestReportsPublisher(this, listDeliverabilityTestReportsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDeliverabilityTestReports(software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDeliverabilityTestReportsPublisher publisher = client.listDeliverabilityTestReportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDeliverabilityTestReportsPublisher publisher = client.listDeliverabilityTestReportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeliverabilityTestReports(software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeliverabilityTestReportsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDeliverabilityTestReportsRequest#builder()}
     * </p>
     *
     * @param listDeliverabilityTestReportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsRequest.Builder} to create
     *        a request. A request to list all of the predictive inbox placement tests that you've performed.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListDeliverabilityTestReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDeliverabilityTestReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeliverabilityTestReportsPublisher listDeliverabilityTestReportsPaginator(
            Consumer<ListDeliverabilityTestReportsRequest.Builder> listDeliverabilityTestReportsRequest) {
        return listDeliverabilityTestReportsPaginator(ListDeliverabilityTestReportsRequest.builder()
                .applyMutation(listDeliverabilityTestReportsRequest).build());
    }

    /**
     * <p>
     * Retrieve deliverability data for all the campaigns that used a specific domain to send email during a specified
     * time range. This data is available for a domain only if you enabled the Deliverability dashboard for the domain.
     * </p>
     *
     * @param listDomainDeliverabilityCampaignsRequest
     *        Retrieve deliverability data for all the campaigns that used a specific domain to send email during a
     *        specified time range. This data is available for a domain only if you enabled the Deliverability
     *        dashboard.
     * @return A Java Future containing the result of the ListDomainDeliverabilityCampaigns operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListDomainDeliverabilityCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDomainDeliverabilityCampaigns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDomainDeliverabilityCampaignsResponse> listDomainDeliverabilityCampaigns(
            ListDomainDeliverabilityCampaignsRequest listDomainDeliverabilityCampaignsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve deliverability data for all the campaigns that used a specific domain to send email during a specified
     * time range. This data is available for a domain only if you enabled the Deliverability dashboard for the domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainDeliverabilityCampaignsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDomainDeliverabilityCampaignsRequest#builder()}
     * </p>
     *
     * @param listDomainDeliverabilityCampaignsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsRequest.Builder} to
     *        create a request. Retrieve deliverability data for all the campaigns that used a specific domain to send
     *        email during a specified time range. This data is available for a domain only if you enabled the
     *        Deliverability dashboard.
     * @return A Java Future containing the result of the ListDomainDeliverabilityCampaigns operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListDomainDeliverabilityCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDomainDeliverabilityCampaigns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDomainDeliverabilityCampaignsResponse> listDomainDeliverabilityCampaigns(
            Consumer<ListDomainDeliverabilityCampaignsRequest.Builder> listDomainDeliverabilityCampaignsRequest) {
        return listDomainDeliverabilityCampaigns(ListDomainDeliverabilityCampaignsRequest.builder()
                .applyMutation(listDomainDeliverabilityCampaignsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDomainDeliverabilityCampaigns(software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDomainDeliverabilityCampaignsPublisher publisher = client.listDomainDeliverabilityCampaignsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDomainDeliverabilityCampaignsPublisher publisher = client.listDomainDeliverabilityCampaignsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomainDeliverabilityCampaigns(software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDomainDeliverabilityCampaignsRequest
     *        Retrieve deliverability data for all the campaigns that used a specific domain to send email during a
     *        specified time range. This data is available for a domain only if you enabled the Deliverability
     *        dashboard.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListDomainDeliverabilityCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDomainDeliverabilityCampaigns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDomainDeliverabilityCampaignsPublisher listDomainDeliverabilityCampaignsPaginator(
            ListDomainDeliverabilityCampaignsRequest listDomainDeliverabilityCampaignsRequest) {
        return new ListDomainDeliverabilityCampaignsPublisher(this, listDomainDeliverabilityCampaignsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDomainDeliverabilityCampaigns(software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDomainDeliverabilityCampaignsPublisher publisher = client.listDomainDeliverabilityCampaignsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDomainDeliverabilityCampaignsPublisher publisher = client.listDomainDeliverabilityCampaignsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomainDeliverabilityCampaigns(software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainDeliverabilityCampaignsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDomainDeliverabilityCampaignsRequest#builder()}
     * </p>
     *
     * @param listDomainDeliverabilityCampaignsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsRequest.Builder} to
     *        create a request. Retrieve deliverability data for all the campaigns that used a specific domain to send
     *        email during a specified time range. This data is available for a domain only if you enabled the
     *        Deliverability dashboard.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListDomainDeliverabilityCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDomainDeliverabilityCampaigns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDomainDeliverabilityCampaignsPublisher listDomainDeliverabilityCampaignsPaginator(
            Consumer<ListDomainDeliverabilityCampaignsRequest.Builder> listDomainDeliverabilityCampaignsRequest) {
        return listDomainDeliverabilityCampaignsPaginator(ListDomainDeliverabilityCampaignsRequest.builder()
                .applyMutation(listDomainDeliverabilityCampaignsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all of the email identities that are associated with your Amazon Web Services account. An
     * identity can be either an email address or a domain. This operation returns identities that are verified as well
     * as those that aren't. This operation returns identities that are associated with Amazon SES and Amazon Pinpoint.
     * </p>
     *
     * @param listEmailIdentitiesRequest
     *        A request to list all of the email identities associated with your Amazon Web Services account. This list
     *        includes identities that you've already verified, identities that are unverified, and identities that were
     *        verified in the past, but are no longer verified.
     * @return A Java Future containing the result of the ListEmailIdentities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListEmailIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListEmailIdentities" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEmailIdentitiesResponse> listEmailIdentities(
            ListEmailIdentitiesRequest listEmailIdentitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all of the email identities that are associated with your Amazon Web Services account. An
     * identity can be either an email address or a domain. This operation returns identities that are verified as well
     * as those that aren't. This operation returns identities that are associated with Amazon SES and Amazon Pinpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEmailIdentitiesRequest.Builder} avoiding the
     * need to create one manually via {@link ListEmailIdentitiesRequest#builder()}
     * </p>
     *
     * @param listEmailIdentitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesRequest.Builder} to create a
     *        request. A request to list all of the email identities associated with your Amazon Web Services account.
     *        This list includes identities that you've already verified, identities that are unverified, and identities
     *        that were verified in the past, but are no longer verified.
     * @return A Java Future containing the result of the ListEmailIdentities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListEmailIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListEmailIdentities" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEmailIdentitiesResponse> listEmailIdentities(
            Consumer<ListEmailIdentitiesRequest.Builder> listEmailIdentitiesRequest) {
        return listEmailIdentities(ListEmailIdentitiesRequest.builder().applyMutation(listEmailIdentitiesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEmailIdentities(software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListEmailIdentitiesPublisher publisher = client.listEmailIdentitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListEmailIdentitiesPublisher publisher = client.listEmailIdentitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEmailIdentities(software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEmailIdentitiesRequest
     *        A request to list all of the email identities associated with your Amazon Web Services account. This list
     *        includes identities that you've already verified, identities that are unverified, and identities that were
     *        verified in the past, but are no longer verified.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListEmailIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListEmailIdentities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEmailIdentitiesPublisher listEmailIdentitiesPaginator(ListEmailIdentitiesRequest listEmailIdentitiesRequest) {
        return new ListEmailIdentitiesPublisher(this, listEmailIdentitiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEmailIdentities(software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListEmailIdentitiesPublisher publisher = client.listEmailIdentitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListEmailIdentitiesPublisher publisher = client.listEmailIdentitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEmailIdentities(software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEmailIdentitiesRequest.Builder} avoiding the
     * need to create one manually via {@link ListEmailIdentitiesRequest#builder()}
     * </p>
     *
     * @param listEmailIdentitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesRequest.Builder} to create a
     *        request. A request to list all of the email identities associated with your Amazon Web Services account.
     *        This list includes identities that you've already verified, identities that are unverified, and identities
     *        that were verified in the past, but are no longer verified.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListEmailIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListEmailIdentities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEmailIdentitiesPublisher listEmailIdentitiesPaginator(
            Consumer<ListEmailIdentitiesRequest.Builder> listEmailIdentitiesRequest) {
        return listEmailIdentitiesPaginator(ListEmailIdentitiesRequest.builder().applyMutation(listEmailIdentitiesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the email templates present in your Amazon SES account in the current Amazon Web Services Region.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param listEmailTemplatesRequest
     *        Represents a request to list the email templates present in your Amazon SES account in the current Amazon
     *        Web Services Region. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the ListEmailTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListEmailTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListEmailTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEmailTemplatesResponse> listEmailTemplates(ListEmailTemplatesRequest listEmailTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the email templates present in your Amazon SES account in the current Amazon Web Services Region.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEmailTemplatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListEmailTemplatesRequest#builder()}
     * </p>
     *
     * @param listEmailTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesRequest.Builder} to create a request.
     *        Represents a request to list the email templates present in your Amazon SES account in the current Amazon
     *        Web Services Region. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the ListEmailTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListEmailTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListEmailTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEmailTemplatesResponse> listEmailTemplates(
            Consumer<ListEmailTemplatesRequest.Builder> listEmailTemplatesRequest) {
        return listEmailTemplates(ListEmailTemplatesRequest.builder().applyMutation(listEmailTemplatesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEmailTemplates(software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListEmailTemplatesPublisher publisher = client.listEmailTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListEmailTemplatesPublisher publisher = client.listEmailTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEmailTemplates(software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesRequest)} operation.</b>
     * </p>
     *
     * @param listEmailTemplatesRequest
     *        Represents a request to list the email templates present in your Amazon SES account in the current Amazon
     *        Web Services Region. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListEmailTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListEmailTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEmailTemplatesPublisher listEmailTemplatesPaginator(ListEmailTemplatesRequest listEmailTemplatesRequest) {
        return new ListEmailTemplatesPublisher(this, listEmailTemplatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEmailTemplates(software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListEmailTemplatesPublisher publisher = client.listEmailTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListEmailTemplatesPublisher publisher = client.listEmailTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEmailTemplates(software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEmailTemplatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListEmailTemplatesRequest#builder()}
     * </p>
     *
     * @param listEmailTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesRequest.Builder} to create a request.
     *        Represents a request to list the email templates present in your Amazon SES account in the current Amazon
     *        Web Services Region. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListEmailTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListEmailTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEmailTemplatesPublisher listEmailTemplatesPaginator(
            Consumer<ListEmailTemplatesRequest.Builder> listEmailTemplatesRequest) {
        return listEmailTemplatesPaginator(ListEmailTemplatesRequest.builder().applyMutation(listEmailTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists all of the export jobs.
     * </p>
     *
     * @param listExportJobsRequest
     *        Represents a request to list all export jobs with filters.
     * @return A Java Future containing the result of the ListExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListExportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExportJobsResponse> listExportJobs(ListExportJobsRequest listExportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the export jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExportJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExportJobsRequest#builder()}
     * </p>
     *
     * @param listExportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListExportJobsRequest.Builder} to create a request.
     *        Represents a request to list all export jobs with filters.
     * @return A Java Future containing the result of the ListExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListExportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExportJobsResponse> listExportJobs(Consumer<ListExportJobsRequest.Builder> listExportJobsRequest) {
        return listExportJobs(ListExportJobsRequest.builder().applyMutation(listExportJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listExportJobs(software.amazon.awssdk.services.sesv2.model.ListExportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListExportJobsPublisher publisher = client.listExportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListExportJobsPublisher publisher = client.listExportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListExportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListExportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExportJobs(software.amazon.awssdk.services.sesv2.model.ListExportJobsRequest)} operation.</b>
     * </p>
     *
     * @param listExportJobsRequest
     *        Represents a request to list all export jobs with filters.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListExportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExportJobsPublisher listExportJobsPaginator(ListExportJobsRequest listExportJobsRequest) {
        return new ListExportJobsPublisher(this, listExportJobsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listExportJobs(software.amazon.awssdk.services.sesv2.model.ListExportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListExportJobsPublisher publisher = client.listExportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListExportJobsPublisher publisher = client.listExportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListExportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListExportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExportJobs(software.amazon.awssdk.services.sesv2.model.ListExportJobsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExportJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExportJobsRequest#builder()}
     * </p>
     *
     * @param listExportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListExportJobsRequest.Builder} to create a request.
     *        Represents a request to list all export jobs with filters.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListExportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExportJobsPublisher listExportJobsPaginator(Consumer<ListExportJobsRequest.Builder> listExportJobsRequest) {
        return listExportJobsPaginator(ListExportJobsRequest.builder().applyMutation(listExportJobsRequest).build());
    }

    /**
     * <p>
     * Lists all of the import jobs.
     * </p>
     *
     * @param listImportJobsRequest
     *        Represents a request to list all of the import jobs for a data destination within the specified maximum
     *        number of import jobs.
     * @return A Java Future containing the result of the ListImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListImportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListImportJobsResponse> listImportJobs(ListImportJobsRequest listImportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the import jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListImportJobsRequest#builder()}
     * </p>
     *
     * @param listImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListImportJobsRequest.Builder} to create a request.
     *        Represents a request to list all of the import jobs for a data destination within the specified maximum
     *        number of import jobs.
     * @return A Java Future containing the result of the ListImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListImportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListImportJobsResponse> listImportJobs(Consumer<ListImportJobsRequest.Builder> listImportJobsRequest) {
        return listImportJobs(ListImportJobsRequest.builder().applyMutation(listImportJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listImportJobs(software.amazon.awssdk.services.sesv2.model.ListImportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListImportJobsPublisher publisher = client.listImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListImportJobsPublisher publisher = client.listImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImportJobs(software.amazon.awssdk.services.sesv2.model.ListImportJobsRequest)} operation.</b>
     * </p>
     *
     * @param listImportJobsRequest
     *        Represents a request to list all of the import jobs for a data destination within the specified maximum
     *        number of import jobs.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListImportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportJobsPublisher listImportJobsPaginator(ListImportJobsRequest listImportJobsRequest) {
        return new ListImportJobsPublisher(this, listImportJobsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listImportJobs(software.amazon.awssdk.services.sesv2.model.ListImportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListImportJobsPublisher publisher = client.listImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListImportJobsPublisher publisher = client.listImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImportJobs(software.amazon.awssdk.services.sesv2.model.ListImportJobsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListImportJobsRequest#builder()}
     * </p>
     *
     * @param listImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListImportJobsRequest.Builder} to create a request.
     *        Represents a request to list all of the import jobs for a data destination within the specified maximum
     *        number of import jobs.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListImportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportJobsPublisher listImportJobsPaginator(Consumer<ListImportJobsRequest.Builder> listImportJobsRequest) {
        return listImportJobsPaginator(ListImportJobsRequest.builder().applyMutation(listImportJobsRequest).build());
    }

    /**
     * <p>
     * List the multi-region endpoints (global-endpoints).
     * </p>
     * <p>
     * Only multi-region endpoints (global-endpoints) whose primary region is the AWS-Region where operation is executed
     * will be listed.
     * </p>
     *
     * @param listMultiRegionEndpointsRequest
     *        Represents a request to list all the multi-region endpoints (global-endpoints) whose primary region is the
     *        AWS-Region where operation is executed.
     * @return A Java Future containing the result of the ListMultiRegionEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListMultiRegionEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListMultiRegionEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMultiRegionEndpointsResponse> listMultiRegionEndpoints(
            ListMultiRegionEndpointsRequest listMultiRegionEndpointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the multi-region endpoints (global-endpoints).
     * </p>
     * <p>
     * Only multi-region endpoints (global-endpoints) whose primary region is the AWS-Region where operation is executed
     * will be listed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMultiRegionEndpointsRequest.Builder} avoiding
     * the need to create one manually via {@link ListMultiRegionEndpointsRequest#builder()}
     * </p>
     *
     * @param listMultiRegionEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListMultiRegionEndpointsRequest.Builder} to create a
     *        request. Represents a request to list all the multi-region endpoints (global-endpoints) whose primary
     *        region is the AWS-Region where operation is executed.
     * @return A Java Future containing the result of the ListMultiRegionEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListMultiRegionEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListMultiRegionEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMultiRegionEndpointsResponse> listMultiRegionEndpoints(
            Consumer<ListMultiRegionEndpointsRequest.Builder> listMultiRegionEndpointsRequest) {
        return listMultiRegionEndpoints(ListMultiRegionEndpointsRequest.builder().applyMutation(listMultiRegionEndpointsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMultiRegionEndpoints(software.amazon.awssdk.services.sesv2.model.ListMultiRegionEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListMultiRegionEndpointsPublisher publisher = client.listMultiRegionEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListMultiRegionEndpointsPublisher publisher = client.listMultiRegionEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListMultiRegionEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListMultiRegionEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMultiRegionEndpoints(software.amazon.awssdk.services.sesv2.model.ListMultiRegionEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMultiRegionEndpointsRequest
     *        Represents a request to list all the multi-region endpoints (global-endpoints) whose primary region is the
     *        AWS-Region where operation is executed.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListMultiRegionEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListMultiRegionEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMultiRegionEndpointsPublisher listMultiRegionEndpointsPaginator(
            ListMultiRegionEndpointsRequest listMultiRegionEndpointsRequest) {
        return new ListMultiRegionEndpointsPublisher(this, listMultiRegionEndpointsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMultiRegionEndpoints(software.amazon.awssdk.services.sesv2.model.ListMultiRegionEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListMultiRegionEndpointsPublisher publisher = client.listMultiRegionEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListMultiRegionEndpointsPublisher publisher = client.listMultiRegionEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListMultiRegionEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListMultiRegionEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMultiRegionEndpoints(software.amazon.awssdk.services.sesv2.model.ListMultiRegionEndpointsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMultiRegionEndpointsRequest.Builder} avoiding
     * the need to create one manually via {@link ListMultiRegionEndpointsRequest#builder()}
     * </p>
     *
     * @param listMultiRegionEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListMultiRegionEndpointsRequest.Builder} to create a
     *        request. Represents a request to list all the multi-region endpoints (global-endpoints) whose primary
     *        region is the AWS-Region where operation is executed.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListMultiRegionEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListMultiRegionEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMultiRegionEndpointsPublisher listMultiRegionEndpointsPaginator(
            Consumer<ListMultiRegionEndpointsRequest.Builder> listMultiRegionEndpointsRequest) {
        return listMultiRegionEndpointsPaginator(ListMultiRegionEndpointsRequest.builder()
                .applyMutation(listMultiRegionEndpointsRequest).build());
    }

    /**
     * <p>
     * Lists the recommendations present in your Amazon SES account in the current Amazon Web Services Region.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param listRecommendationsRequest
     *        Represents a request to list the existing recommendations for your account.
     * @return A Java Future containing the result of the ListRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListRecommendations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRecommendationsResponse> listRecommendations(
            ListRecommendationsRequest listRecommendationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the recommendations present in your Amazon SES account in the current Amazon Web Services Region.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecommendationsRequest#builder()}
     * </p>
     *
     * @param listRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListRecommendationsRequest.Builder} to create a
     *        request. Represents a request to list the existing recommendations for your account.
     * @return A Java Future containing the result of the ListRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListRecommendations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRecommendationsResponse> listRecommendations(
            Consumer<ListRecommendationsRequest.Builder> listRecommendationsRequest) {
        return listRecommendations(ListRecommendationsRequest.builder().applyMutation(listRecommendationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecommendations(software.amazon.awssdk.services.sesv2.model.ListRecommendationsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListRecommendationsPublisher publisher = client.listRecommendationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListRecommendationsPublisher publisher = client.listRecommendationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListRecommendationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListRecommendationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendations(software.amazon.awssdk.services.sesv2.model.ListRecommendationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecommendationsRequest
     *        Represents a request to list the existing recommendations for your account.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListRecommendations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRecommendationsPublisher listRecommendationsPaginator(ListRecommendationsRequest listRecommendationsRequest) {
        return new ListRecommendationsPublisher(this, listRecommendationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecommendations(software.amazon.awssdk.services.sesv2.model.ListRecommendationsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListRecommendationsPublisher publisher = client.listRecommendationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListRecommendationsPublisher publisher = client.listRecommendationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListRecommendationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListRecommendationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendations(software.amazon.awssdk.services.sesv2.model.ListRecommendationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecommendationsRequest#builder()}
     * </p>
     *
     * @param listRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListRecommendationsRequest.Builder} to create a
     *        request. Represents a request to list the existing recommendations for your account.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListRecommendations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRecommendationsPublisher listRecommendationsPaginator(
            Consumer<ListRecommendationsRequest.Builder> listRecommendationsRequest) {
        return listRecommendationsPaginator(ListRecommendationsRequest.builder().applyMutation(listRecommendationsRequest)
                .build());
    }

    /**
     * <p>
     * List reputation entities in your Amazon SES account in the current Amazon Web Services Region. You can filter the
     * results by entity type, reputation impact, sending status, or entity reference prefix.
     * </p>
     * <p>
     * <i>Reputation entities</i> represent resources in your account that have reputation tracking and management
     * capabilities. Use this operation to get an overview of all entities and their current reputation status.
     * </p>
     *
     * @param listReputationEntitiesRequest
     *        Represents a request to list reputation entities with optional filtering.
     * @return A Java Future containing the result of the ListReputationEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListReputationEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListReputationEntities" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListReputationEntitiesResponse> listReputationEntities(
            ListReputationEntitiesRequest listReputationEntitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List reputation entities in your Amazon SES account in the current Amazon Web Services Region. You can filter the
     * results by entity type, reputation impact, sending status, or entity reference prefix.
     * </p>
     * <p>
     * <i>Reputation entities</i> represent resources in your account that have reputation tracking and management
     * capabilities. Use this operation to get an overview of all entities and their current reputation status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReputationEntitiesRequest.Builder} avoiding the
     * need to create one manually via {@link ListReputationEntitiesRequest#builder()}
     * </p>
     *
     * @param listReputationEntitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListReputationEntitiesRequest.Builder} to create a
     *        request. Represents a request to list reputation entities with optional filtering.
     * @return A Java Future containing the result of the ListReputationEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListReputationEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListReputationEntities" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListReputationEntitiesResponse> listReputationEntities(
            Consumer<ListReputationEntitiesRequest.Builder> listReputationEntitiesRequest) {
        return listReputationEntities(ListReputationEntitiesRequest.builder().applyMutation(listReputationEntitiesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReputationEntities(software.amazon.awssdk.services.sesv2.model.ListReputationEntitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListReputationEntitiesPublisher publisher = client.listReputationEntitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListReputationEntitiesPublisher publisher = client.listReputationEntitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListReputationEntitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListReputationEntitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReputationEntities(software.amazon.awssdk.services.sesv2.model.ListReputationEntitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listReputationEntitiesRequest
     *        Represents a request to list reputation entities with optional filtering.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListReputationEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListReputationEntities" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReputationEntitiesPublisher listReputationEntitiesPaginator(
            ListReputationEntitiesRequest listReputationEntitiesRequest) {
        return new ListReputationEntitiesPublisher(this, listReputationEntitiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReputationEntities(software.amazon.awssdk.services.sesv2.model.ListReputationEntitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListReputationEntitiesPublisher publisher = client.listReputationEntitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListReputationEntitiesPublisher publisher = client.listReputationEntitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListReputationEntitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListReputationEntitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReputationEntities(software.amazon.awssdk.services.sesv2.model.ListReputationEntitiesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReputationEntitiesRequest.Builder} avoiding the
     * need to create one manually via {@link ListReputationEntitiesRequest#builder()}
     * </p>
     *
     * @param listReputationEntitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListReputationEntitiesRequest.Builder} to create a
     *        request. Represents a request to list reputation entities with optional filtering.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListReputationEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListReputationEntities" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReputationEntitiesPublisher listReputationEntitiesPaginator(
            Consumer<ListReputationEntitiesRequest.Builder> listReputationEntitiesRequest) {
        return listReputationEntitiesPaginator(ListReputationEntitiesRequest.builder()
                .applyMutation(listReputationEntitiesRequest).build());
    }

    /**
     * <p>
     * List all tenants associated with a specific resource.
     * </p>
     * <p>
     * This operation returns a list of tenants that are associated with the specified resource. This is useful for
     * understanding which tenants are currently using a particular resource such as an email identity, configuration
     * set, or email template.
     * </p>
     *
     * @param listResourceTenantsRequest
     *        Represents a request to list tenants associated with a specific resource.
     * @return A Java Future containing the result of the ListResourceTenants operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListResourceTenants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListResourceTenants" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListResourceTenantsResponse> listResourceTenants(
            ListResourceTenantsRequest listResourceTenantsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all tenants associated with a specific resource.
     * </p>
     * <p>
     * This operation returns a list of tenants that are associated with the specified resource. This is useful for
     * understanding which tenants are currently using a particular resource such as an email identity, configuration
     * set, or email template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceTenantsRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourceTenantsRequest#builder()}
     * </p>
     *
     * @param listResourceTenantsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListResourceTenantsRequest.Builder} to create a
     *        request. Represents a request to list tenants associated with a specific resource.
     * @return A Java Future containing the result of the ListResourceTenants operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListResourceTenants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListResourceTenants" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListResourceTenantsResponse> listResourceTenants(
            Consumer<ListResourceTenantsRequest.Builder> listResourceTenantsRequest) {
        return listResourceTenants(ListResourceTenantsRequest.builder().applyMutation(listResourceTenantsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceTenants(software.amazon.awssdk.services.sesv2.model.ListResourceTenantsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListResourceTenantsPublisher publisher = client.listResourceTenantsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListResourceTenantsPublisher publisher = client.listResourceTenantsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListResourceTenantsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListResourceTenantsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceTenants(software.amazon.awssdk.services.sesv2.model.ListResourceTenantsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceTenantsRequest
     *        Represents a request to list tenants associated with a specific resource.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListResourceTenants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListResourceTenants" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourceTenantsPublisher listResourceTenantsPaginator(ListResourceTenantsRequest listResourceTenantsRequest) {
        return new ListResourceTenantsPublisher(this, listResourceTenantsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceTenants(software.amazon.awssdk.services.sesv2.model.ListResourceTenantsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListResourceTenantsPublisher publisher = client.listResourceTenantsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListResourceTenantsPublisher publisher = client.listResourceTenantsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListResourceTenantsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListResourceTenantsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceTenants(software.amazon.awssdk.services.sesv2.model.ListResourceTenantsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceTenantsRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourceTenantsRequest#builder()}
     * </p>
     *
     * @param listResourceTenantsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListResourceTenantsRequest.Builder} to create a
     *        request. Represents a request to list tenants associated with a specific resource.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListResourceTenants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListResourceTenants" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourceTenantsPublisher listResourceTenantsPaginator(
            Consumer<ListResourceTenantsRequest.Builder> listResourceTenantsRequest) {
        return listResourceTenantsPaginator(ListResourceTenantsRequest.builder().applyMutation(listResourceTenantsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of email addresses that are on the suppression list for your account.
     * </p>
     *
     * @param listSuppressedDestinationsRequest
     *        A request to obtain a list of email destinations that are on the suppression list for your account.
     * @return A Java Future containing the result of the ListSuppressedDestinations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>InvalidNextTokenException The specified request includes an invalid or expired token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListSuppressedDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListSuppressedDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSuppressedDestinationsResponse> listSuppressedDestinations(
            ListSuppressedDestinationsRequest listSuppressedDestinationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of email addresses that are on the suppression list for your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSuppressedDestinationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSuppressedDestinationsRequest#builder()}
     * </p>
     *
     * @param listSuppressedDestinationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsRequest.Builder} to create a
     *        request. A request to obtain a list of email destinations that are on the suppression list for your
     *        account.
     * @return A Java Future containing the result of the ListSuppressedDestinations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>InvalidNextTokenException The specified request includes an invalid or expired token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListSuppressedDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListSuppressedDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSuppressedDestinationsResponse> listSuppressedDestinations(
            Consumer<ListSuppressedDestinationsRequest.Builder> listSuppressedDestinationsRequest) {
        return listSuppressedDestinations(ListSuppressedDestinationsRequest.builder()
                .applyMutation(listSuppressedDestinationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSuppressedDestinations(software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListSuppressedDestinationsPublisher publisher = client.listSuppressedDestinationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListSuppressedDestinationsPublisher publisher = client.listSuppressedDestinationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSuppressedDestinations(software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSuppressedDestinationsRequest
     *        A request to obtain a list of email destinations that are on the suppression list for your account.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>InvalidNextTokenException The specified request includes an invalid or expired token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListSuppressedDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListSuppressedDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSuppressedDestinationsPublisher listSuppressedDestinationsPaginator(
            ListSuppressedDestinationsRequest listSuppressedDestinationsRequest) {
        return new ListSuppressedDestinationsPublisher(this, listSuppressedDestinationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSuppressedDestinations(software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListSuppressedDestinationsPublisher publisher = client.listSuppressedDestinationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListSuppressedDestinationsPublisher publisher = client.listSuppressedDestinationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSuppressedDestinations(software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSuppressedDestinationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSuppressedDestinationsRequest#builder()}
     * </p>
     *
     * @param listSuppressedDestinationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsRequest.Builder} to create a
     *        request. A request to obtain a list of email destinations that are on the suppression list for your
     *        account.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>InvalidNextTokenException The specified request includes an invalid or expired token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListSuppressedDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListSuppressedDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSuppressedDestinationsPublisher listSuppressedDestinationsPaginator(
            Consumer<ListSuppressedDestinationsRequest.Builder> listSuppressedDestinationsRequest) {
        return listSuppressedDestinationsPaginator(ListSuppressedDestinationsRequest.builder()
                .applyMutation(listSuppressedDestinationsRequest).build());
    }

    /**
     * <p>
     * Retrieve a list of the tags (keys and values) that are associated with a specified resource. A <i>tag</i> is a
     * label that you optionally define and associate with a resource. Each tag consists of a required <i>tag
     * key</i> and an optional associated <i>tag value</i>. A tag key is a general label that acts as a category for
     * more specific tag values. A tag value acts as a descriptor within a tag key.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve a list of the tags (keys and values) that are associated with a specified resource. A <i>tag</i> is a
     * label that you optionally define and associate with a resource. Each tag consists of a required <i>tag
     * key</i> and an optional associated <i>tag value</i>. A tag key is a general label that acts as a category for
     * more specific tag values. A tag value acts as a descriptor within a tag key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * List all resources associated with a specific tenant.
     * </p>
     * <p>
     * This operation returns a list of resources (email identities, configuration sets, or email templates) that are
     * associated with the specified tenant. You can optionally filter the results by resource type.
     * </p>
     *
     * @param listTenantResourcesRequest
     *        Represents a request to list resources associated with a specific tenant.
     * @return A Java Future containing the result of the ListTenantResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListTenantResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListTenantResources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTenantResourcesResponse> listTenantResources(
            ListTenantResourcesRequest listTenantResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all resources associated with a specific tenant.
     * </p>
     * <p>
     * This operation returns a list of resources (email identities, configuration sets, or email templates) that are
     * associated with the specified tenant. You can optionally filter the results by resource type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTenantResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListTenantResourcesRequest#builder()}
     * </p>
     *
     * @param listTenantResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListTenantResourcesRequest.Builder} to create a
     *        request. Represents a request to list resources associated with a specific tenant.
     * @return A Java Future containing the result of the ListTenantResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListTenantResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListTenantResources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTenantResourcesResponse> listTenantResources(
            Consumer<ListTenantResourcesRequest.Builder> listTenantResourcesRequest) {
        return listTenantResources(ListTenantResourcesRequest.builder().applyMutation(listTenantResourcesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTenantResources(software.amazon.awssdk.services.sesv2.model.ListTenantResourcesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListTenantResourcesPublisher publisher = client.listTenantResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListTenantResourcesPublisher publisher = client.listTenantResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListTenantResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListTenantResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTenantResources(software.amazon.awssdk.services.sesv2.model.ListTenantResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTenantResourcesRequest
     *        Represents a request to list resources associated with a specific tenant.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListTenantResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListTenantResources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTenantResourcesPublisher listTenantResourcesPaginator(ListTenantResourcesRequest listTenantResourcesRequest) {
        return new ListTenantResourcesPublisher(this, listTenantResourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTenantResources(software.amazon.awssdk.services.sesv2.model.ListTenantResourcesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListTenantResourcesPublisher publisher = client.listTenantResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListTenantResourcesPublisher publisher = client.listTenantResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListTenantResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListTenantResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTenantResources(software.amazon.awssdk.services.sesv2.model.ListTenantResourcesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTenantResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListTenantResourcesRequest#builder()}
     * </p>
     *
     * @param listTenantResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListTenantResourcesRequest.Builder} to create a
     *        request. Represents a request to list resources associated with a specific tenant.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListTenantResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListTenantResources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTenantResourcesPublisher listTenantResourcesPaginator(
            Consumer<ListTenantResourcesRequest.Builder> listTenantResourcesRequest) {
        return listTenantResourcesPaginator(ListTenantResourcesRequest.builder().applyMutation(listTenantResourcesRequest)
                .build());
    }

    /**
     * <p>
     * List all tenants associated with your account in the current Amazon Web Services Region.
     * </p>
     * <p>
     * This operation returns basic information about each tenant, such as tenant name, ID, ARN, and creation timestamp.
     * </p>
     *
     * @param listTenantsRequest
     *        Represents a request to list all tenants associated with your account in the current Amazon Web Services
     *        Region.
     * @return A Java Future containing the result of the ListTenants operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListTenants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListTenants" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTenantsResponse> listTenants(ListTenantsRequest listTenantsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all tenants associated with your account in the current Amazon Web Services Region.
     * </p>
     * <p>
     * This operation returns basic information about each tenant, such as tenant name, ID, ARN, and creation timestamp.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTenantsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTenantsRequest#builder()}
     * </p>
     *
     * @param listTenantsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListTenantsRequest.Builder} to create a request.
     *        Represents a request to list all tenants associated with your account in the current Amazon Web Services
     *        Region.
     * @return A Java Future containing the result of the ListTenants operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListTenants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListTenants" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTenantsResponse> listTenants(Consumer<ListTenantsRequest.Builder> listTenantsRequest) {
        return listTenants(ListTenantsRequest.builder().applyMutation(listTenantsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listTenants(software.amazon.awssdk.services.sesv2.model.ListTenantsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListTenantsPublisher publisher = client.listTenantsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListTenantsPublisher publisher = client.listTenantsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListTenantsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListTenantsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTenants(software.amazon.awssdk.services.sesv2.model.ListTenantsRequest)} operation.</b>
     * </p>
     *
     * @param listTenantsRequest
     *        Represents a request to list all tenants associated with your account in the current Amazon Web Services
     *        Region.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListTenants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListTenants" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTenantsPublisher listTenantsPaginator(ListTenantsRequest listTenantsRequest) {
        return new ListTenantsPublisher(this, listTenantsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listTenants(software.amazon.awssdk.services.sesv2.model.ListTenantsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListTenantsPublisher publisher = client.listTenantsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListTenantsPublisher publisher = client.listTenantsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListTenantsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListTenantsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTenants(software.amazon.awssdk.services.sesv2.model.ListTenantsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTenantsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTenantsRequest#builder()}
     * </p>
     *
     * @param listTenantsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListTenantsRequest.Builder} to create a request.
     *        Represents a request to list all tenants associated with your account in the current Amazon Web Services
     *        Region.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListTenants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListTenants" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTenantsPublisher listTenantsPaginator(Consumer<ListTenantsRequest.Builder> listTenantsRequest) {
        return listTenantsPaginator(ListTenantsRequest.builder().applyMutation(listTenantsRequest).build());
    }

    /**
     * <p>
     * Enable or disable the automatic warm-up feature for dedicated IP addresses.
     * </p>
     *
     * @param putAccountDedicatedIpWarmupAttributesRequest
     *        A request to enable or disable the automatic IP address warm-up feature.
     * @return A Java Future containing the result of the PutAccountDedicatedIpWarmupAttributes operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutAccountDedicatedIpWarmupAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountDedicatedIpWarmupAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutAccountDedicatedIpWarmupAttributesResponse> putAccountDedicatedIpWarmupAttributes(
            PutAccountDedicatedIpWarmupAttributesRequest putAccountDedicatedIpWarmupAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enable or disable the automatic warm-up feature for dedicated IP addresses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutAccountDedicatedIpWarmupAttributesRequest.Builder} avoiding the need to create one manually via
     * {@link PutAccountDedicatedIpWarmupAttributesRequest#builder()}
     * </p>
     *
     * @param putAccountDedicatedIpWarmupAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutAccountDedicatedIpWarmupAttributesRequest.Builder}
     *        to create a request. A request to enable or disable the automatic IP address warm-up feature.
     * @return A Java Future containing the result of the PutAccountDedicatedIpWarmupAttributes operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutAccountDedicatedIpWarmupAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountDedicatedIpWarmupAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutAccountDedicatedIpWarmupAttributesResponse> putAccountDedicatedIpWarmupAttributes(
            Consumer<PutAccountDedicatedIpWarmupAttributesRequest.Builder> putAccountDedicatedIpWarmupAttributesRequest) {
        return putAccountDedicatedIpWarmupAttributes(PutAccountDedicatedIpWarmupAttributesRequest.builder()
                .applyMutation(putAccountDedicatedIpWarmupAttributesRequest).build());
    }

    /**
     * <p>
     * Update your Amazon SES account details.
     * </p>
     *
     * @param putAccountDetailsRequest
     *        A request to submit new account details.
     * @return A Java Future containing the result of the PutAccountDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConflictException If there is already an ongoing account details update under review.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutAccountDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountDetails" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutAccountDetailsResponse> putAccountDetails(PutAccountDetailsRequest putAccountDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update your Amazon SES account details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAccountDetailsRequest.Builder} avoiding the need
     * to create one manually via {@link PutAccountDetailsRequest#builder()}
     * </p>
     *
     * @param putAccountDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutAccountDetailsRequest.Builder} to create a request.
     *        A request to submit new account details.
     * @return A Java Future containing the result of the PutAccountDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConflictException If there is already an ongoing account details update under review.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutAccountDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountDetails" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutAccountDetailsResponse> putAccountDetails(
            Consumer<PutAccountDetailsRequest.Builder> putAccountDetailsRequest) {
        return putAccountDetails(PutAccountDetailsRequest.builder().applyMutation(putAccountDetailsRequest).build());
    }

    /**
     * <p>
     * Enable or disable the ability of your account to send email.
     * </p>
     *
     * @param putAccountSendingAttributesRequest
     *        A request to change the ability of your account to send email.
     * @return A Java Future containing the result of the PutAccountSendingAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutAccountSendingAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountSendingAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutAccountSendingAttributesResponse> putAccountSendingAttributes(
            PutAccountSendingAttributesRequest putAccountSendingAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enable or disable the ability of your account to send email.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAccountSendingAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link PutAccountSendingAttributesRequest#builder()}
     * </p>
     *
     * @param putAccountSendingAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutAccountSendingAttributesRequest.Builder} to create a
     *        request. A request to change the ability of your account to send email.
     * @return A Java Future containing the result of the PutAccountSendingAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutAccountSendingAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountSendingAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutAccountSendingAttributesResponse> putAccountSendingAttributes(
            Consumer<PutAccountSendingAttributesRequest.Builder> putAccountSendingAttributesRequest) {
        return putAccountSendingAttributes(PutAccountSendingAttributesRequest.builder()
                .applyMutation(putAccountSendingAttributesRequest).build());
    }

    /**
     * <p>
     * Change the settings for the account-level suppression list.
     * </p>
     *
     * @param putAccountSuppressionAttributesRequest
     *        A request to change your account's suppression preferences.
     * @return A Java Future containing the result of the PutAccountSuppressionAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutAccountSuppressionAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountSuppressionAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutAccountSuppressionAttributesResponse> putAccountSuppressionAttributes(
            PutAccountSuppressionAttributesRequest putAccountSuppressionAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Change the settings for the account-level suppression list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAccountSuppressionAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link PutAccountSuppressionAttributesRequest#builder()}
     * </p>
     *
     * @param putAccountSuppressionAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutAccountSuppressionAttributesRequest.Builder} to
     *        create a request. A request to change your account's suppression preferences.
     * @return A Java Future containing the result of the PutAccountSuppressionAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutAccountSuppressionAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountSuppressionAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutAccountSuppressionAttributesResponse> putAccountSuppressionAttributes(
            Consumer<PutAccountSuppressionAttributesRequest.Builder> putAccountSuppressionAttributesRequest) {
        return putAccountSuppressionAttributes(PutAccountSuppressionAttributesRequest.builder()
                .applyMutation(putAccountSuppressionAttributesRequest).build());
    }

    /**
     * <p>
     * Update your Amazon SES account VDM attributes.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param putAccountVdmAttributesRequest
     *        A request to submit new account VDM attributes.
     * @return A Java Future containing the result of the PutAccountVdmAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutAccountVdmAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountVdmAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutAccountVdmAttributesResponse> putAccountVdmAttributes(
            PutAccountVdmAttributesRequest putAccountVdmAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update your Amazon SES account VDM attributes.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAccountVdmAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link PutAccountVdmAttributesRequest#builder()}
     * </p>
     *
     * @param putAccountVdmAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutAccountVdmAttributesRequest.Builder} to create a
     *        request. A request to submit new account VDM attributes.
     * @return A Java Future containing the result of the PutAccountVdmAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutAccountVdmAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountVdmAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutAccountVdmAttributesResponse> putAccountVdmAttributes(
            Consumer<PutAccountVdmAttributesRequest.Builder> putAccountVdmAttributesRequest) {
        return putAccountVdmAttributes(PutAccountVdmAttributesRequest.builder().applyMutation(putAccountVdmAttributesRequest)
                .build());
    }

    /**
     * <p>
     * Associate the configuration set with a MailManager archive. When you send email using the <code>SendEmail</code>
     * or <code>SendBulkEmail</code> operations the message as it will be given to the receiving SMTP server will be
     * archived, along with the recipient information.
     * </p>
     *
     * @param putConfigurationSetArchivingOptionsRequest
     *        A request to associate a configuration set with a MailManager archive.
     * @return A Java Future containing the result of the PutConfigurationSetArchivingOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutConfigurationSetArchivingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetArchivingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationSetArchivingOptionsResponse> putConfigurationSetArchivingOptions(
            PutConfigurationSetArchivingOptionsRequest putConfigurationSetArchivingOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate the configuration set with a MailManager archive. When you send email using the <code>SendEmail</code>
     * or <code>SendBulkEmail</code> operations the message as it will be given to the receiving SMTP server will be
     * archived, along with the recipient information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConfigurationSetArchivingOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link PutConfigurationSetArchivingOptionsRequest#builder()}
     * </p>
     *
     * @param putConfigurationSetArchivingOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutConfigurationSetArchivingOptionsRequest.Builder} to
     *        create a request. A request to associate a configuration set with a MailManager archive.
     * @return A Java Future containing the result of the PutConfigurationSetArchivingOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutConfigurationSetArchivingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetArchivingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationSetArchivingOptionsResponse> putConfigurationSetArchivingOptions(
            Consumer<PutConfigurationSetArchivingOptionsRequest.Builder> putConfigurationSetArchivingOptionsRequest) {
        return putConfigurationSetArchivingOptions(PutConfigurationSetArchivingOptionsRequest.builder()
                .applyMutation(putConfigurationSetArchivingOptionsRequest).build());
    }

    /**
     * <p>
     * Associate a configuration set with a dedicated IP pool. You can use dedicated IP pools to create groups of
     * dedicated IP addresses for sending specific types of email.
     * </p>
     *
     * @param putConfigurationSetDeliveryOptionsRequest
     *        A request to associate a configuration set with a dedicated IP pool.
     * @return A Java Future containing the result of the PutConfigurationSetDeliveryOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutConfigurationSetDeliveryOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetDeliveryOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationSetDeliveryOptionsResponse> putConfigurationSetDeliveryOptions(
            PutConfigurationSetDeliveryOptionsRequest putConfigurationSetDeliveryOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate a configuration set with a dedicated IP pool. You can use dedicated IP pools to create groups of
     * dedicated IP addresses for sending specific types of email.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConfigurationSetDeliveryOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link PutConfigurationSetDeliveryOptionsRequest#builder()}
     * </p>
     *
     * @param putConfigurationSetDeliveryOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutConfigurationSetDeliveryOptionsRequest.Builder} to
     *        create a request. A request to associate a configuration set with a dedicated IP pool.
     * @return A Java Future containing the result of the PutConfigurationSetDeliveryOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutConfigurationSetDeliveryOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetDeliveryOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationSetDeliveryOptionsResponse> putConfigurationSetDeliveryOptions(
            Consumer<PutConfigurationSetDeliveryOptionsRequest.Builder> putConfigurationSetDeliveryOptionsRequest) {
        return putConfigurationSetDeliveryOptions(PutConfigurationSetDeliveryOptionsRequest.builder()
                .applyMutation(putConfigurationSetDeliveryOptionsRequest).build());
    }

    /**
     * <p>
     * Enable or disable collection of reputation metrics for emails that you send using a particular configuration set
     * in a specific Amazon Web Services Region.
     * </p>
     *
     * @param putConfigurationSetReputationOptionsRequest
     *        A request to enable or disable tracking of reputation metrics for a configuration set.
     * @return A Java Future containing the result of the PutConfigurationSetReputationOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutConfigurationSetReputationOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetReputationOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationSetReputationOptionsResponse> putConfigurationSetReputationOptions(
            PutConfigurationSetReputationOptionsRequest putConfigurationSetReputationOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enable or disable collection of reputation metrics for emails that you send using a particular configuration set
     * in a specific Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutConfigurationSetReputationOptionsRequest.Builder} avoiding the need to create one manually via
     * {@link PutConfigurationSetReputationOptionsRequest#builder()}
     * </p>
     *
     * @param putConfigurationSetReputationOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutConfigurationSetReputationOptionsRequest.Builder} to
     *        create a request. A request to enable or disable tracking of reputation metrics for a configuration set.
     * @return A Java Future containing the result of the PutConfigurationSetReputationOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutConfigurationSetReputationOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetReputationOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationSetReputationOptionsResponse> putConfigurationSetReputationOptions(
            Consumer<PutConfigurationSetReputationOptionsRequest.Builder> putConfigurationSetReputationOptionsRequest) {
        return putConfigurationSetReputationOptions(PutConfigurationSetReputationOptionsRequest.builder()
                .applyMutation(putConfigurationSetReputationOptionsRequest).build());
    }

    /**
     * <p>
     * Enable or disable email sending for messages that use a particular configuration set in a specific Amazon Web
     * Services Region.
     * </p>
     *
     * @param putConfigurationSetSendingOptionsRequest
     *        A request to enable or disable the ability of Amazon SES to send emails that use a specific configuration
     *        set.
     * @return A Java Future containing the result of the PutConfigurationSetSendingOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutConfigurationSetSendingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetSendingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationSetSendingOptionsResponse> putConfigurationSetSendingOptions(
            PutConfigurationSetSendingOptionsRequest putConfigurationSetSendingOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enable or disable email sending for messages that use a particular configuration set in a specific Amazon Web
     * Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConfigurationSetSendingOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link PutConfigurationSetSendingOptionsRequest#builder()}
     * </p>
     *
     * @param putConfigurationSetSendingOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSendingOptionsRequest.Builder} to
     *        create a request. A request to enable or disable the ability of Amazon SES to send emails that use a
     *        specific configuration set.
     * @return A Java Future containing the result of the PutConfigurationSetSendingOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutConfigurationSetSendingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetSendingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationSetSendingOptionsResponse> putConfigurationSetSendingOptions(
            Consumer<PutConfigurationSetSendingOptionsRequest.Builder> putConfigurationSetSendingOptionsRequest) {
        return putConfigurationSetSendingOptions(PutConfigurationSetSendingOptionsRequest.builder()
                .applyMutation(putConfigurationSetSendingOptionsRequest).build());
    }

    /**
     * <p>
     * Specify the account suppression list preferences for a configuration set.
     * </p>
     *
     * @param putConfigurationSetSuppressionOptionsRequest
     *        A request to change the account suppression list preferences for a specific configuration set.
     * @return A Java Future containing the result of the PutConfigurationSetSuppressionOptions operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutConfigurationSetSuppressionOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetSuppressionOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationSetSuppressionOptionsResponse> putConfigurationSetSuppressionOptions(
            PutConfigurationSetSuppressionOptionsRequest putConfigurationSetSuppressionOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specify the account suppression list preferences for a configuration set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutConfigurationSetSuppressionOptionsRequest.Builder} avoiding the need to create one manually via
     * {@link PutConfigurationSetSuppressionOptionsRequest#builder()}
     * </p>
     *
     * @param putConfigurationSetSuppressionOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSuppressionOptionsRequest.Builder}
     *        to create a request. A request to change the account suppression list preferences for a specific
     *        configuration set.
     * @return A Java Future containing the result of the PutConfigurationSetSuppressionOptions operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutConfigurationSetSuppressionOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetSuppressionOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationSetSuppressionOptionsResponse> putConfigurationSetSuppressionOptions(
            Consumer<PutConfigurationSetSuppressionOptionsRequest.Builder> putConfigurationSetSuppressionOptionsRequest) {
        return putConfigurationSetSuppressionOptions(PutConfigurationSetSuppressionOptionsRequest.builder()
                .applyMutation(putConfigurationSetSuppressionOptionsRequest).build());
    }

    /**
     * <p>
     * Specify a custom domain to use for open and click tracking elements in email that you send.
     * </p>
     *
     * @param putConfigurationSetTrackingOptionsRequest
     *        A request to add a custom domain for tracking open and click events to a configuration set.
     * @return A Java Future containing the result of the PutConfigurationSetTrackingOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutConfigurationSetTrackingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetTrackingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationSetTrackingOptionsResponse> putConfigurationSetTrackingOptions(
            PutConfigurationSetTrackingOptionsRequest putConfigurationSetTrackingOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specify a custom domain to use for open and click tracking elements in email that you send.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConfigurationSetTrackingOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link PutConfigurationSetTrackingOptionsRequest#builder()}
     * </p>
     *
     * @param putConfigurationSetTrackingOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutConfigurationSetTrackingOptionsRequest.Builder} to
     *        create a request. A request to add a custom domain for tracking open and click events to a configuration
     *        set.
     * @return A Java Future containing the result of the PutConfigurationSetTrackingOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutConfigurationSetTrackingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetTrackingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationSetTrackingOptionsResponse> putConfigurationSetTrackingOptions(
            Consumer<PutConfigurationSetTrackingOptionsRequest.Builder> putConfigurationSetTrackingOptionsRequest) {
        return putConfigurationSetTrackingOptions(PutConfigurationSetTrackingOptionsRequest.builder()
                .applyMutation(putConfigurationSetTrackingOptionsRequest).build());
    }

    /**
     * <p>
     * Specify VDM preferences for email that you send using the configuration set.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param putConfigurationSetVdmOptionsRequest
     *        A request to add specific VDM settings to a configuration set.
     * @return A Java Future containing the result of the PutConfigurationSetVdmOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutConfigurationSetVdmOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetVdmOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationSetVdmOptionsResponse> putConfigurationSetVdmOptions(
            PutConfigurationSetVdmOptionsRequest putConfigurationSetVdmOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specify VDM preferences for email that you send using the configuration set.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConfigurationSetVdmOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link PutConfigurationSetVdmOptionsRequest#builder()}
     * </p>
     *
     * @param putConfigurationSetVdmOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutConfigurationSetVdmOptionsRequest.Builder} to create
     *        a request. A request to add specific VDM settings to a configuration set.
     * @return A Java Future containing the result of the PutConfigurationSetVdmOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutConfigurationSetVdmOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetVdmOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationSetVdmOptionsResponse> putConfigurationSetVdmOptions(
            Consumer<PutConfigurationSetVdmOptionsRequest.Builder> putConfigurationSetVdmOptionsRequest) {
        return putConfigurationSetVdmOptions(PutConfigurationSetVdmOptionsRequest.builder()
                .applyMutation(putConfigurationSetVdmOptionsRequest).build());
    }

    /**
     * <p>
     * Move a dedicated IP address to an existing dedicated IP pool.
     * </p>
     * <note>
     * <p>
     * The dedicated IP address that you specify must already exist, and must be associated with your Amazon Web
     * Services account.
     * </p>
     * <p>
     * The dedicated IP pool you specify must already exist. You can create a new pool by using the
     * <code>CreateDedicatedIpPool</code> operation.
     * </p>
     * </note>
     *
     * @param putDedicatedIpInPoolRequest
     *        A request to move a dedicated IP address to a dedicated IP pool.
     * @return A Java Future containing the result of the PutDedicatedIpInPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutDedicatedIpInPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDedicatedIpInPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutDedicatedIpInPoolResponse> putDedicatedIpInPool(
            PutDedicatedIpInPoolRequest putDedicatedIpInPoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Move a dedicated IP address to an existing dedicated IP pool.
     * </p>
     * <note>
     * <p>
     * The dedicated IP address that you specify must already exist, and must be associated with your Amazon Web
     * Services account.
     * </p>
     * <p>
     * The dedicated IP pool you specify must already exist. You can create a new pool by using the
     * <code>CreateDedicatedIpPool</code> operation.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDedicatedIpInPoolRequest.Builder} avoiding the
     * need to create one manually via {@link PutDedicatedIpInPoolRequest#builder()}
     * </p>
     *
     * @param putDedicatedIpInPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutDedicatedIpInPoolRequest.Builder} to create a
     *        request. A request to move a dedicated IP address to a dedicated IP pool.
     * @return A Java Future containing the result of the PutDedicatedIpInPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutDedicatedIpInPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDedicatedIpInPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutDedicatedIpInPoolResponse> putDedicatedIpInPool(
            Consumer<PutDedicatedIpInPoolRequest.Builder> putDedicatedIpInPoolRequest) {
        return putDedicatedIpInPool(PutDedicatedIpInPoolRequest.builder().applyMutation(putDedicatedIpInPoolRequest).build());
    }

    /**
     * <p>
     * Used to convert a dedicated IP pool to a different scaling mode.
     * </p>
     * <note>
     * <p>
     * <code>MANAGED</code> pools cannot be converted to <code>STANDARD</code> scaling mode.
     * </p>
     * </note>
     *
     * @param putDedicatedIpPoolScalingAttributesRequest
     *        A request to convert a dedicated IP pool to a different scaling mode.
     * @return A Java Future containing the result of the PutDedicatedIpPoolScalingAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutDedicatedIpPoolScalingAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDedicatedIpPoolScalingAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutDedicatedIpPoolScalingAttributesResponse> putDedicatedIpPoolScalingAttributes(
            PutDedicatedIpPoolScalingAttributesRequest putDedicatedIpPoolScalingAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to convert a dedicated IP pool to a different scaling mode.
     * </p>
     * <note>
     * <p>
     * <code>MANAGED</code> pools cannot be converted to <code>STANDARD</code> scaling mode.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDedicatedIpPoolScalingAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link PutDedicatedIpPoolScalingAttributesRequest#builder()}
     * </p>
     *
     * @param putDedicatedIpPoolScalingAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutDedicatedIpPoolScalingAttributesRequest.Builder} to
     *        create a request. A request to convert a dedicated IP pool to a different scaling mode.
     * @return A Java Future containing the result of the PutDedicatedIpPoolScalingAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutDedicatedIpPoolScalingAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDedicatedIpPoolScalingAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutDedicatedIpPoolScalingAttributesResponse> putDedicatedIpPoolScalingAttributes(
            Consumer<PutDedicatedIpPoolScalingAttributesRequest.Builder> putDedicatedIpPoolScalingAttributesRequest) {
        return putDedicatedIpPoolScalingAttributes(PutDedicatedIpPoolScalingAttributesRequest.builder()
                .applyMutation(putDedicatedIpPoolScalingAttributesRequest).build());
    }

    /**
     * <p/>
     *
     * @param putDedicatedIpWarmupAttributesRequest
     *        A request to change the warm-up attributes for a dedicated IP address. This operation is useful when you
     *        want to resume the warm-up process for an existing IP address.
     * @return A Java Future containing the result of the PutDedicatedIpWarmupAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li> <li>
     *         TooManyRequestsException Too many requests have been made to the operation.</li> <li>BadRequestException
     *         The input you provided is invalid.</li> <li>SdkException Base class for all exceptions that can be thrown
     *         by the SDK (both service and client). Can be used for catch all scenarios.</li> <li>SdkClientException If
     *         any client side error occurs such as an IO related failure, failure to get credentials, etc.</li> <li>
     *         SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance of
     *         this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutDedicatedIpWarmupAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDedicatedIpWarmupAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutDedicatedIpWarmupAttributesResponse> putDedicatedIpWarmupAttributes(
            PutDedicatedIpWarmupAttributesRequest putDedicatedIpWarmupAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p/>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDedicatedIpWarmupAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link PutDedicatedIpWarmupAttributesRequest#builder()}
     * </p>
     *
     * @param putDedicatedIpWarmupAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutDedicatedIpWarmupAttributesRequest.Builder} to
     *        create a request. A request to change the warm-up attributes for a dedicated IP address. This operation is
     *        useful when you want to resume the warm-up process for an existing IP address.
     * @return A Java Future containing the result of the PutDedicatedIpWarmupAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutDedicatedIpWarmupAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDedicatedIpWarmupAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutDedicatedIpWarmupAttributesResponse> putDedicatedIpWarmupAttributes(
            Consumer<PutDedicatedIpWarmupAttributesRequest.Builder> putDedicatedIpWarmupAttributesRequest) {
        return putDedicatedIpWarmupAttributes(PutDedicatedIpWarmupAttributesRequest.builder()
                .applyMutation(putDedicatedIpWarmupAttributesRequest).build());
    }

    /**
     * <p>
     * Enable or disable the Deliverability dashboard. When you enable the Deliverability dashboard, you gain access to
     * reputation, deliverability, and other metrics for the domains that you use to send email. You also gain the
     * ability to perform predictive inbox placement tests.
     * </p>
     * <p>
     * When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees
     * that you accrue by using Amazon SES and other Amazon Web Services services. For more information about the
     * features and cost of a Deliverability dashboard subscription, see <a
     * href="http://aws.amazon.com/ses/pricing/">Amazon SES Pricing</a>.
     * </p>
     *
     * @param putDeliverabilityDashboardOptionRequest
     *        Enable or disable the Deliverability dashboard. When you enable the Deliverability dashboard, you gain
     *        access to reputation, deliverability, and other metrics for the domains that you use to send email using
     *        Amazon SES API v2. You also gain the ability to perform predictive inbox placement tests.</p>
     *        <p>
     *        When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other
     *        fees that you accrue by using Amazon SES and other Amazon Web Services services. For more information
     *        about the features and cost of a Deliverability dashboard subscription, see <a
     *        href="http://aws.amazon.com/pinpoint/pricing/">Amazon Pinpoint Pricing</a>.
     * @return A Java Future containing the result of the PutDeliverabilityDashboardOption operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li> <li>
     *         NotFoundException The resource you attempted to access doesn't exist.</li> <li>TooManyRequestsException
     *         Too many requests have been made to the operation.</li> <li>LimitExceededException There are too many
     *         instances of the specified resource type.</li> <li>BadRequestException The input you provided is invalid.
     *         </li> <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li> <li>SdkClientException If any client side error occurs
     *         such as an IO related failure, failure to get credentials, etc.</li> <li>SesV2Exception Base class for
     *         all service exceptions. Unknown exceptions will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutDeliverabilityDashboardOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDeliverabilityDashboardOption"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutDeliverabilityDashboardOptionResponse> putDeliverabilityDashboardOption(
            PutDeliverabilityDashboardOptionRequest putDeliverabilityDashboardOptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enable or disable the Deliverability dashboard. When you enable the Deliverability dashboard, you gain access to
     * reputation, deliverability, and other metrics for the domains that you use to send email. You also gain the
     * ability to perform predictive inbox placement tests.
     * </p>
     * <p>
     * When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees
     * that you accrue by using Amazon SES and other Amazon Web Services services. For more information about the
     * features and cost of a Deliverability dashboard subscription, see <a
     * href="http://aws.amazon.com/ses/pricing/">Amazon SES Pricing</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDeliverabilityDashboardOptionRequest.Builder}
     * avoiding the need to create one manually via {@link PutDeliverabilityDashboardOptionRequest#builder()}
     * </p>
     *
     * @param putDeliverabilityDashboardOptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutDeliverabilityDashboardOptionRequest.Builder} to
     *        create a request. Enable or disable the Deliverability dashboard. When you enable the Deliverability
     *        dashboard, you gain access to reputation, deliverability, and other metrics for the domains that you use
     *        to send email using Amazon SES API v2. You also gain the ability to perform predictive inbox placement
     *        tests.</p>
     *        <p>
     *        When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other
     *        fees that you accrue by using Amazon SES and other Amazon Web Services services. For more information
     *        about the features and cost of a Deliverability dashboard subscription, see <a
     *        href="http://aws.amazon.com/pinpoint/pricing/">Amazon Pinpoint Pricing</a>.
     * @return A Java Future containing the result of the PutDeliverabilityDashboardOption operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li> <li>
     *         NotFoundException The resource you attempted to access doesn't exist.</li> <li>TooManyRequestsException
     *         Too many requests have been made to the operation.</li> <li>LimitExceededException There are too many
     *         instances of the specified resource type.</li> <li>BadRequestException The input you provided is invalid.
     *         </li> <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li> <li>SdkClientException If any client side error occurs
     *         such as an IO related failure, failure to get credentials, etc.</li> <li>SesV2Exception Base class for
     *         all service exceptions. Unknown exceptions will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutDeliverabilityDashboardOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDeliverabilityDashboardOption"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutDeliverabilityDashboardOptionResponse> putDeliverabilityDashboardOption(
            Consumer<PutDeliverabilityDashboardOptionRequest.Builder> putDeliverabilityDashboardOptionRequest) {
        return putDeliverabilityDashboardOption(PutDeliverabilityDashboardOptionRequest.builder()
                .applyMutation(putDeliverabilityDashboardOptionRequest).build());
    }

    /**
     * <p>
     * Used to associate a configuration set with an email identity.
     * </p>
     *
     * @param putEmailIdentityConfigurationSetAttributesRequest
     *        A request to associate a configuration set with an email identity.
     * @return A Java Future containing the result of the PutEmailIdentityConfigurationSetAttributes operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutEmailIdentityConfigurationSetAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityConfigurationSetAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutEmailIdentityConfigurationSetAttributesResponse> putEmailIdentityConfigurationSetAttributes(
            PutEmailIdentityConfigurationSetAttributesRequest putEmailIdentityConfigurationSetAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to associate a configuration set with an email identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutEmailIdentityConfigurationSetAttributesRequest.Builder} avoiding the need to create one manually via
     * {@link PutEmailIdentityConfigurationSetAttributesRequest#builder()}
     * </p>
     *
     * @param putEmailIdentityConfigurationSetAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutEmailIdentityConfigurationSetAttributesRequest.Builder}
     *        to create a request. A request to associate a configuration set with an email identity.
     * @return A Java Future containing the result of the PutEmailIdentityConfigurationSetAttributes operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutEmailIdentityConfigurationSetAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityConfigurationSetAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutEmailIdentityConfigurationSetAttributesResponse> putEmailIdentityConfigurationSetAttributes(
            Consumer<PutEmailIdentityConfigurationSetAttributesRequest.Builder> putEmailIdentityConfigurationSetAttributesRequest) {
        return putEmailIdentityConfigurationSetAttributes(PutEmailIdentityConfigurationSetAttributesRequest.builder()
                .applyMutation(putEmailIdentityConfigurationSetAttributesRequest).build());
    }

    /**
     * <p>
     * Used to enable or disable DKIM authentication for an email identity.
     * </p>
     *
     * @param putEmailIdentityDkimAttributesRequest
     *        A request to enable or disable DKIM signing of email that you send from an email identity.
     * @return A Java Future containing the result of the PutEmailIdentityDkimAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutEmailIdentityDkimAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityDkimAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutEmailIdentityDkimAttributesResponse> putEmailIdentityDkimAttributes(
            PutEmailIdentityDkimAttributesRequest putEmailIdentityDkimAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to enable or disable DKIM authentication for an email identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEmailIdentityDkimAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link PutEmailIdentityDkimAttributesRequest#builder()}
     * </p>
     *
     * @param putEmailIdentityDkimAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimAttributesRequest.Builder} to
     *        create a request. A request to enable or disable DKIM signing of email that you send from an email
     *        identity.
     * @return A Java Future containing the result of the PutEmailIdentityDkimAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutEmailIdentityDkimAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityDkimAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutEmailIdentityDkimAttributesResponse> putEmailIdentityDkimAttributes(
            Consumer<PutEmailIdentityDkimAttributesRequest.Builder> putEmailIdentityDkimAttributesRequest) {
        return putEmailIdentityDkimAttributes(PutEmailIdentityDkimAttributesRequest.builder()
                .applyMutation(putEmailIdentityDkimAttributesRequest).build());
    }

    /**
     * <p>
     * Used to configure or change the DKIM authentication settings for an email domain identity. You can use this
     * operation to do any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Update the signing attributes for an identity that uses Bring Your Own DKIM (BYODKIM).
     * </p>
     * </li>
     * <li>
     * <p>
     * Update the key length that should be used for Easy DKIM.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change from using no DKIM authentication to using Easy DKIM.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change from using no DKIM authentication to using BYODKIM.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change from using Easy DKIM to using BYODKIM.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change from using BYODKIM to using Easy DKIM.
     * </p>
     * </li>
     * </ul>
     *
     * @param putEmailIdentityDkimSigningAttributesRequest
     *        A request to change the DKIM attributes for an email identity.
     * @return A Java Future containing the result of the PutEmailIdentityDkimSigningAttributes operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutEmailIdentityDkimSigningAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityDkimSigningAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutEmailIdentityDkimSigningAttributesResponse> putEmailIdentityDkimSigningAttributes(
            PutEmailIdentityDkimSigningAttributesRequest putEmailIdentityDkimSigningAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to configure or change the DKIM authentication settings for an email domain identity. You can use this
     * operation to do any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Update the signing attributes for an identity that uses Bring Your Own DKIM (BYODKIM).
     * </p>
     * </li>
     * <li>
     * <p>
     * Update the key length that should be used for Easy DKIM.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change from using no DKIM authentication to using Easy DKIM.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change from using no DKIM authentication to using BYODKIM.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change from using Easy DKIM to using BYODKIM.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change from using BYODKIM to using Easy DKIM.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutEmailIdentityDkimSigningAttributesRequest.Builder} avoiding the need to create one manually via
     * {@link PutEmailIdentityDkimSigningAttributesRequest#builder()}
     * </p>
     *
     * @param putEmailIdentityDkimSigningAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimSigningAttributesRequest.Builder}
     *        to create a request. A request to change the DKIM attributes for an email identity.
     * @return A Java Future containing the result of the PutEmailIdentityDkimSigningAttributes operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutEmailIdentityDkimSigningAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityDkimSigningAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutEmailIdentityDkimSigningAttributesResponse> putEmailIdentityDkimSigningAttributes(
            Consumer<PutEmailIdentityDkimSigningAttributesRequest.Builder> putEmailIdentityDkimSigningAttributesRequest) {
        return putEmailIdentityDkimSigningAttributes(PutEmailIdentityDkimSigningAttributesRequest.builder()
                .applyMutation(putEmailIdentityDkimSigningAttributesRequest).build());
    }

    /**
     * <p>
     * Used to enable or disable feedback forwarding for an identity. This setting determines what happens when an
     * identity is used to send an email that results in a bounce or complaint event.
     * </p>
     * <p>
     * If the value is <code>true</code>, you receive email notifications when bounce or complaint events occur. These
     * notifications are sent to the address that you specified in the <code>Return-Path</code> header of the original
     * email.
     * </p>
     * <p>
     * You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for
     * receiving bounce or complaint notifications (for example, by setting up an event destination), you receive an
     * email notification when these events occur (even if this setting is disabled).
     * </p>
     *
     * @param putEmailIdentityFeedbackAttributesRequest
     *        A request to set the attributes that control how bounce and complaint events are processed.
     * @return A Java Future containing the result of the PutEmailIdentityFeedbackAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutEmailIdentityFeedbackAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityFeedbackAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutEmailIdentityFeedbackAttributesResponse> putEmailIdentityFeedbackAttributes(
            PutEmailIdentityFeedbackAttributesRequest putEmailIdentityFeedbackAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to enable or disable feedback forwarding for an identity. This setting determines what happens when an
     * identity is used to send an email that results in a bounce or complaint event.
     * </p>
     * <p>
     * If the value is <code>true</code>, you receive email notifications when bounce or complaint events occur. These
     * notifications are sent to the address that you specified in the <code>Return-Path</code> header of the original
     * email.
     * </p>
     * <p>
     * You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for
     * receiving bounce or complaint notifications (for example, by setting up an event destination), you receive an
     * email notification when these events occur (even if this setting is disabled).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEmailIdentityFeedbackAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link PutEmailIdentityFeedbackAttributesRequest#builder()}
     * </p>
     *
     * @param putEmailIdentityFeedbackAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutEmailIdentityFeedbackAttributesRequest.Builder} to
     *        create a request. A request to set the attributes that control how bounce and complaint events are
     *        processed.
     * @return A Java Future containing the result of the PutEmailIdentityFeedbackAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutEmailIdentityFeedbackAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityFeedbackAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutEmailIdentityFeedbackAttributesResponse> putEmailIdentityFeedbackAttributes(
            Consumer<PutEmailIdentityFeedbackAttributesRequest.Builder> putEmailIdentityFeedbackAttributesRequest) {
        return putEmailIdentityFeedbackAttributes(PutEmailIdentityFeedbackAttributesRequest.builder()
                .applyMutation(putEmailIdentityFeedbackAttributesRequest).build());
    }

    /**
     * <p>
     * Used to enable or disable the custom Mail-From domain configuration for an email identity.
     * </p>
     *
     * @param putEmailIdentityMailFromAttributesRequest
     *        A request to configure the custom MAIL FROM domain for a verified identity.
     * @return A Java Future containing the result of the PutEmailIdentityMailFromAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutEmailIdentityMailFromAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityMailFromAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutEmailIdentityMailFromAttributesResponse> putEmailIdentityMailFromAttributes(
            PutEmailIdentityMailFromAttributesRequest putEmailIdentityMailFromAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to enable or disable the custom Mail-From domain configuration for an email identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEmailIdentityMailFromAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link PutEmailIdentityMailFromAttributesRequest#builder()}
     * </p>
     *
     * @param putEmailIdentityMailFromAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutEmailIdentityMailFromAttributesRequest.Builder} to
     *        create a request. A request to configure the custom MAIL FROM domain for a verified identity.
     * @return A Java Future containing the result of the PutEmailIdentityMailFromAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutEmailIdentityMailFromAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityMailFromAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutEmailIdentityMailFromAttributesResponse> putEmailIdentityMailFromAttributes(
            Consumer<PutEmailIdentityMailFromAttributesRequest.Builder> putEmailIdentityMailFromAttributesRequest) {
        return putEmailIdentityMailFromAttributes(PutEmailIdentityMailFromAttributesRequest.builder()
                .applyMutation(putEmailIdentityMailFromAttributesRequest).build());
    }

    /**
     * <p>
     * Adds an email address to the suppression list for your account.
     * </p>
     *
     * @param putSuppressedDestinationRequest
     *        A request to add an email destination to the suppression list for your account.
     * @return A Java Future containing the result of the PutSuppressedDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutSuppressedDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutSuppressedDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutSuppressedDestinationResponse> putSuppressedDestination(
            PutSuppressedDestinationRequest putSuppressedDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an email address to the suppression list for your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutSuppressedDestinationRequest.Builder} avoiding
     * the need to create one manually via {@link PutSuppressedDestinationRequest#builder()}
     * </p>
     *
     * @param putSuppressedDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutSuppressedDestinationRequest.Builder} to create a
     *        request. A request to add an email destination to the suppression list for your account.
     * @return A Java Future containing the result of the PutSuppressedDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutSuppressedDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutSuppressedDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutSuppressedDestinationResponse> putSuppressedDestination(
            Consumer<PutSuppressedDestinationRequest.Builder> putSuppressedDestinationRequest) {
        return putSuppressedDestination(PutSuppressedDestinationRequest.builder().applyMutation(putSuppressedDestinationRequest)
                .build());
    }

    /**
     * <p>
     * Composes an email message to multiple destinations.
     * </p>
     *
     * @param sendBulkEmailRequest
     *        Represents a request to send email messages to multiple destinations using Amazon SES. For more
     *        information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the SendBulkEmail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>AccountSuspendedException The message can't be sent because the account's ability to send email has
     *         been permanently restricted.</li>
     *         <li>SendingPausedException The message can't be sent because the account's ability to send email is
     *         currently paused.</li>
     *         <li>MessageRejectedException The message can't be sent because it contains invalid content.</li>
     *         <li>MailFromDomainNotVerifiedException The message can't be sent because the sending domain isn't
     *         verified.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.SendBulkEmail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/SendBulkEmail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendBulkEmailResponse> sendBulkEmail(SendBulkEmailRequest sendBulkEmailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Composes an email message to multiple destinations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendBulkEmailRequest.Builder} avoiding the need to
     * create one manually via {@link SendBulkEmailRequest#builder()}
     * </p>
     *
     * @param sendBulkEmailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.SendBulkEmailRequest.Builder} to create a request.
     *        Represents a request to send email messages to multiple destinations using Amazon SES. For more
     *        information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the SendBulkEmail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>AccountSuspendedException The message can't be sent because the account's ability to send email has
     *         been permanently restricted.</li>
     *         <li>SendingPausedException The message can't be sent because the account's ability to send email is
     *         currently paused.</li>
     *         <li>MessageRejectedException The message can't be sent because it contains invalid content.</li>
     *         <li>MailFromDomainNotVerifiedException The message can't be sent because the sending domain isn't
     *         verified.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.SendBulkEmail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/SendBulkEmail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendBulkEmailResponse> sendBulkEmail(Consumer<SendBulkEmailRequest.Builder> sendBulkEmailRequest) {
        return sendBulkEmail(SendBulkEmailRequest.builder().applyMutation(sendBulkEmailRequest).build());
    }

    /**
     * <p>
     * Adds an email address to the list of identities for your Amazon SES account in the current Amazon Web Services
     * Region and attempts to verify it. As a result of executing this operation, a customized verification email is
     * sent to the specified address.
     * </p>
     * <p>
     * To use this operation, you must first create a custom verification email template. For more information about
     * creating and using custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param sendCustomVerificationEmailRequest
     *        Represents a request to send a custom verification email to a specified recipient.
     * @return A Java Future containing the result of the SendCustomVerificationEmail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>MessageRejectedException The message can't be sent because it contains invalid content.</li>
     *         <li>SendingPausedException The message can't be sent because the account's ability to send email is
     *         currently paused.</li>
     *         <li>MailFromDomainNotVerifiedException The message can't be sent because the sending domain isn't
     *         verified.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.SendCustomVerificationEmail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/SendCustomVerificationEmail"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendCustomVerificationEmailResponse> sendCustomVerificationEmail(
            SendCustomVerificationEmailRequest sendCustomVerificationEmailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an email address to the list of identities for your Amazon SES account in the current Amazon Web Services
     * Region and attempts to verify it. As a result of executing this operation, a customized verification email is
     * sent to the specified address.
     * </p>
     * <p>
     * To use this operation, you must first create a custom verification email template. For more information about
     * creating and using custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendCustomVerificationEmailRequest.Builder}
     * avoiding the need to create one manually via {@link SendCustomVerificationEmailRequest#builder()}
     * </p>
     *
     * @param sendCustomVerificationEmailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.SendCustomVerificationEmailRequest.Builder} to create a
     *        request. Represents a request to send a custom verification email to a specified recipient.
     * @return A Java Future containing the result of the SendCustomVerificationEmail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>MessageRejectedException The message can't be sent because it contains invalid content.</li>
     *         <li>SendingPausedException The message can't be sent because the account's ability to send email is
     *         currently paused.</li>
     *         <li>MailFromDomainNotVerifiedException The message can't be sent because the sending domain isn't
     *         verified.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.SendCustomVerificationEmail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/SendCustomVerificationEmail"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendCustomVerificationEmailResponse> sendCustomVerificationEmail(
            Consumer<SendCustomVerificationEmailRequest.Builder> sendCustomVerificationEmailRequest) {
        return sendCustomVerificationEmail(SendCustomVerificationEmailRequest.builder()
                .applyMutation(sendCustomVerificationEmailRequest).build());
    }

    /**
     * <p>
     * Sends an email message. You can use the Amazon SES API v2 to send the following types of messages:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Simple</b> – A standard email message. When you create this type of message, you specify the sender, the
     * recipient, and the message body, and Amazon SES assembles the message for you.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Raw</b> – A raw, MIME-formatted email message. When you send this type of email, you have to specify all of
     * the message headers, as well as the message body. You can use this message type to send messages that contain
     * attachments. The message that you specify has to be a valid MIME message.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Templated</b> – A message that contains personalization tags. When you send this type of email, Amazon SES API
     * v2 automatically replaces the tags with values that you specify.
     * </p>
     * </li>
     * </ul>
     *
     * @param sendEmailRequest
     *        Represents a request to send a single formatted email using Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-formatted.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the SendEmail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>AccountSuspendedException The message can't be sent because the account's ability to send email has
     *         been permanently restricted.</li>
     *         <li>SendingPausedException The message can't be sent because the account's ability to send email is
     *         currently paused.</li>
     *         <li>MessageRejectedException The message can't be sent because it contains invalid content.</li>
     *         <li>MailFromDomainNotVerifiedException The message can't be sent because the sending domain isn't
     *         verified.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.SendEmail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/SendEmail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendEmailResponse> sendEmail(SendEmailRequest sendEmailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends an email message. You can use the Amazon SES API v2 to send the following types of messages:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Simple</b> – A standard email message. When you create this type of message, you specify the sender, the
     * recipient, and the message body, and Amazon SES assembles the message for you.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Raw</b> – A raw, MIME-formatted email message. When you send this type of email, you have to specify all of
     * the message headers, as well as the message body. You can use this message type to send messages that contain
     * attachments. The message that you specify has to be a valid MIME message.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Templated</b> – A message that contains personalization tags. When you send this type of email, Amazon SES API
     * v2 automatically replaces the tags with values that you specify.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendEmailRequest.Builder} avoiding the need to
     * create one manually via {@link SendEmailRequest#builder()}
     * </p>
     *
     * @param sendEmailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.SendEmailRequest.Builder} to create a request.
     *        Represents a request to send a single formatted email using Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-formatted.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the SendEmail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>AccountSuspendedException The message can't be sent because the account's ability to send email has
     *         been permanently restricted.</li>
     *         <li>SendingPausedException The message can't be sent because the account's ability to send email is
     *         currently paused.</li>
     *         <li>MessageRejectedException The message can't be sent because it contains invalid content.</li>
     *         <li>MailFromDomainNotVerifiedException The message can't be sent because the sending domain isn't
     *         verified.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.SendEmail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/SendEmail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendEmailResponse> sendEmail(Consumer<SendEmailRequest.Builder> sendEmailRequest) {
        return sendEmail(SendEmailRequest.builder().applyMutation(sendEmailRequest).build());
    }

    /**
     * <p>
     * Add one or more tags (keys and values) to a specified resource. A <i>tag</i> is a label that you optionally
     * define and associate with a resource. Tags can help you categorize and manage resources in different ways, such
     * as by purpose, owner, environment, or other criteria. A resource can have as many as 50 tags.
     * </p>
     * <p>
     * Each tag consists of a required <i>tag key</i> and an associated <i>tag value</i>, both of which you define. A
     * tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor
     * within a tag key.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add one or more tags (keys and values) to a specified resource. A <i>tag</i> is a label that you optionally
     * define and associate with a resource. Tags can help you categorize and manage resources in different ways, such
     * as by purpose, owner, environment, or other criteria. A resource can have as many as 50 tags.
     * </p>
     * <p>
     * Each tag consists of a required <i>tag key</i> and an associated <i>tag value</i>, both of which you define. A
     * tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor
     * within a tag key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Creates a preview of the MIME content of an email when provided with a template and a set of replacement data.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param testRenderEmailTemplateRequest
     *        &gt;Represents a request to create a preview of the MIME content of an email when provided with a template
     *        and a set of replacement data.
     * @return A Java Future containing the result of the TestRenderEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.TestRenderEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/TestRenderEmailTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TestRenderEmailTemplateResponse> testRenderEmailTemplate(
            TestRenderEmailTemplateRequest testRenderEmailTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a preview of the MIME content of an email when provided with a template and a set of replacement data.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestRenderEmailTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link TestRenderEmailTemplateRequest#builder()}
     * </p>
     *
     * @param testRenderEmailTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.TestRenderEmailTemplateRequest.Builder} to create a
     *        request. &gt;Represents a request to create a preview of the MIME content of an email when provided with a
     *        template and a set of replacement data.
     * @return A Java Future containing the result of the TestRenderEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.TestRenderEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/TestRenderEmailTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TestRenderEmailTemplateResponse> testRenderEmailTemplate(
            Consumer<TestRenderEmailTemplateRequest.Builder> testRenderEmailTemplateRequest) {
        return testRenderEmailTemplate(TestRenderEmailTemplateRequest.builder().applyMutation(testRenderEmailTemplateRequest)
                .build());
    }

    /**
     * <p>
     * Remove one or more tags (keys and values) from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove one or more tags (keys and values) from a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Update the configuration of an event destination for a configuration set.
     * </p>
     * <p>
     * <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event
     * destinations</i> are places that you can send information about these events to. For example, you can send event
     * data to Amazon EventBridge and associate a rule to send the event to the specified target.
     * </p>
     *
     * @param updateConfigurationSetEventDestinationRequest
     *        A request to change the settings for an event destination for a configuration set.
     * @return A Java Future containing the result of the UpdateConfigurationSetEventDestination operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.UpdateConfigurationSetEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConfigurationSetEventDestinationResponse> updateConfigurationSetEventDestination(
            UpdateConfigurationSetEventDestinationRequest updateConfigurationSetEventDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the configuration of an event destination for a configuration set.
     * </p>
     * <p>
     * <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event
     * destinations</i> are places that you can send information about these events to. For example, you can send event
     * data to Amazon EventBridge and associate a rule to send the event to the specified target.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateConfigurationSetEventDestinationRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateConfigurationSetEventDestinationRequest#builder()}
     * </p>
     *
     * @param updateConfigurationSetEventDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.UpdateConfigurationSetEventDestinationRequest.Builder}
     *        to create a request. A request to change the settings for an event destination for a configuration set.
     * @return A Java Future containing the result of the UpdateConfigurationSetEventDestination operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.UpdateConfigurationSetEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConfigurationSetEventDestinationResponse> updateConfigurationSetEventDestination(
            Consumer<UpdateConfigurationSetEventDestinationRequest.Builder> updateConfigurationSetEventDestinationRequest) {
        return updateConfigurationSetEventDestination(UpdateConfigurationSetEventDestinationRequest.builder()
                .applyMutation(updateConfigurationSetEventDestinationRequest).build());
    }

    /**
     * <p>
     * Updates a contact's preferences for a list.
     * </p>
     * <note>
     * <p>
     * You must specify all existing topic preferences in the <code>TopicPreferences</code> object, not just the ones
     * that need updating; otherwise, all your existing preferences will be removed.
     * </p>
     * </note>
     *
     * @param updateContactRequest
     * @return A Java Future containing the result of the UpdateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.UpdateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateContact" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateContactResponse> updateContact(UpdateContactRequest updateContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a contact's preferences for a list.
     * </p>
     * <note>
     * <p>
     * You must specify all existing topic preferences in the <code>TopicPreferences</code> object, not just the ones
     * that need updating; otherwise, all your existing preferences will be removed.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateContactRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateContactRequest#builder()}
     * </p>
     *
     * @param updateContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.UpdateContactRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.UpdateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateContact" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateContactResponse> updateContact(Consumer<UpdateContactRequest.Builder> updateContactRequest) {
        return updateContact(UpdateContactRequest.builder().applyMutation(updateContactRequest).build());
    }

    /**
     * <p>
     * Updates contact list metadata. This operation does a complete replacement.
     * </p>
     *
     * @param updateContactListRequest
     * @return A Java Future containing the result of the UpdateContactList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.UpdateContactList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateContactList" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateContactListResponse> updateContactList(UpdateContactListRequest updateContactListRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates contact list metadata. This operation does a complete replacement.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateContactListRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateContactListRequest#builder()}
     * </p>
     *
     * @param updateContactListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.UpdateContactListRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateContactList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.UpdateContactList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateContactList" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateContactListResponse> updateContactList(
            Consumer<UpdateContactListRequest.Builder> updateContactListRequest) {
        return updateContactList(UpdateContactListRequest.builder().applyMutation(updateContactListRequest).build());
    }

    /**
     * <p>
     * Updates an existing custom verification email template.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param updateCustomVerificationEmailTemplateRequest
     *        Represents a request to update an existing custom verification email template.
     * @return A Java Future containing the result of the UpdateCustomVerificationEmailTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.UpdateCustomVerificationEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCustomVerificationEmailTemplateResponse> updateCustomVerificationEmailTemplate(
            UpdateCustomVerificationEmailTemplateRequest updateCustomVerificationEmailTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing custom verification email template.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateCustomVerificationEmailTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateCustomVerificationEmailTemplateRequest#builder()}
     * </p>
     *
     * @param updateCustomVerificationEmailTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.UpdateCustomVerificationEmailTemplateRequest.Builder}
     *        to create a request. Represents a request to update an existing custom verification email template.
     * @return A Java Future containing the result of the UpdateCustomVerificationEmailTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.UpdateCustomVerificationEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCustomVerificationEmailTemplateResponse> updateCustomVerificationEmailTemplate(
            Consumer<UpdateCustomVerificationEmailTemplateRequest.Builder> updateCustomVerificationEmailTemplateRequest) {
        return updateCustomVerificationEmailTemplate(UpdateCustomVerificationEmailTemplateRequest.builder()
                .applyMutation(updateCustomVerificationEmailTemplateRequest).build());
    }

    /**
     * <p>
     * Updates the specified sending authorization policy for the given identity (an email address or a domain). This
     * API returns successfully even if a policy with the specified name does not exist.
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param updateEmailIdentityPolicyRequest
     *        Represents a request to update a sending authorization policy for an identity. Sending authorization is an
     *        Amazon SES feature that enables you to authorize other senders to use your identities. For information,
     *        see the <a href=
     *        "https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-identity-owner-tasks-management.html"
     *        >Amazon SES Developer Guide</a>.
     * @return A Java Future containing the result of the UpdateEmailIdentityPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.UpdateEmailIdentityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateEmailIdentityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEmailIdentityPolicyResponse> updateEmailIdentityPolicy(
            UpdateEmailIdentityPolicyRequest updateEmailIdentityPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified sending authorization policy for the given identity (an email address or a domain). This
     * API returns successfully even if a policy with the specified name does not exist.
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEmailIdentityPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateEmailIdentityPolicyRequest#builder()}
     * </p>
     *
     * @param updateEmailIdentityPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.UpdateEmailIdentityPolicyRequest.Builder} to create a
     *        request. Represents a request to update a sending authorization policy for an identity. Sending
     *        authorization is an Amazon SES feature that enables you to authorize other senders to use your identities.
     *        For information, see the <a href=
     *        "https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-identity-owner-tasks-management.html"
     *        >Amazon SES Developer Guide</a>.
     * @return A Java Future containing the result of the UpdateEmailIdentityPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.UpdateEmailIdentityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateEmailIdentityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEmailIdentityPolicyResponse> updateEmailIdentityPolicy(
            Consumer<UpdateEmailIdentityPolicyRequest.Builder> updateEmailIdentityPolicyRequest) {
        return updateEmailIdentityPolicy(UpdateEmailIdentityPolicyRequest.builder()
                .applyMutation(updateEmailIdentityPolicyRequest).build());
    }

    /**
     * <p>
     * Updates an email template. Email templates enable you to send personalized email to one or more destinations in a
     * single API operation. For more information, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param updateEmailTemplateRequest
     *        Represents a request to update an email template. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the UpdateEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.UpdateEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateEmailTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateEmailTemplateResponse> updateEmailTemplate(
            UpdateEmailTemplateRequest updateEmailTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an email template. Email templates enable you to send personalized email to one or more destinations in a
     * single API operation. For more information, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEmailTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEmailTemplateRequest#builder()}
     * </p>
     *
     * @param updateEmailTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.UpdateEmailTemplateRequest.Builder} to create a
     *        request. Represents a request to update an email template. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the UpdateEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.UpdateEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateEmailTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateEmailTemplateResponse> updateEmailTemplate(
            Consumer<UpdateEmailTemplateRequest.Builder> updateEmailTemplateRequest) {
        return updateEmailTemplate(UpdateEmailTemplateRequest.builder().applyMutation(updateEmailTemplateRequest).build());
    }

    /**
     * <p>
     * Update the customer-managed sending status for a reputation entity. This allows you to enable, disable, or
     * reinstate sending for the entity.
     * </p>
     * <p>
     * The customer-managed status works in conjunction with the Amazon Web Services Amazon SES-managed status to
     * determine the overall sending capability. When you update the customer-managed status, the Amazon Web Services
     * Amazon SES-managed status remains unchanged. If Amazon Web Services Amazon SES has disabled the entity, it will
     * not be allowed to send regardless of the customer-managed status setting. When you reinstate an entity through
     * the customer-managed status, it can continue sending only if the Amazon Web Services Amazon SES-managed status
     * also permits sending, even if there are active reputation findings, until the findings are resolved or new
     * violations occur.
     * </p>
     *
     * @param updateReputationEntityCustomerManagedStatusRequest
     *        Represents a request to update the customer-managed sending status for a reputation entity.
     * @return A Java Future containing the result of the UpdateReputationEntityCustomerManagedStatus operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConflictException If there is already an ongoing account details update under review.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.UpdateReputationEntityCustomerManagedStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateReputationEntityCustomerManagedStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateReputationEntityCustomerManagedStatusResponse> updateReputationEntityCustomerManagedStatus(
            UpdateReputationEntityCustomerManagedStatusRequest updateReputationEntityCustomerManagedStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the customer-managed sending status for a reputation entity. This allows you to enable, disable, or
     * reinstate sending for the entity.
     * </p>
     * <p>
     * The customer-managed status works in conjunction with the Amazon Web Services Amazon SES-managed status to
     * determine the overall sending capability. When you update the customer-managed status, the Amazon Web Services
     * Amazon SES-managed status remains unchanged. If Amazon Web Services Amazon SES has disabled the entity, it will
     * not be allowed to send regardless of the customer-managed status setting. When you reinstate an entity through
     * the customer-managed status, it can continue sending only if the Amazon Web Services Amazon SES-managed status
     * also permits sending, even if there are active reputation findings, until the findings are resolved or new
     * violations occur.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateReputationEntityCustomerManagedStatusRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateReputationEntityCustomerManagedStatusRequest#builder()}
     * </p>
     *
     * @param updateReputationEntityCustomerManagedStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.UpdateReputationEntityCustomerManagedStatusRequest.Builder}
     *        to create a request. Represents a request to update the customer-managed sending status for a reputation
     *        entity.
     * @return A Java Future containing the result of the UpdateReputationEntityCustomerManagedStatus operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConflictException If there is already an ongoing account details update under review.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.UpdateReputationEntityCustomerManagedStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateReputationEntityCustomerManagedStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateReputationEntityCustomerManagedStatusResponse> updateReputationEntityCustomerManagedStatus(
            Consumer<UpdateReputationEntityCustomerManagedStatusRequest.Builder> updateReputationEntityCustomerManagedStatusRequest) {
        return updateReputationEntityCustomerManagedStatus(UpdateReputationEntityCustomerManagedStatusRequest.builder()
                .applyMutation(updateReputationEntityCustomerManagedStatusRequest).build());
    }

    /**
     * <p>
     * Update the reputation management policy for a reputation entity. The policy determines how the entity responds to
     * reputation findings, such as automatically pausing sending when certain thresholds are exceeded.
     * </p>
     * <p>
     * Reputation management policies are Amazon Web Services Amazon SES-managed (predefined policies). You can select
     * from none, standard, and strict policies.
     * </p>
     *
     * @param updateReputationEntityPolicyRequest
     *        Represents a request to update the reputation management policy for a reputation entity.
     * @return A Java Future containing the result of the UpdateReputationEntityPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConflictException If there is already an ongoing account details update under review.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.UpdateReputationEntityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateReputationEntityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateReputationEntityPolicyResponse> updateReputationEntityPolicy(
            UpdateReputationEntityPolicyRequest updateReputationEntityPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the reputation management policy for a reputation entity. The policy determines how the entity responds to
     * reputation findings, such as automatically pausing sending when certain thresholds are exceeded.
     * </p>
     * <p>
     * Reputation management policies are Amazon Web Services Amazon SES-managed (predefined policies). You can select
     * from none, standard, and strict policies.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateReputationEntityPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateReputationEntityPolicyRequest#builder()}
     * </p>
     *
     * @param updateReputationEntityPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.UpdateReputationEntityPolicyRequest.Builder} to create
     *        a request. Represents a request to update the reputation management policy for a reputation entity.
     * @return A Java Future containing the result of the UpdateReputationEntityPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConflictException If there is already an ongoing account details update under review.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.UpdateReputationEntityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateReputationEntityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateReputationEntityPolicyResponse> updateReputationEntityPolicy(
            Consumer<UpdateReputationEntityPolicyRequest.Builder> updateReputationEntityPolicyRequest) {
        return updateReputationEntityPolicy(UpdateReputationEntityPolicyRequest.builder()
                .applyMutation(updateReputationEntityPolicyRequest).build());
    }

    @Override
    default SesV2ServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link SesV2AsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SesV2AsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SesV2AsyncClient}.
     */
    static SesV2AsyncClientBuilder builder() {
        return new DefaultSesV2AsyncClientBuilder();
    }
}
