/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2AsyncClient;
import software.amazon.awssdk.services.sesv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.sesv2.model.ListTenantResourcesRequest;
import software.amazon.awssdk.services.sesv2.model.ListTenantResourcesResponse;
import software.amazon.awssdk.services.sesv2.model.TenantResource;

public class ListTenantResourcesPublisher
implements SdkPublisher<ListTenantResourcesResponse> {
    private final SesV2AsyncClient client;
    private final ListTenantResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTenantResourcesPublisher(SesV2AsyncClient client, ListTenantResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTenantResourcesPublisher(SesV2AsyncClient client, ListTenantResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTenantResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTenantResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TenantResource> tenantResources() {
        Function<ListTenantResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.tenantResources() != null) {
                return response.tenantResources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTenantResourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTenantResourcesResponseFetcher
    implements AsyncPageFetcher<ListTenantResourcesResponse> {
        private ListTenantResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListTenantResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTenantResourcesResponse> nextPage(ListTenantResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListTenantResourcesPublisher.this.client.listTenantResources(ListTenantResourcesPublisher.this.firstRequest);
            }
            return ListTenantResourcesPublisher.this.client.listTenantResources((ListTenantResourcesRequest)((Object)ListTenantResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

