/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.SubscriptionStatus;
import software.amazon.awssdk.services.sesv2.model.TopicFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListContactsFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListContactsFilter> {
    private static final SdkField<String> FILTERED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilteredStatus").getter(ListContactsFilter.getter(ListContactsFilter::filteredStatusAsString)).setter(ListContactsFilter.setter(Builder::filteredStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilteredStatus").build()}).build();
    private static final SdkField<TopicFilter> TOPIC_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TopicFilter").getter(ListContactsFilter.getter(ListContactsFilter::topicFilter)).setter(ListContactsFilter.setter(Builder::topicFilter)).constructor(TopicFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERED_STATUS_FIELD, TOPIC_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListContactsFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String filteredStatus;
    private final TopicFilter topicFilter;

    private ListContactsFilter(BuilderImpl builder) {
        this.filteredStatus = builder.filteredStatus;
        this.topicFilter = builder.topicFilter;
    }

    public final SubscriptionStatus filteredStatus() {
        return SubscriptionStatus.fromValue(this.filteredStatus);
    }

    public final String filteredStatusAsString() {
        return this.filteredStatus;
    }

    public final TopicFilter topicFilter() {
        return this.topicFilter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filteredStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContactsFilter)) {
            return false;
        }
        ListContactsFilter other = (ListContactsFilter)obj;
        return Objects.equals(this.filteredStatusAsString(), other.filteredStatusAsString()) && Objects.equals(this.topicFilter(), other.topicFilter());
    }

    public final String toString() {
        return ToString.builder((String)"ListContactsFilter").add("FilteredStatus", (Object)this.filteredStatusAsString()).add("TopicFilter", (Object)this.topicFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilteredStatus": {
                return Optional.ofNullable(clazz.cast(this.filteredStatusAsString()));
            }
            case "TopicFilter": {
                return Optional.ofNullable(clazz.cast(this.topicFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FilteredStatus", FILTERED_STATUS_FIELD);
        map.put("TopicFilter", TOPIC_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListContactsFilter, T> g) {
        return obj -> g.apply((ListContactsFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filteredStatus;
        private TopicFilter topicFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContactsFilter model) {
            this.filteredStatus(model.filteredStatus);
            this.topicFilter(model.topicFilter);
        }

        public final String getFilteredStatus() {
            return this.filteredStatus;
        }

        public final void setFilteredStatus(String filteredStatus) {
            this.filteredStatus = filteredStatus;
        }

        @Override
        public final Builder filteredStatus(String filteredStatus) {
            this.filteredStatus = filteredStatus;
            return this;
        }

        @Override
        public final Builder filteredStatus(SubscriptionStatus filteredStatus) {
            this.filteredStatus(filteredStatus == null ? null : filteredStatus.toString());
            return this;
        }

        public final TopicFilter.Builder getTopicFilter() {
            return this.topicFilter != null ? this.topicFilter.toBuilder() : null;
        }

        public final void setTopicFilter(TopicFilter.BuilderImpl topicFilter) {
            this.topicFilter = topicFilter != null ? topicFilter.build() : null;
        }

        @Override
        public final Builder topicFilter(TopicFilter topicFilter) {
            this.topicFilter = topicFilter;
            return this;
        }

        public ListContactsFilter build() {
            return new ListContactsFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListContactsFilter> {
        public Builder filteredStatus(String var1);

        public Builder filteredStatus(SubscriptionStatus var1);

        public Builder topicFilter(TopicFilter var1);

        default public Builder topicFilter(Consumer<TopicFilter.Builder> topicFilter) {
            return this.topicFilter((TopicFilter)((TopicFilter.Builder)TopicFilter.builder().applyMutation(topicFilter)).build());
        }
    }
}

