/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.MetricDataError;
import software.amazon.awssdk.services.sesv2.model.MetricDataErrorListCopier;
import software.amazon.awssdk.services.sesv2.model.MetricDataResult;
import software.amazon.awssdk.services.sesv2.model.MetricDataResultListCopier;
import software.amazon.awssdk.services.sesv2.model.SesV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetMetricDataResponse
extends SesV2Response
implements ToCopyableBuilder<Builder, BatchGetMetricDataResponse> {
    private static final SdkField<List<MetricDataResult>> RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Results").getter(BatchGetMetricDataResponse.getter(BatchGetMetricDataResponse::results)).setter(BatchGetMetricDataResponse.setter(Builder::results)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDataResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MetricDataError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(BatchGetMetricDataResponse.getter(BatchGetMetricDataResponse::errors)).setter(BatchGetMetricDataResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDataError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetMetricDataResponse.memberNameToFieldInitializer();
    private final List<MetricDataResult> results;
    private final List<MetricDataError> errors;

    private BatchGetMetricDataResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.errors = builder.errors;
    }

    public final boolean hasResults() {
        return this.results != null && !(this.results instanceof SdkAutoConstructList);
    }

    public final List<MetricDataResult> results() {
        return this.results;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<MetricDataError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResults() ? this.results() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetMetricDataResponse)) {
            return false;
        }
        BatchGetMetricDataResponse other = (BatchGetMetricDataResponse)((Object)obj);
        return this.hasResults() == other.hasResults() && Objects.equals(this.results(), other.results()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetMetricDataResponse").add("Results", this.hasResults() ? this.results() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Results": {
                return Optional.ofNullable(clazz.cast(this.results()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Results", RESULTS_FIELD);
        map.put("Errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetMetricDataResponse, T> g) {
        return obj -> g.apply((BatchGetMetricDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Response.BuilderImpl
    implements Builder {
        private List<MetricDataResult> results = DefaultSdkAutoConstructList.getInstance();
        private List<MetricDataError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetMetricDataResponse model) {
            super(model);
            this.results(model.results);
            this.errors(model.errors);
        }

        public final List<MetricDataResult.Builder> getResults() {
            List<MetricDataResult.Builder> result = MetricDataResultListCopier.copyToBuilder(this.results);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResults(Collection<MetricDataResult.BuilderImpl> results) {
            this.results = MetricDataResultListCopier.copyFromBuilder(results);
        }

        @Override
        public final Builder results(Collection<MetricDataResult> results) {
            this.results = MetricDataResultListCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(MetricDataResult ... results) {
            this.results(Arrays.asList(results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Consumer<MetricDataResult.Builder> ... results) {
            this.results(Stream.of(results).map(c -> (MetricDataResult)((MetricDataResult.Builder)MetricDataResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MetricDataError.Builder> getErrors() {
            List<MetricDataError.Builder> result = MetricDataErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<MetricDataError.BuilderImpl> errors) {
            this.errors = MetricDataErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<MetricDataError> errors) {
            this.errors = MetricDataErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(MetricDataError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<MetricDataError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (MetricDataError)((MetricDataError.Builder)MetricDataError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetMetricDataResponse build() {
            return new BatchGetMetricDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SesV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetMetricDataResponse> {
        public Builder results(Collection<MetricDataResult> var1);

        public Builder results(MetricDataResult ... var1);

        public Builder results(Consumer<MetricDataResult.Builder> ... var1);

        public Builder errors(Collection<MetricDataError> var1);

        public Builder errors(MetricDataError ... var1);

        public Builder errors(Consumer<MetricDataError.Builder> ... var1);
    }
}

