/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.DkimSigningAttributesOrigin;
import software.amazon.awssdk.services.sesv2.model.DkimSigningKeyLength;
import software.amazon.awssdk.services.sesv2.model.DkimStatus;
import software.amazon.awssdk.services.sesv2.model.DnsTokenListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DkimAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DkimAttributes> {
    private static final SdkField<Boolean> SIGNING_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SigningEnabled").getter(DkimAttributes.getter(DkimAttributes::signingEnabled)).setter(DkimAttributes.setter(Builder::signingEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningEnabled").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DkimAttributes.getter(DkimAttributes::statusAsString)).setter(DkimAttributes.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<String>> TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tokens").getter(DkimAttributes.getter(DkimAttributes::tokens)).setter(DkimAttributes.setter(Builder::tokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tokens").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SIGNING_ATTRIBUTES_ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SigningAttributesOrigin").getter(DkimAttributes.getter(DkimAttributes::signingAttributesOriginAsString)).setter(DkimAttributes.setter(Builder::signingAttributesOrigin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningAttributesOrigin").build()}).build();
    private static final SdkField<String> NEXT_SIGNING_KEY_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextSigningKeyLength").getter(DkimAttributes.getter(DkimAttributes::nextSigningKeyLengthAsString)).setter(DkimAttributes.setter(Builder::nextSigningKeyLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextSigningKeyLength").build()}).build();
    private static final SdkField<String> CURRENT_SIGNING_KEY_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentSigningKeyLength").getter(DkimAttributes.getter(DkimAttributes::currentSigningKeyLengthAsString)).setter(DkimAttributes.setter(Builder::currentSigningKeyLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentSigningKeyLength").build()}).build();
    private static final SdkField<Instant> LAST_KEY_GENERATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastKeyGenerationTimestamp").getter(DkimAttributes.getter(DkimAttributes::lastKeyGenerationTimestamp)).setter(DkimAttributes.setter(Builder::lastKeyGenerationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastKeyGenerationTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNING_ENABLED_FIELD, STATUS_FIELD, TOKENS_FIELD, SIGNING_ATTRIBUTES_ORIGIN_FIELD, NEXT_SIGNING_KEY_LENGTH_FIELD, CURRENT_SIGNING_KEY_LENGTH_FIELD, LAST_KEY_GENERATION_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DkimAttributes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean signingEnabled;
    private final String status;
    private final List<String> tokens;
    private final String signingAttributesOrigin;
    private final String nextSigningKeyLength;
    private final String currentSigningKeyLength;
    private final Instant lastKeyGenerationTimestamp;

    private DkimAttributes(BuilderImpl builder) {
        this.signingEnabled = builder.signingEnabled;
        this.status = builder.status;
        this.tokens = builder.tokens;
        this.signingAttributesOrigin = builder.signingAttributesOrigin;
        this.nextSigningKeyLength = builder.nextSigningKeyLength;
        this.currentSigningKeyLength = builder.currentSigningKeyLength;
        this.lastKeyGenerationTimestamp = builder.lastKeyGenerationTimestamp;
    }

    public final Boolean signingEnabled() {
        return this.signingEnabled;
    }

    public final DkimStatus status() {
        return DkimStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTokens() {
        return this.tokens != null && !(this.tokens instanceof SdkAutoConstructList);
    }

    public final List<String> tokens() {
        return this.tokens;
    }

    public final DkimSigningAttributesOrigin signingAttributesOrigin() {
        return DkimSigningAttributesOrigin.fromValue(this.signingAttributesOrigin);
    }

    public final String signingAttributesOriginAsString() {
        return this.signingAttributesOrigin;
    }

    public final DkimSigningKeyLength nextSigningKeyLength() {
        return DkimSigningKeyLength.fromValue(this.nextSigningKeyLength);
    }

    public final String nextSigningKeyLengthAsString() {
        return this.nextSigningKeyLength;
    }

    public final DkimSigningKeyLength currentSigningKeyLength() {
        return DkimSigningKeyLength.fromValue(this.currentSigningKeyLength);
    }

    public final String currentSigningKeyLengthAsString() {
        return this.currentSigningKeyLength;
    }

    public final Instant lastKeyGenerationTimestamp() {
        return this.lastKeyGenerationTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.signingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTokens() ? this.tokens() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.signingAttributesOriginAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextSigningKeyLengthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentSigningKeyLengthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastKeyGenerationTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DkimAttributes)) {
            return false;
        }
        DkimAttributes other = (DkimAttributes)obj;
        return Objects.equals(this.signingEnabled(), other.signingEnabled()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTokens() == other.hasTokens() && Objects.equals(this.tokens(), other.tokens()) && Objects.equals(this.signingAttributesOriginAsString(), other.signingAttributesOriginAsString()) && Objects.equals(this.nextSigningKeyLengthAsString(), other.nextSigningKeyLengthAsString()) && Objects.equals(this.currentSigningKeyLengthAsString(), other.currentSigningKeyLengthAsString()) && Objects.equals(this.lastKeyGenerationTimestamp(), other.lastKeyGenerationTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"DkimAttributes").add("SigningEnabled", (Object)this.signingEnabled()).add("Status", (Object)this.statusAsString()).add("Tokens", this.hasTokens() ? this.tokens() : null).add("SigningAttributesOrigin", (Object)this.signingAttributesOriginAsString()).add("NextSigningKeyLength", (Object)this.nextSigningKeyLengthAsString()).add("CurrentSigningKeyLength", (Object)this.currentSigningKeyLengthAsString()).add("LastKeyGenerationTimestamp", (Object)this.lastKeyGenerationTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SigningEnabled": {
                return Optional.ofNullable(clazz.cast(this.signingEnabled()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Tokens": {
                return Optional.ofNullable(clazz.cast(this.tokens()));
            }
            case "SigningAttributesOrigin": {
                return Optional.ofNullable(clazz.cast(this.signingAttributesOriginAsString()));
            }
            case "NextSigningKeyLength": {
                return Optional.ofNullable(clazz.cast(this.nextSigningKeyLengthAsString()));
            }
            case "CurrentSigningKeyLength": {
                return Optional.ofNullable(clazz.cast(this.currentSigningKeyLengthAsString()));
            }
            case "LastKeyGenerationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastKeyGenerationTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SigningEnabled", SIGNING_ENABLED_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Tokens", TOKENS_FIELD);
        map.put("SigningAttributesOrigin", SIGNING_ATTRIBUTES_ORIGIN_FIELD);
        map.put("NextSigningKeyLength", NEXT_SIGNING_KEY_LENGTH_FIELD);
        map.put("CurrentSigningKeyLength", CURRENT_SIGNING_KEY_LENGTH_FIELD);
        map.put("LastKeyGenerationTimestamp", LAST_KEY_GENERATION_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DkimAttributes, T> g) {
        return obj -> g.apply((DkimAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean signingEnabled;
        private String status;
        private List<String> tokens = DefaultSdkAutoConstructList.getInstance();
        private String signingAttributesOrigin;
        private String nextSigningKeyLength;
        private String currentSigningKeyLength;
        private Instant lastKeyGenerationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(DkimAttributes model) {
            this.signingEnabled(model.signingEnabled);
            this.status(model.status);
            this.tokens(model.tokens);
            this.signingAttributesOrigin(model.signingAttributesOrigin);
            this.nextSigningKeyLength(model.nextSigningKeyLength);
            this.currentSigningKeyLength(model.currentSigningKeyLength);
            this.lastKeyGenerationTimestamp(model.lastKeyGenerationTimestamp);
        }

        public final Boolean getSigningEnabled() {
            return this.signingEnabled;
        }

        public final void setSigningEnabled(Boolean signingEnabled) {
            this.signingEnabled = signingEnabled;
        }

        @Override
        public final Builder signingEnabled(Boolean signingEnabled) {
            this.signingEnabled = signingEnabled;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DkimStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getTokens() {
            if (this.tokens instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tokens;
        }

        public final void setTokens(Collection<String> tokens) {
            this.tokens = DnsTokenListCopier.copy(tokens);
        }

        @Override
        public final Builder tokens(Collection<String> tokens) {
            this.tokens = DnsTokenListCopier.copy(tokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tokens(String ... tokens) {
            this.tokens(Arrays.asList(tokens));
            return this;
        }

        public final String getSigningAttributesOrigin() {
            return this.signingAttributesOrigin;
        }

        public final void setSigningAttributesOrigin(String signingAttributesOrigin) {
            this.signingAttributesOrigin = signingAttributesOrigin;
        }

        @Override
        public final Builder signingAttributesOrigin(String signingAttributesOrigin) {
            this.signingAttributesOrigin = signingAttributesOrigin;
            return this;
        }

        @Override
        public final Builder signingAttributesOrigin(DkimSigningAttributesOrigin signingAttributesOrigin) {
            this.signingAttributesOrigin(signingAttributesOrigin == null ? null : signingAttributesOrigin.toString());
            return this;
        }

        public final String getNextSigningKeyLength() {
            return this.nextSigningKeyLength;
        }

        public final void setNextSigningKeyLength(String nextSigningKeyLength) {
            this.nextSigningKeyLength = nextSigningKeyLength;
        }

        @Override
        public final Builder nextSigningKeyLength(String nextSigningKeyLength) {
            this.nextSigningKeyLength = nextSigningKeyLength;
            return this;
        }

        @Override
        public final Builder nextSigningKeyLength(DkimSigningKeyLength nextSigningKeyLength) {
            this.nextSigningKeyLength(nextSigningKeyLength == null ? null : nextSigningKeyLength.toString());
            return this;
        }

        public final String getCurrentSigningKeyLength() {
            return this.currentSigningKeyLength;
        }

        public final void setCurrentSigningKeyLength(String currentSigningKeyLength) {
            this.currentSigningKeyLength = currentSigningKeyLength;
        }

        @Override
        public final Builder currentSigningKeyLength(String currentSigningKeyLength) {
            this.currentSigningKeyLength = currentSigningKeyLength;
            return this;
        }

        @Override
        public final Builder currentSigningKeyLength(DkimSigningKeyLength currentSigningKeyLength) {
            this.currentSigningKeyLength(currentSigningKeyLength == null ? null : currentSigningKeyLength.toString());
            return this;
        }

        public final Instant getLastKeyGenerationTimestamp() {
            return this.lastKeyGenerationTimestamp;
        }

        public final void setLastKeyGenerationTimestamp(Instant lastKeyGenerationTimestamp) {
            this.lastKeyGenerationTimestamp = lastKeyGenerationTimestamp;
        }

        @Override
        public final Builder lastKeyGenerationTimestamp(Instant lastKeyGenerationTimestamp) {
            this.lastKeyGenerationTimestamp = lastKeyGenerationTimestamp;
            return this;
        }

        public DkimAttributes build() {
            return new DkimAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DkimAttributes> {
        public Builder signingEnabled(Boolean var1);

        public Builder status(String var1);

        public Builder status(DkimStatus var1);

        public Builder tokens(Collection<String> var1);

        public Builder tokens(String ... var1);

        public Builder signingAttributesOrigin(String var1);

        public Builder signingAttributesOrigin(DkimSigningAttributesOrigin var1);

        public Builder nextSigningKeyLength(String var1);

        public Builder nextSigningKeyLength(DkimSigningKeyLength var1);

        public Builder currentSigningKeyLength(String var1);

        public Builder currentSigningKeyLength(DkimSigningKeyLength var1);

        public Builder lastKeyGenerationTimestamp(Instant var1);
    }
}

