/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataQueriesCopier;
import software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataQuery;
import software.amazon.awssdk.services.sesv2.model.SesV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetMetricDataRequest
extends SesV2Request
implements ToCopyableBuilder<Builder, BatchGetMetricDataRequest> {
    private static final SdkField<List<BatchGetMetricDataQuery>> QUERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Queries").getter(BatchGetMetricDataRequest.getter(BatchGetMetricDataRequest::queries)).setter(BatchGetMetricDataRequest.setter(Builder::queries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Queries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetMetricDataQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetMetricDataRequest.memberNameToFieldInitializer();
    private final List<BatchGetMetricDataQuery> queries;

    private BatchGetMetricDataRequest(BuilderImpl builder) {
        super(builder);
        this.queries = builder.queries;
    }

    public final boolean hasQueries() {
        return this.queries != null && !(this.queries instanceof SdkAutoConstructList);
    }

    public final List<BatchGetMetricDataQuery> queries() {
        return this.queries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueries() ? this.queries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetMetricDataRequest)) {
            return false;
        }
        BatchGetMetricDataRequest other = (BatchGetMetricDataRequest)((Object)obj);
        return this.hasQueries() == other.hasQueries() && Objects.equals(this.queries(), other.queries());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetMetricDataRequest").add("Queries", this.hasQueries() ? this.queries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Queries": {
                return Optional.ofNullable(clazz.cast(this.queries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<BatchGetMetricDataQuery>>> map = new HashMap<String, SdkField<List<BatchGetMetricDataQuery>>>();
        map.put("Queries", QUERIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetMetricDataRequest, T> g) {
        return obj -> g.apply((BatchGetMetricDataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Request.BuilderImpl
    implements Builder {
        private List<BatchGetMetricDataQuery> queries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetMetricDataRequest model) {
            super(model);
            this.queries(model.queries);
        }

        public final List<BatchGetMetricDataQuery.Builder> getQueries() {
            List<BatchGetMetricDataQuery.Builder> result = BatchGetMetricDataQueriesCopier.copyToBuilder(this.queries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueries(Collection<BatchGetMetricDataQuery.BuilderImpl> queries) {
            this.queries = BatchGetMetricDataQueriesCopier.copyFromBuilder(queries);
        }

        @Override
        public final Builder queries(Collection<BatchGetMetricDataQuery> queries) {
            this.queries = BatchGetMetricDataQueriesCopier.copy(queries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(BatchGetMetricDataQuery ... queries) {
            this.queries(Arrays.asList(queries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(Consumer<BatchGetMetricDataQuery.Builder> ... queries) {
            this.queries(Stream.of(queries).map(c -> (BatchGetMetricDataQuery)((BatchGetMetricDataQuery.Builder)BatchGetMetricDataQuery.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetMetricDataRequest build() {
            return new BatchGetMetricDataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SesV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetMetricDataRequest> {
        public Builder queries(Collection<BatchGetMetricDataQuery> var1);

        public Builder queries(BatchGetMetricDataQuery ... var1);

        public Builder queries(Consumer<BatchGetMetricDataQuery.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

