/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.SesV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutDedicatedIpInPoolRequest
extends SesV2Request
implements ToCopyableBuilder<Builder, PutDedicatedIpInPoolRequest> {
    private static final SdkField<String> IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ip").getter(PutDedicatedIpInPoolRequest.getter(PutDedicatedIpInPoolRequest::ip)).setter(PutDedicatedIpInPoolRequest.setter(Builder::ip)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("IP").build()}).build();
    private static final SdkField<String> DESTINATION_POOL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationPoolName").getter(PutDedicatedIpInPoolRequest.getter(PutDedicatedIpInPoolRequest::destinationPoolName)).setter(PutDedicatedIpInPoolRequest.setter(Builder::destinationPoolName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPoolName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_FIELD, DESTINATION_POOL_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutDedicatedIpInPoolRequest.memberNameToFieldInitializer();
    private final String ip;
    private final String destinationPoolName;

    private PutDedicatedIpInPoolRequest(BuilderImpl builder) {
        super(builder);
        this.ip = builder.ip;
        this.destinationPoolName = builder.destinationPoolName;
    }

    public final String ip() {
        return this.ip;
    }

    public final String destinationPoolName() {
        return this.destinationPoolName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ip());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPoolName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDedicatedIpInPoolRequest)) {
            return false;
        }
        PutDedicatedIpInPoolRequest other = (PutDedicatedIpInPoolRequest)((Object)obj);
        return Objects.equals(this.ip(), other.ip()) && Objects.equals(this.destinationPoolName(), other.destinationPoolName());
    }

    public final String toString() {
        return ToString.builder((String)"PutDedicatedIpInPoolRequest").add("Ip", (Object)this.ip()).add("DestinationPoolName", (Object)this.destinationPoolName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ip": {
                return Optional.ofNullable(clazz.cast(this.ip()));
            }
            case "DestinationPoolName": {
                return Optional.ofNullable(clazz.cast(this.destinationPoolName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("IP", IP_FIELD);
        map.put("DestinationPoolName", DESTINATION_POOL_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutDedicatedIpInPoolRequest, T> g) {
        return obj -> g.apply((PutDedicatedIpInPoolRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Request.BuilderImpl
    implements Builder {
        private String ip;
        private String destinationPoolName;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDedicatedIpInPoolRequest model) {
            super(model);
            this.ip(model.ip);
            this.destinationPoolName(model.destinationPoolName);
        }

        public final String getIp() {
            return this.ip;
        }

        public final void setIp(String ip) {
            this.ip = ip;
        }

        @Override
        public final Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public final String getDestinationPoolName() {
            return this.destinationPoolName;
        }

        public final void setDestinationPoolName(String destinationPoolName) {
            this.destinationPoolName = destinationPoolName;
        }

        @Override
        public final Builder destinationPoolName(String destinationPoolName) {
            this.destinationPoolName = destinationPoolName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDedicatedIpInPoolRequest build() {
            return new PutDedicatedIpInPoolRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SesV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutDedicatedIpInPoolRequest> {
        public Builder ip(String var1);

        public Builder destinationPoolName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

