/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2Client;
import software.amazon.awssdk.services.sesv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.sesv2.model.ListMultiRegionEndpointsRequest;
import software.amazon.awssdk.services.sesv2.model.ListMultiRegionEndpointsResponse;
import software.amazon.awssdk.services.sesv2.model.MultiRegionEndpoint;

public class ListMultiRegionEndpointsIterable
implements SdkIterable<ListMultiRegionEndpointsResponse> {
    private final SesV2Client client;
    private final ListMultiRegionEndpointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMultiRegionEndpointsIterable(SesV2Client client, ListMultiRegionEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMultiRegionEndpointsResponseFetcher();
    }

    public Iterator<ListMultiRegionEndpointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MultiRegionEndpoint> multiRegionEndpoints() {
        Function<ListMultiRegionEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.multiRegionEndpoints() != null) {
                return response.multiRegionEndpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMultiRegionEndpointsResponseFetcher
    implements SyncPageFetcher<ListMultiRegionEndpointsResponse> {
        private ListMultiRegionEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListMultiRegionEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMultiRegionEndpointsResponse nextPage(ListMultiRegionEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListMultiRegionEndpointsIterable.this.client.listMultiRegionEndpoints(ListMultiRegionEndpointsIterable.this.firstRequest);
            }
            return ListMultiRegionEndpointsIterable.this.client.listMultiRegionEndpoints((ListMultiRegionEndpointsRequest)((Object)ListMultiRegionEndpointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

