/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.BounceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Bounce
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Bounce> {
    private static final SdkField<String> BOUNCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BounceType").getter(Bounce.getter(Bounce::bounceTypeAsString)).setter(Bounce.setter(Builder::bounceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BounceType").build()}).build();
    private static final SdkField<String> BOUNCE_SUB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BounceSubType").getter(Bounce.getter(Bounce::bounceSubType)).setter(Bounce.setter(Builder::bounceSubType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BounceSubType").build()}).build();
    private static final SdkField<String> DIAGNOSTIC_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiagnosticCode").getter(Bounce.getter(Bounce::diagnosticCode)).setter(Bounce.setter(Builder::diagnosticCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiagnosticCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOUNCE_TYPE_FIELD, BOUNCE_SUB_TYPE_FIELD, DIAGNOSTIC_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Bounce.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String bounceType;
    private final String bounceSubType;
    private final String diagnosticCode;

    private Bounce(BuilderImpl builder) {
        this.bounceType = builder.bounceType;
        this.bounceSubType = builder.bounceSubType;
        this.diagnosticCode = builder.diagnosticCode;
    }

    public final BounceType bounceType() {
        return BounceType.fromValue(this.bounceType);
    }

    public final String bounceTypeAsString() {
        return this.bounceType;
    }

    public final String bounceSubType() {
        return this.bounceSubType;
    }

    public final String diagnosticCode() {
        return this.diagnosticCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bounceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bounceSubType());
        hashCode = 31 * hashCode + Objects.hashCode(this.diagnosticCode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Bounce)) {
            return false;
        }
        Bounce other = (Bounce)obj;
        return Objects.equals(this.bounceTypeAsString(), other.bounceTypeAsString()) && Objects.equals(this.bounceSubType(), other.bounceSubType()) && Objects.equals(this.diagnosticCode(), other.diagnosticCode());
    }

    public final String toString() {
        return ToString.builder((String)"Bounce").add("BounceType", (Object)this.bounceTypeAsString()).add("BounceSubType", (Object)this.bounceSubType()).add("DiagnosticCode", (Object)this.diagnosticCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BounceType": {
                return Optional.ofNullable(clazz.cast(this.bounceTypeAsString()));
            }
            case "BounceSubType": {
                return Optional.ofNullable(clazz.cast(this.bounceSubType()));
            }
            case "DiagnosticCode": {
                return Optional.ofNullable(clazz.cast(this.diagnosticCode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("BounceType", BOUNCE_TYPE_FIELD);
        map.put("BounceSubType", BOUNCE_SUB_TYPE_FIELD);
        map.put("DiagnosticCode", DIAGNOSTIC_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Bounce, T> g) {
        return obj -> g.apply((Bounce)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bounceType;
        private String bounceSubType;
        private String diagnosticCode;

        private BuilderImpl() {
        }

        private BuilderImpl(Bounce model) {
            this.bounceType(model.bounceType);
            this.bounceSubType(model.bounceSubType);
            this.diagnosticCode(model.diagnosticCode);
        }

        public final String getBounceType() {
            return this.bounceType;
        }

        public final void setBounceType(String bounceType) {
            this.bounceType = bounceType;
        }

        @Override
        public final Builder bounceType(String bounceType) {
            this.bounceType = bounceType;
            return this;
        }

        @Override
        public final Builder bounceType(BounceType bounceType) {
            this.bounceType(bounceType == null ? null : bounceType.toString());
            return this;
        }

        public final String getBounceSubType() {
            return this.bounceSubType;
        }

        public final void setBounceSubType(String bounceSubType) {
            this.bounceSubType = bounceSubType;
        }

        @Override
        public final Builder bounceSubType(String bounceSubType) {
            this.bounceSubType = bounceSubType;
            return this;
        }

        public final String getDiagnosticCode() {
            return this.diagnosticCode;
        }

        public final void setDiagnosticCode(String diagnosticCode) {
            this.diagnosticCode = diagnosticCode;
        }

        @Override
        public final Builder diagnosticCode(String diagnosticCode) {
            this.diagnosticCode = diagnosticCode;
            return this;
        }

        public Bounce build() {
            return new Bounce(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Bounce> {
        public Builder bounceType(String var1);

        public Builder bounceType(BounceType var1);

        public Builder bounceSubType(String var1);

        public Builder diagnosticCode(String var1);
    }
}

