/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to associate a configuration set with a MailManager archive.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutConfigurationSetArchivingOptionsRequest extends SesV2Request implements
        ToCopyableBuilder<PutConfigurationSetArchivingOptionsRequest.Builder, PutConfigurationSetArchivingOptionsRequest> {
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSetName").getter(getter(PutConfigurationSetArchivingOptionsRequest::configurationSetName))
            .setter(setter(Builder::configurationSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConfigurationSetName").build()).build();

    private static final SdkField<String> ARCHIVE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArchiveArn").getter(getter(PutConfigurationSetArchivingOptionsRequest::archiveArn))
            .setter(setter(Builder::archiveArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_NAME_FIELD,
            ARCHIVE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String configurationSetName;

    private final String archiveArn;

    private PutConfigurationSetArchivingOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.archiveArn = builder.archiveArn;
    }

    /**
     * <p>
     * The name of the configuration set to associate with a MailManager archive.
     * </p>
     * 
     * @return The name of the configuration set to associate with a MailManager archive.
     */
    public final String configurationSetName() {
        return configurationSetName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the MailManager archive that the Amazon SES API v2 sends email to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the MailManager archive that the Amazon SES API v2 sends email to.
     */
    public final String archiveArn() {
        return archiveArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(archiveArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutConfigurationSetArchivingOptionsRequest)) {
            return false;
        }
        PutConfigurationSetArchivingOptionsRequest other = (PutConfigurationSetArchivingOptionsRequest) obj;
        return Objects.equals(configurationSetName(), other.configurationSetName())
                && Objects.equals(archiveArn(), other.archiveArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutConfigurationSetArchivingOptionsRequest").add("ConfigurationSetName", configurationSetName())
                .add("ArchiveArn", archiveArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSetName":
            return Optional.ofNullable(clazz.cast(configurationSetName()));
        case "ArchiveArn":
            return Optional.ofNullable(clazz.cast(archiveArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConfigurationSetName", CONFIGURATION_SET_NAME_FIELD);
        map.put("ArchiveArn", ARCHIVE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutConfigurationSetArchivingOptionsRequest, T> g) {
        return obj -> g.apply((PutConfigurationSetArchivingOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, PutConfigurationSetArchivingOptionsRequest> {
        /**
         * <p>
         * The name of the configuration set to associate with a MailManager archive.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the configuration set to associate with a MailManager archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the MailManager archive that the Amazon SES API v2 sends email to.
         * </p>
         * 
         * @param archiveArn
         *        The Amazon Resource Name (ARN) of the MailManager archive that the Amazon SES API v2 sends email to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveArn(String archiveArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private String configurationSetName;

        private String archiveArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PutConfigurationSetArchivingOptionsRequest model) {
            super(model);
            configurationSetName(model.configurationSetName);
            archiveArn(model.archiveArn);
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final String getArchiveArn() {
            return archiveArn;
        }

        public final void setArchiveArn(String archiveArn) {
            this.archiveArn = archiveArn;
        }

        @Override
        public final Builder archiveArn(String archiveArn) {
            this.archiveArn = archiveArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutConfigurationSetArchivingOptionsRequest build() {
            return new PutConfigurationSetArchivingOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
