/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains details about the data source for the metrics export.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricsDataSource implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricsDataSource.Builder, MetricsDataSource> {
    private static final SdkField<Map<String, List<String>>> DIMENSIONS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("Dimensions")
            .getter(getter(MetricsDataSource::dimensionsAsStrings))
            .setter(setter(Builder::dimensionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(MetricsDataSource::namespaceAsString)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()).build();

    private static final SdkField<List<ExportMetric>> METRICS_FIELD = SdkField
            .<List<ExportMetric>> builder(MarshallingType.LIST)
            .memberName("Metrics")
            .getter(getter(MetricsDataSource::metrics))
            .setter(setter(Builder::metrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExportMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExportMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartDate").getter(getter(MetricsDataSource::startDate)).setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()).build();

    private static final SdkField<Instant> END_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndDate").getter(getter(MetricsDataSource::endDate)).setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD,
            NAMESPACE_FIELD, METRICS_FIELD, START_DATE_FIELD, END_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, List<String>> dimensions;

    private final String namespace;

    private final List<ExportMetric> metrics;

    private final Instant startDate;

    private final Instant endDate;

    private MetricsDataSource(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.namespace = builder.namespace;
        this.metrics = builder.metrics;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
    }

    /**
     * <p>
     * An object that contains a mapping between a <code>MetricDimensionName</code> and
     * <code>MetricDimensionValue</code> to filter metrics by. Must contain a least 1 dimension but no more than 3
     * unique ones.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensions} method.
     * </p>
     * 
     * @return An object that contains a mapping between a <code>MetricDimensionName</code> and
     *         <code>MetricDimensionValue</code> to filter metrics by. Must contain a least 1 dimension but no more than
     *         3 unique ones.
     */
    public final Map<MetricDimensionName, List<String>> dimensions() {
        return ExportDimensionsCopier.copyStringToEnum(dimensions);
    }

    /**
     * For responses, this returns true if the service returned a value for the Dimensions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDimensions() {
        return dimensions != null && !(dimensions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An object that contains a mapping between a <code>MetricDimensionName</code> and
     * <code>MetricDimensionValue</code> to filter metrics by. Must contain a least 1 dimension but no more than 3
     * unique ones.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensions} method.
     * </p>
     * 
     * @return An object that contains a mapping between a <code>MetricDimensionName</code> and
     *         <code>MetricDimensionValue</code> to filter metrics by. Must contain a least 1 dimension but no more than
     *         3 unique ones.
     */
    public final Map<String, List<String>> dimensionsAsStrings() {
        return dimensions;
    }

    /**
     * <p>
     * The metrics namespace - e.g., <code>VDM</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #namespace} will
     * return {@link MetricNamespace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #namespaceAsString}.
     * </p>
     * 
     * @return The metrics namespace - e.g., <code>VDM</code>.
     * @see MetricNamespace
     */
    public final MetricNamespace namespace() {
        return MetricNamespace.fromValue(namespace);
    }

    /**
     * <p>
     * The metrics namespace - e.g., <code>VDM</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #namespace} will
     * return {@link MetricNamespace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #namespaceAsString}.
     * </p>
     * 
     * @return The metrics namespace - e.g., <code>VDM</code>.
     * @see MetricNamespace
     */
    public final String namespaceAsString() {
        return namespace;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metrics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetrics() {
        return metrics != null && !(metrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>ExportMetric</code> objects to export.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetrics} method.
     * </p>
     * 
     * @return A list of <code>ExportMetric</code> objects to export.
     */
    public final List<ExportMetric> metrics() {
        return metrics;
    }

    /**
     * <p>
     * Represents the start date for the export interval as a timestamp.
     * </p>
     * 
     * @return Represents the start date for the export interval as a timestamp.
     */
    public final Instant startDate() {
        return startDate;
    }

    /**
     * <p>
     * Represents the end date for the export interval as a timestamp.
     * </p>
     * 
     * @return Represents the end date for the export interval as a timestamp.
     */
    public final Instant endDate() {
        return endDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensions() ? dimensionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(namespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetrics() ? metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricsDataSource)) {
            return false;
        }
        MetricsDataSource other = (MetricsDataSource) obj;
        return hasDimensions() == other.hasDimensions() && Objects.equals(dimensionsAsStrings(), other.dimensionsAsStrings())
                && Objects.equals(namespaceAsString(), other.namespaceAsString()) && hasMetrics() == other.hasMetrics()
                && Objects.equals(metrics(), other.metrics()) && Objects.equals(startDate(), other.startDate())
                && Objects.equals(endDate(), other.endDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricsDataSource").add("Dimensions", hasDimensions() ? dimensionsAsStrings() : null)
                .add("Namespace", namespaceAsString()).add("Metrics", hasMetrics() ? metrics() : null)
                .add("StartDate", startDate()).add("EndDate", endDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensionsAsStrings()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespaceAsString()));
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "StartDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "EndDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Dimensions", DIMENSIONS_FIELD);
        map.put("Namespace", NAMESPACE_FIELD);
        map.put("Metrics", METRICS_FIELD);
        map.put("StartDate", START_DATE_FIELD);
        map.put("EndDate", END_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricsDataSource, T> g) {
        return obj -> g.apply((MetricsDataSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricsDataSource> {
        /**
         * <p>
         * An object that contains a mapping between a <code>MetricDimensionName</code> and
         * <code>MetricDimensionValue</code> to filter metrics by. Must contain a least 1 dimension but no more than 3
         * unique ones.
         * </p>
         * 
         * @param dimensions
         *        An object that contains a mapping between a <code>MetricDimensionName</code> and
         *        <code>MetricDimensionValue</code> to filter metrics by. Must contain a least 1 dimension but no more
         *        than 3 unique ones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionsWithStrings(Map<String, ? extends Collection<String>> dimensions);

        /**
         * <p>
         * An object that contains a mapping between a <code>MetricDimensionName</code> and
         * <code>MetricDimensionValue</code> to filter metrics by. Must contain a least 1 dimension but no more than 3
         * unique ones.
         * </p>
         * 
         * @param dimensions
         *        An object that contains a mapping between a <code>MetricDimensionName</code> and
         *        <code>MetricDimensionValue</code> to filter metrics by. Must contain a least 1 dimension but no more
         *        than 3 unique ones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Map<MetricDimensionName, ? extends Collection<String>> dimensions);

        /**
         * <p>
         * The metrics namespace - e.g., <code>VDM</code>.
         * </p>
         * 
         * @param namespace
         *        The metrics namespace - e.g., <code>VDM</code>.
         * @see MetricNamespace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricNamespace
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The metrics namespace - e.g., <code>VDM</code>.
         * </p>
         * 
         * @param namespace
         *        The metrics namespace - e.g., <code>VDM</code>.
         * @see MetricNamespace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricNamespace
         */
        Builder namespace(MetricNamespace namespace);

        /**
         * <p>
         * A list of <code>ExportMetric</code> objects to export.
         * </p>
         * 
         * @param metrics
         *        A list of <code>ExportMetric</code> objects to export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Collection<ExportMetric> metrics);

        /**
         * <p>
         * A list of <code>ExportMetric</code> objects to export.
         * </p>
         * 
         * @param metrics
         *        A list of <code>ExportMetric</code> objects to export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(ExportMetric... metrics);

        /**
         * <p>
         * A list of <code>ExportMetric</code> objects to export.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sesv2.model.ExportMetric.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sesv2.model.ExportMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sesv2.model.ExportMetric.Builder#build()} is called immediately and
         * its result is passed to {@link #metrics(List<ExportMetric>)}.
         * 
         * @param metrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sesv2.model.ExportMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metrics(java.util.Collection<ExportMetric>)
         */
        Builder metrics(Consumer<ExportMetric.Builder>... metrics);

        /**
         * <p>
         * Represents the start date for the export interval as a timestamp.
         * </p>
         * 
         * @param startDate
         *        Represents the start date for the export interval as a timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <p>
         * Represents the end date for the export interval as a timestamp.
         * </p>
         * 
         * @param endDate
         *        Represents the end date for the export interval as a timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(Instant endDate);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, List<String>> dimensions = DefaultSdkAutoConstructMap.getInstance();

        private String namespace;

        private List<ExportMetric> metrics = DefaultSdkAutoConstructList.getInstance();

        private Instant startDate;

        private Instant endDate;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricsDataSource model) {
            dimensionsWithStrings(model.dimensions);
            namespace(model.namespace);
            metrics(model.metrics);
            startDate(model.startDate);
            endDate(model.endDate);
        }

        public final Map<String, ? extends Collection<String>> getDimensions() {
            if (dimensions instanceof SdkAutoConstructMap) {
                return null;
            }
            return dimensions;
        }

        public final void setDimensions(Map<String, ? extends Collection<String>> dimensions) {
            this.dimensions = ExportDimensionsCopier.copy(dimensions);
        }

        @Override
        public final Builder dimensionsWithStrings(Map<String, ? extends Collection<String>> dimensions) {
            this.dimensions = ExportDimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        public final Builder dimensions(Map<MetricDimensionName, ? extends Collection<String>> dimensions) {
            this.dimensions = ExportDimensionsCopier.copyEnumToString(dimensions);
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public final Builder namespace(MetricNamespace namespace) {
            this.namespace(namespace == null ? null : namespace.toString());
            return this;
        }

        public final List<ExportMetric.Builder> getMetrics() {
            List<ExportMetric.Builder> result = ExportMetricsCopier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetrics(Collection<ExportMetric.BuilderImpl> metrics) {
            this.metrics = ExportMetricsCopier.copyFromBuilder(metrics);
        }

        @Override
        public final Builder metrics(Collection<ExportMetric> metrics) {
            this.metrics = ExportMetricsCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(ExportMetric... metrics) {
            metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Consumer<ExportMetric.Builder>... metrics) {
            metrics(Stream.of(metrics).map(c -> ExportMetric.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getStartDate() {
            return startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getEndDate() {
            return endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        @Override
        public MetricsDataSource build() {
            return new MetricsDataSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
