/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an email identity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEmailIdentityResponse extends SesV2Response implements
        ToCopyableBuilder<GetEmailIdentityResponse.Builder, GetEmailIdentityResponse> {
    private static final SdkField<String> IDENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityType").getter(getter(GetEmailIdentityResponse::identityTypeAsString))
            .setter(setter(Builder::identityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityType").build()).build();

    private static final SdkField<Boolean> FEEDBACK_FORWARDING_STATUS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("FeedbackForwardingStatus").getter(getter(GetEmailIdentityResponse::feedbackForwardingStatus))
            .setter(setter(Builder::feedbackForwardingStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackForwardingStatus").build())
            .build();

    private static final SdkField<Boolean> VERIFIED_FOR_SENDING_STATUS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("VerifiedForSendingStatus")
            .getter(getter(GetEmailIdentityResponse::verifiedForSendingStatus)).setter(setter(Builder::verifiedForSendingStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedForSendingStatus").build())
            .build();

    private static final SdkField<DkimAttributes> DKIM_ATTRIBUTES_FIELD = SdkField
            .<DkimAttributes> builder(MarshallingType.SDK_POJO).memberName("DkimAttributes")
            .getter(getter(GetEmailIdentityResponse::dkimAttributes)).setter(setter(Builder::dkimAttributes))
            .constructor(DkimAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DkimAttributes").build()).build();

    private static final SdkField<MailFromAttributes> MAIL_FROM_ATTRIBUTES_FIELD = SdkField
            .<MailFromAttributes> builder(MarshallingType.SDK_POJO).memberName("MailFromAttributes")
            .getter(getter(GetEmailIdentityResponse::mailFromAttributes)).setter(setter(Builder::mailFromAttributes))
            .constructor(MailFromAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailFromAttributes").build())
            .build();

    private static final SdkField<Map<String, String>> POLICIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Policies")
            .getter(getter(GetEmailIdentityResponse::policies))
            .setter(setter(Builder::policies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(GetEmailIdentityResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSetName").getter(getter(GetEmailIdentityResponse::configurationSetName))
            .setter(setter(Builder::configurationSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build())
            .build();

    private static final SdkField<String> VERIFICATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VerificationStatus").getter(getter(GetEmailIdentityResponse::verificationStatusAsString))
            .setter(setter(Builder::verificationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationStatus").build())
            .build();

    private static final SdkField<VerificationInfo> VERIFICATION_INFO_FIELD = SdkField
            .<VerificationInfo> builder(MarshallingType.SDK_POJO).memberName("VerificationInfo")
            .getter(getter(GetEmailIdentityResponse::verificationInfo)).setter(setter(Builder::verificationInfo))
            .constructor(VerificationInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_TYPE_FIELD,
            FEEDBACK_FORWARDING_STATUS_FIELD, VERIFIED_FOR_SENDING_STATUS_FIELD, DKIM_ATTRIBUTES_FIELD,
            MAIL_FROM_ATTRIBUTES_FIELD, POLICIES_FIELD, TAGS_FIELD, CONFIGURATION_SET_NAME_FIELD, VERIFICATION_STATUS_FIELD,
            VERIFICATION_INFO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identityType;

    private final Boolean feedbackForwardingStatus;

    private final Boolean verifiedForSendingStatus;

    private final DkimAttributes dkimAttributes;

    private final MailFromAttributes mailFromAttributes;

    private final Map<String, String> policies;

    private final List<Tag> tags;

    private final String configurationSetName;

    private final String verificationStatus;

    private final VerificationInfo verificationInfo;

    private GetEmailIdentityResponse(BuilderImpl builder) {
        super(builder);
        this.identityType = builder.identityType;
        this.feedbackForwardingStatus = builder.feedbackForwardingStatus;
        this.verifiedForSendingStatus = builder.verifiedForSendingStatus;
        this.dkimAttributes = builder.dkimAttributes;
        this.mailFromAttributes = builder.mailFromAttributes;
        this.policies = builder.policies;
        this.tags = builder.tags;
        this.configurationSetName = builder.configurationSetName;
        this.verificationStatus = builder.verificationStatus;
        this.verificationInfo = builder.verificationInfo;
    }

    /**
     * <p>
     * The email identity type. Note: the <code>MANAGED_DOMAIN</code> identity type is not supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return The email identity type. Note: the <code>MANAGED_DOMAIN</code> identity type is not supported.
     * @see IdentityType
     */
    public final IdentityType identityType() {
        return IdentityType.fromValue(identityType);
    }

    /**
     * <p>
     * The email identity type. Note: the <code>MANAGED_DOMAIN</code> identity type is not supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return The email identity type. Note: the <code>MANAGED_DOMAIN</code> identity type is not supported.
     * @see IdentityType
     */
    public final String identityTypeAsString() {
        return identityType;
    }

    /**
     * <p>
     * The feedback forwarding configuration for the identity.
     * </p>
     * <p>
     * If the value is <code>true</code>, you receive email notifications when bounce or complaint events occur. These
     * notifications are sent to the address that you specified in the <code>Return-Path</code> header of the original
     * email.
     * </p>
     * <p>
     * You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for
     * receiving bounce or complaint notifications (for example, by setting up an event destination), you receive an
     * email notification when these events occur (even if this setting is disabled).
     * </p>
     * 
     * @return The feedback forwarding configuration for the identity.</p>
     *         <p>
     *         If the value is <code>true</code>, you receive email notifications when bounce or complaint events occur.
     *         These notifications are sent to the address that you specified in the <code>Return-Path</code> header of
     *         the original email.
     *         </p>
     *         <p>
     *         You're required to have a method of tracking bounces and complaints. If you haven't set up another
     *         mechanism for receiving bounce or complaint notifications (for example, by setting up an event
     *         destination), you receive an email notification when these events occur (even if this setting is
     *         disabled).
     */
    public final Boolean feedbackForwardingStatus() {
        return feedbackForwardingStatus;
    }

    /**
     * <p>
     * Specifies whether or not the identity is verified. You can only send email from verified email addresses or
     * domains. For more information about verifying identities, see the <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-email-manage-verify.html">Amazon Pinpoint
     * User Guide</a>.
     * </p>
     * 
     * @return Specifies whether or not the identity is verified. You can only send email from verified email addresses
     *         or domains. For more information about verifying identities, see the <a
     *         href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-email-manage-verify.html">Amazon
     *         Pinpoint User Guide</a>.
     */
    public final Boolean verifiedForSendingStatus() {
        return verifiedForSendingStatus;
    }

    /**
     * <p>
     * An object that contains information about the DKIM attributes for the identity.
     * </p>
     * 
     * @return An object that contains information about the DKIM attributes for the identity.
     */
    public final DkimAttributes dkimAttributes() {
        return dkimAttributes;
    }

    /**
     * <p>
     * An object that contains information about the Mail-From attributes for the email identity.
     * </p>
     * 
     * @return An object that contains information about the Mail-From attributes for the email identity.
     */
    public final MailFromAttributes mailFromAttributes() {
        return mailFromAttributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Policies property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPolicies() {
        return policies != null && !(policies instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of policy names to policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicies} method.
     * </p>
     * 
     * @return A map of policy names to policies.
     */
    public final Map<String, String> policies() {
        return policies;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that define the tags (keys and values) that are associated with the email identity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of objects that define the tags (keys and values) that are associated with the email identity.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The configuration set used by default when sending from this identity.
     * </p>
     * 
     * @return The configuration set used by default when sending from this identity.
     */
    public final String configurationSetName() {
        return configurationSetName;
    }

    /**
     * <p>
     * The verification status of the identity. The status can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> – The verification process was initiated, but Amazon SES hasn't yet been able to verify the
     * identity.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCESS</code> – The verification process completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> – The verification process failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES from determining the verification
     * status of the identity.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_STARTED</code> – The verification process hasn't been initiated for the identity.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #verificationStatus} will return {@link VerificationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #verificationStatusAsString}.
     * </p>
     * 
     * @return The verification status of the identity. The status can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> – The verification process was initiated, but Amazon SES hasn't yet been able to
     *         verify the identity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCESS</code> – The verification process completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> – The verification process failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES from determining the
     *         verification status of the identity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_STARTED</code> – The verification process hasn't been initiated for the identity.
     *         </p>
     *         </li>
     * @see VerificationStatus
     */
    public final VerificationStatus verificationStatus() {
        return VerificationStatus.fromValue(verificationStatus);
    }

    /**
     * <p>
     * The verification status of the identity. The status can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> – The verification process was initiated, but Amazon SES hasn't yet been able to verify the
     * identity.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCESS</code> – The verification process completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> – The verification process failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES from determining the verification
     * status of the identity.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_STARTED</code> – The verification process hasn't been initiated for the identity.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #verificationStatus} will return {@link VerificationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #verificationStatusAsString}.
     * </p>
     * 
     * @return The verification status of the identity. The status can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> – The verification process was initiated, but Amazon SES hasn't yet been able to
     *         verify the identity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCESS</code> – The verification process completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> – The verification process failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES from determining the
     *         verification status of the identity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_STARTED</code> – The verification process hasn't been initiated for the identity.
     *         </p>
     *         </li>
     * @see VerificationStatus
     */
    public final String verificationStatusAsString() {
        return verificationStatus;
    }

    /**
     * <p>
     * An object that contains additional information about the verification status for the identity.
     * </p>
     * 
     * @return An object that contains additional information about the verification status for the identity.
     */
    public final VerificationInfo verificationInfo() {
        return verificationInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(feedbackForwardingStatus());
        hashCode = 31 * hashCode + Objects.hashCode(verifiedForSendingStatus());
        hashCode = 31 * hashCode + Objects.hashCode(dkimAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(mailFromAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicies() ? policies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(verificationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(verificationInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEmailIdentityResponse)) {
            return false;
        }
        GetEmailIdentityResponse other = (GetEmailIdentityResponse) obj;
        return Objects.equals(identityTypeAsString(), other.identityTypeAsString())
                && Objects.equals(feedbackForwardingStatus(), other.feedbackForwardingStatus())
                && Objects.equals(verifiedForSendingStatus(), other.verifiedForSendingStatus())
                && Objects.equals(dkimAttributes(), other.dkimAttributes())
                && Objects.equals(mailFromAttributes(), other.mailFromAttributes()) && hasPolicies() == other.hasPolicies()
                && Objects.equals(policies(), other.policies()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(configurationSetName(), other.configurationSetName())
                && Objects.equals(verificationStatusAsString(), other.verificationStatusAsString())
                && Objects.equals(verificationInfo(), other.verificationInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEmailIdentityResponse").add("IdentityType", identityTypeAsString())
                .add("FeedbackForwardingStatus", feedbackForwardingStatus())
                .add("VerifiedForSendingStatus", verifiedForSendingStatus()).add("DkimAttributes", dkimAttributes())
                .add("MailFromAttributes", mailFromAttributes()).add("Policies", hasPolicies() ? policies() : null)
                .add("Tags", hasTags() ? tags() : null).add("ConfigurationSetName", configurationSetName())
                .add("VerificationStatus", verificationStatusAsString()).add("VerificationInfo", verificationInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityType":
            return Optional.ofNullable(clazz.cast(identityTypeAsString()));
        case "FeedbackForwardingStatus":
            return Optional.ofNullable(clazz.cast(feedbackForwardingStatus()));
        case "VerifiedForSendingStatus":
            return Optional.ofNullable(clazz.cast(verifiedForSendingStatus()));
        case "DkimAttributes":
            return Optional.ofNullable(clazz.cast(dkimAttributes()));
        case "MailFromAttributes":
            return Optional.ofNullable(clazz.cast(mailFromAttributes()));
        case "Policies":
            return Optional.ofNullable(clazz.cast(policies()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ConfigurationSetName":
            return Optional.ofNullable(clazz.cast(configurationSetName()));
        case "VerificationStatus":
            return Optional.ofNullable(clazz.cast(verificationStatusAsString()));
        case "VerificationInfo":
            return Optional.ofNullable(clazz.cast(verificationInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IdentityType", IDENTITY_TYPE_FIELD);
        map.put("FeedbackForwardingStatus", FEEDBACK_FORWARDING_STATUS_FIELD);
        map.put("VerifiedForSendingStatus", VERIFIED_FOR_SENDING_STATUS_FIELD);
        map.put("DkimAttributes", DKIM_ATTRIBUTES_FIELD);
        map.put("MailFromAttributes", MAIL_FROM_ATTRIBUTES_FIELD);
        map.put("Policies", POLICIES_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ConfigurationSetName", CONFIGURATION_SET_NAME_FIELD);
        map.put("VerificationStatus", VERIFICATION_STATUS_FIELD);
        map.put("VerificationInfo", VERIFICATION_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEmailIdentityResponse, T> g) {
        return obj -> g.apply((GetEmailIdentityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetEmailIdentityResponse> {
        /**
         * <p>
         * The email identity type. Note: the <code>MANAGED_DOMAIN</code> identity type is not supported.
         * </p>
         * 
         * @param identityType
         *        The email identity type. Note: the <code>MANAGED_DOMAIN</code> identity type is not supported.
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(String identityType);

        /**
         * <p>
         * The email identity type. Note: the <code>MANAGED_DOMAIN</code> identity type is not supported.
         * </p>
         * 
         * @param identityType
         *        The email identity type. Note: the <code>MANAGED_DOMAIN</code> identity type is not supported.
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(IdentityType identityType);

        /**
         * <p>
         * The feedback forwarding configuration for the identity.
         * </p>
         * <p>
         * If the value is <code>true</code>, you receive email notifications when bounce or complaint events occur.
         * These notifications are sent to the address that you specified in the <code>Return-Path</code> header of the
         * original email.
         * </p>
         * <p>
         * You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism
         * for receiving bounce or complaint notifications (for example, by setting up an event destination), you
         * receive an email notification when these events occur (even if this setting is disabled).
         * </p>
         * 
         * @param feedbackForwardingStatus
         *        The feedback forwarding configuration for the identity.</p>
         *        <p>
         *        If the value is <code>true</code>, you receive email notifications when bounce or complaint events
         *        occur. These notifications are sent to the address that you specified in the <code>Return-Path</code>
         *        header of the original email.
         *        </p>
         *        <p>
         *        You're required to have a method of tracking bounces and complaints. If you haven't set up another
         *        mechanism for receiving bounce or complaint notifications (for example, by setting up an event
         *        destination), you receive an email notification when these events occur (even if this setting is
         *        disabled).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder feedbackForwardingStatus(Boolean feedbackForwardingStatus);

        /**
         * <p>
         * Specifies whether or not the identity is verified. You can only send email from verified email addresses or
         * domains. For more information about verifying identities, see the <a
         * href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-email-manage-verify.html">Amazon
         * Pinpoint User Guide</a>.
         * </p>
         * 
         * @param verifiedForSendingStatus
         *        Specifies whether or not the identity is verified. You can only send email from verified email
         *        addresses or domains. For more information about verifying identities, see the <a
         *        href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-email-manage-verify.html">Amazon
         *        Pinpoint User Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedForSendingStatus(Boolean verifiedForSendingStatus);

        /**
         * <p>
         * An object that contains information about the DKIM attributes for the identity.
         * </p>
         * 
         * @param dkimAttributes
         *        An object that contains information about the DKIM attributes for the identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dkimAttributes(DkimAttributes dkimAttributes);

        /**
         * <p>
         * An object that contains information about the DKIM attributes for the identity.
         * </p>
         * This is a convenience method that creates an instance of the {@link DkimAttributes.Builder} avoiding the need
         * to create one manually via {@link DkimAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DkimAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #dkimAttributes(DkimAttributes)}.
         * 
         * @param dkimAttributes
         *        a consumer that will call methods on {@link DkimAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dkimAttributes(DkimAttributes)
         */
        default Builder dkimAttributes(Consumer<DkimAttributes.Builder> dkimAttributes) {
            return dkimAttributes(DkimAttributes.builder().applyMutation(dkimAttributes).build());
        }

        /**
         * <p>
         * An object that contains information about the Mail-From attributes for the email identity.
         * </p>
         * 
         * @param mailFromAttributes
         *        An object that contains information about the Mail-From attributes for the email identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mailFromAttributes(MailFromAttributes mailFromAttributes);

        /**
         * <p>
         * An object that contains information about the Mail-From attributes for the email identity.
         * </p>
         * This is a convenience method that creates an instance of the {@link MailFromAttributes.Builder} avoiding the
         * need to create one manually via {@link MailFromAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MailFromAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #mailFromAttributes(MailFromAttributes)}.
         * 
         * @param mailFromAttributes
         *        a consumer that will call methods on {@link MailFromAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mailFromAttributes(MailFromAttributes)
         */
        default Builder mailFromAttributes(Consumer<MailFromAttributes.Builder> mailFromAttributes) {
            return mailFromAttributes(MailFromAttributes.builder().applyMutation(mailFromAttributes).build());
        }

        /**
         * <p>
         * A map of policy names to policies.
         * </p>
         * 
         * @param policies
         *        A map of policy names to policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(Map<String, String> policies);

        /**
         * <p>
         * An array of objects that define the tags (keys and values) that are associated with the email identity.
         * </p>
         * 
         * @param tags
         *        An array of objects that define the tags (keys and values) that are associated with the email
         *        identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of objects that define the tags (keys and values) that are associated with the email identity.
         * </p>
         * 
         * @param tags
         *        An array of objects that define the tags (keys and values) that are associated with the email
         *        identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of objects that define the tags (keys and values) that are associated with the email identity.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sesv2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.sesv2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.sesv2.model.Tag.Builder#build()}
         * is called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.sesv2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The configuration set used by default when sending from this identity.
         * </p>
         * 
         * @param configurationSetName
         *        The configuration set used by default when sending from this identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * The verification status of the identity. The status can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> – The verification process was initiated, but Amazon SES hasn't yet been able to verify
         * the identity.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCESS</code> – The verification process completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> – The verification process failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES from determining the verification
         * status of the identity.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_STARTED</code> – The verification process hasn't been initiated for the identity.
         * </p>
         * </li>
         * </ul>
         * 
         * @param verificationStatus
         *        The verification status of the identity. The status can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> – The verification process was initiated, but Amazon SES hasn't yet been able to
         *        verify the identity.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCESS</code> – The verification process completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> – The verification process failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES from determining the
         *        verification status of the identity.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_STARTED</code> – The verification process hasn't been initiated for the identity.
         *        </p>
         *        </li>
         * @see VerificationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationStatus
         */
        Builder verificationStatus(String verificationStatus);

        /**
         * <p>
         * The verification status of the identity. The status can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> – The verification process was initiated, but Amazon SES hasn't yet been able to verify
         * the identity.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCESS</code> – The verification process completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> – The verification process failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES from determining the verification
         * status of the identity.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_STARTED</code> – The verification process hasn't been initiated for the identity.
         * </p>
         * </li>
         * </ul>
         * 
         * @param verificationStatus
         *        The verification status of the identity. The status can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> – The verification process was initiated, but Amazon SES hasn't yet been able to
         *        verify the identity.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCESS</code> – The verification process completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> – The verification process failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES from determining the
         *        verification status of the identity.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_STARTED</code> – The verification process hasn't been initiated for the identity.
         *        </p>
         *        </li>
         * @see VerificationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationStatus
         */
        Builder verificationStatus(VerificationStatus verificationStatus);

        /**
         * <p>
         * An object that contains additional information about the verification status for the identity.
         * </p>
         * 
         * @param verificationInfo
         *        An object that contains additional information about the verification status for the identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationInfo(VerificationInfo verificationInfo);

        /**
         * <p>
         * An object that contains additional information about the verification status for the identity.
         * </p>
         * This is a convenience method that creates an instance of the {@link VerificationInfo.Builder} avoiding the
         * need to create one manually via {@link VerificationInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VerificationInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #verificationInfo(VerificationInfo)}.
         * 
         * @param verificationInfo
         *        a consumer that will call methods on {@link VerificationInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #verificationInfo(VerificationInfo)
         */
        default Builder verificationInfo(Consumer<VerificationInfo.Builder> verificationInfo) {
            return verificationInfo(VerificationInfo.builder().applyMutation(verificationInfo).build());
        }
    }

    static final class BuilderImpl extends SesV2Response.BuilderImpl implements Builder {
        private String identityType;

        private Boolean feedbackForwardingStatus;

        private Boolean verifiedForSendingStatus;

        private DkimAttributes dkimAttributes;

        private MailFromAttributes mailFromAttributes;

        private Map<String, String> policies = DefaultSdkAutoConstructMap.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String configurationSetName;

        private String verificationStatus;

        private VerificationInfo verificationInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEmailIdentityResponse model) {
            super(model);
            identityType(model.identityType);
            feedbackForwardingStatus(model.feedbackForwardingStatus);
            verifiedForSendingStatus(model.verifiedForSendingStatus);
            dkimAttributes(model.dkimAttributes);
            mailFromAttributes(model.mailFromAttributes);
            policies(model.policies);
            tags(model.tags);
            configurationSetName(model.configurationSetName);
            verificationStatus(model.verificationStatus);
            verificationInfo(model.verificationInfo);
        }

        public final String getIdentityType() {
            return identityType;
        }

        public final void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        @Override
        public final Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        @Override
        public final Builder identityType(IdentityType identityType) {
            this.identityType(identityType == null ? null : identityType.toString());
            return this;
        }

        public final Boolean getFeedbackForwardingStatus() {
            return feedbackForwardingStatus;
        }

        public final void setFeedbackForwardingStatus(Boolean feedbackForwardingStatus) {
            this.feedbackForwardingStatus = feedbackForwardingStatus;
        }

        @Override
        public final Builder feedbackForwardingStatus(Boolean feedbackForwardingStatus) {
            this.feedbackForwardingStatus = feedbackForwardingStatus;
            return this;
        }

        public final Boolean getVerifiedForSendingStatus() {
            return verifiedForSendingStatus;
        }

        public final void setVerifiedForSendingStatus(Boolean verifiedForSendingStatus) {
            this.verifiedForSendingStatus = verifiedForSendingStatus;
        }

        @Override
        public final Builder verifiedForSendingStatus(Boolean verifiedForSendingStatus) {
            this.verifiedForSendingStatus = verifiedForSendingStatus;
            return this;
        }

        public final DkimAttributes.Builder getDkimAttributes() {
            return dkimAttributes != null ? dkimAttributes.toBuilder() : null;
        }

        public final void setDkimAttributes(DkimAttributes.BuilderImpl dkimAttributes) {
            this.dkimAttributes = dkimAttributes != null ? dkimAttributes.build() : null;
        }

        @Override
        public final Builder dkimAttributes(DkimAttributes dkimAttributes) {
            this.dkimAttributes = dkimAttributes;
            return this;
        }

        public final MailFromAttributes.Builder getMailFromAttributes() {
            return mailFromAttributes != null ? mailFromAttributes.toBuilder() : null;
        }

        public final void setMailFromAttributes(MailFromAttributes.BuilderImpl mailFromAttributes) {
            this.mailFromAttributes = mailFromAttributes != null ? mailFromAttributes.build() : null;
        }

        @Override
        public final Builder mailFromAttributes(MailFromAttributes mailFromAttributes) {
            this.mailFromAttributes = mailFromAttributes;
            return this;
        }

        public final Map<String, String> getPolicies() {
            if (policies instanceof SdkAutoConstructMap) {
                return null;
            }
            return policies;
        }

        public final void setPolicies(Map<String, String> policies) {
            this.policies = PolicyMapCopier.copy(policies);
        }

        @Override
        public final Builder policies(Map<String, String> policies) {
            this.policies = PolicyMapCopier.copy(policies);
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final String getVerificationStatus() {
            return verificationStatus;
        }

        public final void setVerificationStatus(String verificationStatus) {
            this.verificationStatus = verificationStatus;
        }

        @Override
        public final Builder verificationStatus(String verificationStatus) {
            this.verificationStatus = verificationStatus;
            return this;
        }

        @Override
        public final Builder verificationStatus(VerificationStatus verificationStatus) {
            this.verificationStatus(verificationStatus == null ? null : verificationStatus.toString());
            return this;
        }

        public final VerificationInfo.Builder getVerificationInfo() {
            return verificationInfo != null ? verificationInfo.toBuilder() : null;
        }

        public final void setVerificationInfo(VerificationInfo.BuilderImpl verificationInfo) {
            this.verificationInfo = verificationInfo != null ? verificationInfo.build() : null;
        }

        @Override
        public final Builder verificationInfo(VerificationInfo verificationInfo) {
            this.verificationInfo = verificationInfo;
            return this;
        }

        @Override
        public GetEmailIdentityResponse build() {
            return new GetEmailIdentityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
