/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the export job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportJobSummary.Builder, ExportJobSummary> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(ExportJobSummary::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<String> EXPORT_SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportSourceType").getter(getter(ExportJobSummary::exportSourceTypeAsString))
            .setter(setter(Builder::exportSourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportSourceType").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobStatus").getter(getter(ExportJobSummary::jobStatusAsString)).setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(ExportJobSummary::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Instant> COMPLETED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletedTimestamp").getter(getter(ExportJobSummary::completedTimestamp))
            .setter(setter(Builder::completedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            EXPORT_SOURCE_TYPE_FIELD, JOB_STATUS_FIELD, CREATED_TIMESTAMP_FIELD, COMPLETED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String jobId;

    private final String exportSourceType;

    private final String jobStatus;

    private final Instant createdTimestamp;

    private final Instant completedTimestamp;

    private ExportJobSummary(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.exportSourceType = builder.exportSourceType;
        this.jobStatus = builder.jobStatus;
        this.createdTimestamp = builder.createdTimestamp;
        this.completedTimestamp = builder.completedTimestamp;
    }

    /**
     * <p>
     * The export job ID.
     * </p>
     * 
     * @return The export job ID.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The source type of the export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportSourceType}
     * will return {@link ExportSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #exportSourceTypeAsString}.
     * </p>
     * 
     * @return The source type of the export job.
     * @see ExportSourceType
     */
    public final ExportSourceType exportSourceType() {
        return ExportSourceType.fromValue(exportSourceType);
    }

    /**
     * <p>
     * The source type of the export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportSourceType}
     * will return {@link ExportSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #exportSourceTypeAsString}.
     * </p>
     * 
     * @return The source type of the export job.
     * @see ExportSourceType
     */
    public final String exportSourceTypeAsString() {
        return exportSourceType;
    }

    /**
     * <p>
     * The status of the export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The status of the export job.
     * @see JobStatus
     */
    public final JobStatus jobStatus() {
        return JobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The status of the export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The status of the export job.
     * @see JobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * The timestamp of when the export job was created.
     * </p>
     * 
     * @return The timestamp of when the export job was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The timestamp of when the export job was completed.
     * </p>
     * 
     * @return The timestamp of when the export job was completed.
     */
    public final Instant completedTimestamp() {
        return completedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(exportSourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(completedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportJobSummary)) {
            return false;
        }
        ExportJobSummary other = (ExportJobSummary) obj;
        return Objects.equals(jobId(), other.jobId())
                && Objects.equals(exportSourceTypeAsString(), other.exportSourceTypeAsString())
                && Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(completedTimestamp(), other.completedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportJobSummary").add("JobId", jobId()).add("ExportSourceType", exportSourceTypeAsString())
                .add("JobStatus", jobStatusAsString()).add("CreatedTimestamp", createdTimestamp())
                .add("CompletedTimestamp", completedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "ExportSourceType":
            return Optional.ofNullable(clazz.cast(exportSourceTypeAsString()));
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "CompletedTimestamp":
            return Optional.ofNullable(clazz.cast(completedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JobId", JOB_ID_FIELD);
        map.put("ExportSourceType", EXPORT_SOURCE_TYPE_FIELD);
        map.put("JobStatus", JOB_STATUS_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("CompletedTimestamp", COMPLETED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportJobSummary, T> g) {
        return obj -> g.apply((ExportJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportJobSummary> {
        /**
         * <p>
         * The export job ID.
         * </p>
         * 
         * @param jobId
         *        The export job ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The source type of the export job.
         * </p>
         * 
         * @param exportSourceType
         *        The source type of the export job.
         * @see ExportSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportSourceType
         */
        Builder exportSourceType(String exportSourceType);

        /**
         * <p>
         * The source type of the export job.
         * </p>
         * 
         * @param exportSourceType
         *        The source type of the export job.
         * @see ExportSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportSourceType
         */
        Builder exportSourceType(ExportSourceType exportSourceType);

        /**
         * <p>
         * The status of the export job.
         * </p>
         * 
         * @param jobStatus
         *        The status of the export job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The status of the export job.
         * </p>
         * 
         * @param jobStatus
         *        The status of the export job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(JobStatus jobStatus);

        /**
         * <p>
         * The timestamp of when the export job was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The timestamp of when the export job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The timestamp of when the export job was completed.
         * </p>
         * 
         * @param completedTimestamp
         *        The timestamp of when the export job was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedTimestamp(Instant completedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private String exportSourceType;

        private String jobStatus;

        private Instant createdTimestamp;

        private Instant completedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportJobSummary model) {
            jobId(model.jobId);
            exportSourceType(model.exportSourceType);
            jobStatus(model.jobStatus);
            createdTimestamp(model.createdTimestamp);
            completedTimestamp(model.completedTimestamp);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getExportSourceType() {
            return exportSourceType;
        }

        public final void setExportSourceType(String exportSourceType) {
            this.exportSourceType = exportSourceType;
        }

        @Override
        public final Builder exportSourceType(String exportSourceType) {
            this.exportSourceType = exportSourceType;
            return this;
        }

        @Override
        public final Builder exportSourceType(ExportSourceType exportSourceType) {
            this.exportSourceType(exportSourceType == null ? null : exportSourceType.toString());
            return this;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getCompletedTimestamp() {
            return completedTimestamp;
        }

        public final void setCompletedTimestamp(Instant completedTimestamp) {
            this.completedTimestamp = completedTimestamp;
        }

        @Override
        public final Builder completedTimestamp(Instant completedTimestamp) {
            this.completedTimestamp = completedTimestamp;
            return this;
        }

        @Override
        public ExportJobSummary build() {
            return new ExportJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
