/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum DkimSigningAttributesOrigin {
    AWS_SES("AWS_SES"),

    EXTERNAL("EXTERNAL"),

    AWS_SES_AF_SOUTH_1("AWS_SES_AF_SOUTH_1"),

    AWS_SES_EU_NORTH_1("AWS_SES_EU_NORTH_1"),

    AWS_SES_AP_SOUTH_1("AWS_SES_AP_SOUTH_1"),

    AWS_SES_EU_WEST_3("AWS_SES_EU_WEST_3"),

    AWS_SES_EU_WEST_2("AWS_SES_EU_WEST_2"),

    AWS_SES_EU_SOUTH_1("AWS_SES_EU_SOUTH_1"),

    AWS_SES_EU_WEST_1("AWS_SES_EU_WEST_1"),

    AWS_SES_AP_NORTHEAST_3("AWS_SES_AP_NORTHEAST_3"),

    AWS_SES_AP_NORTHEAST_2("AWS_SES_AP_NORTHEAST_2"),

    AWS_SES_ME_SOUTH_1("AWS_SES_ME_SOUTH_1"),

    AWS_SES_AP_NORTHEAST_1("AWS_SES_AP_NORTHEAST_1"),

    AWS_SES_IL_CENTRAL_1("AWS_SES_IL_CENTRAL_1"),

    AWS_SES_SA_EAST_1("AWS_SES_SA_EAST_1"),

    AWS_SES_CA_CENTRAL_1("AWS_SES_CA_CENTRAL_1"),

    AWS_SES_AP_SOUTHEAST_1("AWS_SES_AP_SOUTHEAST_1"),

    AWS_SES_AP_SOUTHEAST_2("AWS_SES_AP_SOUTHEAST_2"),

    AWS_SES_AP_SOUTHEAST_3("AWS_SES_AP_SOUTHEAST_3"),

    AWS_SES_EU_CENTRAL_1("AWS_SES_EU_CENTRAL_1"),

    AWS_SES_US_EAST_1("AWS_SES_US_EAST_1"),

    AWS_SES_US_EAST_2("AWS_SES_US_EAST_2"),

    AWS_SES_US_WEST_1("AWS_SES_US_WEST_1"),

    AWS_SES_US_WEST_2("AWS_SES_US_WEST_2"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DkimSigningAttributesOrigin> VALUE_MAP = EnumUtils.uniqueIndex(
            DkimSigningAttributesOrigin.class, DkimSigningAttributesOrigin::toString);

    private final String value;

    private DkimSigningAttributesOrigin(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return DkimSigningAttributesOrigin corresponding to the value
     */
    public static DkimSigningAttributesOrigin fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link DkimSigningAttributesOrigin}s
     */
    public static Set<DkimSigningAttributesOrigin> knownValues() {
        Set<DkimSigningAttributesOrigin> knownValues = EnumSet.allOf(DkimSigningAttributesOrigin.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
