/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2Client;
import software.amazon.awssdk.services.sesv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.sesv2.model.ListContactListsRequest;
import software.amazon.awssdk.services.sesv2.model.ListContactListsResponse;

public class ListContactListsIterable
implements SdkIterable<ListContactListsResponse> {
    private final SesV2Client client;
    private final ListContactListsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListContactListsIterable(SesV2Client client, ListContactListsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListContactListsResponseFetcher();
    }

    public Iterator<ListContactListsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListContactListsResponseFetcher
    implements SyncPageFetcher<ListContactListsResponse> {
        private ListContactListsResponseFetcher() {
        }

        public boolean hasNextPage(ListContactListsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListContactListsResponse nextPage(ListContactListsResponse previousPage) {
            if (previousPage == null) {
                return ListContactListsIterable.this.client.listContactLists(ListContactListsIterable.this.firstRequest);
            }
            return ListContactListsIterable.this.client.listContactLists((ListContactListsRequest)((Object)ListContactListsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

