/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.SuppressionListReason;
import software.amazon.awssdk.services.sesv2.model.SuppressionListReasonsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SuppressionAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SuppressionAttributes> {
    private static final SdkField<List<String>> SUPPRESSED_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuppressedReasons").getter(SuppressionAttributes.getter(SuppressionAttributes::suppressedReasonsAsStrings)).setter(SuppressionAttributes.setter(Builder::suppressedReasonsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuppressedReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPRESSED_REASONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SuppressedReasons", SUPPRESSED_REASONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> suppressedReasons;

    private SuppressionAttributes(BuilderImpl builder) {
        this.suppressedReasons = builder.suppressedReasons;
    }

    public final List<SuppressionListReason> suppressedReasons() {
        return SuppressionListReasonsCopier.copyStringToEnum(this.suppressedReasons);
    }

    public final boolean hasSuppressedReasons() {
        return this.suppressedReasons != null && !(this.suppressedReasons instanceof SdkAutoConstructList);
    }

    public final List<String> suppressedReasonsAsStrings() {
        return this.suppressedReasons;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuppressedReasons() ? this.suppressedReasonsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuppressionAttributes)) {
            return false;
        }
        SuppressionAttributes other = (SuppressionAttributes)obj;
        return this.hasSuppressedReasons() == other.hasSuppressedReasons() && Objects.equals(this.suppressedReasonsAsStrings(), other.suppressedReasonsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"SuppressionAttributes").add("SuppressedReasons", this.hasSuppressedReasons() ? this.suppressedReasonsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SuppressedReasons": {
                return Optional.ofNullable(clazz.cast(this.suppressedReasonsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SuppressionAttributes, T> g) {
        return obj -> g.apply((SuppressionAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> suppressedReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SuppressionAttributes model) {
            this.suppressedReasonsWithStrings(model.suppressedReasons);
        }

        public final Collection<String> getSuppressedReasons() {
            if (this.suppressedReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.suppressedReasons;
        }

        public final void setSuppressedReasons(Collection<String> suppressedReasons) {
            this.suppressedReasons = SuppressionListReasonsCopier.copy(suppressedReasons);
        }

        @Override
        public final Builder suppressedReasonsWithStrings(Collection<String> suppressedReasons) {
            this.suppressedReasons = SuppressionListReasonsCopier.copy(suppressedReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suppressedReasonsWithStrings(String ... suppressedReasons) {
            this.suppressedReasonsWithStrings(Arrays.asList(suppressedReasons));
            return this;
        }

        @Override
        public final Builder suppressedReasons(Collection<SuppressionListReason> suppressedReasons) {
            this.suppressedReasons = SuppressionListReasonsCopier.copyEnumToString(suppressedReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suppressedReasons(SuppressionListReason ... suppressedReasons) {
            this.suppressedReasons(Arrays.asList(suppressedReasons));
            return this;
        }

        public SuppressionAttributes build() {
            return new SuppressionAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SuppressionAttributes> {
        public Builder suppressedReasonsWithStrings(Collection<String> var1);

        public Builder suppressedReasonsWithStrings(String ... var1);

        public Builder suppressedReasons(Collection<SuppressionListReason> var1);

        public Builder suppressedReasons(SuppressionListReason ... var1);
    }
}

