/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.SesV2Request;
import software.amazon.awssdk.services.sesv2.model.Topic;
import software.amazon.awssdk.services.sesv2.model.TopicsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateContactListRequest
extends SesV2Request
implements ToCopyableBuilder<Builder, UpdateContactListRequest> {
    private static final SdkField<String> CONTACT_LIST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactListName").getter(UpdateContactListRequest.getter(UpdateContactListRequest::contactListName)).setter(UpdateContactListRequest.setter(Builder::contactListName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ContactListName").build()}).build();
    private static final SdkField<List<Topic>> TOPICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Topics").getter(UpdateContactListRequest.getter(UpdateContactListRequest::topics)).setter(UpdateContactListRequest.setter(Builder::topics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Topics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Topic::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateContactListRequest.getter(UpdateContactListRequest::description)).setter(UpdateContactListRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_LIST_NAME_FIELD, TOPICS_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ContactListName", CONTACT_LIST_NAME_FIELD);
            this.put("Topics", TOPICS_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
        }
    });
    private final String contactListName;
    private final List<Topic> topics;
    private final String description;

    private UpdateContactListRequest(BuilderImpl builder) {
        super(builder);
        this.contactListName = builder.contactListName;
        this.topics = builder.topics;
        this.description = builder.description;
    }

    public final String contactListName() {
        return this.contactListName;
    }

    public final boolean hasTopics() {
        return this.topics != null && !(this.topics instanceof SdkAutoConstructList);
    }

    public final List<Topic> topics() {
        return this.topics;
    }

    public final String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contactListName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopics() ? this.topics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContactListRequest)) {
            return false;
        }
        UpdateContactListRequest other = (UpdateContactListRequest)((Object)obj);
        return Objects.equals(this.contactListName(), other.contactListName()) && this.hasTopics() == other.hasTopics() && Objects.equals(this.topics(), other.topics()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateContactListRequest").add("ContactListName", (Object)this.contactListName()).add("Topics", this.hasTopics() ? this.topics() : null).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactListName": {
                return Optional.ofNullable(clazz.cast(this.contactListName()));
            }
            case "Topics": {
                return Optional.ofNullable(clazz.cast(this.topics()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateContactListRequest, T> g) {
        return obj -> g.apply((UpdateContactListRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Request.BuilderImpl
    implements Builder {
        private String contactListName;
        private List<Topic> topics = DefaultSdkAutoConstructList.getInstance();
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContactListRequest model) {
            super(model);
            this.contactListName(model.contactListName);
            this.topics(model.topics);
            this.description(model.description);
        }

        public final String getContactListName() {
            return this.contactListName;
        }

        public final void setContactListName(String contactListName) {
            this.contactListName = contactListName;
        }

        @Override
        public final Builder contactListName(String contactListName) {
            this.contactListName = contactListName;
            return this;
        }

        public final List<Topic.Builder> getTopics() {
            List<Topic.Builder> result = TopicsCopier.copyToBuilder(this.topics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopics(Collection<Topic.BuilderImpl> topics) {
            this.topics = TopicsCopier.copyFromBuilder(topics);
        }

        @Override
        public final Builder topics(Collection<Topic> topics) {
            this.topics = TopicsCopier.copy(topics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topics(Topic ... topics) {
            this.topics(Arrays.asList(topics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topics(Consumer<Topic.Builder> ... topics) {
            this.topics(Stream.of(topics).map(c -> (Topic)((Topic.Builder)Topic.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContactListRequest build() {
            return new UpdateContactListRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SesV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateContactListRequest> {
        public Builder contactListName(String var1);

        public Builder topics(Collection<Topic> var1);

        public Builder topics(Topic ... var1);

        public Builder topics(Consumer<Topic.Builder> ... var1);

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

