/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2Client;
import software.amazon.awssdk.services.sesv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsRequest;
import software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsResponse;

public class ListDeliverabilityTestReportsIterable
implements SdkIterable<ListDeliverabilityTestReportsResponse> {
    private final SesV2Client client;
    private final ListDeliverabilityTestReportsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDeliverabilityTestReportsIterable(SesV2Client client, ListDeliverabilityTestReportsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDeliverabilityTestReportsResponseFetcher();
    }

    public Iterator<ListDeliverabilityTestReportsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDeliverabilityTestReportsResponseFetcher
    implements SyncPageFetcher<ListDeliverabilityTestReportsResponse> {
        private ListDeliverabilityTestReportsResponseFetcher() {
        }

        public boolean hasNextPage(ListDeliverabilityTestReportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDeliverabilityTestReportsResponse nextPage(ListDeliverabilityTestReportsResponse previousPage) {
            if (previousPage == null) {
                return ListDeliverabilityTestReportsIterable.this.client.listDeliverabilityTestReports(ListDeliverabilityTestReportsIterable.this.firstRequest);
            }
            return ListDeliverabilityTestReportsIterable.this.client.listDeliverabilityTestReports((ListDeliverabilityTestReportsRequest)((Object)ListDeliverabilityTestReportsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

