/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.HttpsPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrackingOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrackingOptions> {
    private static final SdkField<String> CUSTOM_REDIRECT_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomRedirectDomain").getter(TrackingOptions.getter(TrackingOptions::customRedirectDomain)).setter(TrackingOptions.setter(Builder::customRedirectDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomRedirectDomain").build()}).build();
    private static final SdkField<String> HTTPS_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpsPolicy").getter(TrackingOptions.getter(TrackingOptions::httpsPolicyAsString)).setter(TrackingOptions.setter(Builder::httpsPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpsPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_REDIRECT_DOMAIN_FIELD, HTTPS_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CustomRedirectDomain", CUSTOM_REDIRECT_DOMAIN_FIELD);
            this.put("HttpsPolicy", HTTPS_POLICY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String customRedirectDomain;
    private final String httpsPolicy;

    private TrackingOptions(BuilderImpl builder) {
        this.customRedirectDomain = builder.customRedirectDomain;
        this.httpsPolicy = builder.httpsPolicy;
    }

    public final String customRedirectDomain() {
        return this.customRedirectDomain;
    }

    public final HttpsPolicy httpsPolicy() {
        return HttpsPolicy.fromValue(this.httpsPolicy);
    }

    public final String httpsPolicyAsString() {
        return this.httpsPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customRedirectDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpsPolicyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrackingOptions)) {
            return false;
        }
        TrackingOptions other = (TrackingOptions)obj;
        return Objects.equals(this.customRedirectDomain(), other.customRedirectDomain()) && Objects.equals(this.httpsPolicyAsString(), other.httpsPolicyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TrackingOptions").add("CustomRedirectDomain", (Object)this.customRedirectDomain()).add("HttpsPolicy", (Object)this.httpsPolicyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomRedirectDomain": {
                return Optional.ofNullable(clazz.cast(this.customRedirectDomain()));
            }
            case "HttpsPolicy": {
                return Optional.ofNullable(clazz.cast(this.httpsPolicyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TrackingOptions, T> g) {
        return obj -> g.apply((TrackingOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String customRedirectDomain;
        private String httpsPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(TrackingOptions model) {
            this.customRedirectDomain(model.customRedirectDomain);
            this.httpsPolicy(model.httpsPolicy);
        }

        public final String getCustomRedirectDomain() {
            return this.customRedirectDomain;
        }

        public final void setCustomRedirectDomain(String customRedirectDomain) {
            this.customRedirectDomain = customRedirectDomain;
        }

        @Override
        public final Builder customRedirectDomain(String customRedirectDomain) {
            this.customRedirectDomain = customRedirectDomain;
            return this;
        }

        public final String getHttpsPolicy() {
            return this.httpsPolicy;
        }

        public final void setHttpsPolicy(String httpsPolicy) {
            this.httpsPolicy = httpsPolicy;
        }

        @Override
        public final Builder httpsPolicy(String httpsPolicy) {
            this.httpsPolicy = httpsPolicy;
            return this;
        }

        @Override
        public final Builder httpsPolicy(HttpsPolicy httpsPolicy) {
            this.httpsPolicy(httpsPolicy == null ? null : httpsPolicy.toString());
            return this;
        }

        public TrackingOptions build() {
            return new TrackingOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrackingOptions> {
        public Builder customRedirectDomain(String var1);

        public Builder httpsPolicy(String var1);

        public Builder httpsPolicy(HttpsPolicy var1);
    }
}

