/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to add specific VDM settings to a configuration set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutConfigurationSetVdmOptionsRequest extends SesV2Request implements
        ToCopyableBuilder<PutConfigurationSetVdmOptionsRequest.Builder, PutConfigurationSetVdmOptionsRequest> {
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSetName").getter(getter(PutConfigurationSetVdmOptionsRequest::configurationSetName))
            .setter(setter(Builder::configurationSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConfigurationSetName").build()).build();

    private static final SdkField<VdmOptions> VDM_OPTIONS_FIELD = SdkField.<VdmOptions> builder(MarshallingType.SDK_POJO)
            .memberName("VdmOptions").getter(getter(PutConfigurationSetVdmOptionsRequest::vdmOptions))
            .setter(setter(Builder::vdmOptions)).constructor(VdmOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VdmOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_NAME_FIELD,
            VDM_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ConfigurationSetName", CONFIGURATION_SET_NAME_FIELD);
                    put("VdmOptions", VDM_OPTIONS_FIELD);
                }
            });

    private final String configurationSetName;

    private final VdmOptions vdmOptions;

    private PutConfigurationSetVdmOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.vdmOptions = builder.vdmOptions;
    }

    /**
     * <p>
     * The name of the configuration set.
     * </p>
     * 
     * @return The name of the configuration set.
     */
    public final String configurationSetName() {
        return configurationSetName;
    }

    /**
     * <p>
     * The VDM options to apply to the configuration set.
     * </p>
     * 
     * @return The VDM options to apply to the configuration set.
     */
    public final VdmOptions vdmOptions() {
        return vdmOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(vdmOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutConfigurationSetVdmOptionsRequest)) {
            return false;
        }
        PutConfigurationSetVdmOptionsRequest other = (PutConfigurationSetVdmOptionsRequest) obj;
        return Objects.equals(configurationSetName(), other.configurationSetName())
                && Objects.equals(vdmOptions(), other.vdmOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutConfigurationSetVdmOptionsRequest").add("ConfigurationSetName", configurationSetName())
                .add("VdmOptions", vdmOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSetName":
            return Optional.ofNullable(clazz.cast(configurationSetName()));
        case "VdmOptions":
            return Optional.ofNullable(clazz.cast(vdmOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutConfigurationSetVdmOptionsRequest, T> g) {
        return obj -> g.apply((PutConfigurationSetVdmOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, PutConfigurationSetVdmOptionsRequest> {
        /**
         * <p>
         * The name of the configuration set.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * The VDM options to apply to the configuration set.
         * </p>
         * 
         * @param vdmOptions
         *        The VDM options to apply to the configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vdmOptions(VdmOptions vdmOptions);

        /**
         * <p>
         * The VDM options to apply to the configuration set.
         * </p>
         * This is a convenience method that creates an instance of the {@link VdmOptions.Builder} avoiding the need to
         * create one manually via {@link VdmOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VdmOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #vdmOptions(VdmOptions)}.
         * 
         * @param vdmOptions
         *        a consumer that will call methods on {@link VdmOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vdmOptions(VdmOptions)
         */
        default Builder vdmOptions(Consumer<VdmOptions.Builder> vdmOptions) {
            return vdmOptions(VdmOptions.builder().applyMutation(vdmOptions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private String configurationSetName;

        private VdmOptions vdmOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(PutConfigurationSetVdmOptionsRequest model) {
            super(model);
            configurationSetName(model.configurationSetName);
            vdmOptions(model.vdmOptions);
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final VdmOptions.Builder getVdmOptions() {
            return vdmOptions != null ? vdmOptions.toBuilder() : null;
        }

        public final void setVdmOptions(VdmOptions.BuilderImpl vdmOptions) {
            this.vdmOptions = vdmOptions != null ? vdmOptions.build() : null;
        }

        @Override
        public final Builder vdmOptions(VdmOptions vdmOptions) {
            this.vdmOptions = vdmOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutConfigurationSetVdmOptionsRequest build() {
            return new PutConfigurationSetVdmOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
