/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains filters applied when performing the Message Insights export.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MessageInsightsDataSource implements SdkPojo, Serializable,
        ToCopyableBuilder<MessageInsightsDataSource.Builder, MessageInsightsDataSource> {
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartDate").getter(getter(MessageInsightsDataSource::startDate)).setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()).build();

    private static final SdkField<Instant> END_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndDate").getter(getter(MessageInsightsDataSource::endDate)).setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").build()).build();

    private static final SdkField<MessageInsightsFilters> INCLUDE_FIELD = SdkField
            .<MessageInsightsFilters> builder(MarshallingType.SDK_POJO).memberName("Include")
            .getter(getter(MessageInsightsDataSource::include)).setter(setter(Builder::include))
            .constructor(MessageInsightsFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Include").build()).build();

    private static final SdkField<MessageInsightsFilters> EXCLUDE_FIELD = SdkField
            .<MessageInsightsFilters> builder(MarshallingType.SDK_POJO).memberName("Exclude")
            .getter(getter(MessageInsightsDataSource::exclude)).setter(setter(Builder::exclude))
            .constructor(MessageInsightsFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exclude").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(MessageInsightsDataSource::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_DATE_FIELD,
            END_DATE_FIELD, INCLUDE_FIELD, EXCLUDE_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("StartDate", START_DATE_FIELD);
                    put("EndDate", END_DATE_FIELD);
                    put("Include", INCLUDE_FIELD);
                    put("Exclude", EXCLUDE_FIELD);
                    put("MaxResults", MAX_RESULTS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Instant startDate;

    private final Instant endDate;

    private final MessageInsightsFilters include;

    private final MessageInsightsFilters exclude;

    private final Integer maxResults;

    private MessageInsightsDataSource(BuilderImpl builder) {
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.include = builder.include;
        this.exclude = builder.exclude;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * Represents the start date for the export interval as a timestamp. The start date is inclusive.
     * </p>
     * 
     * @return Represents the start date for the export interval as a timestamp. The start date is inclusive.
     */
    public final Instant startDate() {
        return startDate;
    }

    /**
     * <p>
     * Represents the end date for the export interval as a timestamp. The end date is inclusive.
     * </p>
     * 
     * @return Represents the end date for the export interval as a timestamp. The end date is inclusive.
     */
    public final Instant endDate() {
        return endDate;
    }

    /**
     * <p>
     * Filters for results to be included in the export file.
     * </p>
     * 
     * @return Filters for results to be included in the export file.
     */
    public final MessageInsightsFilters include() {
        return include;
    }

    /**
     * <p>
     * Filters for results to be excluded from the export file.
     * </p>
     * 
     * @return Filters for results to be excluded from the export file.
     */
    public final MessageInsightsFilters exclude() {
        return exclude;
    }

    /**
     * <p>
     * The maximum number of results.
     * </p>
     * 
     * @return The maximum number of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        hashCode = 31 * hashCode + Objects.hashCode(include());
        hashCode = 31 * hashCode + Objects.hashCode(exclude());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageInsightsDataSource)) {
            return false;
        }
        MessageInsightsDataSource other = (MessageInsightsDataSource) obj;
        return Objects.equals(startDate(), other.startDate()) && Objects.equals(endDate(), other.endDate())
                && Objects.equals(include(), other.include()) && Objects.equals(exclude(), other.exclude())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MessageInsightsDataSource").add("StartDate", startDate()).add("EndDate", endDate())
                .add("Include", include()).add("Exclude", exclude()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "EndDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        case "Include":
            return Optional.ofNullable(clazz.cast(include()));
        case "Exclude":
            return Optional.ofNullable(clazz.cast(exclude()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MessageInsightsDataSource, T> g) {
        return obj -> g.apply((MessageInsightsDataSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MessageInsightsDataSource> {
        /**
         * <p>
         * Represents the start date for the export interval as a timestamp. The start date is inclusive.
         * </p>
         * 
         * @param startDate
         *        Represents the start date for the export interval as a timestamp. The start date is inclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <p>
         * Represents the end date for the export interval as a timestamp. The end date is inclusive.
         * </p>
         * 
         * @param endDate
         *        Represents the end date for the export interval as a timestamp. The end date is inclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(Instant endDate);

        /**
         * <p>
         * Filters for results to be included in the export file.
         * </p>
         * 
         * @param include
         *        Filters for results to be included in the export file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder include(MessageInsightsFilters include);

        /**
         * <p>
         * Filters for results to be included in the export file.
         * </p>
         * This is a convenience method that creates an instance of the {@link MessageInsightsFilters.Builder} avoiding
         * the need to create one manually via {@link MessageInsightsFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageInsightsFilters.Builder#build()} is called immediately and
         * its result is passed to {@link #include(MessageInsightsFilters)}.
         * 
         * @param include
         *        a consumer that will call methods on {@link MessageInsightsFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #include(MessageInsightsFilters)
         */
        default Builder include(Consumer<MessageInsightsFilters.Builder> include) {
            return include(MessageInsightsFilters.builder().applyMutation(include).build());
        }

        /**
         * <p>
         * Filters for results to be excluded from the export file.
         * </p>
         * 
         * @param exclude
         *        Filters for results to be excluded from the export file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclude(MessageInsightsFilters exclude);

        /**
         * <p>
         * Filters for results to be excluded from the export file.
         * </p>
         * This is a convenience method that creates an instance of the {@link MessageInsightsFilters.Builder} avoiding
         * the need to create one manually via {@link MessageInsightsFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageInsightsFilters.Builder#build()} is called immediately and
         * its result is passed to {@link #exclude(MessageInsightsFilters)}.
         * 
         * @param exclude
         *        a consumer that will call methods on {@link MessageInsightsFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exclude(MessageInsightsFilters)
         */
        default Builder exclude(Consumer<MessageInsightsFilters.Builder> exclude) {
            return exclude(MessageInsightsFilters.builder().applyMutation(exclude).build());
        }

        /**
         * <p>
         * The maximum number of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);
    }

    static final class BuilderImpl implements Builder {
        private Instant startDate;

        private Instant endDate;

        private MessageInsightsFilters include;

        private MessageInsightsFilters exclude;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageInsightsDataSource model) {
            startDate(model.startDate);
            endDate(model.endDate);
            include(model.include);
            exclude(model.exclude);
            maxResults(model.maxResults);
        }

        public final Instant getStartDate() {
            return startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getEndDate() {
            return endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final MessageInsightsFilters.Builder getInclude() {
            return include != null ? include.toBuilder() : null;
        }

        public final void setInclude(MessageInsightsFilters.BuilderImpl include) {
            this.include = include != null ? include.build() : null;
        }

        @Override
        public final Builder include(MessageInsightsFilters include) {
            this.include = include;
            return this;
        }

        public final MessageInsightsFilters.Builder getExclude() {
            return exclude != null ? exclude.toBuilder() : null;
        }

        public final void setExclude(MessageInsightsFilters.BuilderImpl exclude) {
            this.exclude = exclude != null ? exclude.build() : null;
        }

        @Override
        public final Builder exclude(MessageInsightsFilters exclude) {
            this.exclude = exclude;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public MessageInsightsDataSource build() {
            return new MessageInsightsDataSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
