/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * <p>
 * The https policy to use for tracking open and click events. If the value is OPTIONAL or HttpsPolicy is not specified,
 * the open trackers use HTTP and click tracker use the original protocol of the link. If the value is REQUIRE, both
 * open and click tracker uses HTTPS and if the value is REQUIRE_OPEN_ONLY open tracker uses HTTPS and link tracker is
 * same as original protocol of the link.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public enum HttpsPolicy {
    REQUIRE("REQUIRE"),

    REQUIRE_OPEN_ONLY("REQUIRE_OPEN_ONLY"),

    OPTIONAL("OPTIONAL"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HttpsPolicy> VALUE_MAP = EnumUtils.uniqueIndex(HttpsPolicy.class, HttpsPolicy::toString);

    private final String value;

    private HttpsPolicy(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return HttpsPolicy corresponding to the value
     */
    public static HttpsPolicy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link HttpsPolicy}s
     */
    public static Set<HttpsPolicy> knownValues() {
        Set<HttpsPolicy> knownValues = EnumSet.allOf(HttpsPolicy.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
