/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Statistics about the execution of an export job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportStatistics.Builder, ExportStatistics> {
    private static final SdkField<Integer> PROCESSED_RECORDS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ProcessedRecordsCount").getter(getter(ExportStatistics::processedRecordsCount))
            .setter(setter(Builder::processedRecordsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessedRecordsCount").build())
            .build();

    private static final SdkField<Integer> EXPORTED_RECORDS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ExportedRecordsCount").getter(getter(ExportStatistics::exportedRecordsCount))
            .setter(setter(Builder::exportedRecordsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportedRecordsCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROCESSED_RECORDS_COUNT_FIELD,
            EXPORTED_RECORDS_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ProcessedRecordsCount", PROCESSED_RECORDS_COUNT_FIELD);
                    put("ExportedRecordsCount", EXPORTED_RECORDS_COUNT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer processedRecordsCount;

    private final Integer exportedRecordsCount;

    private ExportStatistics(BuilderImpl builder) {
        this.processedRecordsCount = builder.processedRecordsCount;
        this.exportedRecordsCount = builder.exportedRecordsCount;
    }

    /**
     * <p>
     * The number of records that were processed to generate the final export file.
     * </p>
     * 
     * @return The number of records that were processed to generate the final export file.
     */
    public final Integer processedRecordsCount() {
        return processedRecordsCount;
    }

    /**
     * <p>
     * The number of records that were exported to the final export file.
     * </p>
     * <p>
     * This value might not be available for all export source types
     * </p>
     * 
     * @return The number of records that were exported to the final export file.</p>
     *         <p>
     *         This value might not be available for all export source types
     */
    public final Integer exportedRecordsCount() {
        return exportedRecordsCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(processedRecordsCount());
        hashCode = 31 * hashCode + Objects.hashCode(exportedRecordsCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportStatistics)) {
            return false;
        }
        ExportStatistics other = (ExportStatistics) obj;
        return Objects.equals(processedRecordsCount(), other.processedRecordsCount())
                && Objects.equals(exportedRecordsCount(), other.exportedRecordsCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportStatistics").add("ProcessedRecordsCount", processedRecordsCount())
                .add("ExportedRecordsCount", exportedRecordsCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProcessedRecordsCount":
            return Optional.ofNullable(clazz.cast(processedRecordsCount()));
        case "ExportedRecordsCount":
            return Optional.ofNullable(clazz.cast(exportedRecordsCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ExportStatistics, T> g) {
        return obj -> g.apply((ExportStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportStatistics> {
        /**
         * <p>
         * The number of records that were processed to generate the final export file.
         * </p>
         * 
         * @param processedRecordsCount
         *        The number of records that were processed to generate the final export file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processedRecordsCount(Integer processedRecordsCount);

        /**
         * <p>
         * The number of records that were exported to the final export file.
         * </p>
         * <p>
         * This value might not be available for all export source types
         * </p>
         * 
         * @param exportedRecordsCount
         *        The number of records that were exported to the final export file.</p>
         *        <p>
         *        This value might not be available for all export source types
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportedRecordsCount(Integer exportedRecordsCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer processedRecordsCount;

        private Integer exportedRecordsCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportStatistics model) {
            processedRecordsCount(model.processedRecordsCount);
            exportedRecordsCount(model.exportedRecordsCount);
        }

        public final Integer getProcessedRecordsCount() {
            return processedRecordsCount;
        }

        public final void setProcessedRecordsCount(Integer processedRecordsCount) {
            this.processedRecordsCount = processedRecordsCount;
        }

        @Override
        public final Builder processedRecordsCount(Integer processedRecordsCount) {
            this.processedRecordsCount = processedRecordsCount;
            return this;
        }

        public final Integer getExportedRecordsCount() {
            return exportedRecordsCount;
        }

        public final void setExportedRecordsCount(Integer exportedRecordsCount) {
            this.exportedRecordsCount = exportedRecordsCount;
        }

        @Override
        public final Builder exportedRecordsCount(Integer exportedRecordsCount) {
            this.exportedRecordsCount = exportedRecordsCount;
            return this;
        }

        @Override
        public ExportStatistics build() {
            return new ExportStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
