/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.MetricValueListCopier;
import software.amazon.awssdk.services.sesv2.model.TimestampListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricDataResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricDataResult> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(MetricDataResult.getter(MetricDataResult::id)).setter(MetricDataResult.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<List<Instant>> TIMESTAMPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Timestamps").getter(MetricDataResult.getter(MetricDataResult::timestamps)).setter(MetricDataResult.setter(Builder::timestamps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INSTANT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Long>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Values").getter(MetricDataResult.getter(MetricDataResult::values)).setter(MetricDataResult.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TIMESTAMPS_FIELD, VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("Timestamps", TIMESTAMPS_FIELD);
            this.put("Values", VALUES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final List<Instant> timestamps;
    private final List<Long> values;

    private MetricDataResult(BuilderImpl builder) {
        this.id = builder.id;
        this.timestamps = builder.timestamps;
        this.values = builder.values;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasTimestamps() {
        return this.timestamps != null && !(this.timestamps instanceof SdkAutoConstructList);
    }

    public final List<Instant> timestamps() {
        return this.timestamps;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<Long> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTimestamps() ? this.timestamps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDataResult)) {
            return false;
        }
        MetricDataResult other = (MetricDataResult)obj;
        return Objects.equals(this.id(), other.id()) && this.hasTimestamps() == other.hasTimestamps() && Objects.equals(this.timestamps(), other.timestamps()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values());
    }

    public final String toString() {
        return ToString.builder((String)"MetricDataResult").add("Id", (Object)this.id()).add("Timestamps", this.hasTimestamps() ? this.timestamps() : null).add("Values", this.hasValues() ? this.values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Timestamps": {
                return Optional.ofNullable(clazz.cast(this.timestamps()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MetricDataResult, T> g) {
        return obj -> g.apply((MetricDataResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private List<Instant> timestamps = DefaultSdkAutoConstructList.getInstance();
        private List<Long> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDataResult model) {
            this.id(model.id);
            this.timestamps(model.timestamps);
            this.values(model.values);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Collection<Instant> getTimestamps() {
            if (this.timestamps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.timestamps;
        }

        public final void setTimestamps(Collection<Instant> timestamps) {
            this.timestamps = TimestampListCopier.copy(timestamps);
        }

        @Override
        public final Builder timestamps(Collection<Instant> timestamps) {
            this.timestamps = TimestampListCopier.copy(timestamps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timestamps(Instant ... timestamps) {
            this.timestamps(Arrays.asList(timestamps));
            return this;
        }

        public final Collection<Long> getValues() {
            if (this.values instanceof SdkAutoConstructList) {
                return null;
            }
            return this.values;
        }

        public final void setValues(Collection<Long> values) {
            this.values = MetricValueListCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<Long> values) {
            this.values = MetricValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Long ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public MetricDataResult build() {
            return new MetricDataResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricDataResult> {
        public Builder id(String var1);

        public Builder timestamps(Collection<Instant> var1);

        public Builder timestamps(Instant ... var1);

        public Builder values(Collection<Long> var1);

        public Builder values(Long ... var1);
    }
}

