/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.MessageInsightsFilters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageInsightsDataSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MessageInsightsDataSource> {
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartDate").getter(MessageInsightsDataSource.getter(MessageInsightsDataSource::startDate)).setter(MessageInsightsDataSource.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()}).build();
    private static final SdkField<Instant> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndDate").getter(MessageInsightsDataSource.getter(MessageInsightsDataSource::endDate)).setter(MessageInsightsDataSource.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").build()}).build();
    private static final SdkField<MessageInsightsFilters> INCLUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Include").getter(MessageInsightsDataSource.getter(MessageInsightsDataSource::include)).setter(MessageInsightsDataSource.setter(Builder::include)).constructor(MessageInsightsFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Include").build()}).build();
    private static final SdkField<MessageInsightsFilters> EXCLUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Exclude").getter(MessageInsightsDataSource.getter(MessageInsightsDataSource::exclude)).setter(MessageInsightsDataSource.setter(Builder::exclude)).constructor(MessageInsightsFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exclude").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(MessageInsightsDataSource.getter(MessageInsightsDataSource::maxResults)).setter(MessageInsightsDataSource.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_DATE_FIELD, END_DATE_FIELD, INCLUDE_FIELD, EXCLUDE_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("StartDate", START_DATE_FIELD);
            this.put("EndDate", END_DATE_FIELD);
            this.put("Include", INCLUDE_FIELD);
            this.put("Exclude", EXCLUDE_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Instant startDate;
    private final Instant endDate;
    private final MessageInsightsFilters include;
    private final MessageInsightsFilters exclude;
    private final Integer maxResults;

    private MessageInsightsDataSource(BuilderImpl builder) {
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.include = builder.include;
        this.exclude = builder.exclude;
        this.maxResults = builder.maxResults;
    }

    public final Instant startDate() {
        return this.startDate;
    }

    public final Instant endDate() {
        return this.endDate;
    }

    public final MessageInsightsFilters include() {
        return this.include;
    }

    public final MessageInsightsFilters exclude() {
        return this.exclude;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.include());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclude());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageInsightsDataSource)) {
            return false;
        }
        MessageInsightsDataSource other = (MessageInsightsDataSource)obj;
        return Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.endDate(), other.endDate()) && Objects.equals(this.include(), other.include()) && Objects.equals(this.exclude(), other.exclude()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"MessageInsightsDataSource").add("StartDate", (Object)this.startDate()).add("EndDate", (Object)this.endDate()).add("Include", (Object)this.include()).add("Exclude", (Object)this.exclude()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "EndDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "Include": {
                return Optional.ofNullable(clazz.cast(this.include()));
            }
            case "Exclude": {
                return Optional.ofNullable(clazz.cast(this.exclude()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MessageInsightsDataSource, T> g) {
        return obj -> g.apply((MessageInsightsDataSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant startDate;
        private Instant endDate;
        private MessageInsightsFilters include;
        private MessageInsightsFilters exclude;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageInsightsDataSource model) {
            this.startDate(model.startDate);
            this.endDate(model.endDate);
            this.include(model.include);
            this.exclude(model.exclude);
            this.maxResults(model.maxResults);
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getEndDate() {
            return this.endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final MessageInsightsFilters.Builder getInclude() {
            return this.include != null ? this.include.toBuilder() : null;
        }

        public final void setInclude(MessageInsightsFilters.BuilderImpl include) {
            this.include = include != null ? include.build() : null;
        }

        @Override
        public final Builder include(MessageInsightsFilters include) {
            this.include = include;
            return this;
        }

        public final MessageInsightsFilters.Builder getExclude() {
            return this.exclude != null ? this.exclude.toBuilder() : null;
        }

        public final void setExclude(MessageInsightsFilters.BuilderImpl exclude) {
            this.exclude = exclude != null ? exclude.build() : null;
        }

        @Override
        public final Builder exclude(MessageInsightsFilters exclude) {
            this.exclude = exclude;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public MessageInsightsDataSource build() {
            return new MessageInsightsDataSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MessageInsightsDataSource> {
        public Builder startDate(Instant var1);

        public Builder endDate(Instant var1);

        public Builder include(MessageInsightsFilters var1);

        default public Builder include(Consumer<MessageInsightsFilters.Builder> include) {
            return this.include((MessageInsightsFilters)((MessageInsightsFilters.Builder)MessageInsightsFilters.builder().applyMutation(include)).build());
        }

        public Builder exclude(MessageInsightsFilters var1);

        default public Builder exclude(Consumer<MessageInsightsFilters.Builder> exclude) {
            return this.exclude((MessageInsightsFilters)((MessageInsightsFilters.Builder)MessageInsightsFilters.builder().applyMutation(exclude)).build());
        }

        public Builder maxResults(Integer var1);
    }
}

