/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.DashboardAttributes;
import software.amazon.awssdk.services.sesv2.model.FeatureStatus;
import software.amazon.awssdk.services.sesv2.model.GuardianAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VdmAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VdmAttributes> {
    private static final SdkField<String> VDM_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VdmEnabled").getter(VdmAttributes.getter(VdmAttributes::vdmEnabledAsString)).setter(VdmAttributes.setter(Builder::vdmEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VdmEnabled").build()}).build();
    private static final SdkField<DashboardAttributes> DASHBOARD_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DashboardAttributes").getter(VdmAttributes.getter(VdmAttributes::dashboardAttributes)).setter(VdmAttributes.setter(Builder::dashboardAttributes)).constructor(DashboardAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardAttributes").build()}).build();
    private static final SdkField<GuardianAttributes> GUARDIAN_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GuardianAttributes").getter(VdmAttributes.getter(VdmAttributes::guardianAttributes)).setter(VdmAttributes.setter(Builder::guardianAttributes)).constructor(GuardianAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GuardianAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VDM_ENABLED_FIELD, DASHBOARD_ATTRIBUTES_FIELD, GUARDIAN_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("VdmEnabled", VDM_ENABLED_FIELD);
            this.put("DashboardAttributes", DASHBOARD_ATTRIBUTES_FIELD);
            this.put("GuardianAttributes", GUARDIAN_ATTRIBUTES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String vdmEnabled;
    private final DashboardAttributes dashboardAttributes;
    private final GuardianAttributes guardianAttributes;

    private VdmAttributes(BuilderImpl builder) {
        this.vdmEnabled = builder.vdmEnabled;
        this.dashboardAttributes = builder.dashboardAttributes;
        this.guardianAttributes = builder.guardianAttributes;
    }

    public final FeatureStatus vdmEnabled() {
        return FeatureStatus.fromValue(this.vdmEnabled);
    }

    public final String vdmEnabledAsString() {
        return this.vdmEnabled;
    }

    public final DashboardAttributes dashboardAttributes() {
        return this.dashboardAttributes;
    }

    public final GuardianAttributes guardianAttributes() {
        return this.guardianAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vdmEnabledAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardianAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VdmAttributes)) {
            return false;
        }
        VdmAttributes other = (VdmAttributes)obj;
        return Objects.equals(this.vdmEnabledAsString(), other.vdmEnabledAsString()) && Objects.equals(this.dashboardAttributes(), other.dashboardAttributes()) && Objects.equals(this.guardianAttributes(), other.guardianAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"VdmAttributes").add("VdmEnabled", (Object)this.vdmEnabledAsString()).add("DashboardAttributes", (Object)this.dashboardAttributes()).add("GuardianAttributes", (Object)this.guardianAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VdmEnabled": {
                return Optional.ofNullable(clazz.cast(this.vdmEnabledAsString()));
            }
            case "DashboardAttributes": {
                return Optional.ofNullable(clazz.cast(this.dashboardAttributes()));
            }
            case "GuardianAttributes": {
                return Optional.ofNullable(clazz.cast(this.guardianAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VdmAttributes, T> g) {
        return obj -> g.apply((VdmAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vdmEnabled;
        private DashboardAttributes dashboardAttributes;
        private GuardianAttributes guardianAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(VdmAttributes model) {
            this.vdmEnabled(model.vdmEnabled);
            this.dashboardAttributes(model.dashboardAttributes);
            this.guardianAttributes(model.guardianAttributes);
        }

        public final String getVdmEnabled() {
            return this.vdmEnabled;
        }

        public final void setVdmEnabled(String vdmEnabled) {
            this.vdmEnabled = vdmEnabled;
        }

        @Override
        public final Builder vdmEnabled(String vdmEnabled) {
            this.vdmEnabled = vdmEnabled;
            return this;
        }

        @Override
        public final Builder vdmEnabled(FeatureStatus vdmEnabled) {
            this.vdmEnabled(vdmEnabled == null ? null : vdmEnabled.toString());
            return this;
        }

        public final DashboardAttributes.Builder getDashboardAttributes() {
            return this.dashboardAttributes != null ? this.dashboardAttributes.toBuilder() : null;
        }

        public final void setDashboardAttributes(DashboardAttributes.BuilderImpl dashboardAttributes) {
            this.dashboardAttributes = dashboardAttributes != null ? dashboardAttributes.build() : null;
        }

        @Override
        public final Builder dashboardAttributes(DashboardAttributes dashboardAttributes) {
            this.dashboardAttributes = dashboardAttributes;
            return this;
        }

        public final GuardianAttributes.Builder getGuardianAttributes() {
            return this.guardianAttributes != null ? this.guardianAttributes.toBuilder() : null;
        }

        public final void setGuardianAttributes(GuardianAttributes.BuilderImpl guardianAttributes) {
            this.guardianAttributes = guardianAttributes != null ? guardianAttributes.build() : null;
        }

        @Override
        public final Builder guardianAttributes(GuardianAttributes guardianAttributes) {
            this.guardianAttributes = guardianAttributes;
            return this;
        }

        public VdmAttributes build() {
            return new VdmAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VdmAttributes> {
        public Builder vdmEnabled(String var1);

        public Builder vdmEnabled(FeatureStatus var1);

        public Builder dashboardAttributes(DashboardAttributes var1);

        default public Builder dashboardAttributes(Consumer<DashboardAttributes.Builder> dashboardAttributes) {
            return this.dashboardAttributes((DashboardAttributes)((DashboardAttributes.Builder)DashboardAttributes.builder().applyMutation(dashboardAttributes)).build());
        }

        public Builder guardianAttributes(GuardianAttributes var1);

        default public Builder guardianAttributes(Consumer<GuardianAttributes.Builder> guardianAttributes) {
            return this.guardianAttributes((GuardianAttributes)((GuardianAttributes.Builder)GuardianAttributes.builder().applyMutation(guardianAttributes)).build());
        }
    }
}

