/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sesv2.model.ExportDimensionsCopier;
import software.amazon.awssdk.services.sesv2.model.ExportMetric;
import software.amazon.awssdk.services.sesv2.model.ExportMetricsCopier;
import software.amazon.awssdk.services.sesv2.model.MetricDimensionName;
import software.amazon.awssdk.services.sesv2.model.MetricNamespace;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricsDataSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricsDataSource> {
    private static final SdkField<Map<String, List<String>>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Dimensions").getter(MetricsDataSource.getter(MetricsDataSource::dimensionsAsStrings)).setter(MetricsDataSource.setter(Builder::dimensionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(MetricsDataSource.getter(MetricsDataSource::namespaceAsString)).setter(MetricsDataSource.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()}).build();
    private static final SdkField<List<ExportMetric>> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Metrics").getter(MetricsDataSource.getter(MetricsDataSource::metrics)).setter(MetricsDataSource.setter(Builder::metrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExportMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartDate").getter(MetricsDataSource.getter(MetricsDataSource::startDate)).setter(MetricsDataSource.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()}).build();
    private static final SdkField<Instant> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndDate").getter(MetricsDataSource.getter(MetricsDataSource::endDate)).setter(MetricsDataSource.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD, NAMESPACE_FIELD, METRICS_FIELD, START_DATE_FIELD, END_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Dimensions", DIMENSIONS_FIELD);
            this.put("Namespace", NAMESPACE_FIELD);
            this.put("Metrics", METRICS_FIELD);
            this.put("StartDate", START_DATE_FIELD);
            this.put("EndDate", END_DATE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Map<String, List<String>> dimensions;
    private final String namespace;
    private final List<ExportMetric> metrics;
    private final Instant startDate;
    private final Instant endDate;

    private MetricsDataSource(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.namespace = builder.namespace;
        this.metrics = builder.metrics;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
    }

    public final Map<MetricDimensionName, List<String>> dimensions() {
        return ExportDimensionsCopier.copyStringToEnum(this.dimensions);
    }

    public final boolean hasDimensions() {
        return this.dimensions != null && !(this.dimensions instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> dimensionsAsStrings() {
        return this.dimensions;
    }

    public final MetricNamespace namespace() {
        return MetricNamespace.fromValue(this.namespace);
    }

    public final String namespaceAsString() {
        return this.namespace;
    }

    public final boolean hasMetrics() {
        return this.metrics != null && !(this.metrics instanceof SdkAutoConstructList);
    }

    public final List<ExportMetric> metrics() {
        return this.metrics;
    }

    public final Instant startDate() {
        return this.startDate;
    }

    public final Instant endDate() {
        return this.endDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensions() ? this.dimensionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetrics() ? this.metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricsDataSource)) {
            return false;
        }
        MetricsDataSource other = (MetricsDataSource)obj;
        return this.hasDimensions() == other.hasDimensions() && Objects.equals(this.dimensionsAsStrings(), other.dimensionsAsStrings()) && Objects.equals(this.namespaceAsString(), other.namespaceAsString()) && this.hasMetrics() == other.hasMetrics() && Objects.equals(this.metrics(), other.metrics()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.endDate(), other.endDate());
    }

    public final String toString() {
        return ToString.builder((String)"MetricsDataSource").add("Dimensions", this.hasDimensions() ? this.dimensionsAsStrings() : null).add("Namespace", (Object)this.namespaceAsString()).add("Metrics", this.hasMetrics() ? this.metrics() : null).add("StartDate", (Object)this.startDate()).add("EndDate", (Object)this.endDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensionsAsStrings()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespaceAsString()));
            }
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "StartDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "EndDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MetricsDataSource, T> g) {
        return obj -> g.apply((MetricsDataSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, List<String>> dimensions = DefaultSdkAutoConstructMap.getInstance();
        private String namespace;
        private List<ExportMetric> metrics = DefaultSdkAutoConstructList.getInstance();
        private Instant startDate;
        private Instant endDate;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricsDataSource model) {
            this.dimensionsWithStrings(model.dimensions);
            this.namespace(model.namespace);
            this.metrics(model.metrics);
            this.startDate(model.startDate);
            this.endDate(model.endDate);
        }

        public final Map<String, ? extends Collection<String>> getDimensions() {
            if (this.dimensions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.dimensions;
        }

        public final void setDimensions(Map<String, ? extends Collection<String>> dimensions) {
            this.dimensions = ExportDimensionsCopier.copy(dimensions);
        }

        @Override
        public final Builder dimensionsWithStrings(Map<String, ? extends Collection<String>> dimensions) {
            this.dimensions = ExportDimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        public final Builder dimensions(Map<MetricDimensionName, ? extends Collection<String>> dimensions) {
            this.dimensions = ExportDimensionsCopier.copyEnumToString(dimensions);
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public final Builder namespace(MetricNamespace namespace) {
            this.namespace(namespace == null ? null : namespace.toString());
            return this;
        }

        public final List<ExportMetric.Builder> getMetrics() {
            List<ExportMetric.Builder> result = ExportMetricsCopier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetrics(Collection<ExportMetric.BuilderImpl> metrics) {
            this.metrics = ExportMetricsCopier.copyFromBuilder(metrics);
        }

        @Override
        public final Builder metrics(Collection<ExportMetric> metrics) {
            this.metrics = ExportMetricsCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(ExportMetric ... metrics) {
            this.metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Consumer<ExportMetric.Builder> ... metrics) {
            this.metrics(Stream.of(metrics).map(c -> (ExportMetric)((ExportMetric.Builder)ExportMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getEndDate() {
            return this.endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public MetricsDataSource build() {
            return new MetricsDataSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricsDataSource> {
        public Builder dimensionsWithStrings(Map<String, ? extends Collection<String>> var1);

        public Builder dimensions(Map<MetricDimensionName, ? extends Collection<String>> var1);

        public Builder namespace(String var1);

        public Builder namespace(MetricNamespace var1);

        public Builder metrics(Collection<ExportMetric> var1);

        public Builder metrics(ExportMetric ... var1);

        public Builder metrics(Consumer<ExportMetric.Builder> ... var1);

        public Builder startDate(Instant var1);

        public Builder endDate(Instant var1);
    }
}

