/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.SesV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCustomVerificationEmailTemplateRequest
extends SesV2Request
implements ToCopyableBuilder<Builder, CreateCustomVerificationEmailTemplateRequest> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateName").getter(CreateCustomVerificationEmailTemplateRequest.getter(CreateCustomVerificationEmailTemplateRequest::templateName)).setter(CreateCustomVerificationEmailTemplateRequest.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()}).build();
    private static final SdkField<String> FROM_EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FromEmailAddress").getter(CreateCustomVerificationEmailTemplateRequest.getter(CreateCustomVerificationEmailTemplateRequest::fromEmailAddress)).setter(CreateCustomVerificationEmailTemplateRequest.setter(Builder::fromEmailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromEmailAddress").build()}).build();
    private static final SdkField<String> TEMPLATE_SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateSubject").getter(CreateCustomVerificationEmailTemplateRequest.getter(CreateCustomVerificationEmailTemplateRequest::templateSubject)).setter(CreateCustomVerificationEmailTemplateRequest.setter(Builder::templateSubject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateSubject").build()}).build();
    private static final SdkField<String> TEMPLATE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateContent").getter(CreateCustomVerificationEmailTemplateRequest.getter(CreateCustomVerificationEmailTemplateRequest::templateContent)).setter(CreateCustomVerificationEmailTemplateRequest.setter(Builder::templateContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateContent").build()}).build();
    private static final SdkField<String> SUCCESS_REDIRECTION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SuccessRedirectionURL").getter(CreateCustomVerificationEmailTemplateRequest.getter(CreateCustomVerificationEmailTemplateRequest::successRedirectionURL)).setter(CreateCustomVerificationEmailTemplateRequest.setter(Builder::successRedirectionURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessRedirectionURL").build()}).build();
    private static final SdkField<String> FAILURE_REDIRECTION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureRedirectionURL").getter(CreateCustomVerificationEmailTemplateRequest.getter(CreateCustomVerificationEmailTemplateRequest::failureRedirectionURL)).setter(CreateCustomVerificationEmailTemplateRequest.setter(Builder::failureRedirectionURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureRedirectionURL").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD, FROM_EMAIL_ADDRESS_FIELD, TEMPLATE_SUBJECT_FIELD, TEMPLATE_CONTENT_FIELD, SUCCESS_REDIRECTION_URL_FIELD, FAILURE_REDIRECTION_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TemplateName", TEMPLATE_NAME_FIELD);
            this.put("FromEmailAddress", FROM_EMAIL_ADDRESS_FIELD);
            this.put("TemplateSubject", TEMPLATE_SUBJECT_FIELD);
            this.put("TemplateContent", TEMPLATE_CONTENT_FIELD);
            this.put("SuccessRedirectionURL", SUCCESS_REDIRECTION_URL_FIELD);
            this.put("FailureRedirectionURL", FAILURE_REDIRECTION_URL_FIELD);
        }
    });
    private final String templateName;
    private final String fromEmailAddress;
    private final String templateSubject;
    private final String templateContent;
    private final String successRedirectionURL;
    private final String failureRedirectionURL;

    private CreateCustomVerificationEmailTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.templateName = builder.templateName;
        this.fromEmailAddress = builder.fromEmailAddress;
        this.templateSubject = builder.templateSubject;
        this.templateContent = builder.templateContent;
        this.successRedirectionURL = builder.successRedirectionURL;
        this.failureRedirectionURL = builder.failureRedirectionURL;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final String fromEmailAddress() {
        return this.fromEmailAddress;
    }

    public final String templateSubject() {
        return this.templateSubject;
    }

    public final String templateContent() {
        return this.templateContent;
    }

    public final String successRedirectionURL() {
        return this.successRedirectionURL;
    }

    public final String failureRedirectionURL() {
        return this.failureRedirectionURL;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateSubject());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.successRedirectionURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureRedirectionURL());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomVerificationEmailTemplateRequest)) {
            return false;
        }
        CreateCustomVerificationEmailTemplateRequest other = (CreateCustomVerificationEmailTemplateRequest)((Object)obj);
        return Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.fromEmailAddress(), other.fromEmailAddress()) && Objects.equals(this.templateSubject(), other.templateSubject()) && Objects.equals(this.templateContent(), other.templateContent()) && Objects.equals(this.successRedirectionURL(), other.successRedirectionURL()) && Objects.equals(this.failureRedirectionURL(), other.failureRedirectionURL());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCustomVerificationEmailTemplateRequest").add("TemplateName", (Object)this.templateName()).add("FromEmailAddress", (Object)this.fromEmailAddress()).add("TemplateSubject", (Object)this.templateSubject()).add("TemplateContent", (Object)this.templateContent()).add("SuccessRedirectionURL", (Object)this.successRedirectionURL()).add("FailureRedirectionURL", (Object)this.failureRedirectionURL()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "FromEmailAddress": {
                return Optional.ofNullable(clazz.cast(this.fromEmailAddress()));
            }
            case "TemplateSubject": {
                return Optional.ofNullable(clazz.cast(this.templateSubject()));
            }
            case "TemplateContent": {
                return Optional.ofNullable(clazz.cast(this.templateContent()));
            }
            case "SuccessRedirectionURL": {
                return Optional.ofNullable(clazz.cast(this.successRedirectionURL()));
            }
            case "FailureRedirectionURL": {
                return Optional.ofNullable(clazz.cast(this.failureRedirectionURL()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomVerificationEmailTemplateRequest, T> g) {
        return obj -> g.apply((CreateCustomVerificationEmailTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Request.BuilderImpl
    implements Builder {
        private String templateName;
        private String fromEmailAddress;
        private String templateSubject;
        private String templateContent;
        private String successRedirectionURL;
        private String failureRedirectionURL;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomVerificationEmailTemplateRequest model) {
            super(model);
            this.templateName(model.templateName);
            this.fromEmailAddress(model.fromEmailAddress);
            this.templateSubject(model.templateSubject);
            this.templateContent(model.templateContent);
            this.successRedirectionURL(model.successRedirectionURL);
            this.failureRedirectionURL(model.failureRedirectionURL);
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getFromEmailAddress() {
            return this.fromEmailAddress;
        }

        public final void setFromEmailAddress(String fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
        }

        @Override
        public final Builder fromEmailAddress(String fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
            return this;
        }

        public final String getTemplateSubject() {
            return this.templateSubject;
        }

        public final void setTemplateSubject(String templateSubject) {
            this.templateSubject = templateSubject;
        }

        @Override
        public final Builder templateSubject(String templateSubject) {
            this.templateSubject = templateSubject;
            return this;
        }

        public final String getTemplateContent() {
            return this.templateContent;
        }

        public final void setTemplateContent(String templateContent) {
            this.templateContent = templateContent;
        }

        @Override
        public final Builder templateContent(String templateContent) {
            this.templateContent = templateContent;
            return this;
        }

        public final String getSuccessRedirectionURL() {
            return this.successRedirectionURL;
        }

        public final void setSuccessRedirectionURL(String successRedirectionURL) {
            this.successRedirectionURL = successRedirectionURL;
        }

        @Override
        public final Builder successRedirectionURL(String successRedirectionURL) {
            this.successRedirectionURL = successRedirectionURL;
            return this;
        }

        public final String getFailureRedirectionURL() {
            return this.failureRedirectionURL;
        }

        public final void setFailureRedirectionURL(String failureRedirectionURL) {
            this.failureRedirectionURL = failureRedirectionURL;
        }

        @Override
        public final Builder failureRedirectionURL(String failureRedirectionURL) {
            this.failureRedirectionURL = failureRedirectionURL;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomVerificationEmailTemplateRequest build() {
            return new CreateCustomVerificationEmailTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SesV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCustomVerificationEmailTemplateRequest> {
        public Builder templateName(String var1);

        public Builder fromEmailAddress(String var1);

        public Builder templateSubject(String var1);

        public Builder templateContent(String var1);

        public Builder successRedirectionURL(String var1);

        public Builder failureRedirectionURL(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

