/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.SOARecord;
import software.amazon.awssdk.services.sesv2.model.VerificationError;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerificationInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VerificationInfo> {
    private static final SdkField<Instant> LAST_CHECKED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastCheckedTimestamp").getter(VerificationInfo.getter(VerificationInfo::lastCheckedTimestamp)).setter(VerificationInfo.setter(Builder::lastCheckedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastCheckedTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_SUCCESS_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastSuccessTimestamp").getter(VerificationInfo.getter(VerificationInfo::lastSuccessTimestamp)).setter(VerificationInfo.setter(Builder::lastSuccessTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessTimestamp").build()}).build();
    private static final SdkField<String> ERROR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorType").getter(VerificationInfo.getter(VerificationInfo::errorTypeAsString)).setter(VerificationInfo.setter(Builder::errorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorType").build()}).build();
    private static final SdkField<SOARecord> SOA_RECORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SOARecord").getter(VerificationInfo.getter(VerificationInfo::soaRecord)).setter(VerificationInfo.setter(Builder::soaRecord)).constructor(SOARecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SOARecord").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_CHECKED_TIMESTAMP_FIELD, LAST_SUCCESS_TIMESTAMP_FIELD, ERROR_TYPE_FIELD, SOA_RECORD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LastCheckedTimestamp", LAST_CHECKED_TIMESTAMP_FIELD);
            this.put("LastSuccessTimestamp", LAST_SUCCESS_TIMESTAMP_FIELD);
            this.put("ErrorType", ERROR_TYPE_FIELD);
            this.put("SOARecord", SOA_RECORD_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Instant lastCheckedTimestamp;
    private final Instant lastSuccessTimestamp;
    private final String errorType;
    private final SOARecord soaRecord;

    private VerificationInfo(BuilderImpl builder) {
        this.lastCheckedTimestamp = builder.lastCheckedTimestamp;
        this.lastSuccessTimestamp = builder.lastSuccessTimestamp;
        this.errorType = builder.errorType;
        this.soaRecord = builder.soaRecord;
    }

    public final Instant lastCheckedTimestamp() {
        return this.lastCheckedTimestamp;
    }

    public final Instant lastSuccessTimestamp() {
        return this.lastSuccessTimestamp;
    }

    public final VerificationError errorType() {
        return VerificationError.fromValue(this.errorType);
    }

    public final String errorTypeAsString() {
        return this.errorType;
    }

    public final SOARecord soaRecord() {
        return this.soaRecord;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lastCheckedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.soaRecord());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerificationInfo)) {
            return false;
        }
        VerificationInfo other = (VerificationInfo)obj;
        return Objects.equals(this.lastCheckedTimestamp(), other.lastCheckedTimestamp()) && Objects.equals(this.lastSuccessTimestamp(), other.lastSuccessTimestamp()) && Objects.equals(this.errorTypeAsString(), other.errorTypeAsString()) && Objects.equals(this.soaRecord(), other.soaRecord());
    }

    public final String toString() {
        return ToString.builder((String)"VerificationInfo").add("LastCheckedTimestamp", (Object)this.lastCheckedTimestamp()).add("LastSuccessTimestamp", (Object)this.lastSuccessTimestamp()).add("ErrorType", (Object)this.errorTypeAsString()).add("SOARecord", (Object)this.soaRecord()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LastCheckedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastCheckedTimestamp()));
            }
            case "LastSuccessTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastSuccessTimestamp()));
            }
            case "ErrorType": {
                return Optional.ofNullable(clazz.cast(this.errorTypeAsString()));
            }
            case "SOARecord": {
                return Optional.ofNullable(clazz.cast(this.soaRecord()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VerificationInfo, T> g) {
        return obj -> g.apply((VerificationInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant lastCheckedTimestamp;
        private Instant lastSuccessTimestamp;
        private String errorType;
        private SOARecord soaRecord;

        private BuilderImpl() {
        }

        private BuilderImpl(VerificationInfo model) {
            this.lastCheckedTimestamp(model.lastCheckedTimestamp);
            this.lastSuccessTimestamp(model.lastSuccessTimestamp);
            this.errorType(model.errorType);
            this.soaRecord(model.soaRecord);
        }

        public final Instant getLastCheckedTimestamp() {
            return this.lastCheckedTimestamp;
        }

        public final void setLastCheckedTimestamp(Instant lastCheckedTimestamp) {
            this.lastCheckedTimestamp = lastCheckedTimestamp;
        }

        @Override
        public final Builder lastCheckedTimestamp(Instant lastCheckedTimestamp) {
            this.lastCheckedTimestamp = lastCheckedTimestamp;
            return this;
        }

        public final Instant getLastSuccessTimestamp() {
            return this.lastSuccessTimestamp;
        }

        public final void setLastSuccessTimestamp(Instant lastSuccessTimestamp) {
            this.lastSuccessTimestamp = lastSuccessTimestamp;
        }

        @Override
        public final Builder lastSuccessTimestamp(Instant lastSuccessTimestamp) {
            this.lastSuccessTimestamp = lastSuccessTimestamp;
            return this;
        }

        public final String getErrorType() {
            return this.errorType;
        }

        public final void setErrorType(String errorType) {
            this.errorType = errorType;
        }

        @Override
        public final Builder errorType(String errorType) {
            this.errorType = errorType;
            return this;
        }

        @Override
        public final Builder errorType(VerificationError errorType) {
            this.errorType(errorType == null ? null : errorType.toString());
            return this;
        }

        public final SOARecord.Builder getSoaRecord() {
            return this.soaRecord != null ? this.soaRecord.toBuilder() : null;
        }

        public final void setSoaRecord(SOARecord.BuilderImpl soaRecord) {
            this.soaRecord = soaRecord != null ? soaRecord.build() : null;
        }

        @Override
        public final Builder soaRecord(SOARecord soaRecord) {
            this.soaRecord = soaRecord;
            return this;
        }

        public VerificationInfo build() {
            return new VerificationInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VerificationInfo> {
        public Builder lastCheckedTimestamp(Instant var1);

        public Builder lastSuccessTimestamp(Instant var1);

        public Builder errorType(String var1);

        public Builder errorType(VerificationError var1);

        public Builder soaRecord(SOARecord var1);

        default public Builder soaRecord(Consumer<SOARecord.Builder> soaRecord) {
            return this.soaRecord((SOARecord)((SOARecord.Builder)SOARecord.builder().applyMutation(soaRecord)).build());
        }
    }
}

