/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.Destination;
import software.amazon.awssdk.services.sesv2.model.EmailAddressListCopier;
import software.amazon.awssdk.services.sesv2.model.EmailContent;
import software.amazon.awssdk.services.sesv2.model.ListManagementOptions;
import software.amazon.awssdk.services.sesv2.model.MessageTag;
import software.amazon.awssdk.services.sesv2.model.MessageTagListCopier;
import software.amazon.awssdk.services.sesv2.model.SesV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendEmailRequest
extends SesV2Request
implements ToCopyableBuilder<Builder, SendEmailRequest> {
    private static final SdkField<String> FROM_EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FromEmailAddress").getter(SendEmailRequest.getter(SendEmailRequest::fromEmailAddress)).setter(SendEmailRequest.setter(Builder::fromEmailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromEmailAddress").build()}).build();
    private static final SdkField<String> FROM_EMAIL_ADDRESS_IDENTITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FromEmailAddressIdentityArn").getter(SendEmailRequest.getter(SendEmailRequest::fromEmailAddressIdentityArn)).setter(SendEmailRequest.setter(Builder::fromEmailAddressIdentityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromEmailAddressIdentityArn").build()}).build();
    private static final SdkField<Destination> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Destination").getter(SendEmailRequest.getter(SendEmailRequest::destination)).setter(SendEmailRequest.setter(Builder::destination)).constructor(Destination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final SdkField<List<String>> REPLY_TO_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplyToAddresses").getter(SendEmailRequest.getter(SendEmailRequest::replyToAddresses)).setter(SendEmailRequest.setter(Builder::replyToAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplyToAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FEEDBACK_FORWARDING_EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeedbackForwardingEmailAddress").getter(SendEmailRequest.getter(SendEmailRequest::feedbackForwardingEmailAddress)).setter(SendEmailRequest.setter(Builder::feedbackForwardingEmailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackForwardingEmailAddress").build()}).build();
    private static final SdkField<String> FEEDBACK_FORWARDING_EMAIL_ADDRESS_IDENTITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeedbackForwardingEmailAddressIdentityArn").getter(SendEmailRequest.getter(SendEmailRequest::feedbackForwardingEmailAddressIdentityArn)).setter(SendEmailRequest.setter(Builder::feedbackForwardingEmailAddressIdentityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackForwardingEmailAddressIdentityArn").build()}).build();
    private static final SdkField<EmailContent> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Content").getter(SendEmailRequest.getter(SendEmailRequest::content)).setter(SendEmailRequest.setter(Builder::content)).constructor(EmailContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<List<MessageTag>> EMAIL_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EmailTags").getter(SendEmailRequest.getter(SendEmailRequest::emailTags)).setter(SendEmailRequest.setter(Builder::emailTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationSetName").getter(SendEmailRequest.getter(SendEmailRequest::configurationSetName)).setter(SendEmailRequest.setter(Builder::configurationSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build()}).build();
    private static final SdkField<ListManagementOptions> LIST_MANAGEMENT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ListManagementOptions").getter(SendEmailRequest.getter(SendEmailRequest::listManagementOptions)).setter(SendEmailRequest.setter(Builder::listManagementOptions)).constructor(ListManagementOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListManagementOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_EMAIL_ADDRESS_FIELD, FROM_EMAIL_ADDRESS_IDENTITY_ARN_FIELD, DESTINATION_FIELD, REPLY_TO_ADDRESSES_FIELD, FEEDBACK_FORWARDING_EMAIL_ADDRESS_FIELD, FEEDBACK_FORWARDING_EMAIL_ADDRESS_IDENTITY_ARN_FIELD, CONTENT_FIELD, EMAIL_TAGS_FIELD, CONFIGURATION_SET_NAME_FIELD, LIST_MANAGEMENT_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FromEmailAddress", FROM_EMAIL_ADDRESS_FIELD);
            this.put("FromEmailAddressIdentityArn", FROM_EMAIL_ADDRESS_IDENTITY_ARN_FIELD);
            this.put("Destination", DESTINATION_FIELD);
            this.put("ReplyToAddresses", REPLY_TO_ADDRESSES_FIELD);
            this.put("FeedbackForwardingEmailAddress", FEEDBACK_FORWARDING_EMAIL_ADDRESS_FIELD);
            this.put("FeedbackForwardingEmailAddressIdentityArn", FEEDBACK_FORWARDING_EMAIL_ADDRESS_IDENTITY_ARN_FIELD);
            this.put("Content", CONTENT_FIELD);
            this.put("EmailTags", EMAIL_TAGS_FIELD);
            this.put("ConfigurationSetName", CONFIGURATION_SET_NAME_FIELD);
            this.put("ListManagementOptions", LIST_MANAGEMENT_OPTIONS_FIELD);
        }
    });
    private final String fromEmailAddress;
    private final String fromEmailAddressIdentityArn;
    private final Destination destination;
    private final List<String> replyToAddresses;
    private final String feedbackForwardingEmailAddress;
    private final String feedbackForwardingEmailAddressIdentityArn;
    private final EmailContent content;
    private final List<MessageTag> emailTags;
    private final String configurationSetName;
    private final ListManagementOptions listManagementOptions;

    private SendEmailRequest(BuilderImpl builder) {
        super(builder);
        this.fromEmailAddress = builder.fromEmailAddress;
        this.fromEmailAddressIdentityArn = builder.fromEmailAddressIdentityArn;
        this.destination = builder.destination;
        this.replyToAddresses = builder.replyToAddresses;
        this.feedbackForwardingEmailAddress = builder.feedbackForwardingEmailAddress;
        this.feedbackForwardingEmailAddressIdentityArn = builder.feedbackForwardingEmailAddressIdentityArn;
        this.content = builder.content;
        this.emailTags = builder.emailTags;
        this.configurationSetName = builder.configurationSetName;
        this.listManagementOptions = builder.listManagementOptions;
    }

    public final String fromEmailAddress() {
        return this.fromEmailAddress;
    }

    public final String fromEmailAddressIdentityArn() {
        return this.fromEmailAddressIdentityArn;
    }

    public final Destination destination() {
        return this.destination;
    }

    public final boolean hasReplyToAddresses() {
        return this.replyToAddresses != null && !(this.replyToAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> replyToAddresses() {
        return this.replyToAddresses;
    }

    public final String feedbackForwardingEmailAddress() {
        return this.feedbackForwardingEmailAddress;
    }

    public final String feedbackForwardingEmailAddressIdentityArn() {
        return this.feedbackForwardingEmailAddressIdentityArn;
    }

    public final EmailContent content() {
        return this.content;
    }

    public final boolean hasEmailTags() {
        return this.emailTags != null && !(this.emailTags instanceof SdkAutoConstructList);
    }

    public final List<MessageTag> emailTags() {
        return this.emailTags;
    }

    public final String configurationSetName() {
        return this.configurationSetName;
    }

    public final ListManagementOptions listManagementOptions() {
        return this.listManagementOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fromEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromEmailAddressIdentityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplyToAddresses() ? this.replyToAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.feedbackForwardingEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.feedbackForwardingEmailAddressIdentityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEmailTags() ? this.emailTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.listManagementOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendEmailRequest)) {
            return false;
        }
        SendEmailRequest other = (SendEmailRequest)((Object)obj);
        return Objects.equals(this.fromEmailAddress(), other.fromEmailAddress()) && Objects.equals(this.fromEmailAddressIdentityArn(), other.fromEmailAddressIdentityArn()) && Objects.equals(this.destination(), other.destination()) && this.hasReplyToAddresses() == other.hasReplyToAddresses() && Objects.equals(this.replyToAddresses(), other.replyToAddresses()) && Objects.equals(this.feedbackForwardingEmailAddress(), other.feedbackForwardingEmailAddress()) && Objects.equals(this.feedbackForwardingEmailAddressIdentityArn(), other.feedbackForwardingEmailAddressIdentityArn()) && Objects.equals(this.content(), other.content()) && this.hasEmailTags() == other.hasEmailTags() && Objects.equals(this.emailTags(), other.emailTags()) && Objects.equals(this.configurationSetName(), other.configurationSetName()) && Objects.equals(this.listManagementOptions(), other.listManagementOptions());
    }

    public final String toString() {
        return ToString.builder((String)"SendEmailRequest").add("FromEmailAddress", (Object)this.fromEmailAddress()).add("FromEmailAddressIdentityArn", (Object)this.fromEmailAddressIdentityArn()).add("Destination", (Object)this.destination()).add("ReplyToAddresses", this.hasReplyToAddresses() ? this.replyToAddresses() : null).add("FeedbackForwardingEmailAddress", (Object)this.feedbackForwardingEmailAddress()).add("FeedbackForwardingEmailAddressIdentityArn", (Object)this.feedbackForwardingEmailAddressIdentityArn()).add("Content", (Object)this.content()).add("EmailTags", this.hasEmailTags() ? this.emailTags() : null).add("ConfigurationSetName", (Object)this.configurationSetName()).add("ListManagementOptions", (Object)this.listManagementOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FromEmailAddress": {
                return Optional.ofNullable(clazz.cast(this.fromEmailAddress()));
            }
            case "FromEmailAddressIdentityArn": {
                return Optional.ofNullable(clazz.cast(this.fromEmailAddressIdentityArn()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "ReplyToAddresses": {
                return Optional.ofNullable(clazz.cast(this.replyToAddresses()));
            }
            case "FeedbackForwardingEmailAddress": {
                return Optional.ofNullable(clazz.cast(this.feedbackForwardingEmailAddress()));
            }
            case "FeedbackForwardingEmailAddressIdentityArn": {
                return Optional.ofNullable(clazz.cast(this.feedbackForwardingEmailAddressIdentityArn()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "EmailTags": {
                return Optional.ofNullable(clazz.cast(this.emailTags()));
            }
            case "ConfigurationSetName": {
                return Optional.ofNullable(clazz.cast(this.configurationSetName()));
            }
            case "ListManagementOptions": {
                return Optional.ofNullable(clazz.cast(this.listManagementOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SendEmailRequest, T> g) {
        return obj -> g.apply((SendEmailRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Request.BuilderImpl
    implements Builder {
        private String fromEmailAddress;
        private String fromEmailAddressIdentityArn;
        private Destination destination;
        private List<String> replyToAddresses = DefaultSdkAutoConstructList.getInstance();
        private String feedbackForwardingEmailAddress;
        private String feedbackForwardingEmailAddressIdentityArn;
        private EmailContent content;
        private List<MessageTag> emailTags = DefaultSdkAutoConstructList.getInstance();
        private String configurationSetName;
        private ListManagementOptions listManagementOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(SendEmailRequest model) {
            super(model);
            this.fromEmailAddress(model.fromEmailAddress);
            this.fromEmailAddressIdentityArn(model.fromEmailAddressIdentityArn);
            this.destination(model.destination);
            this.replyToAddresses(model.replyToAddresses);
            this.feedbackForwardingEmailAddress(model.feedbackForwardingEmailAddress);
            this.feedbackForwardingEmailAddressIdentityArn(model.feedbackForwardingEmailAddressIdentityArn);
            this.content(model.content);
            this.emailTags(model.emailTags);
            this.configurationSetName(model.configurationSetName);
            this.listManagementOptions(model.listManagementOptions);
        }

        public final String getFromEmailAddress() {
            return this.fromEmailAddress;
        }

        public final void setFromEmailAddress(String fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
        }

        @Override
        public final Builder fromEmailAddress(String fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
            return this;
        }

        public final String getFromEmailAddressIdentityArn() {
            return this.fromEmailAddressIdentityArn;
        }

        public final void setFromEmailAddressIdentityArn(String fromEmailAddressIdentityArn) {
            this.fromEmailAddressIdentityArn = fromEmailAddressIdentityArn;
        }

        @Override
        public final Builder fromEmailAddressIdentityArn(String fromEmailAddressIdentityArn) {
            this.fromEmailAddressIdentityArn = fromEmailAddressIdentityArn;
            return this;
        }

        public final Destination.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        public final void setDestination(Destination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public final Collection<String> getReplyToAddresses() {
            if (this.replyToAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.replyToAddresses;
        }

        public final void setReplyToAddresses(Collection<String> replyToAddresses) {
            this.replyToAddresses = EmailAddressListCopier.copy(replyToAddresses);
        }

        @Override
        public final Builder replyToAddresses(Collection<String> replyToAddresses) {
            this.replyToAddresses = EmailAddressListCopier.copy(replyToAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replyToAddresses(String ... replyToAddresses) {
            this.replyToAddresses(Arrays.asList(replyToAddresses));
            return this;
        }

        public final String getFeedbackForwardingEmailAddress() {
            return this.feedbackForwardingEmailAddress;
        }

        public final void setFeedbackForwardingEmailAddress(String feedbackForwardingEmailAddress) {
            this.feedbackForwardingEmailAddress = feedbackForwardingEmailAddress;
        }

        @Override
        public final Builder feedbackForwardingEmailAddress(String feedbackForwardingEmailAddress) {
            this.feedbackForwardingEmailAddress = feedbackForwardingEmailAddress;
            return this;
        }

        public final String getFeedbackForwardingEmailAddressIdentityArn() {
            return this.feedbackForwardingEmailAddressIdentityArn;
        }

        public final void setFeedbackForwardingEmailAddressIdentityArn(String feedbackForwardingEmailAddressIdentityArn) {
            this.feedbackForwardingEmailAddressIdentityArn = feedbackForwardingEmailAddressIdentityArn;
        }

        @Override
        public final Builder feedbackForwardingEmailAddressIdentityArn(String feedbackForwardingEmailAddressIdentityArn) {
            this.feedbackForwardingEmailAddressIdentityArn = feedbackForwardingEmailAddressIdentityArn;
            return this;
        }

        public final EmailContent.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(EmailContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(EmailContent content) {
            this.content = content;
            return this;
        }

        public final List<MessageTag.Builder> getEmailTags() {
            List<MessageTag.Builder> result = MessageTagListCopier.copyToBuilder(this.emailTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEmailTags(Collection<MessageTag.BuilderImpl> emailTags) {
            this.emailTags = MessageTagListCopier.copyFromBuilder(emailTags);
        }

        @Override
        public final Builder emailTags(Collection<MessageTag> emailTags) {
            this.emailTags = MessageTagListCopier.copy(emailTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emailTags(MessageTag ... emailTags) {
            this.emailTags(Arrays.asList(emailTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emailTags(Consumer<MessageTag.Builder> ... emailTags) {
            this.emailTags(Stream.of(emailTags).map(c -> (MessageTag)((MessageTag.Builder)MessageTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final ListManagementOptions.Builder getListManagementOptions() {
            return this.listManagementOptions != null ? this.listManagementOptions.toBuilder() : null;
        }

        public final void setListManagementOptions(ListManagementOptions.BuilderImpl listManagementOptions) {
            this.listManagementOptions = listManagementOptions != null ? listManagementOptions.build() : null;
        }

        @Override
        public final Builder listManagementOptions(ListManagementOptions listManagementOptions) {
            this.listManagementOptions = listManagementOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendEmailRequest build() {
            return new SendEmailRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SesV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendEmailRequest> {
        public Builder fromEmailAddress(String var1);

        public Builder fromEmailAddressIdentityArn(String var1);

        public Builder destination(Destination var1);

        default public Builder destination(Consumer<Destination.Builder> destination) {
            return this.destination((Destination)((Destination.Builder)Destination.builder().applyMutation(destination)).build());
        }

        public Builder replyToAddresses(Collection<String> var1);

        public Builder replyToAddresses(String ... var1);

        public Builder feedbackForwardingEmailAddress(String var1);

        public Builder feedbackForwardingEmailAddressIdentityArn(String var1);

        public Builder content(EmailContent var1);

        default public Builder content(Consumer<EmailContent.Builder> content) {
            return this.content((EmailContent)((EmailContent.Builder)EmailContent.builder().applyMutation(content)).build());
        }

        public Builder emailTags(Collection<MessageTag> var1);

        public Builder emailTags(MessageTag ... var1);

        public Builder emailTags(Consumer<MessageTag.Builder> ... var1);

        public Builder configurationSetName(String var1);

        public Builder listManagementOptions(ListManagementOptions var1);

        default public Builder listManagementOptions(Consumer<ListManagementOptions.Builder> listManagementOptions) {
            return this.listManagementOptions((ListManagementOptions)((ListManagementOptions.Builder)ListManagementOptions.builder().applyMutation(listManagementOptions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

