/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains details about the data source of the export job. It can only contain one of
 * <code>MetricsDataSource</code> or <code>MessageInsightsDataSource</code> object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportDataSource implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportDataSource.Builder, ExportDataSource> {
    private static final SdkField<MetricsDataSource> METRICS_DATA_SOURCE_FIELD = SdkField
            .<MetricsDataSource> builder(MarshallingType.SDK_POJO).memberName("MetricsDataSource")
            .getter(getter(ExportDataSource::metricsDataSource)).setter(setter(Builder::metricsDataSource))
            .constructor(MetricsDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricsDataSource").build()).build();

    private static final SdkField<MessageInsightsDataSource> MESSAGE_INSIGHTS_DATA_SOURCE_FIELD = SdkField
            .<MessageInsightsDataSource> builder(MarshallingType.SDK_POJO).memberName("MessageInsightsDataSource")
            .getter(getter(ExportDataSource::messageInsightsDataSource)).setter(setter(Builder::messageInsightsDataSource))
            .constructor(MessageInsightsDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageInsightsDataSource").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRICS_DATA_SOURCE_FIELD,
            MESSAGE_INSIGHTS_DATA_SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final MetricsDataSource metricsDataSource;

    private final MessageInsightsDataSource messageInsightsDataSource;

    private ExportDataSource(BuilderImpl builder) {
        this.metricsDataSource = builder.metricsDataSource;
        this.messageInsightsDataSource = builder.messageInsightsDataSource;
    }

    /**
     * Returns the value of the MetricsDataSource property for this object.
     * 
     * @return The value of the MetricsDataSource property for this object.
     */
    public final MetricsDataSource metricsDataSource() {
        return metricsDataSource;
    }

    /**
     * Returns the value of the MessageInsightsDataSource property for this object.
     * 
     * @return The value of the MessageInsightsDataSource property for this object.
     */
    public final MessageInsightsDataSource messageInsightsDataSource() {
        return messageInsightsDataSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricsDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(messageInsightsDataSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportDataSource)) {
            return false;
        }
        ExportDataSource other = (ExportDataSource) obj;
        return Objects.equals(metricsDataSource(), other.metricsDataSource())
                && Objects.equals(messageInsightsDataSource(), other.messageInsightsDataSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportDataSource").add("MetricsDataSource", metricsDataSource())
                .add("MessageInsightsDataSource", messageInsightsDataSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricsDataSource":
            return Optional.ofNullable(clazz.cast(metricsDataSource()));
        case "MessageInsightsDataSource":
            return Optional.ofNullable(clazz.cast(messageInsightsDataSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportDataSource, T> g) {
        return obj -> g.apply((ExportDataSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportDataSource> {
        /**
         * Sets the value of the MetricsDataSource property for this object.
         *
         * @param metricsDataSource
         *        The new value for the MetricsDataSource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsDataSource(MetricsDataSource metricsDataSource);

        /**
         * Sets the value of the MetricsDataSource property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MetricsDataSource.Builder} avoiding the
         * need to create one manually via {@link MetricsDataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetricsDataSource.Builder#build()} is called immediately and its
         * result is passed to {@link #metricsDataSource(MetricsDataSource)}.
         * 
         * @param metricsDataSource
         *        a consumer that will call methods on {@link MetricsDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricsDataSource(MetricsDataSource)
         */
        default Builder metricsDataSource(Consumer<MetricsDataSource.Builder> metricsDataSource) {
            return metricsDataSource(MetricsDataSource.builder().applyMutation(metricsDataSource).build());
        }

        /**
         * Sets the value of the MessageInsightsDataSource property for this object.
         *
         * @param messageInsightsDataSource
         *        The new value for the MessageInsightsDataSource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageInsightsDataSource(MessageInsightsDataSource messageInsightsDataSource);

        /**
         * Sets the value of the MessageInsightsDataSource property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MessageInsightsDataSource.Builder}
         * avoiding the need to create one manually via {@link MessageInsightsDataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageInsightsDataSource.Builder#build()} is called immediately
         * and its result is passed to {@link #messageInsightsDataSource(MessageInsightsDataSource)}.
         * 
         * @param messageInsightsDataSource
         *        a consumer that will call methods on {@link MessageInsightsDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messageInsightsDataSource(MessageInsightsDataSource)
         */
        default Builder messageInsightsDataSource(Consumer<MessageInsightsDataSource.Builder> messageInsightsDataSource) {
            return messageInsightsDataSource(MessageInsightsDataSource.builder().applyMutation(messageInsightsDataSource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MetricsDataSource metricsDataSource;

        private MessageInsightsDataSource messageInsightsDataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportDataSource model) {
            metricsDataSource(model.metricsDataSource);
            messageInsightsDataSource(model.messageInsightsDataSource);
        }

        public final MetricsDataSource.Builder getMetricsDataSource() {
            return metricsDataSource != null ? metricsDataSource.toBuilder() : null;
        }

        public final void setMetricsDataSource(MetricsDataSource.BuilderImpl metricsDataSource) {
            this.metricsDataSource = metricsDataSource != null ? metricsDataSource.build() : null;
        }

        @Override
        public final Builder metricsDataSource(MetricsDataSource metricsDataSource) {
            this.metricsDataSource = metricsDataSource;
            return this;
        }

        public final MessageInsightsDataSource.Builder getMessageInsightsDataSource() {
            return messageInsightsDataSource != null ? messageInsightsDataSource.toBuilder() : null;
        }

        public final void setMessageInsightsDataSource(MessageInsightsDataSource.BuilderImpl messageInsightsDataSource) {
            this.messageInsightsDataSource = messageInsightsDataSource != null ? messageInsightsDataSource.build() : null;
        }

        @Override
        public final Builder messageInsightsDataSource(MessageInsightsDataSource messageInsightsDataSource) {
            this.messageInsightsDataSource = messageInsightsDataSource;
            return this;
        }

        @Override
        public ExportDataSource build() {
            return new ExportDataSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
