/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeliveryEventType {
    SEND("SEND"),
    DELIVERY("DELIVERY"),
    TRANSIENT_BOUNCE("TRANSIENT_BOUNCE"),
    PERMANENT_BOUNCE("PERMANENT_BOUNCE"),
    UNDETERMINED_BOUNCE("UNDETERMINED_BOUNCE"),
    COMPLAINT("COMPLAINT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeliveryEventType> VALUE_MAP;
    private final String value;

    private DeliveryEventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeliveryEventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeliveryEventType> knownValues() {
        EnumSet<DeliveryEventType> knownValues = EnumSet.allOf(DeliveryEventType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeliveryEventType.class, DeliveryEventType::toString);
    }
}

