/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportStatistics> {
    private static final SdkField<Integer> PROCESSED_RECORDS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ProcessedRecordsCount").getter(ExportStatistics.getter(ExportStatistics::processedRecordsCount)).setter(ExportStatistics.setter(Builder::processedRecordsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessedRecordsCount").build()}).build();
    private static final SdkField<Integer> EXPORTED_RECORDS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ExportedRecordsCount").getter(ExportStatistics.getter(ExportStatistics::exportedRecordsCount)).setter(ExportStatistics.setter(Builder::exportedRecordsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportedRecordsCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROCESSED_RECORDS_COUNT_FIELD, EXPORTED_RECORDS_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer processedRecordsCount;
    private final Integer exportedRecordsCount;

    private ExportStatistics(BuilderImpl builder) {
        this.processedRecordsCount = builder.processedRecordsCount;
        this.exportedRecordsCount = builder.exportedRecordsCount;
    }

    public final Integer processedRecordsCount() {
        return this.processedRecordsCount;
    }

    public final Integer exportedRecordsCount() {
        return this.exportedRecordsCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.processedRecordsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportedRecordsCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportStatistics)) {
            return false;
        }
        ExportStatistics other = (ExportStatistics)obj;
        return Objects.equals(this.processedRecordsCount(), other.processedRecordsCount()) && Objects.equals(this.exportedRecordsCount(), other.exportedRecordsCount());
    }

    public final String toString() {
        return ToString.builder((String)"ExportStatistics").add("ProcessedRecordsCount", (Object)this.processedRecordsCount()).add("ExportedRecordsCount", (Object)this.exportedRecordsCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProcessedRecordsCount": {
                return Optional.ofNullable(clazz.cast(this.processedRecordsCount()));
            }
            case "ExportedRecordsCount": {
                return Optional.ofNullable(clazz.cast(this.exportedRecordsCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportStatistics, T> g) {
        return obj -> g.apply((ExportStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer processedRecordsCount;
        private Integer exportedRecordsCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportStatistics model) {
            this.processedRecordsCount(model.processedRecordsCount);
            this.exportedRecordsCount(model.exportedRecordsCount);
        }

        public final Integer getProcessedRecordsCount() {
            return this.processedRecordsCount;
        }

        public final void setProcessedRecordsCount(Integer processedRecordsCount) {
            this.processedRecordsCount = processedRecordsCount;
        }

        @Override
        public final Builder processedRecordsCount(Integer processedRecordsCount) {
            this.processedRecordsCount = processedRecordsCount;
            return this;
        }

        public final Integer getExportedRecordsCount() {
            return this.exportedRecordsCount;
        }

        public final void setExportedRecordsCount(Integer exportedRecordsCount) {
            this.exportedRecordsCount = exportedRecordsCount;
        }

        @Override
        public final Builder exportedRecordsCount(Integer exportedRecordsCount) {
            this.exportedRecordsCount = exportedRecordsCount;
            return this;
        }

        public ExportStatistics build() {
            return new ExportStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportStatistics> {
        public Builder processedRecordsCount(Integer var1);

        public Builder exportedRecordsCount(Integer var1);
    }
}

