/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2AsyncClient;
import software.amazon.awssdk.services.sesv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesRequest;
import software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesResponse;

public class ListEmailTemplatesPublisher
implements SdkPublisher<ListEmailTemplatesResponse> {
    private final SesV2AsyncClient client;
    private final ListEmailTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEmailTemplatesPublisher(SesV2AsyncClient client, ListEmailTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEmailTemplatesPublisher(SesV2AsyncClient client, ListEmailTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEmailTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEmailTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListEmailTemplatesResponseFetcher
    implements AsyncPageFetcher<ListEmailTemplatesResponse> {
        private ListEmailTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListEmailTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEmailTemplatesResponse> nextPage(ListEmailTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListEmailTemplatesPublisher.this.client.listEmailTemplates(ListEmailTemplatesPublisher.this.firstRequest);
            }
            return ListEmailTemplatesPublisher.this.client.listEmailTemplates((ListEmailTemplatesRequest)((Object)ListEmailTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

