/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2Client;
import software.amazon.awssdk.services.sesv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.sesv2.model.ListRecommendationsRequest;
import software.amazon.awssdk.services.sesv2.model.ListRecommendationsResponse;

public class ListRecommendationsIterable
implements SdkIterable<ListRecommendationsResponse> {
    private final SesV2Client client;
    private final ListRecommendationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRecommendationsIterable(SesV2Client client, ListRecommendationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRecommendationsResponseFetcher();
    }

    public Iterator<ListRecommendationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListRecommendationsResponseFetcher
    implements SyncPageFetcher<ListRecommendationsResponse> {
        private ListRecommendationsResponseFetcher() {
        }

        public boolean hasNextPage(ListRecommendationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRecommendationsResponse nextPage(ListRecommendationsResponse previousPage) {
            if (previousPage == null) {
                return ListRecommendationsIterable.this.client.listRecommendations(ListRecommendationsIterable.this.firstRequest);
            }
            return ListRecommendationsIterable.this.client.listRecommendations((ListRecommendationsRequest)((Object)ListRecommendationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

