/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2Client;
import software.amazon.awssdk.services.sesv2.model.ListContactsRequest;
import software.amazon.awssdk.services.sesv2.model.ListContactsResponse;

public class ListContactsIterable
implements SdkIterable<ListContactsResponse> {
    private final SesV2Client client;
    private final ListContactsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListContactsIterable(SesV2Client client, ListContactsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListContactsResponseFetcher();
    }

    public Iterator<ListContactsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListContactsResponseFetcher
    implements SyncPageFetcher<ListContactsResponse> {
        private ListContactsResponseFetcher() {
        }

        public boolean hasNextPage(ListContactsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListContactsResponse nextPage(ListContactsResponse previousPage) {
            if (previousPage == null) {
                return ListContactsIterable.this.client.listContacts(ListContactsIterable.this.firstRequest);
            }
            return ListContactsIterable.this.client.listContacts((ListContactsRequest)((Object)ListContactsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

