/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.DkimSigningAttributes;
import software.amazon.awssdk.services.sesv2.model.SesV2Request;
import software.amazon.awssdk.services.sesv2.model.Tag;
import software.amazon.awssdk.services.sesv2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEmailIdentityRequest
extends SesV2Request
implements ToCopyableBuilder<Builder, CreateEmailIdentityRequest> {
    private static final SdkField<String> EMAIL_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailIdentity").getter(CreateEmailIdentityRequest.getter(CreateEmailIdentityRequest::emailIdentity)).setter(CreateEmailIdentityRequest.setter(Builder::emailIdentity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailIdentity").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateEmailIdentityRequest.getter(CreateEmailIdentityRequest::tags)).setter(CreateEmailIdentityRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DkimSigningAttributes> DKIM_SIGNING_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DkimSigningAttributes").getter(CreateEmailIdentityRequest.getter(CreateEmailIdentityRequest::dkimSigningAttributes)).setter(CreateEmailIdentityRequest.setter(Builder::dkimSigningAttributes)).constructor(DkimSigningAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DkimSigningAttributes").build()}).build();
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationSetName").getter(CreateEmailIdentityRequest.getter(CreateEmailIdentityRequest::configurationSetName)).setter(CreateEmailIdentityRequest.setter(Builder::configurationSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_IDENTITY_FIELD, TAGS_FIELD, DKIM_SIGNING_ATTRIBUTES_FIELD, CONFIGURATION_SET_NAME_FIELD));
    private final String emailIdentity;
    private final List<Tag> tags;
    private final DkimSigningAttributes dkimSigningAttributes;
    private final String configurationSetName;

    private CreateEmailIdentityRequest(BuilderImpl builder) {
        super(builder);
        this.emailIdentity = builder.emailIdentity;
        this.tags = builder.tags;
        this.dkimSigningAttributes = builder.dkimSigningAttributes;
        this.configurationSetName = builder.configurationSetName;
    }

    public final String emailIdentity() {
        return this.emailIdentity;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final DkimSigningAttributes dkimSigningAttributes() {
        return this.dkimSigningAttributes;
    }

    public final String configurationSetName() {
        return this.configurationSetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.emailIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dkimSigningAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEmailIdentityRequest)) {
            return false;
        }
        CreateEmailIdentityRequest other = (CreateEmailIdentityRequest)((Object)obj);
        return Objects.equals(this.emailIdentity(), other.emailIdentity()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.dkimSigningAttributes(), other.dkimSigningAttributes()) && Objects.equals(this.configurationSetName(), other.configurationSetName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEmailIdentityRequest").add("EmailIdentity", (Object)this.emailIdentity()).add("Tags", this.hasTags() ? this.tags() : null).add("DkimSigningAttributes", (Object)this.dkimSigningAttributes()).add("ConfigurationSetName", (Object)this.configurationSetName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EmailIdentity": {
                return Optional.ofNullable(clazz.cast(this.emailIdentity()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "DkimSigningAttributes": {
                return Optional.ofNullable(clazz.cast(this.dkimSigningAttributes()));
            }
            case "ConfigurationSetName": {
                return Optional.ofNullable(clazz.cast(this.configurationSetName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEmailIdentityRequest, T> g) {
        return obj -> g.apply((CreateEmailIdentityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Request.BuilderImpl
    implements Builder {
        private String emailIdentity;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private DkimSigningAttributes dkimSigningAttributes;
        private String configurationSetName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEmailIdentityRequest model) {
            super(model);
            this.emailIdentity(model.emailIdentity);
            this.tags(model.tags);
            this.dkimSigningAttributes(model.dkimSigningAttributes);
            this.configurationSetName(model.configurationSetName);
        }

        public final String getEmailIdentity() {
            return this.emailIdentity;
        }

        @Override
        public final Builder emailIdentity(String emailIdentity) {
            this.emailIdentity = emailIdentity;
            return this;
        }

        public final void setEmailIdentity(String emailIdentity) {
            this.emailIdentity = emailIdentity;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final DkimSigningAttributes.Builder getDkimSigningAttributes() {
            return this.dkimSigningAttributes != null ? this.dkimSigningAttributes.toBuilder() : null;
        }

        @Override
        public final Builder dkimSigningAttributes(DkimSigningAttributes dkimSigningAttributes) {
            this.dkimSigningAttributes = dkimSigningAttributes;
            return this;
        }

        public final void setDkimSigningAttributes(DkimSigningAttributes.BuilderImpl dkimSigningAttributes) {
            this.dkimSigningAttributes = dkimSigningAttributes != null ? dkimSigningAttributes.build() : null;
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEmailIdentityRequest build() {
            return new CreateEmailIdentityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEmailIdentityRequest> {
        public Builder emailIdentity(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder dkimSigningAttributes(DkimSigningAttributes var1);

        default public Builder dkimSigningAttributes(Consumer<DkimSigningAttributes.Builder> dkimSigningAttributes) {
            return this.dkimSigningAttributes((DkimSigningAttributes)((DkimSigningAttributes.Builder)DkimSigningAttributes.builder().applyMutation(dkimSigningAttributes)).build());
        }

        public Builder configurationSetName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

