/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.CloudWatchDestination;
import software.amazon.awssdk.services.sesv2.model.EventType;
import software.amazon.awssdk.services.sesv2.model.EventTypesCopier;
import software.amazon.awssdk.services.sesv2.model.KinesisFirehoseDestination;
import software.amazon.awssdk.services.sesv2.model.PinpointDestination;
import software.amazon.awssdk.services.sesv2.model.SnsDestination;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventDestinationDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventDestinationDefinition> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(EventDestinationDefinition.getter(EventDestinationDefinition::enabled)).setter(EventDestinationDefinition.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<List<String>> MATCHING_EVENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MatchingEventTypes").getter(EventDestinationDefinition.getter(EventDestinationDefinition::matchingEventTypesAsStrings)).setter(EventDestinationDefinition.setter(Builder::matchingEventTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchingEventTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<KinesisFirehoseDestination> KINESIS_FIREHOSE_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisFirehoseDestination").getter(EventDestinationDefinition.getter(EventDestinationDefinition::kinesisFirehoseDestination)).setter(EventDestinationDefinition.setter(Builder::kinesisFirehoseDestination)).constructor(KinesisFirehoseDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisFirehoseDestination").build()}).build();
    private static final SdkField<CloudWatchDestination> CLOUD_WATCH_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchDestination").getter(EventDestinationDefinition.getter(EventDestinationDefinition::cloudWatchDestination)).setter(EventDestinationDefinition.setter(Builder::cloudWatchDestination)).constructor(CloudWatchDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchDestination").build()}).build();
    private static final SdkField<SnsDestination> SNS_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SnsDestination").getter(EventDestinationDefinition.getter(EventDestinationDefinition::snsDestination)).setter(EventDestinationDefinition.setter(Builder::snsDestination)).constructor(SnsDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsDestination").build()}).build();
    private static final SdkField<PinpointDestination> PINPOINT_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PinpointDestination").getter(EventDestinationDefinition.getter(EventDestinationDefinition::pinpointDestination)).setter(EventDestinationDefinition.setter(Builder::pinpointDestination)).constructor(PinpointDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinpointDestination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, MATCHING_EVENT_TYPES_FIELD, KINESIS_FIREHOSE_DESTINATION_FIELD, CLOUD_WATCH_DESTINATION_FIELD, SNS_DESTINATION_FIELD, PINPOINT_DESTINATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final List<String> matchingEventTypes;
    private final KinesisFirehoseDestination kinesisFirehoseDestination;
    private final CloudWatchDestination cloudWatchDestination;
    private final SnsDestination snsDestination;
    private final PinpointDestination pinpointDestination;

    private EventDestinationDefinition(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.matchingEventTypes = builder.matchingEventTypes;
        this.kinesisFirehoseDestination = builder.kinesisFirehoseDestination;
        this.cloudWatchDestination = builder.cloudWatchDestination;
        this.snsDestination = builder.snsDestination;
        this.pinpointDestination = builder.pinpointDestination;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final List<EventType> matchingEventTypes() {
        return EventTypesCopier.copyStringToEnum(this.matchingEventTypes);
    }

    public final boolean hasMatchingEventTypes() {
        return this.matchingEventTypes != null && !(this.matchingEventTypes instanceof SdkAutoConstructList);
    }

    public final List<String> matchingEventTypesAsStrings() {
        return this.matchingEventTypes;
    }

    public final KinesisFirehoseDestination kinesisFirehoseDestination() {
        return this.kinesisFirehoseDestination;
    }

    public final CloudWatchDestination cloudWatchDestination() {
        return this.cloudWatchDestination;
    }

    public final SnsDestination snsDestination() {
        return this.snsDestination;
    }

    public final PinpointDestination pinpointDestination() {
        return this.pinpointDestination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchingEventTypes() ? this.matchingEventTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisFirehoseDestination());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchDestination());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsDestination());
        hashCode = 31 * hashCode + Objects.hashCode(this.pinpointDestination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventDestinationDefinition)) {
            return false;
        }
        EventDestinationDefinition other = (EventDestinationDefinition)obj;
        return Objects.equals(this.enabled(), other.enabled()) && this.hasMatchingEventTypes() == other.hasMatchingEventTypes() && Objects.equals(this.matchingEventTypesAsStrings(), other.matchingEventTypesAsStrings()) && Objects.equals(this.kinesisFirehoseDestination(), other.kinesisFirehoseDestination()) && Objects.equals(this.cloudWatchDestination(), other.cloudWatchDestination()) && Objects.equals(this.snsDestination(), other.snsDestination()) && Objects.equals(this.pinpointDestination(), other.pinpointDestination());
    }

    public final String toString() {
        return ToString.builder((String)"EventDestinationDefinition").add("Enabled", (Object)this.enabled()).add("MatchingEventTypes", this.hasMatchingEventTypes() ? this.matchingEventTypesAsStrings() : null).add("KinesisFirehoseDestination", (Object)this.kinesisFirehoseDestination()).add("CloudWatchDestination", (Object)this.cloudWatchDestination()).add("SnsDestination", (Object)this.snsDestination()).add("PinpointDestination", (Object)this.pinpointDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "MatchingEventTypes": {
                return Optional.ofNullable(clazz.cast(this.matchingEventTypesAsStrings()));
            }
            case "KinesisFirehoseDestination": {
                return Optional.ofNullable(clazz.cast(this.kinesisFirehoseDestination()));
            }
            case "CloudWatchDestination": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchDestination()));
            }
            case "SnsDestination": {
                return Optional.ofNullable(clazz.cast(this.snsDestination()));
            }
            case "PinpointDestination": {
                return Optional.ofNullable(clazz.cast(this.pinpointDestination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventDestinationDefinition, T> g) {
        return obj -> g.apply((EventDestinationDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private List<String> matchingEventTypes = DefaultSdkAutoConstructList.getInstance();
        private KinesisFirehoseDestination kinesisFirehoseDestination;
        private CloudWatchDestination cloudWatchDestination;
        private SnsDestination snsDestination;
        private PinpointDestination pinpointDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(EventDestinationDefinition model) {
            this.enabled(model.enabled);
            this.matchingEventTypesWithStrings(model.matchingEventTypes);
            this.kinesisFirehoseDestination(model.kinesisFirehoseDestination);
            this.cloudWatchDestination(model.cloudWatchDestination);
            this.snsDestination(model.snsDestination);
            this.pinpointDestination(model.pinpointDestination);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Collection<String> getMatchingEventTypes() {
            if (this.matchingEventTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.matchingEventTypes;
        }

        @Override
        public final Builder matchingEventTypesWithStrings(Collection<String> matchingEventTypes) {
            this.matchingEventTypes = EventTypesCopier.copy(matchingEventTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchingEventTypesWithStrings(String ... matchingEventTypes) {
            this.matchingEventTypesWithStrings(Arrays.asList(matchingEventTypes));
            return this;
        }

        @Override
        public final Builder matchingEventTypes(Collection<EventType> matchingEventTypes) {
            this.matchingEventTypes = EventTypesCopier.copyEnumToString(matchingEventTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchingEventTypes(EventType ... matchingEventTypes) {
            this.matchingEventTypes(Arrays.asList(matchingEventTypes));
            return this;
        }

        public final void setMatchingEventTypes(Collection<String> matchingEventTypes) {
            this.matchingEventTypes = EventTypesCopier.copy(matchingEventTypes);
        }

        public final KinesisFirehoseDestination.Builder getKinesisFirehoseDestination() {
            return this.kinesisFirehoseDestination != null ? this.kinesisFirehoseDestination.toBuilder() : null;
        }

        @Override
        public final Builder kinesisFirehoseDestination(KinesisFirehoseDestination kinesisFirehoseDestination) {
            this.kinesisFirehoseDestination = kinesisFirehoseDestination;
            return this;
        }

        public final void setKinesisFirehoseDestination(KinesisFirehoseDestination.BuilderImpl kinesisFirehoseDestination) {
            this.kinesisFirehoseDestination = kinesisFirehoseDestination != null ? kinesisFirehoseDestination.build() : null;
        }

        public final CloudWatchDestination.Builder getCloudWatchDestination() {
            return this.cloudWatchDestination != null ? this.cloudWatchDestination.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchDestination(CloudWatchDestination cloudWatchDestination) {
            this.cloudWatchDestination = cloudWatchDestination;
            return this;
        }

        public final void setCloudWatchDestination(CloudWatchDestination.BuilderImpl cloudWatchDestination) {
            this.cloudWatchDestination = cloudWatchDestination != null ? cloudWatchDestination.build() : null;
        }

        public final SnsDestination.Builder getSnsDestination() {
            return this.snsDestination != null ? this.snsDestination.toBuilder() : null;
        }

        @Override
        public final Builder snsDestination(SnsDestination snsDestination) {
            this.snsDestination = snsDestination;
            return this;
        }

        public final void setSnsDestination(SnsDestination.BuilderImpl snsDestination) {
            this.snsDestination = snsDestination != null ? snsDestination.build() : null;
        }

        public final PinpointDestination.Builder getPinpointDestination() {
            return this.pinpointDestination != null ? this.pinpointDestination.toBuilder() : null;
        }

        @Override
        public final Builder pinpointDestination(PinpointDestination pinpointDestination) {
            this.pinpointDestination = pinpointDestination;
            return this;
        }

        public final void setPinpointDestination(PinpointDestination.BuilderImpl pinpointDestination) {
            this.pinpointDestination = pinpointDestination != null ? pinpointDestination.build() : null;
        }

        public EventDestinationDefinition build() {
            return new EventDestinationDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventDestinationDefinition> {
        public Builder enabled(Boolean var1);

        public Builder matchingEventTypesWithStrings(Collection<String> var1);

        public Builder matchingEventTypesWithStrings(String ... var1);

        public Builder matchingEventTypes(Collection<EventType> var1);

        public Builder matchingEventTypes(EventType ... var1);

        public Builder kinesisFirehoseDestination(KinesisFirehoseDestination var1);

        default public Builder kinesisFirehoseDestination(Consumer<KinesisFirehoseDestination.Builder> kinesisFirehoseDestination) {
            return this.kinesisFirehoseDestination((KinesisFirehoseDestination)((KinesisFirehoseDestination.Builder)KinesisFirehoseDestination.builder().applyMutation(kinesisFirehoseDestination)).build());
        }

        public Builder cloudWatchDestination(CloudWatchDestination var1);

        default public Builder cloudWatchDestination(Consumer<CloudWatchDestination.Builder> cloudWatchDestination) {
            return this.cloudWatchDestination((CloudWatchDestination)((CloudWatchDestination.Builder)CloudWatchDestination.builder().applyMutation(cloudWatchDestination)).build());
        }

        public Builder snsDestination(SnsDestination var1);

        default public Builder snsDestination(Consumer<SnsDestination.Builder> snsDestination) {
            return this.snsDestination((SnsDestination)((SnsDestination.Builder)SnsDestination.builder().applyMutation(snsDestination)).build());
        }

        public Builder pinpointDestination(PinpointDestination var1);

        default public Builder pinpointDestination(Consumer<PinpointDestination.Builder> pinpointDestination) {
            return this.pinpointDestination((PinpointDestination)((PinpointDestination.Builder)PinpointDestination.builder().applyMutation(pinpointDestination)).build());
        }
    }
}

